/************************************************************************

                2.2' TFT Demonstration

                FFT of analog input


  This Code is a modified version of dujianyi's FFT:
  https://github.com/dujianyi/ardFFT

  TFT used
  ILI9340C

  libraries used
  ==============
  Arduino Due library for interfacing with ILI9341 SPI TFTs ( ultra fast DMA )
  http://marekburiak.github.io/ILI9341_due/

  Written by a MC-Net User 2016

************************************************************************/
#include <SPI.h>
#include "myFFT.h"

#include "ILI9341_due_config.h"
#include "ILI9341_due.h"
#include "SystemFont5x7.h"
#include "fonts\Arial_bold_14.h"

#define mic_adc 0 // Pin # of the ADC
#define N 512    // Sampling point
#define Fs 10000 // Sampling Frequency

#define DISPLAY_SIGNAL_LENGTH N/2
#define SCREEN_HEIGHT 240
#define SCREEN_WIDTH 480

uint16_t oldSignal[N];
uint16_t SampledSignal[N];

// global variables
double sound_wave[N], re[N], im[N], Xr[N], Xi[N];

// For the Adafruit shield, these are the default.
#define TFT_RST 8
#define TFT_DC 9
#define TFT_CS 10

// Use hardware SPI (on Uno, #13, #12, #11) and the above for CS/DC
ILI9341_due tft = ILI9341_due(TFT_CS, TFT_DC, TFT_RST);

// Color set
#define BLACK           0x0000
#define RED             0xF800
#define GREEN           0x07E0
#define BLUE            0x102E
#define CYAN            0x07FF
#define MAGENTA         0xF81F
#define YELLOW          0xFFE0
#define ORANGE          0xFD20
#define GREENYELLOW     0xAFE5
#define DARKGREEN       0x03E0
#define WHITE           0xFFFF


void setup()
{
  Serial.begin(9600);
  while (!Serial);
  analogReadResolution(10);

  Serial.println("ILI9340c analog input test");

  tft.begin();
  tft.setRotation(iliRotation90);
  tft.fillScreen(BLACK);
  tft.setFont(Arial_bold_14);
  tft.setTextLetterSpacing(5);
  tft.setTextColor(YELLOW, BLUE);

}

// Sampling process
inline void Sampling(double *sw, double *re, double *im) {
  double gap_time = (1000000.0 / Fs);
  int start_time = micros();
  for (int i = 0; i < N; i++) {
    while (micros() - start_time < gap_time);
    sw[i] = (double) analogRead(mic_adc);
    start_time = micros();
  }
  for (int i = 0; i < N; i++) {
    re[i] = sw[i];
    im[i] = 0;
  }
}

// Post-processing
inline double postProcessing(double Xr[], double Xi[], double preMax)
{
  double maxk = -1.0;
  double maxvalue = -1;

  for (int i = 0; i < N / 2; i++)
  {
    double nowFre = i * Fs * 1.0 / N;
    double temp = sqrt(Xr[i] * Xr[i] + Xi[i] * Xi[i]);
    SampledSignal[i] = log10(temp) * 400.0;

    if (temp > maxvalue) {
      if (i != 0)
      {
        maxk = nowFre;
        maxvalue = temp;
      }
    }
  }
  return maxk;
}

void displayAnalogSignal(uint16_t color)
{
  int n;

  int oldx;
  int oldy;
  int x, y;
  float scale_x = 1;
  //scale_x=(float)SCREEN_WIDTH/DISPLAY_SIGNAL_LENGTH;

  for (n = 1; n < DISPLAY_SIGNAL_LENGTH; n++)
  {
    y = SCREEN_HEIGHT - SampledSignal[n] / 10 - 1;

    if (n == 1)
    {
      oldx = n;
      oldy = y;
    }

    tft.drawLine((n - 1)*scale_x , oldSignal[n - 1], n * scale_x , oldSignal[n], BLACK);
    tft.drawLine(oldx * scale_x,           oldy, n * scale_x , y  , color);
    oldSignal[n - 1] = oldy;
    oldx = n;
    oldy = y;
  }
}
char Number[20];
void loop(void)
{
  //displayAnalogSignal(GREEN);
  double preMax = -100.0;
  while (1) {
    // Sampling
    Sampling(sound_wave, re, im);
    // FFT
    myFFT2(Xr, Xi, 0, re, im, N, 0, 1);
    // Post-processing
    preMax = postProcessing(Xr, Xi, preMax);
    itoa((int)preMax, Number, 10);
    tft.printAt("       [Hz] peak frequency", 30, 10);
    tft.printAt(Number, 30, 10);
    //Serial.println(preMax);
    displayAnalogSignal(GREEN);
  }
}
