/* -------------------------------------------------------
                         ili9163_small.c

     Demoprogramm fuer erstes Lebenszeichen des Displays

     MCU   :  STM8S103F3
     Takt  :  interner Takt 16 MHz

     19.05.2016  R. Seelig
   ------------------------------------------------------ */

#include "ili9163.h"

#include "female84.h"

#define printf       my_printf


/* --------------------------------------------------------
   putchar

   wird von my-printf / printf aufgerufen und hier muss
   eine Zeichenausgabefunktion angegeben sein, auf das
   printf dann schreibt !
   -------------------------------------------------------- */
void putchar(char ch)
{
  lcd_putchar(ch);
}

int main(void)
{
  char  b;
  int   x;

  sysclock_init(0);
//  sysclock_init(1);

  printfkomma= 2;

  lcd_init();

  while(1)
  {
  bkcolor= rgbfromega(15);
  clrscr();
  showimage(18,40,&bmppic[0],rgbfromega(0));
  textcolor= rgbfromega(blue);
  for (b= 3; b > -1; b--)
  {
	gotoxy(2,12);
	printf("Countdown: %d ",b);
	delay_ms(1000);
  }

  textcolor= rgbfromega(14);
  bkcolor= rgbfromvalue(0x00,0x00,0x66);
  clrscr();
  bkcolor= rgbfromvalue(0x20,0x20,0xff);
  fillrect(6,6,122,122,rgbfromvalue(0x20,0x20,0xff));
  gotoxy(2,1); printf("STM8S103F3P6\n\r");
  gotoxy(2,2); printf("    16MHz\n\r");
  gotoxy(2,3); printf("-------------\n\r");
  gotoxy(2,4); printf("by R.Seelig %c", 0x82);

  fillcircle(64,85,25, rgbfromvalue(0x66,0x00,0x00));
  for (x= 51; x< 121; x++)
  {
    putpixel(x,x,rgbfromvalue(0x00,0x80,0x00));
  }
  line(30,51,97,121,rgbfromega(yellow));

  delay_ms(2500);
  }


}
