/* -------------------------------------------------------
                         ili9163.c

     Bibliothek fuer TFT 1.44" 128 x 128 Pixel / 16 Bit
     Color mit ILI9163 Chip (China-Display)

     MCU   :  STM8S103F3
     Takt  :  interner Takt 16 MHz

     22.06.2016  R. Seelig
   ------------------------------------------------------ */

#ifndef in_ili9163
  #define in_ili9163

  #include "stm8s.h"
  #include "stm8_init.h"
  #include "stm8_gpio.h"
  #include "spi.h"
  #include "my_printf.h"

/* -------------------------------------------------------------
                 Hardwareanbindung LCD Pins
   ------------------------------------------------------------- */

  #define LCD_PORT                PC_ODR
  #define LCD_CR1                 PC_CR1
  #define LCD_DDR                 PC_DDR
  #define LCD_RST_PIN             PC3
  #define LCD_DC_PIN              PC4


  /*  ------------------------------------------------------------
       soll innerhalb der fillrect - Funktion ein Fastfill mittels
       der Funktionen des Displays vorgenommen werden (hier
       funktioniert dann ein "Drehen" mittels outmode NICHT)
     ------------------------------------------------------------- */

  #define  fastfillmode             1

  /*  ------------------------------------------------------------
                         P R O T O T Y P E N
      ------------------------------------------------------------ */

  // ----------------- LCD - Benutzerfunktionen ---------------

  void lcd_init(void);                                                        // initialisiert Display
  void putpixel(int x, int y,uint16_t color);                                 // schreibt einen einzelnen Punkt auf das Display
  void clrscr();                                                              // loescht Display-Inhalt
  void fastxline(uint8_t x1, uint8_t y1, uint8_t x2, uint16_t color);         // zeichnet eine Linie in X-Achse
  void fillrect(int x1, int y1, int x2, int y2, uint16_t color);              // fuellt einen rechteckigen Bereich mit Farbe aus
  uint16_t rgbfromvalue(uint8_t r, uint8_t g, uint8_t b);                     // konvertiert einen 24 Bit RGB-Farbwert in einen 16 Bit Farbwert
  uint16_t rgbfromega(uint8_t entry);                                         // konvertiert einen Farbwert aus der EGA-Palette in einen 16 Bit Farbwert
  void gotoxy(unsigned char x, unsigned char y);                              // setzt den Textcursor fuer Textausgaben
  void lcd_putchar(unsigned char ch);                                         // setzt ein Zeichen auf das Display
  void lcd_putcharxy(int oldx, int oldy, unsigned char ch);                   // setzt ein Zeichen auf den GRAFIK-Bildschirm (Hintergrund unveraendert)
  void outtextxy(int x, int y, unsigned char *c);                             // gibt einen String auf dem Display aus
  void line(int x0, int y0, int x1, int y1, uint16_t color);                  // zeichnet eine Linie
  void rectangle(int x1, int y1, int x2, int y2, uint16_t color);             // zeichnet ein Rechteck
  void ellipse(int xm, int ym, int a, int b, uint16_t color );                // zeichnet eine Ellipse
  void fillellipse(int xm, int ym, int a, int b, uint16_t color );            // zeichnet eine ausgefuellte Ellipse
  void circle(int x, int y, int r, uint16_t color );                          // zeichnet einen Kreis
  void fillcircle(int x, int y, int r, uint16_t color );                      // zeichnet einen ausgefuellten Kreis
  void showimage(int ox, int oy, const unsigned char* const image, uint16_t fwert);     // zeichnet ein monochromes Bitmap
  void putstring(char *c);                                                    // schreibt einen Textstring auf das LCD

  // ---------------- Low-level Displayfunktionen -------------

  void set_ram_address (uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2);  // setzt den zu beschreibenden Speicherbereich
  void setcol(int startcol);                    // setzt zu beschreibende Spalte
  void setpage(int startpage);                  // setzt zu beschreibende Reihe
  void setxypos(int x, int y);                  // setzt die zu beschreibende Koordinate im Display-Ram

  // --------------------- SPI-Funktionen ---------------------

  void wrcmd(uint8_t cmd);                      // schreibt einzelnes Kommandodatum (Registerzugriff)
  void wrdata(uint8_t data);                    // schreibt einzelnen Registerwert oder Ramwert
  void wrdata16(int data);                      // schreibt einen Integerwert

  /*  ------------------------------------------------------------
                         Displayaufloesung
      ------------------------------------------------------------ */

  #define _xres                   128
  #define _yres                   128

  /*  ------------------------------------------------------------
                      EGA - Farbzuweisungen
      ------------------------------------------------------------ */

  #define black                   0
  #define blue                    1
  #define green                   2
  #define cyan                    3
  #define red                     4
  #define magenta                 5
  #define brown                   6
  #define grey                    7
  #define darkgrey                8
  #define lightblue               9
  #define lightgreen              10
  #define lightcyan               11
  #define lightred                12
  #define lightmagenta            13
  #define yellow                  14
  #define white                   15


  extern int      aktxp;                    // Beinhaltet die aktuelle Position des Textcursors in X-Achse
  extern int      aktyp;                    // dto. fuer die Y-Achse
  extern uint16_t textcolor;                // Beinhaltet die Farbwahl fuer die Vordergrundfarbe
  extern uint16_t bkcolor;                  // dto. fuer die Hintergrundfarbe
  extern uint8_t  outmode;                  // Variable zum "Drehen" der Displayausgabe
  extern uint8_t  textsize;                 // Skalierung der Ausgabeschriftgroesse
  extern uint8_t  fontsizex;                // benoetigte Variable zur Positionierung von gotoxy x Achse
  extern uint8_t  fontsizey;                // dto. y Achse

  const extern uint16_t egapalette [];      // RGB565 Farbwerte der EGA-Palette


  //-------------------------------------------------------------
  // Registerzuordnung der Adressierungsregister der
  // verschiedenen Displaycontroller
  //-------------------------------------------------------------

  #define coladdr      0x2a
  #define rowaddr      0x2b
  #define writereg     0x2c

  //-------------------------------------------------------------
  //  Initialisierungssequenz
  //-------------------------------------------------------------

  #define delay_flag 0x80                              // Markierungsflag: bestimmt, ob nach einem Kommando

  static const uint8_t  s6d02a_seq[] =                 // Initialisierungssequenzen
  {
    29,                                                // Anzahl Gesamtkommandos

  /*
    Byte 0 | Byte 1       | Byte 2 u. folgende | evtl. Delaytime-Byte
    CMD    | Anzahl Datas | Datas | evtl. Delaytime
  */

    0xf0, 2,0x5a,0x5a,
    0xfc, 2,0x5a,0x5a,                                                                   // Excommand3
    0x26, 1,0x01,                                                                        // Gammaset
    0xfa, 15,0x02,0x1f,0x00,0x10,0x22,0x30,0x38,0x3A,0x3A,0x3A,0x3A,0x3A,0x3d,0x02,0x01, // Positivegammacontrol
    0xfb, 15,0x21,0x00,0x02,0x04,0x07,0x0a,0x0b,0x0c,0x0c,0x16,0x1e,0x30,0x3f,0x01,0x02, // Negativegammacontrol
    0xfd, 11,0x00,0x00,0x00,0x17,0x10,0x00,0x01,0x01,0x00,0x1f,0x1f,                     // Analogparametercontrol
    0xf4, 15,0x00,0x00,0x00,0x00,0x00,0x3f,0x3f,0x07,0x00,0x3C,0x36,0x00,0x3C,0x36,0x00, // Powercontrol
    0xf5, 13,0x00,0x70,0x66,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x6d,0x66,0x06,           // VCOMcontrol
    0xf6, 11,0x02,0x00,0x3f,0x00,0x00,0x00,0x02,0x00,0x06,0x01,0x00,                     // Sourcecontrol
                                                                                         // Displaycontrol
    0xf2, 17,0x00,0x01,0x03,0x08,0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x04,0x08,0x08,
    0xf8, 1, 0x11,                                                                       // Gatecontrol
    0xf7, 4,0xc8,0x20,0x00,0x00,                                                         //Interfacecontrol
    0xf3, 2,0x00,0x00,                                                                   //Powersequencecontrol
    0x11, delay_flag,50,                                                                 //Wake
    0xf3, 2+delay_flag,0x00,0x01,50,                                                     //Powersequencecontrol
    0xf3, 2+delay_flag,0x00,0x03,50,
    0xf3, 2+delay_flag,0x00,0x07,50,
    0xf3, 2+delay_flag,0x00,0x0f,50,
    0xf4, 15+delay_flag,0x00,0x04,0x00,0x00,0x00,0x3f,0x3f,0x07,0x00,0x3C,0x36,0x00,0x3C,0x36,0x00,50,
    0xf3, 2+delay_flag,0x00,0x1f,50,
    0xf3, 2+delay_flag,0x00,0x7f,50,
    0xf3, 2+delay_flag,0x00,0xff,50,
    0xfd, 11,0x00,0x00,0x00,0x17,0x10,0x00,0x00,0x01,0x00,0x16,0x16,                     // Analogparametercontrol
    0xf4, 15,0x00,0x09,0x00,0x00,0x00,0x3f,0x3f,0x07,0x00,0x3C,0x36,0x00,0x3C,0x36,0x00,
    0x36, 1,0x08,                                                                        //Memoryaccessdatacontrol
    0x35, 1,0x00,                                                                        //Tearingeffectlineon
    0x3a, 1+delay_flag,0x05,150,                                                         //Interfacepixelcontrol
    0x29,0,                                                                              //Displayon
    0x2c,0                                                                               //Memorywrite
  };

  static const unsigned char font8x8[][8]  =
  {
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00},  // 0x20     Leerzeichen
    {0x30,0x78,0x78,0x30,0x30,0x00,0x30,0x00},	// 0x21     !
    {0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00},	// 0x22     "
    {0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00},	// 0x23     #
    {0x30,0x7C,0xC0,0x78,0x0C,0xF8,0x30,0x00},	// 0x24     $
    {0x00,0xC6,0xCC,0x18,0x30,0x66,0xC6,0x00},	// 0x25     %
    {0x38,0x6C,0x38,0x76,0xDC,0xCC,0x76,0x00},	// 0x26     &
    {0x60,0x60,0xC0,0x00,0x00,0x00,0x00,0x00},	// 0x27     '
    {0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00},	// 0x28     (
    {0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00},	// 0x29     )
    {0x00,0x66,0x3C,0xFF,0x3C,0x66,0x00,0x00},	// 0x2A     *
    {0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00},	// 0x2B     +
    {0x00,0x00,0x00,0x00,0x00,0x70,0x30,0x60},	// 0x2C     ,
    {0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00},	// 0x2D     -
    {0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00},	// 0x2E     .
    {0x06,0x0C,0x18,0x30,0x60,0xC0,0x80,0x00},	// 0x2F     /
    {0x78,0xCC,0xDC,0xFC,0xEC,0xCC,0x78,0x00},	// 0x30     0
    {0x30,0xF0,0x30,0x30,0x30,0x30,0xFC,0x00},	// 0x31     1
    {0x78,0xCC,0x0C,0x38,0x60,0xCC,0xFC,0x00},	// 0x32     2
    {0x78,0xCC,0x0C,0x38,0x0C,0xCC,0x78,0x00},	// 0x33     3
    {0x1C,0x3C,0x6C,0xCC,0xFE,0x0C,0x0C,0x00},	// 0x34     4
    {0xFC,0xC0,0xF8,0x0C,0x0C,0xCC,0x78,0x00},	// 0x35     5
    {0x38,0x60,0xC0,0xF8,0xCC,0xCC,0x78,0x00},	// 0x36     6
    {0xFC,0xCC,0x0C,0x18,0x30,0x60,0x60,0x00},	// 0x37     7
    {0x78,0xCC,0xCC,0x78,0xCC,0xCC,0x78,0x00},	// 0x38     8
    {0x78,0xCC,0xCC,0x7C,0x0C,0x18,0x70,0x00},	// 0x39     9
    {0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x00},	// 0x3A     :
    {0x00,0x00,0x30,0x30,0x00,0x70,0x30,0x60},	// 0x3B     ;
    {0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x00},	// 0x3C     <
    {0x00,0x00,0xFC,0x00,0xFC,0x00,0x00,0x00},	// 0x3D     =
    {0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00},	// 0x3E     >
    {0x78,0xCC,0x0C,0x18,0x30,0x00,0x30,0x00},	// 0x3F     ?
    {0x7C,0xC6,0xDE,0xDE,0xDE,0xC0,0x78,0x00},	// 0x40     @
    {0x30,0x78,0xCC,0xCC,0xFC,0xCC,0xCC,0x00},	// 0x41     A
    {0xFC,0x66,0x66,0x7C,0x66,0x66,0xFC,0x00},	// 0x42     B
    {0x3C,0x66,0xC0,0xC0,0xC0,0x66,0x3C,0x00},	// 0x43     C
    {0xFC,0x6C,0x66,0x66,0x66,0x6C,0xFC,0x00},	// 0x44     D
    {0xFE,0x62,0x68,0x78,0x68,0x62,0xFE,0x00},	// 0x45     E
    {0xFE,0x62,0x68,0x78,0x68,0x60,0xF0,0x00},	// 0x46     F
    {0x3C,0x66,0xC0,0xC0,0xCE,0x66,0x3E,0x00},	// 0x47     G
    {0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0x00},	// 0x48     H
    {0x78,0x30,0x30,0x30,0x30,0x30,0x78,0x00},	// 0x49     I
    {0x1E,0x0C,0x0C,0x0C,0xCC,0xCC,0x78,0x00},	// 0x4A     J
    {0xE6,0x66,0x6C,0x78,0x6C,0x66,0xE6,0x00},	// 0x4B     K
    {0xF0,0x60,0x60,0x60,0x62,0x66,0xFE,0x00},	// 0x4C     L
    {0xC6,0xEE,0xFE,0xD6,0xC6,0xC6,0xC6,0x00},	// 0x4D     M
    {0xC6,0xE6,0xF6,0xDE,0xCE,0xC6,0xC6,0x00},	// 0x4E     N
    {0x38,0x6C,0xC6,0xC6,0xC6,0x6C,0x38,0x00},	// 0x4F     O
    {0xFC,0x66,0x66,0x7C,0x60,0x60,0xF0,0x00},	// 0x50     P
    {0x78,0xCC,0xCC,0xCC,0xDC,0x78,0x1C,0x00},	// 0x51     Q
    {0xFC,0x66,0x66,0x7C,0x78,0x6C,0xE6,0x00},	// 0x52     R
    {0x78,0xCC,0xE0,0x38,0x1C,0xCC,0x78,0x00},	// 0x53     S
    {0xFC,0xB4,0x30,0x30,0x30,0x30,0x78,0x00},	// 0x54     T
    {0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xFC,0x00},	// 0x55     U
    {0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x30,0x00},	// 0x56     V
    {0xC6,0xC6,0xC6,0xD6,0xFE,0xEE,0xC6,0x00},	// 0x57     W
    {0xC6,0xC6,0x6C,0x38,0x6C,0xC6,0xC6,0x00},	// 0x58     X
    {0xCC,0xCC,0xCC,0x78,0x30,0x30,0x78,0x00},	// 0x59     Y
    {0xFE,0xCC,0x98,0x30,0x62,0xC6,0xFE,0x00},	// 0x5A     Z
    {0x78,0x60,0x60,0x60,0x60,0x60,0x78,0x00},	// 0x5B     [
    {0xC0,0x60,0x30,0x18,0x0C,0x06,0x02,0x00},	// 0x5C     Backslash
    {0x78,0x18,0x18,0x18,0x18,0x18,0x78,0x00},	// 0x5D     ]
    {0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00},	// 0x5E     ^
    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF},	// 0x5F     _
    {0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00},	// 0x60     `
    {0x00,0x00,0x78,0x0C,0x7C,0xCC,0x76,0x00},	// 0x61     a
    {0xE0,0x60,0x7C,0x66,0x66,0x66,0xFC,0x00},	// 0x62     b
    {0x00,0x00,0x78,0xCC,0xC0,0xCC,0x78,0x00},	// 0x63     c
    {0x1C,0x0C,0x0C,0x7C,0xCC,0xCC,0x76,0x00},	// 0x64     d
    {0x00,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00},	// 0x65     e
    {0x38,0x6C,0x60,0xF0,0x60,0x60,0xF0,0x00},	// 0x66     f
    {0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0xF8},	// 0x67     g
    {0xE0,0x60,0x6C,0x76,0x66,0x66,0xE6,0x00},	// 0x68     h
    {0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00},	// 0x69     i
    {0x18,0x00,0x78,0x18,0x18,0x18,0xD8,0x70},	// 0x6A     j
    {0xE0,0x60,0x66,0x6C,0x78,0x6C,0xE6,0x00},	// 0x6B     k
    {0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00},	// 0x6C     l
    {0x00,0x00,0xEC,0xFE,0xD6,0xC6,0xC6,0x00},	// 0x6D     m
    {0x00,0x00,0xF8,0xCC,0xCC,0xCC,0xCC,0x00},	// 0x6E     n
    {0x00,0x00,0x78,0xCC,0xCC,0xCC,0x78,0x00},	// 0x6F     o
    {0x00,0x00,0xDC,0x66,0x66,0x7C,0x60,0xF0},	// 0x70     p
    {0x00,0x00,0x76,0xCC,0xCC,0x7C,0x0C,0x1E},	// 0x71     q
    {0x00,0x00,0xD8,0x6C,0x6C,0x60,0xF0,0x00},	// 0x72     r
    {0x00,0x00,0x7C,0xC0,0x78,0x0C,0xF8,0x00},	// 0x73     s
    {0x10,0x30,0x7C,0x30,0x30,0x34,0x18,0x00},	// 0x74     t
    {0x00,0x00,0xCC,0xCC,0xCC,0xCC,0x76,0x00},	// 0x75     u
    {0x00,0x00,0xCC,0xCC,0xCC,0x78,0x30,0x00},	// 0x76     v
    {0x00,0x00,0xC6,0xC6,0xD6,0xFE,0x6C,0x00},	// 0x77     w
    {0x00,0x00,0xC6,0x6C,0x38,0x6C,0xC6,0x00},	// 0x78     x
    {0x00,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0xF8},	// 0x79     y
    {0x00,0x00,0xFC,0x98,0x30,0x64,0xFC,0x00},	// 0x7A     z
    {0x1C,0x30,0x30,0xE0,0x30,0x30,0x1C,0x00},	// 0x7B     {
    {0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00},	// 0x7C
    {0xE0,0x30,0x30,0x1C,0x30,0x30,0xE0,0x00},	// 0x7D     }
    {0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00},	// 0x7E
    {0x10,0x38,0x6C,0xC6,0xC6,0xC6,0xFE,0x00},	// 0x7F
    {0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},      // 0x80     ausgefuelltes Quadrat
    {0x70,0xd8,0xd8,0x70,0x00,0x00,0x00,0x00},      // 0x81     Grad Celcius Zeichen
    {0x38,0x44,0x82,0x44,0x28,0xaa,0xee,0x00}       // 0x82     Ohm - Zeichen
  };

#endif
