; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; INITIALISIERUNG																
;																				
ONE_WIRE_INITIALISIERUNG:
	; DATENBUS											
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)								; AUF EINGANG	
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)								; PULL-UP ein	
	rcall WAIT_10ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ONE_WIRE_BUS_RESET:
	; DATENBUS-RESET (2s LOW)						
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)								; AUF AUSGANG	
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)								; LOW			
	rcall WAIT_1s
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)								; AUF EINGANG	
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)								; PULL-UP ein	
	rcall WAIT_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; GELB leuchtet, wenn Kurzschluss auf BUS										
ONE_WIRE_BUS_CHECK:
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB aus		
	ldi temp,255
ONE_WIRE_BUS_CHECK_s:
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip if..."	
	ret	
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB an		
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN aus		
	rcall wait_10ms
	dec temp
	brne ONE_WIRE_BUS_CHECK_s
; ------------------------------------------------------------------------------
	; ERROR					
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF EINGANG	
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; PULL-UP ein	
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR		; ROT  an		
	ldi temp,(ERROR_OW_BUS)
	STS(adr_ERROR_CODE),temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ONE_WIRE_BUS_POWER_CHECK:
	sbic (ONE_WIRE_DDR),(ONE_WIRE_PIN_NR) 	; "skip if..."	
	cbi (LED_BLAU_PORT),(LED_BLAU_PIN_NR)	; BLAU an		
	sbis (ONE_WIRE_DDR),(ONE_WIRE_PIN_NR) 	; "skip if..."	
	sbi (LED_BLAU_PORT),(LED_BLAU_PIN_NR)	; BLAU aus		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; OUT: CARRY	0=ERROR 1=OK													
;																				
ONE_WIRE_RESET_PRESENCE_C:
	WDR	
	; PIN schon auf HIGH ?					
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN LOW"
	rjmp ONE_WIRE_RESET_PRESENCE_C_RUN
; ------------------------------------------------------------------------------
	; PIN auf EINGANG + HIGH				
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 	
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	NOP										; etwas warten	
	NOP
	NOP
	NOP
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF EINGANG	
	rcall WAIT_10ms							; PAUSE 		
	; PIN HIGH ? Wenn LOW, dann ERROR		
	sbis (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN HIGH"
	rjmp ONE_WIRE_RESET_PRESENCE_C_ERROR
; ------------------------------------------------------------------------------
ONE_WIRE_RESET_PRESENCE_C_RUN:
	; PIN auf AUSGANG und LOW				
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; AUF LOW		
	rcall WAIT_500us						; PAUSE 500ms	
	; PIN auf EINGANG + HIGH				
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 	
	NOP										; etwas warten	
	NOP
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF EINGANG	
	NOP										; etwas warten	
	NOP
	; PIN HIGH ? Wenn LOW, dann ERROR		
	sbis (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN HIGH"	
	rjmp ONE_WIRE_RESET_PRESENCE_C_ERROR
	rcall WAIT_50us							; Pause 50s 			
	; SAMPLES - Wenn HIGH, dann ERROR		
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN LOW"	
	rjmp ONE_WIRE_RESET_PRESENCE_C_ERROR
; ------------------------------------------------------------------------------
	; PRESENCE-IMPULS abwarten, bis PIN wieder HIGH ist		
ONE_WIRE_RESET_PRESENCE_C_S1:
	sbis (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip wenn PIN HIGH"	
	rjmp ONE_WIRE_RESET_PRESENCE_C_S1
; ------------------------------------------------------------------------------
	; Verbesserung der Flankensteilheit		
	;sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF EINGANG	
	rcall WAIT_100us						; PAUSE		


	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)		; ROT  aus	
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN an	
	SEC										; CARRY=1	
	ret
; ------------------------------------------------------------------------------
ONE_WIRE_RESET_PRESENCE_C_ERROR:
	; ERROR									
	ldi temp,(ERROR_OW_RESET_PRESENCE)
	STS(adr_ERROR_CODE),temp
	rcall WAIT_100us						; PAUSE 10us
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)		; ROT  an	
	CLC										; CARRY=0	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 1 DATENBYTE 1-wire schreiben													
;																				
; inp: temp1																	
;																				
ONE_WIRE_BYTE_WRITE_TEMP1:
	LSR temp1						; 1x rechts 1 rollt raus (LSB)
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-0 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-1 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-2 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-3 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-4 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-5 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus 	
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-6 schreiben			
	LSR temp1						; 1x rechts 1 rollt raus (MSB)
	rcall ONE_WIRE_BIT_WRITE_C		; BIT-7 schreiben			
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; DATEN-BIT schreiben															
;																				
; Hier kommt es auf Zeiten an, stimmen die Zeiten nicht, werden die BITs vom	
; MASTER an den SLAVE nicht genau gelesen ! (ggf. mit OSZI prfen)				
;																				
; INP: CARRY																	
;																				
ONE_WIRE_BIT_WRITE_C:
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB an	
	; CARRY auswerten													
	brcs ONE_WIRE_DATA_WRITE_BIT_HIGH		; wenn CARRY=1 dann HIGH	
	; "0" SLOT 60s (LOW-PEGEL)											
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 				
	sbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF AUSGANG				
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; LOW-PEGEL					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	; mind. 10s (HIGH-PEGEL)											
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 				
;	cbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF EINGANG				
	rcall WAIT_10us							; PAUSE 					
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB aus	
ret
;-------------------------------------------------------------------------------
ONE_WIRE_DATA_WRITE_BIT_HIGH:
	; "1" SLOT 5s (LOW-PEGEL)											
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 				
	sbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF AUSGANG				
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; LOW-PEGEL					
	rcall WAIT_5us							; PAUSE						
	; mind. 64s (HIGH-PEGEL)											
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 				
;	cbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF EINGANG				
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	rcall WAIT_10us							; PAUSE 					
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 1 DATENBYTE 1-wire lesen														
;																				
; out: temp1																	
;																				
ONE_WIRE_BYTE_READ_TEMP1:
	clr temp1
	rcall ONE_WIRE_BIT_READ_C		; LSB					
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	rcall ONE_WIRE_BIT_READ_C
	ROR temp1						; 1x rechts ber CARRY 	
	ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ein BIT vom SLAVE einlesen													
;																				
; Hier kommt es auf Zeiten an, stimmen die Zeiten nicht, werden die BITs vom	
; MASTER an den SLAVE nicht genau gelesen ! (ggf. mit OSZI prfen)				
;																				
; OUT: CARRY																	
;																				
ONE_WIRE_BIT_READ_C:
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB an		
	; kurzer LOW-IMPULS 1...5s								
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 	
	sbi (ONE_WIRE_DDR) ,(ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; LOW-PEGEL		
	; diese Pause ist kritisch, hier ggf. nachbessern		
	rcall WAIT_5us					; 5s PAUSE				
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF EINGANG	
	; diese Pause ist kritisch, hier ggf. nachbessern		
	rcall WAIT_10us							; ca 10s warten
	; MASTER SAMPLES			
	sbic (ONE_WIRE_PIN),(ONE_WIRE_PIN_NR) 	; "skip if..."	
	rjmp ONE_WIRE_DATA_READ_1_SLOT
	rjmp ONE_WIRE_DATA_READ_0_SLOT
;-------------------------------------------------------------------------------
ONE_WIRE_DATA_READ_0_SLOT:
	rcall WAIT_100us						; warten		
	CLC										; CARRY clear	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB aus		
	ret
;-------------------------------------------------------------------------------
ONE_WIRE_DATA_READ_1_SLOT:
	rcall WAIT_100us						; warten		
	SEC										; CARRY setzen	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB aus		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ONE_WIRE_ROM_CLEAR:
	STS(adr_ROM_CRC_BEREICH8+0),NULL			; FAMILY	
	STS(adr_ROM_CRC_BEREICH8+1),NULL
	STS(adr_ROM_CRC_BEREICH8+2),NULL
	STS(adr_ROM_CRC_BEREICH8+3),NULL
	STS(adr_ROM_CRC_BEREICH8+4),NULL
	STS(adr_ROM_CRC_BEREICH8+5),NULL
	STS(adr_ROM_CRC_BEREICH8+6),NULL
	STS(adr_ROM_CRC_BEREICH8+7),NULL 		; CRC		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; CLEAR																			
ONE_WIRE_SCRATCHPAD_CLEAR:
	STS(adr_SCRATCHPAD10+0),NULL
	STS(adr_SCRATCHPAD10+1),NULL
	STS(adr_SCRATCHPAD10+2),NULL
	STS(adr_SCRATCHPAD10+3),NULL
	STS(adr_SCRATCHPAD10+4),NULL
	STS(adr_SCRATCHPAD10+5),NULL
	STS(adr_SCRATCHPAD10+6),NULL
	STS(adr_SCRATCHPAD10+7),NULL
	STS(adr_SCRATCHPAD10+8),NULL
	STS(adr_SCRATCHPAD10+9),NULL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ONE_WIRE_SCRATCHPAD_READ:
	rcall ONE_WIRE_SCRATCHPAD_CLEAR				; CLEAR		

	rcall ONE_WIRE_RESET_PRESENCE_C				; RESET-PRESENCE
	brcs ONE_WIRE_SCRATCHPAD_READ_RUN
	ret
;-------------------------------------------------------------------------------
ONE_WIRE_SCRATCHPAD_READ_RUN:
	ldi temp1,0x55 								; MATCH-ROM	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	
	LDS temp1,(adr_ROM_CRC_BEREICH8+0)			; ROM-ID	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	LDS temp1,(adr_ROM_CRC_BEREICH8+1)			; ROM-ID	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	LDS temp1,(adr_ROM_CRC_BEREICH8+2)			; ROM-ID	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	LDS temp1,(adr_ROM_CRC_BEREICH8+3)			; ROM-ID	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	LDS temp1,(adr_ROM_CRC_BEREICH8+4)			; ROM-ID	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	LDS temp1,(adr_ROM_CRC_BEREICH8+5)			; ROM-ID	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	LDS temp1,(adr_ROM_CRC_BEREICH8+6)			; ROM-ID	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	LDS temp1,(adr_ROM_CRC_BEREICH8+7)			; ROM-ID	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1

	ldi temp1,0xBE 								; SCRATCHPAD-read
	rcall ONE_WIRE_BYTE_WRITE_TEMP1

	rcall ONE_WIRE_BYTE_READ_TEMP1				; auslesen	
	STS(adr_SCRATCHPAD10+0),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1				
	STS(adr_SCRATCHPAD10+1),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1				
	STS(adr_SCRATCHPAD10+2),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1				
	STS(adr_SCRATCHPAD10+3),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1				
	STS(adr_SCRATCHPAD10+4),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1				
	STS(adr_SCRATCHPAD10+5),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1				
	STS(adr_SCRATCHPAD10+6),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1				
	STS(adr_SCRATCHPAD10+7),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1				
	STS(adr_SCRATCHPAD10+8),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1				
	STS(adr_SCRATCHPAD10+9),temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ROM auslesen, nur ein SLAVE vorhanden !										
;																				
; OUT: CARRY, SRAM (adr_ROM_CRC_BEREICH)										
;																				
ONE_WIRE_SINGLE_ROM_READ:
	; CLEAR										
	rcall ONE_WIRE_ROM_CLEAR
	; RESET										
	rcall ONE_WIRE_RESET_PRESENCE_C				; RESET-PRESENCE	
	brcs ONE_WIRE_SINGLE_ROM_READ_RUN			; CARRY=1 ==> SPRUNG
	ret
;-------------------------------------------------------------------------------
ONE_WIRE_SINGLE_ROM_READ_RUN:
	; MASTER TX x33 (read ROM)					
	ldi	temp1,0x33			
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	; MASTER RX 8 BYTE und im SRAM ablegen		
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_ROM_CRC_BEREICH8+0),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_ROM_CRC_BEREICH8+1),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_ROM_CRC_BEREICH8+2),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_ROM_CRC_BEREICH8+3),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_ROM_CRC_BEREICH8+4),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_ROM_CRC_BEREICH8+5),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_ROM_CRC_BEREICH8+6),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_ROM_CRC_BEREICH8+7),temp1
	; ROM CRC- CHECK							
	rcall ROM_CRC7_C						; OUT: CARRY		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; SCRATCHPAD auslesen, nur ein SLAVE vorhanden !								
;																				
; OUT: CARRY, SRAM (adr_SCRATCHPAD_CRC_BEREICH)									
;																				
ONE_WIRE_SINGLE_SCRATCHPAD_READ:
	; CLEAR												
	rcall ONE_WIRE_SCRATCHPAD_CLEAR
	; RESET												
	rcall ONE_WIRE_RESET_PRESENCE_C				; RESET-PRESENCE
	brcs ONE_WIRE_SINGLE_SCRATCHPAD_READ_RUN
	ret
;-------------------------------------------------------------------------------
ONE_WIRE_SINGLE_SCRATCHPAD_READ_RUN:
	; MASTER TX xCC (SKIP ROM)							
	ldi	temp1,0xCC
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	; MASTER TX xBE (read SCRATCHPAD)					
	ldi	temp1,0xBE			
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	; MASTER RX 9 BYTE und im SRAM ablegen		
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_SCRATCHPAD10+0),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_SCRATCHPAD10+1),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_SCRATCHPAD10+2),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_SCRATCHPAD10+3),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_SCRATCHPAD10+4),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_SCRATCHPAD10+5),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_SCRATCHPAD10+6),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_SCRATCHPAD10+7),temp1
	rcall ONE_WIRE_BYTE_READ_TEMP1
	STS(adr_SCRATCHPAD10+8),temp1
	; CRC CHECK													
	rcall SCRATCHPAD_CRC8_C
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
