; ##############################################################################
; ##############################################################################
; ##############################################################################
; CRC Berechnung bernommen und abgendert von: http://s-huehn.de				
; CRC-Berechnung Application Note 27 von Dallas/Maxim							
;																				
; INP: SRAM(adr_ROM_CRC_BEREICH)												
; OUT: CARRY + R0(CRC-WERT)														
;																				
ROM_CRC7_C:
	push XL          						; auf dem Stack sichern            
	push XH
	push r16
	push r17
	push r18
	push r19
	push r20
	push r21
 	ldi XL,low (adr_ROM_CRC_BEREICH8) 		; X-Zeiger 					
    ldi XH,high(adr_ROM_CRC_BEREICH8) 
    ldi     r19, 7                          ;7 Bytes berechnen			
    ldi     r20, 0x18                       ;Konstante fr Berechnung
    clr     r17                            	;CRC-Startwert = 0 setzen
ROM_CRC7_100: 
	ld      r18, x+                         ;Byte aus Puffer holen
    mov     r21, r18                        ;Byte zwischenspeichern
    ldi     r16, 8                          ;8 Verschiebungen
ROM_CRC7_200: 
	eor     r18, r17                      	;CRC berechnen
    ror     r18                             ;Ergebnis in Carry schieben
    mov     r18, r17                      	;letzten CRC-Wert holen
    brcc    ROM_CRC7_300                    ;war Ergebnis = 0? ja -> weiter
    eor     r18, r20                        ;sonst CRC-Wert updaten
ROM_CRC7_300: 
	ror     r18                             ;neuen CRC-Wert positionieren
    mov     r17, r18          	            ;und speichern
    mov     r18, r21                        ;restliche Bits holen
    bst     r18, 0                          ;LSB sichern, nchste Bitposition
    ror     r18                             ;gesichertes Bit als MSB einsetzen
    bld     r18, 7                          ;(Ersatz fr RR-Befehl)
    mov     r21, r18                        ;und Wert zwischenspeichern
    dec     r16                             ;alle Verschiebungen erledigt?
    brne    ROM_CRC7_200               ;nein -> Schleife
    dec     r19                             ;alle Bytes bearbeitet?
    brne    ROM_CRC7_100               ;nein -> Schleife
;-------------------------------------------------------------------------------
	mov R0,R17							; CRC nach R0 speichern		
	LDS r16,(adr_ROM_CRC_BEREICH8+7)
	cp r16,r17
	brne ROM_CRC7_ERROR
;-------------------------------------------------------------------------------
; OK																			
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN an	
	SEC										; CARRY=1	
	rjmp ROM_CRC7_FERTIG
;-------------------------------------------------------------------------------
; ERROR 																		
ROM_CRC7_ERROR:
	LDS temp,(adr_CRC_ON)
	tst temp
	brne ROM_CRC7_ERROR_w
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN aus	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)		; ROT  an	
	SEC										; CARRY=1	
	rjmp ROM_CRC7_FERTIG
;-------------------------------------------------------------------------------
ROM_CRC7_ERROR_w:
	ldi R16,(ERROR_OW_CRC)
	STS(adr_ERROR_CODE),R16
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN aus	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)		; ROT  an	
	CLC										; CARRY=0	
;-------------------------------------------------------------------------------
ROM_CRC7_FERTIG:
	pop r21      							; wiederherstellen                	
	pop r20
	pop r19
	pop r18
	pop r17
	pop r16
	pop XH
	pop XL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ROM_BUFFER_CLEAR:
	ldi XL,LOW (adr_ROM_BUFFER512)	 
	ldi XH,HIGH(adr_ROM_BUFFER512)
	clr temp
ROM_BUFFER_s:
	ST X+,NULL
	cpi XH,HIGH(adr_ROM_BUFFER512+512)
	brne ROM_BUFFER_s
	cpi XL,LOW (adr_ROM_BUFFER512+512)
	brne ROM_BUFFER_s
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; SUCHE nach unbekannten SLAVES im BUS											
; REGISTER:																		
;	temp	   Hilfsregister													
;	temp1	(1)SUCHBYTE															
;	temp6	(6)LASTnull  (0...63 / 255 Sonderfunktion)							
;	temp9	(9)BITzhler (0...63)												
;																				
; 	OUT: CARRY; SRAM(adr_ANZAHL_SLAVES), SRAM (adr_ROM_SLAVE_LISTE) "LISTE"		
;																				
;-------------------------------------------------------------------------------
ROM_SEARCH:
	; Initialisierung					
	rcall ROM_BUFFER_CLEAR
	rcall ROM_SEARCH_KNOTEN_CLEAR		; KNOTEN clear		
	STS(adr_ANZAHL_SLAVES),NULL			; ANZ. SLAVES clear	
;===============================================================================
ROM_SEARCH_NEXT_SLAVE:
	;Reset und Presence-Test			
	rcall ONE_WIRE_RESET_PRESENCE_C		; OUT: CARRY		
	brcs ROM_SEARCH_NEXT_SLAVE_w
	ret
ROM_SEARCH_NEXT_SLAVE_w:
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR; GRN aus			
	; MASTER TX xF0 (SEARCH ROM)		
	ldi	temp1,0xF0			
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	; CLEAR HILFSREGISTER 				
	clr temp1							;(1)SUCHBYTE		
	ldi	temp6,255						;(6)LASTnull		
	clr temp9							;(9)BITzhler		
;-------------------------------------------------------------------------------
ROM_SEARCH_NEXT_BIT:
	; BIT-A lesen						
	clr temp
	rcall ONE_WIRE_BIT_READ_C			; OUT: CARRY		
	ROL temp							; 1xlinks ber C	
	; BIT-B lesen						
	rcall ONE_WIRE_BIT_READ_C			; OUT: CARRY		
	ROL temp							; 1xlinks ber C	
	; ERROR (A)=(B)=1 ?					
	cpi temp,0b00000011
	brne ROM_SEARCH_NEXT_BIT_w
	; ERROR								
	ldi temp,(ERROR_OW_SEARCH_AB)
	STS(adr_ERROR_CODE),temp
	CLC									; CARRY clear		
	ret
;-------------------------------------------------------------------------------
ROM_SEARCH_NEXT_BIT_w:
	; vergleich (A) (B)					
	rcall ROM_SEARCH_AB_VERGLEICH_TEMP	; inp: temp			
	; ROM SUCHBYTE im CRC_BEREICH ablegen
	rcall ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1
	; alle Bits eingelesen ?			
	inc temp9							;(9)BITZHLER+1		
	cpi temp9,64						;(9)BITZHLER		
	brne ROM_SEARCH_NEXT_BIT			; ==> SCHLEIFE		
;===============================================================================
	; CRC-CHECK							
	rcall ROM_CRC7_C					; OUT CARRY			
	brcs ROM_SEARCH_CRC_OK
	ldi temp,(ERROR_OW_SEARCH_CRC)
	STS(adr_ERROR_CODE),temp
	CLC									; CARRY clear		
	ret
;-------------------------------------------------------------------------------
ROM_SEARCH_CRC_OK:
	; KNOTEN BEREINIGEN					
	rcall ROM_SEARCH_KNOTEN_BEREINIGEN_TEMP6
	; max SLAVES						
	LDS temp,(adr_ANZAHL_SLAVES)
	inc temp							; ANZAHL SLAVES +1	
	cpi temp,(ONE_WIRE_MAX_SLAVES+1)
	brlo ROM_SEARCH_OK
	; ERROR								
	ldi temp,(ERROR_OW_SEARCH_ANZAHL)
	STS(adr_ERROR_CODE),temp
	CLC									; CARRY clear		
	ret
;-------------------------------------------------------------------------------
ROM_SEARCH_OK:
	STS(adr_ANZAHL_SLAVES),temp
	; ROM im SRAM ablegen				
	rcall ROM_SEARCH_ERGEBNIS_SPEICHERN
	; Schleife							
	cpi temp6,255						;(6)LASTnull		
	breq ROM_SEARCH_FERTIG
	rcall WAIT_10ms
	rjmp ROM_SEARCH_NEXT_SLAVE			; ==> SCHLEIFE		
;===============================================================================
;===============================================================================
ROM_SEARCH_FERTIG:
	SEC	; CARRY setzen			
ret
; ##############################################################################
; inp: temp																		
; A=1 	0b00000010																
; B=1 	0b00000001																
; A=B=1 0b00000000																
;																				
; A und B miteinander vergleichen												
;																				
ROM_SEARCH_AB_VERGLEICH_TEMP:
	; A=B=temp=0 ? 	(0=DISCREPANCY)									
	tst temp							; =0 ?						
	breq ROM_SEARCH_DISCREPANCY			; ja  =>SPRUNG				
	; (A) zurcksenden												
	andi temp,0b00000010				; (A) selektieren			
	tst temp							; (A)=0 ?					
	breq ROM_SEARCH_TX_NULL				; ja, A=0 ==> NULL senden	
	rjmp ROM_SEARCH_TX_EINS  			;     A=1 ==> EINS senden	
;===============================================================================
ROM_SEARCH_DISCREPANCY:
	; KNOTEN laden													
	ldi ZL,LOW (adr_ROM_SEARCH_KNOTEN64); Z-initalisieren			
	ldi ZH,HIGH(adr_ROM_SEARCH_KNOTEN64)
	;(9)BITZHLER addieren											
	add ZL,temp9						;(9)BITZHLER				
	adc ZH,NULL
	LD temp,Z							; aus SRAM laden			
	tst temp							; ist NULL ?				
	breq ROM_SEARCH_DISCREPANCY_NULL	; ja=>SPRUNG				
	rjmp ROM_SEARCH_TX_EINS				; TX "1"					
;-------------------------------------------------------------------------------
ROM_SEARCH_DISCREPANCY_NULL:
	mov temp6,temp9						;(6)LASTnull=(9)BITZHLER	
	rjmp ROM_SEARCH_TX_NULL				; TX "0"					
; ##############################################################################
; ##############################################################################
; ##############################################################################
; WRITE BIT	0																	
ROM_SEARCH_TX_NULL:
	CLC									; CARRY=0	
	rcall ONE_WIRE_BIT_WRITE_C			; INP: Carry
	CLC									; CARRY=0	
	ROR temp1							; CARRY in's (1)SUCHBYTE	
ret
;-------------------------------------------------------------------------------
; WRITE BIT	1																	
ROM_SEARCH_TX_EINS:
	SEC									; CARRY=1	
	rcall ONE_WIRE_BIT_WRITE_C			; INP: Carry
	SEC									; CARRY=1	
	ROR temp1							; CARRY in's (1)SUCHBYTE	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; die letzte NULLPOSITION auf eins setzen 										
; und den oberen Bereich lschen,												
ROM_SEARCH_KNOTEN_BEREINIGEN_TEMP6:
	cpi temp6,255
	brne ROM_SEARCH_KNOTEN_setzen_w
	ret
ROM_SEARCH_KNOTEN_setzen_w:
	; Z-initalisieren											
	ldi ZL,LOW (adr_ROM_SEARCH_KNOTEN64)
	ldi ZH,HIGH(adr_ROM_SEARCH_KNOTEN64)
	; (6)LASTnull addieren										
	add ZL,temp6						;(6)LASTnull
	adc ZH,NULL
	; auf "1" und Z+1											
	ST Z+,EINS
	; Schleife													
	ldi temp,64+1
	sub temp,temp6						;(6)LASTnull
ROM_SEARCH_KNOTEN_setzen_s:
	ST z+,NULL
	dec temp
	brne ROM_SEARCH_KNOTEN_setzen_s
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ROM_SEARCH_KNOTEN_CLEAR:
	; Z-initalisieren				
	ldi ZL,LOW (adr_ROM_SEARCH_KNOTEN64)
	ldi ZH,HIGH(adr_ROM_SEARCH_KNOTEN64)
	; 64 Bytes CLEAR				
	ldi temp,64
ROM_SEARCH_KNOTEN_CLEAR_s:
	ST z+,NULL
	dec temp
	brne ROM_SEARCH_KNOTEN_CLEAR_s
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1:
	cpi temp9,(8-1)
	breq ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_0
	cpi temp9,(16-1)
	breq ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_1
	cpi temp9,(24-1)
	breq ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_2
	cpi temp9,(32-1)
	breq ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_3
	cpi temp9,(40-1)
	breq ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_4
	cpi temp9,(48-1)
	breq ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_5
	cpi temp9,(56-1)
	breq ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_6
	cpi temp9,(64-1)
	breq ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_7
ret
;-------------------------------------------------------------------------------
ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_0:
	STS(adr_ROM_CRC_BEREICH8+0),temp1
	ret
ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_1:
	STS(adr_ROM_CRC_BEREICH8+1),temp1
	ret
ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_2:
	STS(adr_ROM_CRC_BEREICH8+2),temp1
	ret
ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_3:
	STS(adr_ROM_CRC_BEREICH8+3),temp1
	ret
ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_4:
	STS(adr_ROM_CRC_BEREICH8+4),temp1
	ret
ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_5:
	STS(adr_ROM_CRC_BEREICH8+5),temp1
	ret
ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_6:
	STS(adr_ROM_CRC_BEREICH8+6),temp1
	ret
ROM_SEARCH_SUCHBYTE_SPEICHERN_TEMP1_7:
	STS(adr_ROM_CRC_BEREICH8+7),temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ROM wird im SRAM abgelegt														
;																				
ROM_SEARCH_ERGEBNIS_SPEICHERN:
	; Z-ZEIGER					
	ldi ZL,LOW (adr_ROM_BUFFER512)
	ldi ZH,HIGH(adr_ROM_BUFFER512)
	; X-ZEIGER					
	ldi XL,LOW (adr_ROM_CRC_BEREICH8)
	ldi XH,HIGH(adr_ROM_CRC_BEREICH8)
	; ANZAHL-SLAVES				
	LDS temp,(adr_ANZAHL_SLAVES)
	dec temp					; -1	
	; 8 x addieren				
	ldi temp2,8
	mul temp2,temp
	add ZL,R0
	adc ZH,R1


	LD temp,X+		; 
	ST Z+,temp
	LD temp,X+		; 
	ST Z+,temp
	LD temp,X+		; 
	ST Z+,temp
	LD temp,X+		; 
	ST Z+,temp
	LD temp,X+		; 
	ST Z+,temp
	LD temp,X+		; 
	ST Z+,temp
	LD temp,X+		; 
	ST Z+,temp
	LD temp,X+		; 
	ST Z+,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
