; ##############################################################################
; ##############################################################################
; ##############################################################################
SCRATCHPAD_CRC8_C:
 	ldi ZL,low (adr_SCRATCHPAD10+0) 		; Z-Zeiger 					
    ldi ZH,high(adr_SCRATCHPAD10+0) 
    ldi     r19, 8                          ;8 Bytes berechnen			
    ldi     r20, 0x18                       ;Konstante fr Berechnung
    clr     r17                            	;CRC-Startwert = 0 setzen
SCRATCHPAD_CRC8_100: 
	LD      r18, Z+                         ;Byte aus Puffer holen
    mov     r21, r18                        ;Byte zwischenspeichern
    ldi     r16, 8                          ;8 Verschiebungen
SCRATCHPAD_CRC8_200: 
	eor     r18, r17                      	;CRC berechnen
    ror     r18                             ;Ergebnis in Carry schieben
    mov     r18, r17                      	;letzten CRC-Wert holen
    brcc    SCRATCHPAD_CRC8_300             ;war Ergebnis = 0? ja -> weiter
    eor     r18, r20                        ;sonst CRC-Wert updaten
SCRATCHPAD_CRC8_300: 
	ror     r18                             ;neuen CRC-Wert positionieren
    mov     r17, r18          	            ;und speichern
    mov     r18, r21                        ;restliche Bits holen
    bst     r18, 0                          ;LSB sichern, nchste Bitposition
    ror     r18                             ;gesichertes Bit als MSB einsetzen
    bld     r18, 7                          ;(Ersatz fr RR-Befehl)
    mov     r21, r18                        ;und Wert zwischenspeichern
    dec     r16                             ;alle Verschiebungen erledigt?
    brne    SCRATCHPAD_CRC8_200        		;nein -> Schleife		
    dec     r19                             ;alle Bytes bearbeitet?	
    brne    SCRATCHPAD_CRC8_100    		 	;nein -> Schleife		
;-------------------------------------------------------------------------------
	; Ergebnis in R17	
	LD R16,Z
	cp R16,R17
	brne SCRATCHPAD_CRC8_ERROR
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN an	
	SEC										; CARRY=1	
	ret
;-------------------------------------------------------------------------------
SCRATCHPAD_CRC8_ERROR:
	LDS temp,(adr_CRC_ON)
	tst temp
	brne SCRATCHPAD_CRC8_ERROR_w
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN aus	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)		; ROT  an	
	SEC										; CARRY=1	
	ret
;-------------------------------------------------------------------------------
SCRATCHPAD_CRC8_ERROR_w:
	ldi temp,(ERROR_OW_SCRATCHPAD_CRC)
	STS(adr_ERROR_CODE),temp
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN aus	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)		; ROT  an	
	CLC										; CARRY=0	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Berechnung der Temperatur mit 0,5 GRD GENAUIGKEIT								
;																				
; +85.0C ===> 0x00AA															
; +25.0C ===> 0x0032															
;  +0.5C ===> 0x0001															
;     0C ===> 0x0000															
;  -0.5C ===> 0xFFFF															
; -25.0C ===> 0xFFCE															
; -55.0C ===> 0xFF92															
;																				
; inp: SRAM (adr_SCRATCHPAD_CRC_BEREICH)										
; OUT: temp1+2																	
;																				
DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_9BIT:
	; aus SRAM laden		
	LDS temp1,(adr_SCRATCHPAD10+0)	
	LDS temp2,(adr_SCRATCHPAD10+1)
;----------------------------------------------------------------------------------
	; TESTZAHLEN (-0,5)		
	;ldi temp1, low (0xFFFF)	
	;ldi temp2, HIGH(0xFFFF)
	; TESTZAHLEN (-25)		
	;ldi temp1, low (0xFFCE)	
	;ldi temp2, HIGH(0xFFCE)
	; TESTZAHLEN (+25)		
	;ldi temp1, low (0x0032)	
	;ldi temp2, HIGH(0x0032)
;----------------------------------------------------------------------------------
	mov R0,temp1
	mov R1,temp2
	add temp1,R0
	adc temp2,R1
	add temp1,R0
	adc temp2,R1
	add temp1,R0
	adc temp2,R1
	add temp1,R0
	adc temp2,R1
	; im SRAM ablegen		
	STS(adr_TEMPERATUR_L),temp1
	STS(adr_TEMPERATUR_H),temp2
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Berechnung der Temperatur mit 0,1 GRD GENAUIGKEIT								
;																				
; +125      C ===> 0x07D0														
;  +85      C*===> 0x0550														
;  +25.0625 C ===> 0x0191														
;  +10.125  C ===> 0x00A2														
;   +0.5    C ===> 0x0008														
;    0      C ===> 0x0000														
;   -0.5    C ===> 0xFFF8														
;  -10.125  C ===> 0xFF5E														
;  -25.0625 C ===> 0xFE6F														
;  -55      C ===> 0xFC90														
;																				
; inp: SRAM (adr_SCRATCHPAD_CRC_BEREICH)										
; OUT: temp1+2																	
;																				
DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_12BIT:
	; aus SRAM laden		
	LDS temp1,(adr_SCRATCHPAD10+0)	; aus SRAM laden	
	LDS temp2,(adr_SCRATCHPAD10+1)
;----------------------------------------------------------------------------------
	; TESTZAHLEN (+125)		
	;ldi temp1, low (0x07D0)	
	;ldi temp2, HIGH(0x07D0)
	; TESTZAHLEN (+85)		
	;ldi temp1, low (0x0550)	
	;ldi temp2, HIGH(0x0550)
	; TESTZAHLEN (+0,5)		
	;ldi temp1, low (0x0008)	
	;ldi temp2, HIGH(0x0008)
	; TESTZAHLEN (-0,5)		
	;ldi temp1, low (0xFFF8)	
	;ldi temp2, HIGH(0xFFF8)
	; TESTZAHLEN (-10.125)		
	;ldi temp1, low (0xFF5E)	
	;ldi temp2, HIGH(0xFF5E)
;-------------------------------------------------------------------------------

	; mal 5 (4 mal addieren)			
	mov temp3,temp1
	mov temp4,temp2
	add temp1,temp3	; x2
	adc temp2,temp4
	add temp1,temp3	; x3
	adc temp2,temp4
	add temp1,temp3	; x4
	adc temp2,temp4
	add temp1,temp3	; x5
	adc temp2,temp4
	; aufrunden+4				
	subi temp1,LOW (-4)	
	sbci temp2,HIGH(-4)
	; : 8 (mit 3x Arithmetisch rechts)
	ASR temp2			; :2 (:2)	
	ROR temp1
	ASR temp2			; :2 (:4)	
	ROR temp1
	ASR temp2			; :2 (:8)	
	ROR temp1
	; im SRAM ablegen		
	STS(adr_TEMPERATUR_L),temp1
	STS(adr_TEMPERATUR_H),temp2
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Berechnung der Temperatur mit 0,1 GRD GENAUIGKEIT								
;																				
; TEMPERATUR= TEMP_READ - 0,25 + ((COUNT_PER_C - COUNT_REMAIN)/COUNT_PER_C)		
;																				
; COUNT_PER_C ist immer 16 !													
;																				
; TEMPERATUR= TEMP_READ - 0,25 + ((16 - COUNT_REMAIN)/16)						
;																				
; mit 160 erweitern:															
;																				
; 160*TEMPERATUR= (160*TEMP_READ)-(160*0,25)+ 160*((16 - COUNT_REMAIN)/16)		
;																				
; vereinfachen:																	
;																				
; 160*TEMPERATUR= (160*TEMP_READ)-(40)+ 10*(16 - COUNT_REMAIN)					
;																				
; durch 16 (ergibt 0,1GRD)														
;																				
; 10*TEMPERATUR= ((160*TEMP_READ)-(40)+ 10*(16 - COUNT_REMAIN))/16				
;																				
; +85.0C ===> 0x00AA															
; +25.0C ===> 0x0032															
;  +0.5C ===> 0x0001															
;     0C ===> 0x0000															
;  -0.5C ===> 0xFFFF															
; -25.0C ===> 0xFFCE															
; -55.0C ===> 0xFF92															
;																				
;																				
; inp: SRAM (adr_SCRATCHPAD_CRC_BEREICH)										
; OUT: temp1+2																	
;																				
DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_A:
	; BIT 7 muss x10 sein				
	LDS temp,(adr_SCRATCHPAD10+7)
	cpi temp,0x10
	breq DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_A_RUN
;----------------------------------------------------------------------------------
	; ERROR																		
	ldi temp,(ERROR_TEMPERATURBERECHNUNG)	; CODE											
	STS(adr_ERROR_CODE),temp 				; OUT: CARRY=0 									
	ret
;----------------------------------------------------------------------------------
DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_A_RUN:
	; aus SRAM laden					
	LDS temp1,(adr_SCRATCHPAD10+0)	
	LDS temp2,(adr_SCRATCHPAD10+1)	
	LDS temp6,(adr_SCRATCHPAD10+6)
;----------------------------------------------------------------------------------
	; TESTZAHLEN (-0,5)		
	;ldi temp1, low (0xFFFF)	
	;ldi temp2, HIGH(0xFFFF)
	; TESTZAHLEN (-25)		
	;ldi temp1, low (0xFFCE)	
	;ldi temp2, HIGH(0xFFCE)
	; TESTZAHLEN (+25)		
	;ldi temp1, low (0x0032)	
	;ldi temp2, HIGH(0x0032)
;----------------------------------------------------------------------------------
	; negativ ?							
	tst temp2
	brmi DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_A_NEGATIV 
	rjmp DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_A_POSITIV
;===================================================================================
DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_A_NEGATIV:
	sbrc temp1,0
	dec temp1
	; 1*rechts BIT 0 clear (0,5 GRD ignorieren)	
	SEC
	ROR temp1
	; x 160						
	ldi temp,160
	mulsu temp1,temp
	mov temp1,R0				; Kopie			
	mov temp2,R1	
	rjmp ONE_WIRE_TEMPERATURBERECHNUNG_VARIANTE_A_POSITIV_w
;----------------------------------------------------------------------------------
DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_A_POSITIV:
	; 1*rechts BIT 0 clear (0,5 GRD ignorieren)	
	LSR temp1	
	; x 160						
	ldi temp,160
	mul temp1,temp
	mov temp1,R0				; Kopie			
	mov temp2,R1
ONE_WIRE_TEMPERATURBERECHNUNG_VARIANTE_A_POSITIV_w:
	; -40						
	subi temp1,LOW (40)	
	sbci temp2,HIGH(40)
	; "COUNT_REMAIN" berechnen	
	; 16-(COUNT_REMAIN)			
	ldi temp,16
	sub temp,temp6
	mov temp6,temp
	; x 10				
	ldi temp,10
	MUL temp6,temp
	mov temp6,R0				; Kopie			
	; addieren					
	add temp1,temp6
	adc temp2,NULL
	; aufrunden+8				
	subi temp1,LOW (-8)	
	sbci temp2,HIGH(-8)
	; : 16 (mit Arithmetisch rechts)
	ASR temp2			; :2 (:2)	
	ROR temp1
	ASR temp2			; :2 (:4)	
	ROR temp1
	ASR temp2			; :2 (:8)	
	ROR temp1
	ASR temp2			; :2 (:16)	
	ROR temp1

	; im SRAM ablegen		
	STS(adr_TEMPERATUR_L),temp1
	STS(adr_TEMPERATUR_H),temp2
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
