;																
; 1-WIRE-TESTER ATmega8											
; Bernhard.Erfurt@gmx.de										
; 03/2016														
;																

;																
; GELB blinkt nach Programmstart: 1-WIRE-BUS-KURZSCHLUSS 		
;																
; GRN: alles OK												
; GELB: 1-WIRE-BUS Aktivitt									
; BLAU: Power auf BUS / Strong Pull Up							
; ROT:  ERROR													
;																
; Blinken die LEDs, das ist nicht gut !							
; ROT blinkt: 			 Fehler im Programmcheck				
; ROT+GELB+GRN blinken: unkorrekter Interruptaufruf			
;																

;												
; Anschlussbelegung PINS						
;												
; PB0 ==> LCD									
; PB1 ==> LCD									
; PB2 ==> LCD									
; PB3 ==> LCD									
; PB4 ==> LCD									
; PB5 ==> LCD									
; PB6 ==> TASTE									
; PB7 ==> LED BLAU								
;												
; PC0 ==> 										
; PC1 ==> 										
; PC2 ==> 										
; PC3 ==> 1-WIRE								
; PC4 ==> 										
; PC5 ==> 										
;												
; PD0 ==> TASTE									
; PD1 ==> TASTE									
; PD2 ==> TASTE									
; PD3 ==> TASTE									
; PD4 ==> TASTE									
; PD5 ==> LED GRN								
; PD6 ==> LED GELB								
; PD7 ==> LED ROT								
;												


; ATmega8 										
.include "m8def.inc"
; KONSTANTEN									
.equ TAKT						= 1000000		; 1 MHz	
; ERROR-CODES									
.equ ERROR_OW_SEARCH_AB			= 0xAB
.equ ERROR_OW_SEARCH_CRC		= 0x1C
.equ ERROR_OW_SEARCH_ANZAHL		= 0x16
.equ ERROR_OW_CRC				= 0x20
.equ ERROR_OW_RESET_PRESENCE	= 0x30
.equ ERROR_OW_BUS				= 0x40
.equ ERROR_TEMPERATURBERECHNUNG = 0x50
.equ ERROR_OW_SCRATCHPAD_CRC	= 0x60
; TASTENBELEGUNG								
.equ TASTE_SEARCH					= 1
.equ TASTE_MESSEN					= 2
.equ TASTE_MENUE_PLUS				= 4
.equ TASTE_MENUE_MINUS				= 8
.equ TASTE_PLUS						= 16
.equ TASTE_MINUS					= 32
; START-MENUE									
.equ START_MENUE					= 10
; 1-WIRE-MAXIMAL-ANZAHL-SLAVES					
.equ ONE_WIRE_MAX_SLAVES			= 64
; 1-WIRE-DATENBUS								
.equ ONE_WIRE_PIN_NR				= 3
.equ ONE_WIRE_DDR					= DDRC
.equ ONE_WIRE_PORT					= PORTC
.equ ONE_WIRE_PIN					= PINC
; TASTE-A										
.equ TASTE_A_PIN_NR					= 0
.equ TASTE_A_DDR					= DDRD
.equ TASTE_A_PORT					= PORTD
.equ TASTE_A_PIN					= PIND
; TASTE-B										
.equ TASTE_B_PIN_NR					= 1
.equ TASTE_B_DDR					= DDRD
.equ TASTE_B_PORT					= PORTD
.equ TASTE_B_PIN					= PIND
; TASTE-C										
.equ TASTE_C_PIN_NR					= 2
.equ TASTE_C_DDR					= DDRD
.equ TASTE_C_PORT					= PORTD
.equ TASTE_C_PIN					= PIND
; TASTE-D										
.equ TASTE_D_PIN_NR					= 3
.equ TASTE_D_DDR					= DDRD
.equ TASTE_D_PORT					= PORTD
.equ TASTE_D_PIN					= PIND
; TASTE-E										
.equ TASTE_E_PIN_NR					= 4
.equ TASTE_E_DDR					= DDRD
.equ TASTE_E_PORT					= PORTD
.equ TASTE_E_PIN					= PIND
; LED-GRUEN										
.equ LED_GRUEN_PIN_NR				= 5
.equ LED_GRUEN_DDR					= DDRD
.equ LED_GRUEN_PORT					= PORTD
; LED-GELB										
.equ LED_GELB_PIN_NR				= 6
.equ LED_GELB_DDR					= DDRD
.equ LED_GELB_PORT					= PORTD
; LED-ROT										
.equ LED_ROT_PIN_NR					= 7
.equ LED_ROT_DDR					= DDRD
.equ LED_ROT_PORT					= PORTD
; LED-BLAU										
.equ LED_BLAU_PIN_NR				= 7
.equ LED_BLAU_DDR					= DDRB
.equ LED_BLAU_PORT					= PORTB
; LCD (DATA)									
.equ LCD_DATA0_DDR					= DDRB
.equ LCD_DATA1_DDR					= DDRB
.equ LCD_DATA2_DDR					= DDRB
.equ LCD_DATA3_DDR					= DDRB
.equ LCD_DATA0_PORT					= PORTB
.equ LCD_DATA1_PORT					= PORTB
.equ LCD_DATA2_PORT					= PORTB
.equ LCD_DATA3_PORT					= PORTB
.equ LCD_DATA0						= 0
.equ LCD_DATA1						= 1
.equ LCD_DATA2						= 2
.equ LCD_DATA3						= 3
; LCD RS (Befehl/DATEN)							
.equ LCD_RS_DDR						= DDRB
.equ LCD_RS_PORT					= PORTB
.equ LCD_RS							= 4
; LCD_ENABLE									
.equ LCD_EN_DDR						= DDRB
.equ LCD_EN_PORT					= PORTB
.equ LCD_EN							= 5
; TASTE-F										
.equ TASTE_F_PIN_NR					= 6
.equ TASTE_F_DDR					= DDRB
.equ TASTE_F_PORT					= PORTB
.equ TASTE_F_PIN					= PINB
; SRAM-BELEGUNG ATmega8							
.equ adr_DATEN						=SRAM_START+0	; 0x0060 START Adresse 		
.equ adr_MENUE						=SRAM_START+2
.equ adr_ERROR_CODE					=SRAM_START+4
.equ adr_TASTE						=SRAM_START+6
.equ adr_ANZAHL_SLAVES				=SRAM_START+8
.equ adr_CRC_ON						=SRAM_START+9

.equ adr_TEMPERATUR_L				=SRAM_START+10
.equ adr_TEMPERATUR_H				=SRAM_START+11

.equ adr_ROM_CRC_BEREICH8			=SRAM_START+20	; 8 BYTES ROM-ID					

.equ adr_SCRATCHPAD10				=SRAM_START+30 

.equ adr_ROM_SEARCH_KNOTEN64		=SRAM_START+40	; Zwischenergebnisse				

.equ adr_ROM_BUFFER512				=SRAM_START+200	; ROM-PUFFER (8x64=512)				

.equ adr_SRAM_CHECK					=SRAM_START+940	; SRAM CHECK muss immer "S" sein	
; REGISTER										
.def NULL 	= R14
.def EINS 	= R15

.def temp 	= R16
.def temp1 	= R17
.def temp2 	= R18
.def temp3 	= R19
.def temp4 	= R20
.def temp5 	= R21
.def temp6 	= R22
.def temp7 	= R23
.def temp8 	= R24
.def temp9 	= R25


.cseg					;Beginn eines Code-Segmentes
.org 0					;Startadresse=0

rjmp RESET      		; Reset Handler                           				
rjmp INTERRUPT_ERROR	;rjmp EXT_INT0   ; IRQ0 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp EXT_INT1   ; IRQ1 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp TIM2_COMP  ; Timer2 Compare Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM2_OVF   ; Timer2 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_CAPT  ; Timer1 Capture Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPA ; Timer1 CompareA Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPB ; Timer1 CompareB Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_OVF   	  	; Timer1 Overflow Handler       
rjmp INTERRUPT_ERROR	;rjmp TIM0_OVF   ; Timer0 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp SPI_STC    ; SPI Transfer Complete Handler     	
rjmp INTERRUPT_ERROR	;rjmp USART_RXC 			; USART RX Complete Handler 
rjmp INTERRUPT_ERROR	;rjmp USART_UDRE ; UDR Empty Handler                 	
rjmp INTERRUPT_ERROR	;rjmp USART_TXC  ; USART TX Complete Handler         	
rjmp INTERRUPT_ERROR	;rjmp ADC        ; ADC Conversion Complete Handler   	
rjmp INTERRUPT_ERROR	;rjmp EE_RDY     ; EEPROM Ready Handler              	
rjmp INTERRUPT_ERROR	;rjmp ANA_COMP   ; Analog Comparator Handler         	
rjmp INTERRUPT_ERROR	;rjmp TWSI		       	; Two-wire Serial Interface Handler 					
rjmp INTERRUPT_ERROR	;rjmp SPM_RDY    ; Store Program Memory Ready Handler	


; Unkorrekten Interrupt Aufruf 						
INTERRUPT_ERROR:
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
	rcall wait_100ms
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	rcall wait_100ms
	rjmp INTERRUPT_ERROR
RESET:                        
; STACK initialisieren								
	ldi temp, LOW(RAMEND)
    out SPL, temp
    ldi temp, HIGH(RAMEND)
    out SPH, temp
; SRAM lschen										
	rcall SRAM_CLEAR
; REGISTER_CLEAR									
	rcall REGISTER_CLEAR
; PORT_CLEAR										
	rcall PORT_CLEAR
; LED_INITIALISIERUNG								
	rcall LED_INITIALISIERUNG
; WDR_INITIALISIERUNG								
	rcall WDR_INITIALISIERUNG
; NEUSTART_MIT_WDR									
	rcall NEUSTART_MIT_WDR
; TASTEN_INITIALISIERUNG							
	rcall TASTEN_INITIALISIERUNG
; STARTWERTE										
	; NULL				
	clr NULL
	; EINS				
	ldi temp,1
	mov EINS,temp
	; CRC_ON			
	STS(adr_CRC_ON),EINS
	; SRAM CHECK		
	ldi temp,'S'
	STS(adr_SRAM_CHECK),temp
	; START-MENUE		
	ldi temp,(START_MENUE)
	STS(adr_MENUE),temp
; LCD-INITIALISIERUNG									
	rcall LCD_INITIALISIERUNG
	rcall ANZEIGE_BEGRUESSUNG
	rcall WAIT_100ms
; ONE_WIRE-INITIALISIERUNG								
	rcall ONE_WIRE_INITIALISIERUNG
; PROGRAMM_CHECK										
	rcall PROGRAMM_CHECK
;-------------------------------------------------------------------------------
 	SEI										;Interrupts freigeben	
	rcall MENUE_ANZEIGE_TASTENBELEGUNG
; ##############################################################################
; ##############################################################################
; ##############################################################################
LOOP:
	WDR
	rcall TASTEN_ABFRAGE
	rcall MENUE
	rcall ANZEIGE_ERROR
	rcall ONE_WIRE_BUS_CHECK
	rcall ONE_WIRE_BUS_POWER_CHECK
	rcall PROGRAMM_CHECK
rjmp LOOP
; ##############################################################################
; ##############################################################################
; ##############################################################################
.include "OWTESTER_MENUE.asm"			; MENUE							
.include "OWTESTER_LCD_ini.asm"			; LCD  Initialisierung 4x16/4x20
.include "OWTESTER_LCD_ANZEIGE.asm"		; LCD 							
.include "OWTESTER_LCD_KURZ.asm"		; LCD							
.include "OWTESTER_1WIRE.asm"			; 1-WIRE						
.include "OWTESTER_1WIRE_ROM.asm"		; 1-WIRE (ROM)					
.include "OWTESTER_1WIRE_SCRATCHPAD.asm"
.include "OWTESTER_SONSTIGES.asm"		; sonstiges						
.include "OWTESTER_WAIT_01MHZ.asm"		; 1 MHz							


TEXT_BEGRUESSUNG_1:
.db "1-WIRE-TESTER",0
TEXT_BEGRUESSUNG_2:
.db "01/2017",0
TEXT_BEGRUESSUNG_3:
.db "ATmega8 1-MHz",0
TEXT_BEGRUESSUNG_4:
.db "1-WIRE TESTER",0
TEXT_TASTENBELEGUNG:
.db "SEARCH    Messen",0,0
