; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; LCD 2x16 4x16 4x20 ZEICHEN													
;																				
; LCD-INITIALISIERUNG															
LCD_INITIALISIERUNG:
	; auf LOW				
	cbi (LCD_DATA0_PORT),(LCD_DATA0)
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	cbi (LCD_EN_PORT),(LCD_EN)
	cbi (LCD_RS_PORT),(LCD_RS)
	; auf Ausgang			
	sbi (LCD_DATA0_DDR),(LCD_DATA0)
	sbi (LCD_DATA1_DDR),(LCD_DATA1)
	sbi (LCD_DATA2_DDR),(LCD_DATA2)
	sbi (LCD_DATA3_DDR),(LCD_DATA3)
	sbi (LCD_RS_DDR),(LCD_RS)
	sbi (LCD_EN_DDR),(LCD_EN)
	; INITIALISIERUNG		
    cbi (LCD_RS_PORT),(LCD_RS) 			; RS aus (low)				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)  	; x03 muss 3mal hintereinander gesendet werden zur Initialisierun
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	rcall LCD_ENABLE					; 1	
	rcall LCD_ENABLE					; 2	
	rcall LCD_ENABLE					; 3	
    ldi temp, 0b00000010        ;4bit-Modus einstellen
	rcall LCD_COMMAND
    ldi temp, 0b00000001        ; DISPLAY lschen			
 	rcall LCD_COMMAND
    ldi temp, 0b00001110        ; DISPLAY ein / CURSOR blinken
	rcall LCD_COMMAND
    ldi temp, 0b00000110        ; Cursor Auto-Increment
 	rcall LCD_COMMAND
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																		  		
;erzeugt den Enable-Puls												  		
;																		  		
LCD_ENABLE:
	sbi (LCD_EN_PORT),(LCD_EN) 		   	; Enable high		
 	rcall wait_5us            		  	; kurze PAUSE		
	cbi (LCD_EN_PORT),(LCD_EN)     	  	; Enable low		
	rcall wait_50us            		 	; kurze PAUSE		
ret                          
; ##############################################################################
; ##############################################################################
; ##############################################################################
; sendet ein Datenbyte an das LCD										  		
;																		  		
; INPUT: temp															  		
;																		  		
; rcall LCD_DATA			; DATENBYTE an LCD inp: temp 				  		
;																		  		
LCD_DATA:
	sbi LCD_RS_PORT, LCD_RS 			; RS ein/auf DATA (high)				
LCD_DATA_RS:
	cbi (LCD_DATA0_PORT),(LCD_DATA0)	; alle auf LOW							
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	SBRC temp,4							; SPRUNG, wenn BIT clear				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)
	SBRC temp,5
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	SBRC temp,6
	sbi (LCD_DATA2_PORT),(LCD_DATA2)
	SBRC temp,7
	sbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	rcall lcd_enable        			; Enable-Routine aufrufen				
;-------------------------------------------------------------------------------
	cbi (LCD_DATA0_PORT),(LCD_DATA0)	; auf LOW								
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	SBRC temp,0							; SPRUNG, wenn BIT clear				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)
	SBRC temp,1
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	SBRC temp,2
	sbi (LCD_DATA2_PORT),(LCD_DATA2)
	SBRC temp,3
	sbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	rcall lcd_enable        			; Enable-Routine aufrufen				
	rcall wait_5us						; Pause 								
	sbi LCD_RS_PORT, LCD_RS 			; vorsichtshalber RS ein/auf DATA (high)
ret				                       
; ##############################################################################
; ##############################################################################
; ##############################################################################
;sendet einen Befehl an das LCD;wie lcd_data, nur ohne RS zu setzen		  		
;																		  		
; INPUT: temp															  		
;																		  		
LCD_COMMAND:                            
    cbi (LCD_RS_PORT),(LCD_RS) 			;	 RS aus (low)				
	rcall LCD_DATA_RS
	rcall wait_5ms						; Pause (wichtig)				
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Display lschen														  		
LCD_CLEAR:
   	ldi temp, 0b00000001
    rcall lcd_command
	rcall LCD_ZEILE1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR GO-HOME														  		
LCD_ZEILE1:
 	ldi temp, 0b00000010
	rcall lcd_command 
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR Sprung in ZEILE2												  		
LCD_ZEILE2:
 	ldi temp, 0b11000000 
	rcall lcd_command 
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR Sprung in ZEILE3														
LCD_ZEILE3:
	;ldi temp, 0b10010100  	; LCD 4x20	
	ldi temp, 0b10010000 	; LCD 4x16	
	rcall lcd_command 
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR Sprung in ZEILE4												  		
LCD_ZEILE4:
	;ldi temp, 0b11010100	; LCD 4x20	
	ldi temp, 0b11010000 	; LCD 4x16	
	rcall lcd_command 
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1															  		
ANZEIGE_1_STELLEN_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_1_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
ANZEIGE_2_STELLEN_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_2_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
ANZEIGE_3_STELLEN_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1															  		
; z.B. +127																		
; z.B. -128																		
ANZEIGE_3_STELLEN_NEGATIV_TEMP1:
	tst temp1
	brmi ANZEIGE_3_STELLEN_NEGATIV_TEMP1_n
	ldi temp, '+'				; VORZEICHEN	
	rcall LCD_DATA
ANZEIGE_3_STELLEN_NEGATIV_TEMP1_p:
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ	
	ret
ANZEIGE_3_STELLEN_NEGATIV_TEMP1_n:
	ldi temp, '-'				; VORZEICHEN	
	rcall LCD_DATA
	COM temp1
	inc temp1
	rjmp ANZEIGE_3_STELLEN_NEGATIV_TEMP1_p
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1 + TEMP2																	
ANZEIGE_4_STELLEN_TEMP1_TEMP2:
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_4_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1 + TEMP2																	
ANZEIGE_5_STELLEN_TEMP1_TEMP2:
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_5_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1															  		
; z.B. +32767																	
; z.B. -32768																	
ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2:
	tst temp2
	brmi ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2_n
	ldi temp, '+'				; VORZEICHEN	
	rcall LCD_DATA
ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2_p:
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_5_STELLEN_KURZ
	ret
ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2_n:
	ldi temp, '-'				; VORZEICHEN	
	rcall LCD_DATA
	COM temp1					; BETRAG bilden	
	COM temp2
	add temp1,EINS
	adc temp2,NULL
	rjmp ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2_p
;######################################################################## 	
;######################################################################## 	
;######################################################################## 	
; INPUT: TEMP1...TEMP9 (temp)												
LCD_AUSGABE_ZAHL_10_STELLEN_KURZ:
	; temp !
	rcall LCD_DATA			; 10.ZEICHEN 	
LCD_AUSGABE_ZAHL_9_STELLEN_KURZ:
	mov temp, temp9			; 9.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_8_STELLEN_KURZ:
	mov temp, temp8			; 8.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_7_STELLEN_KURZ:
	mov temp, temp7			; 7.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_6_STELLEN_KURZ:
	mov temp, temp6			; 6.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_5_STELLEN_KURZ:
	mov temp, temp5			; 5.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_4_STELLEN_KURZ:
	mov temp, temp4			; 4.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_3_STELLEN_KURZ:
	mov temp, temp3			; 3.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_2_STELLEN_KURZ:
	mov temp, temp2			; 2.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_1_STELLEN_KURZ:
	mov temp, temp1			; 1.ZEICHEN (1-er Stelle)	
	rcall LCD_DATA
ret
;######################################################################## 	
;######################################################################## 	
;######################################################################## 	
; formatiert die LCD AUSGABE mit 1000-er Punkt								
; 	Bsp. "00012345 => "___12.345"											
;	INPUT/Output TEMP1														
;	INPUT/Output TEMP2														
;	INPUT/Output TEMP3														
;	INPUT/Output TEMP4														
;	INPUT/Output TEMP5														
;	INPUT/Output TEMP6														
; 	INPUT/Output TEMP8														
; 	INPUT/Output TEMP9														
LCD_FORMAT:
;---------------------------------------------------------------------------
	cpi temp9, '0'
	brne LCD_FORMAT_FERTIG
	mov temp9,temp8
	mov temp8,temp7
	ldi temp7,'.'
;---------------------------------------------------------------------------
	cpi temp9, '0'
	brne LCD_FORMAT_FERTIG
	mov temp9,temp8
	mov temp8,temp7
	mov temp7,temp6
	mov temp6,temp5
	mov temp5,temp4
	ldi temp4,'.'
;---------------------------------------------------------------------------
LCD_FORMAT_FERTIG:
	rcall NULLSTELLENUNTERDRUCKUNG
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
NULLSTELLENUNTERDRUCKUNG:
;---------------------------------------------------------------------------
	mov temp,temp9							; KOPIE			
	rcall NULLSTELLENUNTERDRUCKUNG_TAUSCH	; '.' ==> '0'	
	mov temp9,temp							; KOPIE			
	cpi temp,'0'							; ist '0'		
	brne NULLSTELLENUNTERDRUCKUNG_FERTIG	; nein=>> SPRUNG
	ldi temp9, '_'							; ersetzen		
;---------------------------------------------------------------------------
	mov temp,temp8							; KOPIE			
	rcall NULLSTELLENUNTERDRUCKUNG_TAUSCH	; '.' ==> '0'	
	mov temp8,temp							; KOPIE			
	cpi temp,'0'							; ist '0'		
	brne NULLSTELLENUNTERDRUCKUNG_FERTIG	; nein=>> SPRUNG
	ldi temp8, '_'							; ersetzen		
;---------------------------------------------------------------------------
	mov temp,temp7							; KOPIE			
	rcall NULLSTELLENUNTERDRUCKUNG_TAUSCH	; '.' ==> '0'	
	mov temp7,temp							; KOPIE			
	cpi temp,'0'							; ist '0'		
	brne NULLSTELLENUNTERDRUCKUNG_FERTIG	; nein=>> SPRUNG
	ldi temp7, '_'							; ersetzen		
;---------------------------------------------------------------------------
	mov temp,temp6							; KOPIE			
	rcall NULLSTELLENUNTERDRUCKUNG_TAUSCH	; '.' ==> '0'	
	mov temp6,temp							; KOPIE			
	cpi temp,'0'							; ist '0'		
	brne NULLSTELLENUNTERDRUCKUNG_FERTIG	; nein=>> SPRUNG
	ldi temp6, '_'							; ersetzen		
;---------------------------------------------------------------------------
	mov temp,temp5							; KOPIE			
	rcall NULLSTELLENUNTERDRUCKUNG_TAUSCH	; '.' ==> '0'	
	mov temp5,temp							; KOPIE			
	cpi temp,'0'							; ist '0'		
	brne NULLSTELLENUNTERDRUCKUNG_FERTIG	; nein=>> SPRUNG
	ldi temp5, '_'							; ersetzen		
;---------------------------------------------------------------------------
	mov temp,temp4							; KOPIE			
	rcall NULLSTELLENUNTERDRUCKUNG_TAUSCH	; '.' ==> '0'	
	mov temp4,temp							; KOPIE			
	cpi temp,'0'							; ist '0'		
	brne NULLSTELLENUNTERDRUCKUNG_FERTIG	; nein=>> SPRUNG
	ldi temp4, '_'							; ersetzen		
;---------------------------------------------------------------------------
	mov temp,temp3							; KOPIE			
	rcall NULLSTELLENUNTERDRUCKUNG_TAUSCH	; '.' ==> '0'	
	mov temp3,temp							; KOPIE			
	cpi temp,'0'							; ist '0'		
	brne NULLSTELLENUNTERDRUCKUNG_FERTIG	; nein=>> SPRUNG
	ldi temp3, '_'							; ersetzen		
;---------------------------------------------------------------------------
	mov temp,temp2							; KOPIE			
	rcall NULLSTELLENUNTERDRUCKUNG_TAUSCH	; '.' ==> '0'	
	mov temp2,temp							; KOPIE			
	cpi temp,'0'							; ist '0'		
	brne NULLSTELLENUNTERDRUCKUNG_FERTIG	; nein=>> SPRUNG
	ldi temp2, '_'							; ersetzen		
;---------------------------------------------------------------------------
	mov temp,temp1							; KOPIE			
	rcall NULLSTELLENUNTERDRUCKUNG_TAUSCH	; '.' ==> '0'	
	mov temp1,temp							; KOPIE			
	cpi temp,'0'							; ist '0'		
	brne NULLSTELLENUNTERDRUCKUNG_FERTIG	; nein=>> SPRUNG
	ldi temp1, '_'							; ersetzen		
;---------------------------------------------------------------------------
NULLSTELLENUNTERDRUCKUNG_FERTIG:
	ret
;---------------------------------------------------------------------------
NULLSTELLENUNTERDRUCKUNG_TAUSCH:
	cpi temp,'.'
	breq NULLSTELLENUNTERDRUCKUNG_TAUSCH_w
	ret
NULLSTELLENUNTERDRUCKUNG_TAUSCH_w:
	ldi temp,'0'
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
; STAND: 09.12.2011															
;																			
;	Value: 0...	9.999.999.999												
;																			
;	INPUT: 	temp1	(BYTE1)													
;	 		temp2	(BYTE2)													
;			temp3	(BYTE3)													
;			temp4	(BYTE4)													
;																			
;	OUTPUT:	temp1	(		     1-er Stelle)								
;			temp2	(		    10-er Stelle)								
;			temp3	(          100-er Stelle)								
;			temp4	(        1.000-er Stelle)								
;			temp5	(       10.000-er Stelle)								
;			temp6	(      100.000-er Stelle)								
;			temp7	(    1.000.000-er Stelle)								
;			temp8	(   10.000.000-er Stelle)								
;			temp9	(  100.000.000-er Stelle)								
;			temp	(1.000.000.000-er Stelle)								
; 																			
; rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
; 																			
FUNKTION_HEX_ASC_32:
;---------------------------------------------------------------------------
	clr temp			
FUNKTION_HEX_ASC_109:	; 1.100.000.000
	inc temp
	subi temp1, BYTE1    (1000000000)
	sbci temp2, BYTE2    (1000000000)
	sbci temp3, BYTE3    (1000000000)
	sbci temp4, BYTE4    (1000000000)
	brcc FUNKTION_HEX_ASC_109
	subi temp, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-1000000000)
	sbci temp2, BYTE2   (-1000000000)
	sbci temp3, BYTE3   (-1000000000)
	sbci temp4, BYTE4   (-1000000000)
;---------------------------------------------------------------------------
	clr temp9			
FUNKTION_HEX_ASC_108:	; 100.000.000
	inc temp9
	subi temp1, BYTE1    (100000000)
	sbci temp2, BYTE2    (100000000)
	sbci temp3, BYTE3    (100000000)
	sbci temp4, BYTE4    (100000000)
	brcc FUNKTION_HEX_ASC_108
	subi temp9, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-100000000)
	sbci temp2, BYTE2   (-100000000)
	sbci temp3, BYTE3   (-100000000)
	sbci temp4, BYTE4   (-100000000)
;---------------------------------------------------------------------------
	clr temp8
FUNKTION_HEX_ASC_107:	; 10.000.000
	inc temp8
	subi temp1, BYTE1    (10000000)
	sbci temp2, BYTE2    (10000000)
	sbci temp3, BYTE3    (10000000)
	sbci temp4, BYTE4    (10000000)
	brcc FUNKTION_HEX_ASC_107
	subi temp8, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-10000000)
	sbci temp2, BYTE2   (-10000000)
	sbci temp3, BYTE3   (-10000000)
	sbci temp4, BYTE4   (-10000000)
;---------------------------------------------------------------------------
	clr temp7
FUNKTION_HEX_ASC_106:	; 1.000.000
	inc temp7
	subi temp1, BYTE1    (1000000)
	sbci temp2, BYTE2    (1000000)
	sbci temp3, BYTE3    (1000000)
	brcc FUNKTION_HEX_ASC_106
	subi temp7, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-1000000)
	sbci temp2, BYTE2   (-1000000)
	sbci temp3, BYTE3   (-1000000)
;---------------------------------------------------------------------------
	clr temp6
FUNKTION_HEX_ASC_105:	; 100.000	
	inc temp6
	subi temp1, BYTE1    (100000)
	sbci temp2, BYTE2    (100000)
	sbci temp3, BYTE3    (100000)
	brcc FUNKTION_HEX_ASC_105
	subi temp6, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-100000)
	sbci temp2, BYTE2   (-100000)
	sbci temp3, BYTE3   (-100000)
;---------------------------------------------------------------------------	clr temp
	clr temp5
FUNKTION_HEX_ASC_104:	; 10.000	
	inc temp5
	subi temp1, BYTE1    (10000)
	sbci temp2, BYTE2    (10000)
	sbci temp3, BYTE3    (10000)
	brcc FUNKTION_HEX_ASC_104
	subi temp5, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1  (-10000)
	sbci temp2, BYTE2  (-10000)
	sbci temp3, BYTE3  (-10000)
;---------------------------------------------------------------------------
	clr temp4
FUNKTION_HEX_ASC_103:	; 1.000		
	inc temp4
	subi temp1, low  (1000)
	sbci temp2, HIGH (1000)
	brcc FUNKTION_HEX_ASC_103
	subi temp4, (-48+1)	; HEX->ASC	
	subi temp1, low  (-1000)
	sbci temp2, HIGH (-1000)
;---------------------------------------------------------------------------
	clr temp3
FUNKTION_HEX_ASC_102:	; 100		
	inc temp3
	subi temp1, low  (100)
	sbci temp2, HIGH (100)
	brcc FUNKTION_HEX_ASC_102
	subi temp3, (-48+1)	; HEX->ASC	
	subi temp1, low  (-100)
	sbci temp2, HIGH (-100)
;---------------------------------------------------------------------------
	clr temp2
FUNKTION_HEX_ASC_101:	; 10		
	inc temp2
	subi temp1, low  (10)
	brcc FUNKTION_HEX_ASC_101
	subi temp2, (-48+1)	; HEX->ASC	
	subi temp1, low  (-10)
;---------------------------------------------------------------------------
FUNKTION_HEX_ASC_100:	; 1			
	subi temp1, -48		; HEX->ASC	
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
; INP: temp1																
; OUT: (z.B."FF") 															
;																			
; rcall ANZEIGE_HEX_TEMP1 ; inp: temp1										
;																			
ANZEIGE_HEX_TEMP1:
	; SICHERUNGSKOPIE						
	push temp
	push temp1
	; oberes NIBBLE bearbeiten				
	mov temp,temp1	
	swap temp						; NIBBLES tausch	
	rcall ANZEIGE_HEX_UMWANDLUNG	; INP/OUT: temp		
	rcall LCD_DATA					; ANZEIGE			
	; unteres NIBBLE bearbeiten				
	mov temp,temp1	
	rcall ANZEIGE_HEX_UMWANDLUNG	; INP/OUT: temp		
	rcall LCD_DATA					; ANZEIGE			
	; SICHERUNGSKOPIE wieder herstellen		
	pop temp1
	pop temp
	ret
;-------------------------------------------------------------------------------
ANZEIGE_HEX_UMWANDLUNG:
	; BITMUSTER	
	andi temp,0b00001111
	; vergleich	
	cpi temp,10
	brsh ANZEIGE_HEX_UMWANDLUNG_A_F
ANZEIGE_HEX_UMWANDLUNG_0_9:
	subi temp,-48
	ret
ANZEIGE_HEX_UMWANDLUNG_A_F:
	subi temp,-48-7
	ret
;######################################################################## 
;########################################################################
;######################################################################## 
ANZEIGE_TEXT:
	LPM temp, Z+   			; aus Tabelle laden und Zeiger um 1 erhhen	
	tst temp  			
	brne ANZEIGE_TEXT_w
	ret
ANZEIGE_TEXT_w:
	rcall LCD_DATA			; Anzeige
	rjmp ANZEIGE_TEXT
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_SPACE3:
	ldi temp, ' '		; SPACE
	rcall LCD_DATA
LCD_SPACE2:
	ldi temp, ' '		; SPACE
	rcall LCD_DATA
LCD_SPACE:
	ldi temp, ' '		; SPACE
	rjmp LCD_DATA
;######################################################################## 
LCD_PUNKT3:
	ldi temp, '.'		; . 
	rcall LCD_DATA	
	rcall LCD_DATA		; . 
LCD_PUNKT:
	ldi temp, '.'		; . 
	rjmp LCD_DATA
;######################################################################## 
LCD_DOPPEL_PUNKT:
	ldi temp, ':'		; : 
	rjmp LCD_DATA
;######################################################################## 
LCD_FRAGEZEICHEN:
	ldi temp, '?'		; ? 
	rjmp LCD_DATA
;######################################################################## 
LCD_PLUS:
	ldi temp, '+'		; + 
	rjmp LCD_DATA
;######################################################################## 
LCD_MINUS:
	ldi temp, '-'		; - 
	rjmp LCD_DATA	
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_A:
	ldi temp, 'A'	
	rjmp LCD_DATA
LCD_B:
	ldi temp, 'B'	
	rjmp LCD_DATA
LCD_C:
	ldi temp, 'C'	
	rjmp LCD_DATA
LCD_D:
	ldi temp, 'D'	
	rjmp LCD_DATA
LCD_E:
	ldi temp, 'E'	
	rjmp LCD_DATA
LCD_F:
	ldi temp, 'F'	
	rjmp LCD_DATA
LCD_G:
	ldi temp, 'G'	
	rjmp LCD_DATA
LCD_H:
	ldi temp, 'H'	
	rjmp LCD_DATA
LCD_I:
	ldi temp, 'I'	
	rjmp LCD_DATA
LCD_J:
	ldi temp, 'J'	
	rjmp LCD_DATA
LCD_K:
	ldi temp, 'K'	
	rjmp LCD_DATA
LCD_L:
	ldi temp, 'L'	
	rjmp LCD_DATA
LCD_M:
	ldi temp, 'M'	
	rjmp LCD_DATA
LCD_N:
	ldi temp, 'N'	
	rjmp LCD_DATA
LCD_O:
	ldi temp, 'O'	
	rjmp LCD_DATA
LCD_P:
	ldi temp, 'P'	
	rjmp LCD_DATA
LCD_Q:
	ldi temp, 'Q'	
	rjmp LCD_DATA
LCD_R:
	ldi temp, 'R'	
	rjmp LCD_DATA
LCD_S:
	ldi temp, 'S'	
	rjmp LCD_DATA
LCD_T:
	ldi temp, 'T'	
	rjmp LCD_DATA
LCD_U:
	ldi temp, 'U'	
	rjmp LCD_DATA
LCD_V:
	ldi temp, 'V'	
	rjmp LCD_DATA
LCD_W:
	ldi temp, 'W'	
	rjmp LCD_DATA
LCD_X:
	ldi temp, 'X'	
	rjmp LCD_DATA
LCD_Y:
	ldi temp, 'Y'	
	rjmp LCD_DATA
LCD_Z:
	ldi temp, 'Z'	
	rjmp LCD_DATA


LCD_A_:
	ldi temp, 'a'	
	rjmp LCD_DATA
LCD_B_:
	ldi temp, 'b'	
	rjmp LCD_DATA
LCD_C_:
	ldi temp, 'c'	
	rjmp LCD_DATA
LCD_D_:
	ldi temp, 'd'	
	rjmp LCD_DATA
LCD_E_:
	ldi temp, 'e'	
	rjmp LCD_DATA
LCD_F_:
	ldi temp, 'f'	
	rjmp LCD_DATA
LCD_G_:
	ldi temp, 'g'	
	rjmp LCD_DATA
LCD_H_:
	ldi temp, 'h'	
	rjmp LCD_DATA
LCD_I_:
	ldi temp, 'i'	
	rjmp LCD_DATA
LCD_J_:
	ldi temp, 'j'	
	rjmp LCD_DATA
LCD_K_:
	ldi temp, 'k'	
	rjmp LCD_DATA
LCD_L_:
	ldi temp, 'l'	
	rjmp LCD_DATA
LCD_M_:
	ldi temp, 'm'	
	rjmp LCD_DATA
LCD_N_:
	ldi temp, 'n'	
	rjmp LCD_DATA
LCD_O_:
	ldi temp, 'o'	
	rjmp LCD_DATA
LCD_P_:
	ldi temp, 'p'	
	rjmp LCD_DATA
LCD_Q_:
	ldi temp, 'q'	
	rjmp LCD_DATA
LCD_R_:
	ldi temp, 'r'	
	rjmp LCD_DATA
LCD_S_:
	ldi temp, 's'	
	rjmp LCD_DATA
LCD_T_:
	ldi temp, 't'	
	rjmp LCD_DATA
LCD_U_:
	ldi temp, 'u'	
	rjmp LCD_DATA
LCD_V_:
	ldi temp, 'v'	
	rjmp LCD_DATA
LCD_W_:
	ldi temp, 'w'	
	rjmp LCD_DATA
LCD_X_:
	ldi temp, 'x'	
	rjmp LCD_DATA
LCD_Y_:
	ldi temp, 'y'	
	rjmp LCD_DATA
LCD_Z_:
	ldi temp, 'z'	
	rjmp LCD_DATA





LCD_0:
	ldi temp, '0'	
	rjmp LCD_DATA
LCD_1:
	ldi temp, '1'	
	rjmp LCD_DATA
LCD_2:
	ldi temp, '2'	
	rjmp LCD_DATA
LCD_3:
	ldi temp, '3'	
	rjmp LCD_DATA
LCD_4:
	ldi temp, '4'	
	rjmp LCD_DATA
LCD_5:
	ldi temp, '5'	
	rjmp LCD_DATA
LCD_6:
	ldi temp, '6'	
	rjmp LCD_DATA
LCD_7:
	ldi temp, '7'	
	rjmp LCD_DATA
LCD_8:
	ldi temp, '8'	
	rjmp LCD_DATA
LCD_9:
	ldi temp, '9'	
	rjmp LCD_DATA



;######################################################################## 
;######################################################################## 
;######################################################################## 
