; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE:
	LDS temp,(adr_TASTE)
	tst temp
	brne MENUE_RUN
	ret
;-------------------------------------------------------------------------------
MENUE_RUN:
	rcall LCD_CLEAR
	; TASTEN-AUSWERTUNG	
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_MENUE_PLUS)
	breq MENUE_PLUS
	cpi temp,(TASTE_MENUE_MINUS)
	breq MENUE_MINUS
	rjmp MENUE_START
;-------------------------------------------------------------------------------
MENUE_PLUS:
	LDS temp,(adr_MENUE)
	inc temp
	STS(adr_MENUE),temp
	rjmp MENUE_START
;-------------------------------------------------------------------------------
MENUE_MINUS:
	LDS temp,(adr_MENUE)
	tst temp
	breq MENUE_START
	dec temp
	STS(adr_MENUE),temp
	rjmp MENUE_START
;-------------------------------------------------------------------------------
MENUE_START:
	ldi ZL,LOW (MENUE_SPRUNGMARKE)
	ldi ZH,HIGH(MENUE_SPRUNGMARKE)
	LDS temp,(adr_MENUE)
	add ZL,temp
	adc ZH,NULL
	ijmp ; Sprung nach Z
;-------------------------------------------------------------------------------
MENUE_SPRUNGMARKE:
	rjmp MENUE_ANZEIGE_WARTUNG
	rjmp MENUE_ANZEIGE_WARTUNG
	rjmp MENUE_ANZEIGE_WARTUNG
	rjmp MENUE_ANZEIGE_WARTUNG
	rjmp MENUE_ANZEIGE_CRC_ON_OFF
	rjmp MENUE_ANZEIGE_BUS_RESET
	rjmp MENUE_RESET_PRESENCE
	rjmp MENUE_SINGLE_SCRATCHPAD_READ
	rjmp MENUE_SINGLE_ROM_READ
	rjmp MENUE_ANZEIGE_TASTENBELEGUNG
	rjmp MENUE_ANZEIGE_HAUPTMENUE		; 10 

	rjmp MENUE_ANZEIGE_SLAVES	; 11
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES

	rjmp MENUE_ANZEIGE_SLAVES	; 21
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES	; 31
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES	; 41
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES	; 51
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES	; 61
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES
	rjmp MENUE_ANZEIGE_SLAVES



	; START-MENUE		
	ldi temp,(START_MENUE)
	STS(adr_MENUE),temp
	rjmp MENUE_START
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_ANZEIGE_HAUPTMENUE:
	; ZEILE1	
	rcall LCD_CLEAR
	LDS temp1,(adr_ANZAHL_SLAVES)
	rcall ANZEIGE_3_STELLEN_TEMP1
	rcall LCD_SPACE
	rcall LCD_S
	rcall LCD_L
	rcall LCD_A
	rcall LCD_V
	rcall LCD_E
	rcall LCD_S
	rcall LCD_SPACE
	rcall LCD_f_
	rcall LCD_o_
	rcall LCD_u_
	rcall LCD_n_
	rcall LCD_d_
	; ZEILE2	
	rcall LCD_ZEILE2

	; ZEILE3		
	rcall LCD_ZEILE3

	; ZEILE4		
	rcall LCD_ZEILE4

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_ANZEIGE_CRC_ON_OFF:
	rcall MENUE_ANZEIGE_CRC_VIEW
;-------------------------------------------------------------------------------
	; TASTE ?							
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS)
	breq MENUE_ANZEIGE_CRC_ON_OFF_RUN
	ret
;-------------------------------------------------------------------------------
MENUE_ANZEIGE_CRC_ON_OFF_RUN:
	LDS temp,(adr_CRC_ON)
	inc temp
	andi temp,0b00000001
	STS(adr_CRC_ON),temp
	rcall MENUE_ANZEIGE_CRC_VIEW
	ret
;-------------------------------------------------------------------------------
MENUE_ANZEIGE_CRC_VIEW:
	; ZEILE1
	rcall LCD_CLEAR
	rcall LCD_C
	rcall LCD_R
	rcall LCD_C
	rcall LCD_MINUS
	rcall LCD_o_
	rcall LCD_n_
	rcall LCD_SPACE
	rcall LCD_SPACE
	LDS temp1,(adr_CRC_ON)
	rcall ANZEIGE_1_STELLEN_TEMP1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_ANZEIGE_BUS_RESET:
	rcall LCD_B
	rcall LCD_U
	rcall LCD_S
	rcall LCD_MINUS
	rcall LCD_R
	rcall LCD_E
	rcall LCD_S
	rcall LCD_E
	rcall LCD_T
;-------------------------------------------------------------------------------
	; TASTE ?							
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS)
	breq MENUE_ANZEIGE_BUS_RESET_RUN
	ret
;-------------------------------------------------------------------------------
MENUE_ANZEIGE_BUS_RESET_RUN:
	sbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF AUSGANG	
	cbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; AUF LOW		
	; ZEILE2
	rcall LCD_ZEILE2
	ldi temp9,10
MENUE_ANZEIGE_BUS_RESET_s:
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB an		
	rcall WAIT_100ms
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB aus		
	rcall LCD_PUNKT
	rcall WAIT_100ms
	dec temp9
	brne MENUE_ANZEIGE_BUS_RESET_s
	sbi (ONE_WIRE_PORT),(ONE_WIRE_PIN_NR)	; HIGH-PEGEL 	
	cbi (ONE_WIRE_DDR), (ONE_WIRE_PIN_NR)	; AUF EINGANG	
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN an		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_RESET_PRESENCE:
	rcall LCD_R
	rcall LCD_E
	rcall LCD_S
	rcall LCD_E
	rcall LCD_T
	rcall LCD_MINUS
	rcall LCD_P
	rcall LCD_R
	rcall LCD_E
	rcall LCD_S
	rcall LCD_E
	rcall LCD_N
	rcall LCD_C
	rcall LCD_E
;-------------------------------------------------------------------------------
	; TASTE ?							
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS)
	breq MENUE_RESET_PRESENCE_RUN
	ret
;-------------------------------------------------------------------------------
MENUE_RESET_PRESENCE_RUN:
	rcall ONE_WIRE_RESET_PRESENCE_C
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_SINGLE_ROM_READ:
	; ZEILE1	
	rcall LCD_CLEAR
	rcall LCD_S
	rcall LCD_i_
	rcall LCD_n_
	rcall LCD_g_
	rcall LCD_l_
	rcall LCD_e_
	rcall LCD_MINUS
	rcall LCD_R
	rcall LCD_O
	rcall LCD_M
	rcall LCD_MINUS
	rcall LCD_R
	rcall LCD_E
	rcall LCD_A
	rcall LCD_D
;-------------------------------------------------------------------------------
	; TASTE ?							
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS)
	breq MENUE_SINGLE_ROM_READ_RUN
	ret
;-------------------------------------------------------------------------------
MENUE_SINGLE_ROM_READ_RUN:
	; ZEILE2		
	rcall LCD_ZEILE2
	rcall ONE_WIRE_SINGLE_ROM_READ
	rcall ANZEIGE_ROM_ID_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_SINGLE_SCRATCHPAD_READ:
	; ZEILE1	
	rcall LCD_CLEAR
	rcall LCD_S
	rcall LCD_i_
	rcall LCD_n_
	rcall LCD_g_
	rcall LCD_l_
	rcall LCD_e_
	rcall LCD_MINUS
	rcall LCD_S
	rcall LCD_C
	rcall LCD_R
	rcall LCD_A
	rcall LCD_MINUS
	rcall LCD_R
	rcall LCD_E
	rcall LCD_A
	rcall LCD_D
;-------------------------------------------------------------------------------
	; TASTE ?							
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS)
	breq MENUE_SINGLE_SCRATCHPAD_READ_RUN
	ret
;-------------------------------------------------------------------------------
MENUE_SINGLE_SCRATCHPAD_READ_RUN:
	; ZEILE2	
	rcall LCD_ZEILE2
	rcall ONE_WIRE_SINGLE_SCRATCHPAD_READ
	rcall ANZEIGE_SCRATCHPAD_KURZ9
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_ANZEIGE_TASTENBELEGUNG:
	; ZEILE1	
	rcall LCD_CLEAR
	; ZEILE2	
	rcall LCD_ZEILE2
	; ZEILE3		
	rcall LCD_ZEILE3
	; ZEILE4		
	rcall LCD_ZEILE4
	ldi ZH, high(TEXT_TASTENBELEGUNG*2)	; TEXT 
	ldi ZL,  low(TEXT_TASTENBELEGUNG*2)
	rjmp ANZEIGE_TEXT
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_ANZEIGE_WARTUNG:
	; ZEILE1	
	rcall LCD_CLEAR
	rcall LCD_W
	rcall LCD_A
	rcall LCD_R
	rcall LCD_T
	rcall LCD_U
	rcall LCD_N
	rcall LCD_G


	; ZEILE2	
	rcall LCD_ZEILE2
	rcall LCD_T
	LDS temp1,(adr_TASTE)
	rcall ANZEIGE_3_STELLEN_TEMP1
	; ZEILE3	
	rcall LCD_ZEILE3
	rcall LCD_E
	LDS temp1,(adr_ERROR_CODE)
	rcall ANZEIGE_3_STELLEN_TEMP1
	; ZEILE4	
	rcall LCD_ZEILE4
	rcall LCD_M
	LDS temp1,(adr_MENUE)
	rcall ANZEIGE_3_STELLEN_TEMP1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Anzeige ROM-ID und Typ														
;																				
;	INP: SRAM (adr_MENUE)														
;																				
MENUE_ANZEIGE_SLAVES:
	; ZEILE1	
	rcall LCD_CLEAR
	LDS temp1,(adr_MENUE)
	subi temp1,10					; -10		
	rcall ANZEIGE_3_STELLEN_TEMP1	; SLAVE-NR	
	rcall LCD_SPACE
	rcall LCD_R
	rcall LCD_O
	rcall LCD_M
	rcall LCD_MINUS
	rcall LCD_I
	rcall LCD_D
;-------------------------------------------------------------------------------
	; ZEILE2	
	rcall LCD_ZEILE2
	ldi ZL,LOW (adr_ROM_BUFFER512)	; Z-initialisieren
	ldi ZH,HIGH(adr_ROM_BUFFER512)
	LDS temp,(adr_MENUE)
	subi temp,11			; -11
	ldi temp1,8
	mul temp,temp1			; mal 8
	add ZL,R0
	adc ZH,R1
	; in ROM-CRC-BEREICH kopieren		
	LD temp,Z+
	STS(adr_ROM_CRC_BEREICH8+0),temp
	LD temp,Z+
	STS(adr_ROM_CRC_BEREICH8+1),temp
	LD temp,Z+
	STS(adr_ROM_CRC_BEREICH8+2),temp
	LD temp,Z+
	STS(adr_ROM_CRC_BEREICH8+3),temp
	LD temp,Z+
	STS(adr_ROM_CRC_BEREICH8+4),temp
	LD temp,Z+
	STS(adr_ROM_CRC_BEREICH8+5),temp
	LD temp,Z+
	STS(adr_ROM_CRC_BEREICH8+6),temp
	LD temp,Z+
	STS(adr_ROM_CRC_BEREICH8+7),temp	; CRC	
	; ROM-CRC-CHECK						
;	rcall ROM_CRC7
;-------------------------------------------------------------------------------
	; TASTE ?							
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS)
	breq MENUE_ANZEIGE_SCRATCHPAD
	; ROM-ID-ANZEIGE					
	rcall ANZEIGE_ROM_ID_KURZ
;-------------------------------------------------------------------------------
	; ZEILE3		
	rcall LCD_ZEILE3
	LDS temp1,(adr_ROM_CRC_BEREICH8+0)		; FAM-NAME
	rcall ANZEIGE_TEXT_FAMILY_KURZ_TEMP1
;-------------------------------------------------------------------------------
	; ZEILE4		
	rcall LCD_ZEILE4

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Anzeige SCRATCHPAD															
;																				
;	INP: SRAM (adr_MENUE)														
;   INP; SRAM (adr_ROM_CRC_BEREICH8)											
;																				
MENUE_ANZEIGE_SCRATCHPAD:
	; ZEILE1	
	rcall LCD_CLEAR
	rcall LCD_S
	rcall LCD_L
	rcall LCD_A
	rcall LCD_V
	rcall LCD_E
	rcall LCD_MINUS
	LDS temp1,(adr_MENUE)
	subi temp1,10						; -10		
	rcall ANZEIGE_3_STELLEN_TEMP1		; SLAVE-NR	
;-------------------------------------------------------------------------------
	LDS temp,(adr_ROM_CRC_BEREICH8+0)	; FAM		
	cpi temp,0x10
	brne MENUE_ANZEIGE_SCRATCHPAD_NO_x10
	rjmp MENUE_ANZEIGE_SCRATCHPAD_x10
MENUE_ANZEIGE_SCRATCHPAD_NO_x10:
;-------------------------------------------------------------------------------
	LDS temp,(adr_ROM_CRC_BEREICH8+0)	; FAM		
	cpi temp,0x22
	brne MENUE_ANZEIGE_SCRATCHPAD_NO_x22
	rjmp MENUE_ANZEIGE_SCRATCHPAD_x22
MENUE_ANZEIGE_SCRATCHPAD_NO_x22:
;-------------------------------------------------------------------------------
	LDS temp,(adr_ROM_CRC_BEREICH8+0)	; FAM		
	cpi temp,0x28
	brne MENUE_ANZEIGE_SCRATCHPAD_NO_x28
	rjmp MENUE_ANZEIGE_SCRATCHPAD_x28
MENUE_ANZEIGE_SCRATCHPAD_NO_x28:
;-------------------------------------------------------------------------------

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_ANZEIGE_SCRATCHPAD_x10:
	rcall ONE_WIRE_SCRATCHPAD_READ
	rcall ANZEIGE_SCRATCHPAD_KURZ9
	rcall SCRATCHPAD_CRC8_C			; CRC	
	; ZEILE4
	rcall LCD_ZEILE4
	rcall DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_9BIT
	rcall LCD_SPACE3
	rcall LCD_SPACE3
	rcall ANZEIGE_TEMPERATUR_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_ANZEIGE_SCRATCHPAD_x22:
	rcall ONE_WIRE_SCRATCHPAD_READ
	rcall ANZEIGE_SCRATCHPAD_KURZ9
	rcall SCRATCHPAD_CRC8_C			; CRC	
	; ZEILE4
	rcall LCD_ZEILE4
	rcall DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_12BIT
	rcall LCD_SPACE3
	rcall LCD_SPACE3
	rcall ANZEIGE_TEMPERATUR_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
MENUE_ANZEIGE_SCRATCHPAD_x28:
	rcall ONE_WIRE_SCRATCHPAD_READ
	rcall ANZEIGE_SCRATCHPAD_KURZ9
	rcall SCRATCHPAD_CRC8_C			; CRC	
	; ZEILE4
	rcall LCD_ZEILE4
	rcall DSXXXX_TEMPERATURBERECHNUNG_VARIANTE_12BIT
	rcall LCD_SPACE3
	rcall LCD_SPACE3
	rcall ANZEIGE_TEMPERATUR_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
