; ##############################################################################
; ##############################################################################
; ##############################################################################
WDR_INITIALISIERUNG:
; Watchdog aktivieren (max. Zeit)					
	ldi TEMP,(1<<WDCE)|(1<<WDE)  
	out wdtcr,TEMP       
	ldi TEMP,(1<<WDE) | (1<<WDP2)|(1<<WDP1)|(1<<WDP0) 
	out wdtcr,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
NEUSTART_MIT_WDR:
	WDR
	in temp, MCUCSR
	andi temp,0b00001000
	tst temp
	breq NEUSTART_MIT_WDR_FEHLER
	; MCUCSR clear		
	out MCUCSR,NULL
	ret
NEUSTART_MIT_WDR_FEHLER:
	rjmp NEUSTART_MIT_WDR_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
SRAM_CLEAR:
	ldi ZL, LOW (adr_DATEN)
	ldi ZH, HIGH(adr_DATEN)
	ldi temp,0
SRAM_CLEAR_w:
	ST z+,temp
	cpi ZH, HIGH(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	cpi ZL, LOW(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	breq SRAM_CLEAR_w		; gleich  => SPRUNG	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; PORT B+C+D CLEAR														
PORT_CLEAR:
	ldi temp, 0b00000000	
	out DDRB, temp
	out DDRC, temp
	out DDRD, temp
	out PORTB,temp				
	out PORTC,temp				
	out PORTD,temp	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
REGISTER_CLEAR:
	clr R0
	clr R1
	clr R2
	clr R3
	clr R4
	clr R5
	clr R6
	clr R7
	clr R8
	clr R9
	clr R10
	clr R11
	clr R12
	clr R13
	clr R14
	clr R15
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_INITIALISIERUNG:
	; auf AUSGANG								
	sbi (LED_GRUEN_DDR),(LED_GRUEN_PIN_NR)		; GRN		
	sbi (LED_GELB_DDR),(LED_GELB_PIN_NR)		; GELB		
	sbi (LED_ROT_DDR) ,(LED_ROT_PIN_NR)			; ROT		
	sbi (LED_BLAU_DDR) ,(LED_BLAU_PIN_NR)		; BLAU		
	; LEDs an									
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	cbi (LED_BLAU_PORT),(LED_BLAU_PIN_NR)		; BLAU an	
	rcall wait_100ms
	; LEDs aus									
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB aus	
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  aus	
	sbi (LED_BLAU_PORT),(LED_BLAU_PIN_NR)		; BLAU aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TASTEN_INITIALISIERUNG:
	; auf EINGANG						
	cbi (TASTE_A_DDR),(TASTE_A_PIN_NR) 
	cbi (TASTE_B_DDR),(TASTE_B_PIN_NR) 
	cbi (TASTE_C_DDR),(TASTE_C_PIN_NR) 
	cbi (TASTE_D_DDR),(TASTE_D_PIN_NR) 
	cbi (TASTE_E_DDR),(TASTE_E_PIN_NR) 
	cbi (TASTE_F_DDR),(TASTE_F_PIN_NR) 	
	; PULL UP ein						
	sbi (TASTE_A_PORT),(TASTE_A_PIN_NR) 		
	sbi (TASTE_B_PORT),(TASTE_B_PIN_NR) 		
	sbi (TASTE_C_PORT),(TASTE_C_PIN_NR) 		
	sbi (TASTE_D_PORT),(TASTE_D_PIN_NR) 		
	sbi (TASTE_E_PORT),(TASTE_E_PIN_NR) 		
	sbi (TASTE_F_PORT),(TASTE_F_PIN_NR) 		

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TASTEN_ABFRAGE:
	; TASTEN-WAIT			
	LDS temp,(adr_TASTE)
	tst temp
	breq TASTEN_ABFRAGE_RUN
	rcall WAIT_100ms
	rcall WAIT_100ms
	rcall WAIT_100ms
;-------------------------------------------------------------------------------
TASTEN_ABFRAGE_RUN:
	clr temp
	sbis (TASTE_A_PIN),(TASTE_A_PIN_NR)	; springe, wenn...	
	ori	temp,(TASTE_MESSEN)		; 1 
	sbis (TASTE_B_PIN),(TASTE_B_PIN_NR)	; springe, wenn...	
	ori	temp,(TASTE_PLUS)		; 2	
	sbis (TASTE_C_PIN),(TASTE_C_PIN_NR)	; springe, wenn...	
	ori	temp,(TASTE_MENUE_MINUS); 4	
	sbis (TASTE_D_PIN),(TASTE_D_PIN_NR)	; springe, wenn...	
	ori	temp,(TASTE_MENUE_PLUS)	; 8 
	sbis (TASTE_E_PIN),(TASTE_E_PIN_NR)	; springe, wenn...	
	ori	temp,(TASTE_MINUS)		;16 
	sbis (TASTE_F_PIN),(TASTE_F_PIN_NR)	; springe, wenn...	
	ori	temp,(TASTE_SEARCH)		;32 
	STS(adr_TASTE),temp
;-------------------------------------------------------------------------------
	tst temp
	brne TASTEN_ABFRAGE_ACTION
	ret
;-------------------------------------------------------------------------------
TASTEN_ABFRAGE_ACTION:
	STS(adr_TEMPERATUR_L),NULL
	STS(adr_TEMPERATUR_H),NULL
	STS(adr_ERROR_CODE),NULL

	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB aus	
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  aus	
	sbi (LED_BLAU_PORT),(LED_BLAU_PIN_NR)		; BLAU aus	
;-------------------------------------------------------------------------------
; RESET ?																		
	cpi temp,(TASTE_PLUS)+(TASTE_MINUS)
	breq TASTEN_ABFRAGE_RESET
	cpi temp,(TASTE_SEARCH)
	breq TASTEN_ABFRAGE_SEARCH
	cpi temp,(TASTE_MESSEN)
	breq TASTEN_ABFRAGE_MESSEN_ALLE
	ret
;-------------------------------------------------------------------------------
TASTEN_ABFRAGE_RESET:
	rcall ANZEIGE_TEXT_RESET_KURZ
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  an	
	cbi (LED_BLAU_PORT),(LED_BLAU_PIN_NR)		; BLAU an	
TASTEN_ABFRAGE_RESET_s:
	rjmp TASTEN_ABFRAGE_RESET_s
;-------------------------------------------------------------------------------
TASTEN_ABFRAGE_SEARCH:
	STS(adr_ERROR_CODE),NULL					; ERROR-CODE	
	rcall ANZEIGE_TEXT_SEARCH_KURZ
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_ROT_PORT),(LED_ROT_PIN_NR)			; ROT  aus	
	rcall ROM_SEARCH
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	ldi temp,(START_MENUE)
	STS(adr_MENUE),temp
	ret
;-------------------------------------------------------------------------------
TASTEN_ABFRAGE_MESSEN_ALLE:
	STS(adr_ERROR_CODE),NULL					; ERROR-CODE	
	rcall ANZEIGE_TEXT_MESSEN_KURZ
	rcall ONE_WIRE_RESET_PRESENCE_C				; Reset+Presence
	brcs TASTEN_ABFRAGE_MESSEN_ALLE_w
	ret
TASTEN_ABFRAGE_MESSEN_ALLE_w:
	ldi temp1,0xCC								; SKIP-ROM		
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	ldi temp1,0x44								; Convert "T"	
	rcall ONE_WIRE_BYTE_WRITE_TEMP1
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	; ZEILE2	
	rcall LCD_ZEILE2
	ldi temp9,10
TASTEN_ABFRAGE_MESSEN_ALLE_s:
	cbi (LED_GELB_PORT),(LED_GELB_PIN_NR)		; GELB an	
	rcall WAIT_100ms
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	rcall LCD_PUNKT
	rcall WAIT_100ms
	dec temp9
	brne TASTEN_ABFRAGE_MESSEN_ALLE_s
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
PROGRAMM_CHECK:
	; NULL		
	tst NULL
	brne PROGRAMM_CHECK_FEHLER
	; EINS		
	mov temp,EINS
	cpi temp,1
	brne PROGRAMM_CHECK_FEHLER
	; SRAM CHECK
	LDS temp,(adr_SRAM_CHECK)
	cpi temp,'S'
	brne PROGRAMM_CHECK_FEHLER
	ret
;-------------------------------------------------------------------------------
; SCHLEIFE																		
PROGRAMM_CHECK_FEHLER:
	CLI											; INTERRUPTS sperren	
	rcall wait_100ms
	sbi (LED_GRUEN_PORT),LED_GRUEN_PIN_NR		; GRN aus	
	sbi (LED_GELB_PORT),LED_GELB_PIN_NR			; GELB aus	
	sbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  aus	
	rcall wait_100ms
	cbi (LED_ROT_PORT),LED_ROT_PIN_NR			; ROT  an	
	rjmp PROGRAMM_CHECK_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################















