#include <avr/io.h>
#include <util/delay.h>
#include <stdlib.h>
#include <stdint.h>
#include <util/twi.h>
#include "i2cmaster/i2cmaster.h"

#define     F_CPU           16000000UL
#define     LED             PB5
#define     PCF8574_WRITE   0x4E


void LED_init(void) {
    // define pin LED as output
    DDRB |= (1<<LED);
}

void LED_blink_slow() {
    _delay_ms(1000);
    PORTB ^= (1<<LED);
    _delay_ms(1000);
    PORTB ^= (1<<LED);
}

void LED_blink_fast() {
    _delay_ms(300);
    PORTB ^= (1<<LED);
    _delay_ms(300);
    PORTB ^= (1<<LED);
}

void LED_on(void) {
    PORTB &= (1<<LED);
}

void LED_toggle(void) {
    PORTB ^= (1<<LED);
}

int main(void) {
    LED_init();
    i2c_init();

    while(1) {
        i2c_start(PCF8574_WRITE);
        i2c_write(0x00);
        i2c_stop();

        _delay_ms(1000);

        i2c_start(PCF8574_WRITE);
        i2c_write(0xff);
        i2c_stop();

        _delay_ms(1000);
    }
}
