/*
 * Sebi_2017_2_13_TEST.c
 *
 * Created: 13.02.2017 13:20:50
 * Author : Sebastian
 */ 

#define F_CPU 20000000UL
#define BAUDRATE 19200
#define UBRRVAL ((F_CPU/(BAUDRATE*16UL))-1)

#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include <stdbool.h>
#include <inttypes.h>
#include "spi_config.h"
#include "spi.h"
#include "ili9341.c"
#include "ili9341gfx.c"
#include "mfrc522.h"
#include "mfrc522_cmd.h"
#include "mfrc522_reg.h"

#define POINTCOLOUR PINK 
extern uint16_t vsetx,vsety,vactualx,vactualy,isetx,isety,iactualx,iactualy;
uint8_t byte = 0,bb = 0; char str[MAX_LEN], inits = 0;
volatile int timerc = 0;

#define FOSC 20000000UL // Clock Speed
#define BAUD 9600
#define MYUBRR (FOSC/16/BAUD-1)

void USART_Init( unsigned int ubrr){
	/* Set baud rate */
	UBRR0H = (unsigned char)(ubrr>>8);
	UBRR0L = (unsigned char)ubrr;
	/* Enable receiver and transmitter */
	UCSR0B = (1<<RXEN0)|(1<<TXEN0);
	/* Set frame format: 8data, 1stop bit */
	UCSR0C = (3<<UCSZ00);
} // USART_Init

void USART_Transmit( unsigned char data )
{
	/* Wait for empty transmit buffer */
	while ( !( UCSR0A & (1<<UDRE0)) )
	;
	/* Put data into buffer, sends the data */
	UDR0 = data;
}

unsigned char USART_Receive( void )
{
	/* Wait for data to be received */
	while ( !(UCSR0A & (1<<RXC0)) )
	;
	/* Get and return received data from buffer */
	return UDR0;
}


// initialize timer, interrupt and variable
void timer1_init()
{
	cli();
	TCCR1B |= (1 << WGM12)|(1 << CS11)|(1 << CS10);
	TCNT1 = 0;
	OCR1A = 20000;
	TIMSK1 |= (1 << OCIE1A);
	sei();
}

void Checkper(void){

stdout = & mydata;//it is used for printf function and must be declared locally

ili9341_writescr(0, 10, WHITE, BLACK, 2, "Starting up");

ili9341_writescr(0, 30, WHITE, BLACK, 2, "Checking Network");
_delay_us(10);
//if(Lan == ok){
ili9341_writescr(0, 50, GREEN, BLACK, 2, "Ok");
//} else{
ili9341_writescr(100, 50, RED, BLACK, 2, "failed");
//}
_delay_us(1);
ili9341_writescr(0, 70, WHITE, BLACK, 2, "Checking RFID");
if(byte == 146){
ili9341_writescr(0, 90, GREEN, BLACK, 2, "Ok");
} else{
ili9341_writescr(100, 90, RED, BLACK, 2, "failed");
}
ili9341_writescr(0, 120, WHITE, BLACK, 2, "Initializing HUD");
_delay_us(1);
ili9341_writescr(0, LCD_H-30, WHITE, BLACK, 1, "Build: v.1");
ili9341_writescr(65, LCD_H-30, WHITE, BLACK, 1, __TIMESTAMP__);
_delay_ms(1000);
ili9341_clear(BLACK);
}

int main(void)
{
	cli();

	CLKPR=(1<<CLKPCE); // change enable
	//CLKPR=0; // "no pre-scaler"

	stdout = & mydata;
	ili9341_init();//initial driver setup to drive ili9341
	ili9341_clear(BLACK);//fill screen with black colour
	_delay_us(10);
	ili9341_setRotation(1);//rotate screen
	_delay_ms(2);


	//timer1_init(); // Timer1 Initialisieren

	USART_Init(MYUBRR); // Initialisieren des USARTS

	mfrc522_init(); // RFID Initialisieren

	byte = mfrc522_read(VersionReg);
	//display_init();//display initial data
	Checkper();

	char buffer[10];
	sprintf(buffer, "%i", byte);
	ili9341_writescr(10,LCD_H-30,WHITE,BLACK,2,buffer);

	inits = 1; //  Initialisierung fertig, LED Blinken-
	sei();

	while(1)
	{		
	//USART_Transmit(1);
	char rec = USART_Receive();
	sprintf(buffer, "%c", rec);
	ili9341_writescr(10,10,WHITE,BLACK,2,buffer);
	ili9341_writescr(10,50,WHITE,BLACK,2,"Test");
	/*
						bb=0;
						byte = mfrc522_request(PICC_REQALL,str);
						sprintf(buffer, "%d", byte);
						ili9341_writescr(10,10,WHITE,BLACK,2,buffer);
						if(byte == CARD_FOUND)
						{
							byte = mfrc522_get_card_serial(str);
							ili9341_writescr(10,10,WHITE,BLACK,2,byte);
							if(byte == CARD_FOUND)
							{
								bb = byte;
								for(byte=0;byte<8;byte++){
									sprintf(buffer, "%x", str[byte]);
									ili9341_writescr(10+35*byte, 40, WHITE, BLACK, 2, buffer);
								}
							}
							else
							{
								ili9341_writescr(0, 50, WHITE, BLACK, 2, "Error");
							}
						}
						for(byte=0;byte<8;byte++){
							str[byte] = 0;
							sprintf(buffer, "%x", str[byte]);
						}
						ili9341_writescr(10+35*byte, 40, WHITE, BLACK, 2, buffer);
		
		*/
	}
}

ISR (TIMER1_COMPA_vect)
{

}
