#include "spi.h"
void spi_init()
{
	
	DDRB = (1<<SPI_MOSI)|(1<<SPI_SCK)|(1<<SPI_SS)|(1<<CS_LCD);
	SSDDR |= (1<<RFIDSS); DDRC = 0xFF;
	SPCR = (1<<SPE)|(1<<MSTR);//SPI as Master
	SPSR |=(1<<SPI2X);	// f/2 
	SPI_DDR |=(1<<DC_LCD);//cs off during startup
}


uint8_t spi_transmit(uint8_t data)
{
	SPDR = data;
	while(!(SPSR & (1<<SPIF)));
	
	return SPDR;
}


