;    vu.s is free software: you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation, either version 3 of the License, or
;    (at your option) any later version.
;
;    vu.s is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with vu.  If not, see <http://www.gnu.org/licenses/>.
;
;
;    fuses: hfuse=0xff lfuse=0x6a ; so no fuse programming should be
;           necessary.
;

.org 0x00
reset:
    rjmp coldstart ; reset
    rjmp crap_int  ; int0
    rjmp crap_int  ; pcint0
    rjmp crap_int  ; tim0_ovf
    rjmp crap_int  ; ee_rdy
    rjmp crap_int  ; ana_comp
    rjmp crap_int  ; tim0_compa
    rjmp crap_int  ; tim0_compb
    rjmp crap_int  ; wdt
adcirq: ; this gets called 9600000/256=37500 times per sec.
    ; we save  2 cycles by not using rjmp to jump to the handler...
    in r0, 0x3f  ; save flags - i guess we would not need this either.
    out 0x38,r2  ; TIFR0 = (1 << TOV0) : ack timer overflow
    adiw r24,0x01   ; inc counter
    in r30,0x05  ; read ADCH  = get audio sample
    ldi r31, hi8(square_table_l)
    lpm r16,z
    inc r31
    lpm r17,z ;  (ADCH-128)^2  now in R17:R16
    add r12,r16
    adc r13,r17
    adc r14,r1
;---sigmadelta-auto-zero-adjust---
;    subi r30,0x80
;    add r30,r8
;    brvc satdone
;    ldi r30,0x7f
;    brcc satdone
;    inc r30
;satdone:
;    mov r8,r30
;    subi r30,0x80
;    add r9,r30
;    brcs pb5hi
;    ; pin5 to hi z
;    rjmp pb5done
;pb5hi:
;   ; pin5 to hi
;pb5done:
;---/sigmadelta-auto-zero-adjust---
    mov r16,r24
    andi r16,0x3f
    breq dodisplay
    out 0x3f,r0  ; restore flags; fertsch
    reti
dodisplay: ; all 1/586Hz we advance the display multiplex...
    mov r16,r24
    lsr r16
    lsr r16
    andi r16,0x30
    mov r11,r16
    mov r16,r15 ; get display value
    andi r16,0x0f ; get bar value
    or  r16,r11 ;  offset for display table
    ldi r30, lo8(display_table)
    ldi r31, hi8(display_table)
    add r30,r16 ; there can t be any carry to r31
    lpm r10,z ; save bar pattern in r10
    mov r16,r15 ; get display value
    swap r16
    andi r16,0xf ; get dot value
    or  r16,r11 ;  offset for display table
    ldi r30, lo8(display_table)
    ldi r31, hi8(display_table)
    add r30,r16 ; there can t be any carry to r31
    lpm r16,z ; save dot pattern in r16
    swap r16;
    or r16,r10 ; verknuspel bar and dot value
    andi r16,0xf
    out 0x18,r1  ; all LEDs off
    out 0x17,r16 ; new pattern active
    mov r11,r24  ; 2msb from r24 -> 4 bit pattern, walking "1" in PORTB
    lsl r11
    brcs case_1x
    lsl r11
    brcs case_01
    sbi 0x18,0 ; case_00
    rjmp adcirq_done
case_01:
    sbi 0x18,1
    rjmp adcirq_done
case_1x:
    lsl r11
    brcs case_11
    sbi 0x18,2 ; case_10
    rjmp adcirq_done
case_11:
    sbi 0x18,3
    mov r16,r25 ; see if square sum is ready
    andi r16,0x03
    breq docalc
adcirq_done:
    out 0x3f,r0  ; restore flags
    reti
    ; now calc. the amount of leds to be lit...
docalc:
;; put some extra shifts in here to be more sensitive
;    lsl r12
;    rol r13
;    rol r14
    ldi r17,0x0c
    lsl r13
    rol r14
    brcs calcdone ; 0dBFS ;  10*log10(256/256) = 0
    dec r17
    cp r14,r3
    brcc calcdone ; -1dB  ;  10*log10(203/256) = -1.0...
    dec r17
    cp r14,r4
    brcc calcdone ; -2dB  ;  10*log10(161/256) = -2.0...
    dec r17
    lsl r13
    rol r14
    brcs calcdone ; -3dB  ;  10*log10(128/256) = -3.0...
    dec r17
    cp r14,r3
    brcc calcdone ; -4dB
    dec r17
    cp r14,r4
    brcc calcdone ; -5dB
    dec r17
db3:
    lsl r13
    rol r14
    brcs calcdone ; -6dB, ... , -21dB
    dec r17
    brne db3
calcdone: ; value in lower nibble of r17
    mov r16,r15
    andi r16,0xf0
    or r17,r16
    mov r15,r17
    mov r16,r17
    swap r16
    andi r16,0x0f  ; dot in LSN of r16
    andi r17,0x0f  ; bar in LSN of r17
    cp r17,r16
    brcs no_bar_to_dot_copy
    ;bar is same or bigger than dot, so cp bar->dot and reset counter...
    mov r16,r17
    swap r16 ; dot in MSN of r16
    or r17,r16
    mov r15,r17
    mov r7,r1 ; dotcounter=0
    rjmp rss
no_bar_to_dot_copy:
    mov r16,r7
    mov r17,r15
    cpi r16,0xff
    brne no_counter_done
    ; dotcounter has reached 255, so be sure to set dot=0
    andi r17,0x0f
    mov r15,r17
    rjmp rss
no_counter_done:
    inc r16 ;  dotcounter++
    mov r7,r16;
    cpi r16,0x17 ; time to wait until dots count down
    brcc downcount_dots
    rjmp rss
downcount_dots:
    andi r16,0x01 ;1,3,7 : speed to count
    brne rss
    mov r16,r17
    andi r16,0xf0
    breq rss
    subi r17,0x10
    mov r15,r17
rss:
    mov r12,r1 ; reset square sum
    mov r13,r1
    mov r14,r1
    out 0x3f,r0  ; restore flags
    reti

coldstart:
    eor r1,r1 ; put const=0 in r1
    out 0x3f,r1 ; clear flags, disable irq
    ldi r23,0x9f
    out 0x3d,r23 ; set stackptr
    ori r18,0x40
    andi r22,0x25
    andi r22,0x57
    ori r23,0x54
    ori r23,0x57
    ori r22,0x1b
    and r2,r0
    ldi r22,0x02;
    mov r2,r22   ; put const values in r2,r3,r4
    ldi r22,0xcb
    mov r3,r22
    ldi r22,0xa1
    mov r4,r22
    ldi r22,0x80
    out 0x26,r22
    out 0x26,r1 ; switch to 9.6MHz clk
    ldi r22,0x40
    out 0x35,r22 ; MCUCR = 0x40 ; disable pull ups
    out 0x2f,r1  ; TCCR0A = 0
    ldi r22,0x01
    out 0x33,r22 ; TCCR0B = (1<<CS00)
    out 0x39,r1  ; TIMSK = 0;
    ldi r22,0x04
    out 0x03,r22 ; ADCSRB = (1<<ADTS2)
    ldi r22,0x62
    out 0x07,r22 ; ADMUX
    ldi r22,0xec
    out 0x06,r22 ; ADCSRA
    ldi r22,0x10
    out 0x14,r22 ; DIDR0 = (1<<ADC2D)
    sei

endless_loop: ; this is the "main()" loop.
    rjmp endless_loop

crap_int: ; we should never get here,
    cli   ; but if we do: light some LEDs
    sbi 0x18,0
    sbi 0x17,0
    sbi 0x17,1
    sbi 0x17,2
    rjmp crap_int

.org 0x1c0
display_table:
.byte 0x11,0x11,0x11,0x11,0x33,0x13,0x13,0x13
.byte 0x13,0x57,0x9f,0x1f,0x1f,0x1f,0x1f,0x1f
.byte 0x22,0x22,0x22,0x33,0x23,0x23,0x23,0x23
.byte 0x67,0x27,0x27,0xaf,0x2f,0x2f,0x2f,0x2f
.byte 0x44,0x44,0x55,0x45,0x45,0x67,0x47,0x47
.byte 0x47,0x47,0x47,0x47,0xcf,0x4f,0x4f,0x4f
.byte 0x88,0x99,0x89,0x89,0x89,0x89,0xab,0xcf
.byte 0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f,0x8f

.org 0x200
square_table_l:
.byte 0xff,0x01,0x04,0x09,0x10,0x19,0x24,0x31
.byte 0x40,0x51,0x64,0x79,0x90,0xa9,0xc4,0xe1
.byte 0x00,0x21,0x44,0x69,0x90,0xb9,0xe4,0x11
.byte 0x40,0x71,0xa4,0xd9,0x10,0x49,0x84,0xc1
.byte 0x00,0x41,0x84,0xc9,0x10,0x59,0xa4,0xf1
.byte 0x40,0x91,0xe4,0x39,0x90,0xe9,0x44,0xa1
.byte 0x00,0x61,0xc4,0x29,0x90,0xf9,0x64,0xd1
.byte 0x40,0xb1,0x24,0x99,0x10,0x89,0x04,0x81
.byte 0x00,0x81,0x04,0x89,0x10,0x99,0x24,0xb1
.byte 0x40,0xd1,0x64,0xf9,0x90,0x29,0xc4,0x61
.byte 0x00,0xa1,0x44,0xe9,0x90,0x39,0xe4,0x91
.byte 0x40,0xf1,0xa4,0x59,0x10,0xc9,0x84,0x41
.byte 0x00,0xc1,0x84,0x49,0x10,0xd9,0xa4,0x71
.byte 0x40,0x11,0xe4,0xb9,0x90,0x69,0x44,0x21
.byte 0x00,0xe1,0xc4,0xa9,0x90,0x79,0x64,0x51
.byte 0x40,0x31,0x24,0x19,0x10,0x09,0x04,0x01
.byte 0x00,0x01,0x04,0x09,0x10,0x19,0x24,0x31
.byte 0x40,0x51,0x64,0x79,0x90,0xa9,0xc4,0xe1
.byte 0x00,0x21,0x44,0x69,0x90,0xb9,0xe4,0x11
.byte 0x40,0x71,0xa4,0xd9,0x10,0x49,0x84,0xc1
.byte 0x00,0x41,0x84,0xc9,0x10,0x59,0xa4,0xf1
.byte 0x40,0x91,0xe4,0x39,0x90,0xe9,0x44,0xa1
.byte 0x00,0x61,0xc4,0x29,0x90,0xf9,0x64,0xd1
.byte 0x40,0xb1,0x24,0x99,0x10,0x89,0x04,0x81
.byte 0x00,0x81,0x04,0x89,0x10,0x99,0x24,0xb1
.byte 0x40,0xd1,0x64,0xf9,0x90,0x29,0xc4,0x61
.byte 0x00,0xa1,0x44,0xe9,0x90,0x39,0xe4,0x91
.byte 0x40,0xf1,0xa4,0x59,0x10,0xc9,0x84,0x41
.byte 0x00,0xc1,0x84,0x49,0x10,0xd9,0xa4,0x71
.byte 0x40,0x11,0xe4,0xb9,0x90,0x69,0x44,0x21
.byte 0x00,0xe1,0xc4,0xa9,0x90,0x79,0x64,0x51
.byte 0x40,0x31,0x24,0x19,0x10,0x09,0x04,0x01

.org 0x300
square_table_h:
.byte 0x3f,0x3f,0x3e,0x3d,0x3c,0x3b,0x3a,0x39
.byte 0x38,0x37,0x36,0x35,0x34,0x33,0x32,0x31
.byte 0x31,0x30,0x2f,0x2e,0x2d,0x2c,0x2b,0x2b
.byte 0x2a,0x29,0x28,0x27,0x27,0x26,0x25,0x24
.byte 0x24,0x23,0x22,0x21,0x21,0x20,0x1f,0x1e
.byte 0x1e,0x1d,0x1c,0x1c,0x1b,0x1a,0x1a,0x19
.byte 0x19,0x18,0x17,0x17,0x16,0x15,0x15,0x14
.byte 0x14,0x13,0x13,0x12,0x12,0x11,0x11,0x10
.byte 0x10,0x0f,0x0f,0x0e,0x0e,0x0d,0x0d,0x0c
.byte 0x0c,0x0b,0x0b,0x0a,0x0a,0x0a,0x09,0x09
.byte 0x09,0x08,0x08,0x07,0x07,0x07,0x06,0x06
.byte 0x06,0x05,0x05,0x05,0x05,0x04,0x04,0x04
.byte 0x04,0x03,0x03,0x03,0x03,0x02,0x02,0x02
.byte 0x02,0x02,0x01,0x01,0x01,0x01,0x01,0x01
.byte 0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.byte 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.byte 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.byte 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
.byte 0x01,0x01,0x01,0x01,0x01,0x01,0x01,0x02
.byte 0x02,0x02,0x02,0x02,0x03,0x03,0x03,0x03
.byte 0x04,0x04,0x04,0x04,0x05,0x05,0x05,0x05
.byte 0x06,0x06,0x06,0x07,0x07,0x07,0x08,0x08
.byte 0x09,0x09,0x09,0x0a,0x0a,0x0a,0x0b,0x0b
.byte 0x0c,0x0c,0x0d,0x0d,0x0e,0x0e,0x0f,0x0f
.byte 0x10,0x10,0x11,0x11,0x12,0x12,0x13,0x13
.byte 0x14,0x14,0x15,0x15,0x16,0x17,0x17,0x18
.byte 0x19,0x19,0x1a,0x1a,0x1b,0x1c,0x1c,0x1d
.byte 0x1e,0x1e,0x1f,0x20,0x21,0x21,0x22,0x23
.byte 0x24,0x24,0x25,0x26,0x27,0x27,0x28,0x29
.byte 0x2a,0x2b,0x2b,0x2c,0x2d,0x2e,0x2f,0x30
.byte 0x31,0x31,0x32,0x33,0x34,0x35,0x36,0x37
.byte 0x38,0x39,0x3a,0x3b,0x3c,0x3d,0x3e,0x3f



;--------------------------------------------
; reg usage proposal:
; r 00  : saves flag register during interrupts
; r 01  : constant 0
; r 02  : constant 2
; r 03  : constant 203=0xcb
; r 04  : constant 161=0xa1
; r 05
; r 06
; r 07  : dotcounter
; r 08  : (integrator w. saturation)
; r 09  : (sigma delta adc integrator)
; r 10  : tmp workspace for display calc.
; r 11  : tmp workspace for display calc.
; r 12  : sum of squares LSB
; r 13  : sum of squares
; r 14  : sum of squares MSB
; r 15  : display value: upper nibble: dot /  lower nibble: bar
; r 16  : scratch, square low, dot/bar
; r 17  : scratch, square hi, dot/bar
; r 18  :
; r 19  :
; r 20  :
; r 21  :
; r 22  : immediate value for init
; r 23  : immediate value for init
; r 24  : counter
; r 25  : counter

; r 26  : X :
; r 27  : X :

; r 28  : Y :
; r 29  : Y :

; r 30  : Z : pointer to various tables in flash
; r 31  : Z : "       "
