unit BildConvUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, SynGdiPlus, ComCtrls;

type

  PIconHeader = ^TIconHeader;
  TIconHeader = packed record
    idReserved: Word;  {always 0}
    idType    : Word;  {always 1}
    idCount   : Word;  {total number of icon pics in file}
  end;

  PIconDirEntry = ^TIconDirEntry;
  TIconDirEntry = packed record
    bWidth:       Byte;      {ie: 16 or 32}
    bHeight:      Byte;      {ie: 16 or 32}
    bColorCount:  Byte;      {number of entires in pallette table below}
    bReserved:    Byte;      { not used  = 0}
    wPlanes:      Word; { not used  = 0}
    wBitCount:    Word; { not used  = 0}
    dwBytesInRes: Longint;  {total number bytes in images including pallette data
                             XOR, AND     and bitmap info header}
    dwImageOffset: Longint;  {pos of image as offset from the beginning of file}
  end;

  PIconTafel = ^TIconTafel;
  TIconTafel = Array[0..99] of TIconDirEntry;

  PBmfHeader = ^TBmfHeader;
  TBmfHeader = packed record
    magic      : word; { immer 'BM' }
    fsize      : longint;   { Dateilaenge }
    null1      : word;
    null2      : word;
    offset     : longint;   { Offset der Pixel vom Dateibeginn }
    end;

  PBmfInfoHeader = ^TBmfInfoHeader;
  TBmfInfoHeader = packed record
    infSize    : longint; { Size dieses Headers }
    biWidth    : longint; { Bildbreite in Pixeln }
    biHeight   : longint; { Bildhhe in Pixeln }
    biPlanes   : word; { ? }
    biBitCount : word; { Bits/Pixel }
    biCompression: longint; { normal = 0 }
    biSizeImage: longint;   { nur bei Kompression }
    biXPelsPerMeter: longint; { X: Pixels/Meter }
    biYPelsPerMeter: longint; { Y: Pixels/Meter }
    biColorsUsed: longint;    { Anzahl benutzter Farben }
    biColorsImportant: longint; { Anzahl 'wichtiger' Farben }
    end;




  TMainForm = class(TForm)
    ConvPanel: TPanel;
    OpenDialog: TOpenDialog;
    Bilderrrahmen: TGroupBox;
    TheImage: TImage;
    IconSelBox: TGroupBox;
    IconSelCombo: TComboBox;
    Stabar: TStatusBar;
    ZielBox: TGroupBox;
    ZielImage: TImage;
    LadeButton: TButton;
    E1: TScrollBar;
    E2: TScrollBar;
    E3: TScrollBar;
    grButton: TButton;
    StoreButton: TButton;
    BildSaveDialog: TSaveDialog;
    CSaveDialog: TSaveDialog;
    CButton: TButton;
    procedure LadeButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure IconSelComboChange(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure TheImageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure grButtonClick(Sender: TObject);
    procedure ScrollBarsChange(Sender: TObject);
    procedure StoreButtonClick(Sender: TObject);
    procedure CButtonClick(Sender: TObject);
  private
    { Private declarations }
    Urname  : String;
    Incname : String;
    UrBmp   : TBitmap;
    ArbBmp  : TBitmap;
    ZielBmp : TBitmap;
    Pit   : PIconTafel;
    procedure LoadPicture(Name: String);
    procedure KonvertiereBild;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;
  Buf : array[0..$7FFFF] of byte;

implementation

{$R *.dfm}

procedure TMainForm.LadeButtonClick(Sender: TObject);
begin
  if OpenDialog.Execute
  then  LoadPicture(OpenDialog.FileName);
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Gdip := TGDIPlusFull.Create('gdiplus.dll');
  Pit  := nil;
  UrBmp:= nil;
  Urname:= 'nofile';
  Incname:= 'mypicture';
  ZielBmp:= TBitmap.Create;
  ArbBmp := TBitmap.Create;
  ConvPanel.Visible:= false;
end;

procedure TMainForm.LoadPicture(Name: String);
var
  F : File;
  L : longint;
  Pic  : PIconHeader;
  i,
  numicons : integer;
  raspect,
  aspect: single;
  R : TRect;
  S : String;
begin
  IconSelCombo.Clear;
  IconSelBox.Visible:= false;
  ArbBmp.Width:= 128;
  ArbBmp.Height:= 160;
  UrName:= Name;
  S:= ExtractFileName(Name);
  i:= pos('.',S);
  if i<>0 then S:= copy(S,1,i-1);
  Incname:= S;

  if Uppercase(ExtractFileExt(Name)) = '.ICO'
  then
  begin
  { ---------------- Icon laden ------------------------- }
    IconSelBox.Visible:= true;
    fillchar(Buf, sizeof(Buf),0);
    assignfile(F,Name);
    reset(F,1);
    L:= FileSize(F);
    if L > sizeof(Buf)
    then begin
           closefile(F);
           beep;
           exit;
         end;
    blockread(F,Buf,L);
    closefile(F);
    Pic:= @Buf;
    numicons:= Pic^.idCount;
    if numicons < 1 then begin beep; exit; end;

    UrBmp:= TBitmap.Create;
    i:= 0;
    while i < numicons do
    begin
      Pit:= @Buf[sizeof(TIconHeader)];
      S:= IntToStr(Pit^[i].bWidth)+'x'+IntToStr(Pit^[i].bHeight)+
          ' colors ' + IntToStr(Pit^[i].wBitCount) + ' bit';
      IconSelCombo.AddItem(S,nil);
      IconSelCombo.ItemIndex:= i;
      inc(i);
    end;
    Caption:= Name+' '+S;
    Bilderrrahmen.Caption:= ExtractFileName(Name)+' '+S;
    IconSelComboChange(self);
    exit;
  end
  else
  begin
  { ---------------- Bild laden ------------------------- }
    UrBmp:= LoadFrom(Name);
  end;
  S:= IntToStr(UrBmp.Width) + 'x' + IntToStr(UrBmp.Height);
  aspect:= UrBmp.Width / UrBmp.Height;
  with TheImage.Canvas do
  begin
    R.Left:= 0;
    R.Top:= 0;
    R.Right:= Width;
    R.Bottom:= Height;
    raspect:= R.Right / R.Bottom;
    if raspect > aspect
    then R.Right:= round(R.Bottom * aspect)
    else R.Bottom:= round(R.Right / aspect);
  end;

  if (UrBmp.Width <=128) and (UrBmp.Height <= 160)
  then begin
         ArbBmp.Width:= UrBmp.Width;
         ArbBmp.Height:= UrBmp.Height;
       end
  else
  begin
    ArbBmp.Width:= 128;
    ArbBmp.Height:= 160;
    aspect:= UrBmp.Width / UrBmp.Height;
    with ArbBmp do
    begin
      raspect:= round(Width/Height);
      if raspect > aspect
      then Width:= round(Height * aspect)
      else Height:= round(Width / aspect);
    end;
  end;

  TheImage.Picture.Assign(UrBmp);
  ArbBmp.Canvas.StretchDraw(ArbBmp.Canvas.ClipRect,UrBmp);

  Bilderrrahmen.Caption:= Name+' '+S;
end;




procedure TMainForm.IconSelComboChange(Sender: TObject);
var
  S : String;
  E : TIconDirEntry;
  i, j,
  x, y : integer;
  R,G,B,
  L,M,Q : longint;
  PAL : array[0..255] of longint;
  aspect,
  raspect : single;
begin
  if IconSelCombo.ItemIndex < 0 then exit;
  E:= Pit^[IconSelCombo.ItemIndex];
  S:= 'Size: ' + IntToStr(E.bWidth) + 'x' + IntToStr(E.bHeight) +
      ' ab Buf['+IntToStr(E.dwImageOffset)+
      '] Colors: ' + IntToStr(E.bColorCount) +
      ' res ' + IntToStr(E.bReserved) +
      ' Planes: ' + IntToStr(E.wPlanes) +
      ' Bitcnt: ' + IntToStr(E.wBitCount) +
      ' len= ' + IntToStr(E.dwBytesInRes);
      ;
  Stabar.Panels[2].Text:= S;

  UrBmp.Width:= E.bWidth;
  UrBmp.Height:= E.bHeight;
  L:= E.dwImageOffset;

  if E.wBitCount = 32
  then
  begin
    { Maske aufsetzen }
    M:= L + 40 + E.bWidth*E.bHeight*4;
    for y:= E.bHeight-1 downto 0 do
      begin
      for x:= 0 to E.bWidth-1 do
      begin
        i:= x shr 3;
        Q:= Buf[M+i] and (128 shr (x and 7));
        if Q  <> 0
        then Q:= 1;
        UrBmp.Canvas.Pixels[x,y]:= Q;
      end;
      j:= (E.bWidth+7) shr 3;
      j:= (j + 3) shr 2;
      inc(M, j*4);
      end;

    inc(L,40);
     for y:= E.bHeight-1 downto 0 do
      for x:= 0 to E.bWidth-1 do
      begin
        B:= Buf[L]; inc(L);
        G:= Buf[L]; inc(L);
        R:= Buf[L]; inc(L);
        Q:= R or (G shl 8) or (B shl 16);
        inc(L);
        M:= UrBmp.Canvas.Pixels[x,y];
        if M <>0  then Q:= $00FFFFFF;
        UrBmp.Canvas.Pixels[x,y]:= Q;
      end;
  end;

  if E.wBitCount <= 8
  then
  begin
      { Maske aufsetzen }
    M:= L + 40 + E.bWidth*E.bHeight + 4*256;;
    for y:= E.bHeight-1 downto 0 do
      begin
      for x:= 0 to E.bWidth-1 do
      begin
        i:= x shr 3;
        Q:= Buf[M+i] and (128 shr (x and 7));
        if Q  <> 0
        then Q:= 1;
        UrBmp.Canvas.Pixels[x,y]:= Q;
      end;
      j:= (E.bWidth+7) shr 3;
      j:= (j + 3) shr 2;
      inc(M, j*4);
      end;

    inc(L,40);
    for i:= 0 to 255 do
    begin
      B:= Buf[L]; inc(L);
      G:= Buf[L]; inc(L);
      R:= Buf[L]; inc(L); inc(L);
      PAL[i]:= R or (G shl 8) or (B shl 16);
    end;

    for y:= E.bHeight-1 downto 0 do
      for x:= 0 to E.bWidth-1 do
      begin
        Q:= PAL[Buf[L]]; inc(L);
        M:= UrBmp.Canvas.Pixels[x,y];
        if M <>0  then Q:= $00FFFFFF;
        UrBmp.Canvas.Pixels[x,y]:= Q;
      end;
  end;
  TheImage.Picture.Assign(UrBmp);

  if (UrBmp.Width <=128) and (UrBmp.Height <= 160)
  then begin
         ArbBmp.Width:= UrBmp.Width;
         ArbBmp.Height:= UrBmp.Height;
       end
  else
  begin
    ArbBmp.Width:= 128;
    ArbBmp.Height:= 160;
    aspect:= UrBmp.Width / UrBmp.Height;
    with ArbBmp do
    begin
      raspect:= round(Width/Height);
      if raspect > aspect
      then Width:= round(Height * aspect)
      else Height:= round(Width / aspect);
    end;
  end;
  ArbBmp.Canvas.StretchDraw(ArbBmp.Canvas.ClipRect,UrBmp);
  KonvertiereBild;
end;

procedure TMainForm.Edit1Change(Sender: TObject);
begin
  IconSelComboChange(self);
end;

procedure TMainForm.TheImageMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
var
  f : single;
  XX,YY : integer;
  Color : dword;
  S : String;
begin
  if UrBmp = nil then exit;
  f:= UrBmp.Width;
  f:= f / TheImage.Width;
  XX:= round(X*f);
  YY:= round(Y*f);

  Color:= UrBmp.Canvas.Pixels[XX,YY];

  S:= IntToStr(X)+'/'+IntToStr(Y)+
      ' R:'+IntToStr(Color and 255)+' G:'+IntToStr((Color shr 8) and 255)+
      ' B:'+IntToStr((Color shr 16) and 255);
  Stabar.Panels[0].Text:= S;
end;


procedure TMainForm.KonvertiereBild;
var
  x, y : integer;
  Co   : longint;
  R,B,G : dword;
begin
  ZielBmp.Width:=  ArbBmp.Width;
  ZielBmp.Height:= ArbBmp.Height;
  for y:= 0 to ZielBmp.Height-1 do
    for x:= 0 to ZielBmp.Width do
    begin
      Co:= ArbBmp.Canvas.Pixels[x,y];
      R:= Co and $FF;
      G:= (Co shr 8) and $FF;
      B:= (Co shr 16) and $FF;

      Co:= (R+B+G) div 3;
      if Co > (255 - E1.Position)
      then Co:= 255
        else
        if Co > (255 - E2.Position)
        then Co:= 170
          else
          if Co > (255 - E3.Position)
          then Co:= 85
          else Co:= 0;

      R:= Co; G:= Co; B:= Co;




      Co:= R or (G shl 8) or (B shl 16);
      ZielBmp.Canvas.Pixels[x,y]:= Co;
    end;
  ZielImage.Picture.Assign(ZielBmp);
end;

procedure TMainForm.grButtonClick(Sender: TObject);
begin
  ConvPanel.Visible:= true;
  if UrBmp <> nil then KonvertiereBild;
end;

procedure TMainForm.ScrollBarsChange(Sender: TObject);
begin
  KonvertiereBild;
end;

procedure TMainForm.StoreButtonClick(Sender: TObject);
begin
  if BildSaveDialog.Execute
  then  ZielBmp.SaveToFile(BildSaveDialog.FileName);
end;

procedure TMainForm.CButtonClick(Sender: TObject);
const
  Tafel : array[0..3] of char = ('.','+','o','M');
var
  T : TextFile;
  i, j,
  x, y : integer;
  B : word;
  bc: integer;
  S : String;
begin
  if Incname<>''
  then CSaveDialog.FileName:= Incname+'.inc';
  if CSaveDialog.Execute
  then
  begin
    assignfile(T,CSaveDialog.FileName);
    rewrite(T);
    S:= ExtractFileName(CSaveDialog.FileName);
    writeln(T,'/*  Picture from ', UrName, '  */');
    i:= pos('.',S);
    if i<>0 then S:= copy(S,1,i-1);
    writeln(T,'const char ', S, '[] = '#13#10'{ ');
    writeln(T,ZielBmp.Width:4,',  ', ZielBmp.Height:4,',  /* dx, dy */');

    B:= 0;
    bc:= 0;
    S:= '/*';

    for y:= 0 to ZielBmp.Height-1 do
      begin
        S:= S + #13#10;
        write(T,#13#10'/* Y ',y:3,' */');
        for x:= 0 to ZielBmp.Width-1 do
        begin
          j:= ZielBmp.Canvas.Pixels[x,y] and $FF;
          case j of
          255: i:= 0;
          170: i:= 1;
           85: i:= 2;
          else i:= 3;
          end;
          B:= B or (i shl bc);
          inc(bc,2);
          if bc >= 8
          then begin
                 write(T, B:3,', ');
                 bc:= 0;
                 B:= 0;
               end;
          S:= S + Tafel[i];
        end;
      end;

    writeln(T,#13#10' };',#13#10, S, #13#10'*/ '#13#10);
    closefile(T);
  end;
end;

end.
