; ##############################################################################
; ##############################################################################
; ##############################################################################
; Berechnung der Temperatur mit 0,5 GRD GENAUIGKEIT								
;																				
; +85.0C ===> 0x00AA															
; +25.0C ===> 0x0032															
;  +0.5C ===> 0x0001															
;     0C ===> 0x0000															
;  -0.5C ===> 0xFFFF															
; -25.0C ===> 0xFFCE															
; -55.0C ===> 0xFF92															
;																				
; inp: SRAM (adr_SCRATCHPAD_CRC_BEREICH)										
; OUT: temp1+2																	
;																				
TEMPERATURBERECHNUNG_VARIANTE_9BIT:
	; aus SRAM laden		
	LDS temp1,(adr_OW_SCRATCHPAD_BEREICH9+0)	; aus SRAM laden	
	LDS temp2,(adr_OW_SCRATCHPAD_BEREICH9+1)
;----------------------------------------------------------------------------------
	; TESTZAHLEN (-0,5)		
	;ldi temp1, low (0xFFFF)	
	;ldi temp2, HIGH(0xFFFF)
	; TESTZAHLEN (-25)		
	;ldi temp1, low (0xFFCE)	
	;ldi temp2, HIGH(0xFFCE)
	; TESTZAHLEN (+25)		
	;ldi temp1, low (0x0032)	
	;ldi temp2, HIGH(0x0032)
;----------------------------------------------------------------------------------
	mov R0,temp1
	mov R1,temp2
	add temp1,R0
	adc temp2,R1
	add temp1,R0
	adc temp2,R1
	add temp1,R0
	adc temp2,R1
	add temp1,R0
	adc temp2,R1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Berechnung der Temperatur mit 0,1 GRD GENAUIGKEIT								
;																				
; +125      C ===> 0x07D0														
;  +85      C*===> 0x0550														
;  +25.0625 C ===> 0x0191														
;  +10.125  C ===> 0x00A2														
;   +0.5    C ===> 0x0008														
;    0      C ===> 0x0000														
;   -0.5    C ===> 0xFFF8														
;  -10.125  C ===> 0xFF5E														
;  -25.0625 C ===> 0xFE6F														
;  -55      C ===> 0xFC90														
;																				
; inp: SRAM (adr_SCRATCHPAD_CRC_BEREICH)										
; OUT: temp1+2																	
;																				
TEMPERATURBERECHNUNG_VARIANTE_12BIT:
	; aus SRAM laden		
	LDS temp1,(adr_OW_SCRATCHPAD_BEREICH9+0)	; aus SRAM laden	
	LDS temp2,(adr_OW_SCRATCHPAD_BEREICH9+1)
;----------------------------------------------------------------------------------
	; TESTZAHLEN (+125)		
	;ldi temp1, low (0x07D0)	
	;ldi temp2, HIGH(0x07D0)
	; TESTZAHLEN (+85)		
	;ldi temp1, low (0x0550)	
	;ldi temp2, HIGH(0x0550)
	; TESTZAHLEN (+0,5)		
	;ldi temp1, low (0x0008)	
	;ldi temp2, HIGH(0x0008)
	; TESTZAHLEN (-0,5)		
	;ldi temp1, low (0xFFF8)	
	;ldi temp2, HIGH(0xFFF8)
	; TESTZAHLEN (-10.125)		
	;ldi temp1, low (0xFF5E)	
	;ldi temp2, HIGH(0xFF5E)
;-------------------------------------------------------------------------------
	; mal 5 (4 mal addieren)			
	mov temp3,temp1
	mov temp4,temp2
	add temp1,temp3	; x2
	adc temp2,temp4
	add temp1,temp3	; x3
	adc temp2,temp4
	add temp1,temp3	; x4
	adc temp2,temp4
	add temp1,temp3	; x5
	adc temp2,temp4
	; aufrunden+4				
	subi temp1,LOW (-4)	
	sbci temp2,HIGH(-4)
	; : 8 (mit 3x Arithmetisch rechts)
	ASR temp2			; :2 (:2)	
	ROR temp1
	ASR temp2			; :2 (:4)	
	ROR temp1
	ASR temp2			; :2 (:8)	
	ROR temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
