; 1wire SNIFFER 								
; OLED 4x20										
;												
; ATmega8 4 MHz									
;												
; Bernhard.Erfurt@gmx.de						
; 03/2017										
;												
;												
; LED grn = DATA								
; LED gelb = 1wire Aktivitt					
; LED rot  = ERROR								

; ATmega8 										
.include "m8def.inc"
; ERROR-CODES									
.equ ERROR_CRC_ROM_ID				=0xC0
.equ ERROR_CRC_SCRATCHPAD			=0xC1
; EEPROM										
.equ EEPROM_KENNUNG_WERKSEINSTELLUNG= 'X'
.equ EEPROM_ANZAHL_BYTES			= 20
; ANZAHL SLAVES MAX								
.equ ANZAHL_SLAVES_MAX				= 60
; TASTENBELEGUNG								
.equ TASTE_MENUE_PLUS				= 2
.equ TASTE_MENUE_MINUS				= 4
.equ TASTE_PLUS						= 8
.equ TASTE_MINUS					= 16
; 1-WIRE-ROM-ID									
.equ ROM_ID_BYTE0		= 0x28	;FAMILY				
.equ ROM_ID_BYTE1		= 0xD3
.equ ROM_ID_BYTE2		= 0x5B
.equ ROM_ID_BYTE3		= 0xDE
.equ ROM_ID_BYTE4		= 0x01
.equ ROM_ID_BYTE5		= 0x00
.equ ROM_ID_BYTE6		= 0x00
.equ ROM_ID_BYTE7		= 0x00	; D9 CRC-DUMMY (wird automatisch korrigiert)	
; 1-WIRE-ROM-COMMANDS							
.equ OW_COMMAND_SKIP_ROM		=0xCC
.equ OW_COMMAND_MATCH_ROM		=0x55
.equ OW_COMMAND_ROM_READ		=0x33
.equ OW_COMMAND_SEARCH_ROM		=0xF0
; 1-WIRE-FUNCTION-COMMANDS						
.equ OW_FUNCTION_CONVERT_T		=0x44		;CONVERT "T" DS19s20	
.equ OW_FUNCTION_TX_PRIVATE_DATA=0xF6
.equ OW_FUNCTION_READ_SCRATCHPAD=0xBE		; read  DS18s20	
.equ OW_FUNCTION_RECALL_EE		=0xB8
; 1-WIRE-DATENBUS								
.equ OW_PIN_NR				= 2
.equ OW_DDR					= DDRD
.equ OW_PORT				= PORTD
.equ OW_PIN					= PIND
; LED-GRUEN										
.equ LED_GRUEN_PIN_NR		= 5
.equ LED_GRUEN_DDR			= DDRD
.equ LED_GRUEN_PORT			= PORTD
; LED-GELB										
.equ LED_GELB_PIN_NR		= 6
.equ LED_GELB_DDR			= DDRD
.equ LED_GELB_PORT			= PORTD
; LED-ROT										
.equ LED_ROT_PIN_NR			= 7
.equ LED_ROT_DDR			= DDRD
.equ LED_ROT_PORT			= PORTD
; LED-TASTEN									
.equ LED_TASTEN_PIN_NR		= 0
.equ LED_TASTEN_DDR			= DDRD
.equ LED_TASTEN_PORT		= PORTD
; LCD_POWER										
.equ LCD_POWER_DDR			= DDRC
.equ LCD_POWER_PORT			= PORTC
.equ LCD_POWER_PIN_NR		= 1
; LCD (DATA)									
.equ LCD_DATA0_DDR			= DDRB
.equ LCD_DATA1_DDR			= DDRB
.equ LCD_DATA2_DDR			= DDRB
.equ LCD_DATA3_DDR			= DDRB
.equ LCD_DATA0_PORT			= PORTB
.equ LCD_DATA1_PORT			= PORTB
.equ LCD_DATA2_PORT			= PORTB
.equ LCD_DATA3_PORT			= PORTB
.equ LCD_DATA0				= 0
.equ LCD_DATA1				= 1
.equ LCD_DATA2				= 2
.equ LCD_DATA3				= 3
; LCD RS (Befehl/DATEN)							
.equ LCD_RS_DDR				= DDRB
.equ LCD_RS_PORT			= PORTB
.equ LCD_RS					= 4
; LCD_ENABLE									
.equ LCD_EN_DDR				= DDRB
.equ LCD_EN_PORT			= PORTB
.equ LCD_EN					= 5
; TASTE-A										
.equ TASTE_A_PIN_NR					= 2
.equ TASTE_A_DDR					= DDRC
.equ TASTE_A_PORT					= PORTC
.equ TASTE_A_PIN					= PINC
; TASTE-B										
.equ TASTE_B_PIN_NR					= 3
.equ TASTE_B_DDR					= DDRC
.equ TASTE_B_PORT					= PORTC
.equ TASTE_B_PIN					= PINC
; TASTE-C										
.equ TASTE_C_PIN_NR					= 4
.equ TASTE_C_DDR					= DDRC
.equ TASTE_C_PORT					= PORTC
.equ TASTE_C_PIN					= PINC
; TASTE-D										
.equ TASTE_D_PIN_NR					= 5
.equ TASTE_D_DDR					= DDRC
.equ TASTE_D_PORT					= PORTC
.equ TASTE_D_PIN					= PINC
; REGISTER										

.def KOPIE_SREG			= R5
.def KOPIE_TEMP			= R6
.def KOPIE_TEMP1		= R7
.def KOPIE_ZL			= R8
.def KOPIE_ZH			= R9


.def OW_RX_BIT_ZAEHLER	= R11	; fr RX_BYTE			
.def OW_RX_BYTE			= R12	; empfangenes RX BYTE	

.def NULL 				= R13
.def EINS 				= R14
.def VOLL				= R15

.def temp 				= R16
.def temp1 				= R17
.def temp2 				= R18
.def temp3 				= R19
.def temp4 				= R20
.def temp5 				= R21
.def temp6 				= R22
.def temp7 				= R23
.def temp8 				= R24
.def temp9 				= R25
; SRAM-BELEGUNG ATmega8							
.equ adr_DATEN							=SRAM_START			; 0x0060 START Adresse 		
.equ adr_WERKSEINSTELLUNG				=SRAM_START+0
.equ adr_MELDUNG_OFF					=SRAM_START+1
.equ adr_OW_ROM_ID_BEREICH8				=SRAM_START+10		; (8 BYTE) ROM-ID (SNIFFER)

.equ adr_TASTE							=SRAM_START+20
.equ adr_MENUE							=SRAM_START+21
.equ adr_MENUE_OFFSET					=SRAM_START+22
.equ adr_ERROR_CODE						=SRAM_START+23
.equ adr_OW_ZAEHLER_RP_L				=SRAM_START+24		; fr Wartungszwecke (ZAEHLERWERTE)	
.equ adr_OW_ZAEHLER_RP_H				=SRAM_START+25		; fr Wartungszwecke (ZAEHLERWERTE)	
.equ adr_OW_BYTE_ZAEHLER				=SRAM_START+26
.equ adr_OW_ANZAHL_SLAVES				=SRAM_START+27
.equ adr_OW_HIST_ROM_OLD				=SRAM_START+28		;
.equ adr_OW_HIST_ROM_COUNTER			=SRAM_START+29		;
.equ adr_OW_HIST_ROM_BEREICH			=SRAM_START+30		; Historie ROM-Command 6*3=18 Bytes	
.equ adr_OW_SCRATCHPAD_BEREICH9			=SRAM_START+60		; (9 BYTE) SCRATCHPAD  	

.equ adr_OW_RX_DATA256					=SRAM_START+100		; 1wire RX DATA			

.equ adr_ROM_LISTE						=SRAM_START+400		;60*8=480				

.equ adr_SRAM_CHECK						=SRAM_START+943		; SRAM CHECK muss immer "S" sein

.cseg					;Beginn eines Code-Segmentes
.org 0					;Startadresse=0				

rjmp RESET      		; Reset Handler                           				
rjmp EXT_INT0   		; IRQ0 Handler  										
rjmp INTERRUPT_ERROR	;rjmp EXT_INT1   ; IRQ1 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp TIM2_COMP  ; Timer2 Compare Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM2_OVF   ; Timer2 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_CAPT  ; Timer1 Capture Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPA ; Timer1 CompareA Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPB ; Timer1 CompareB Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_OVF   ; Timer1 Overflow Handler           	
rjmp INTERRUPT_ERROR	;TIM0_OVF   		; Timer0 Overflow Handler           
rjmp INTERRUPT_ERROR	;rjmp SPI_STC    ; SPI Transfer Complete Handler     	
rjmp INTERRUPT_ERROR	; USART RX Complete Handler         					
rjmp INTERRUPT_ERROR	;rjmp USART_UDRE ; UDR Empty Handler                 	
rjmp INTERRUPT_ERROR	;rjmp USART_TXC  ; USART TX Complete Handler         	
rjmp INTERRUPT_ERROR	;rjmp ADC        ; ADC Conversion Complete Handler   	
rjmp INTERRUPT_ERROR	;rjmp EE_RDY     ; EEPROM Ready Handler              	
rjmp INTERRUPT_ERROR	;rjmp ANA_COMP   ; Analog Comparator Handler         	
rjmp INTERRUPT_ERROR	;rjmp TWSI      ; Two-wire Serial Interface Handler 	
rjmp INTERRUPT_ERROR	;rjmp SPM_RDY    ; Store Program Memory Ready Handler	


; Bei unkorrekten Interrupt aufrufen erfolgt ein RESET ber WDR	
INTERRUPT_ERROR:
	rjmp INTERRUPT_ERROR
RESET:                        
; STACK initialisieren								
	ldi temp, LOW(RAMEND)
    out SPL, temp
    ldi temp, HIGH(RAMEND)
    out SPH, temp
; SRAM_CLEAR										
	rcall SRAM_CLEAR
; PORT_CLEAR										
	rcall PORT_CLEAR
; REGISTER_CLEAR									
	rcall REGISTER_CLEAR
; LED_INITIALISIERUNG								
	rcall LED_INITIALISIERUNG
; WDR_INITIALISIEREN								
	rcall WDR_INITIALISIEREN
; NEUSTART_MIT_WDR									
	rcall NEUSTART_MIT_WDR
; LED_TEST											
	rcall LED_TEST
; STARTWERTE										
	; NULL				
	clr NULL
	; EINS				
	ldi temp,1
	mov EINS,temp
	; VOLL				
	ldi temp,255
	mov VOLL,temp
	; SRAM CHECK		
	ldi temp,'S'
	STS(adr_SRAM_CHECK),temp
; TASTEN_INITIALISIERUNG							
	rcall TASTEN_INITIALISIERUNG
; OLED_INITIALISIERUNG								
	rcall OLED_INITIALISIERUNG
; 1-WIRE											
	rcall OW_INITIALISIERUNG
	rcall EXTERNER_INTERUPT_INITIALISIEREN
	rcall EXTERNER_INTERRUPT_AKTIVIEREN
; EEPROM											
	rcall EEPROM_KONFIGURATION_LADEN
	rcall ONE_WIRE_ROM_CRC_CHECK		; wichtig !	
	rcall PROGRAMM_CHECK
; ------------------------------------------------------------------------------
	out GIFR,VOLL	; eventuelle Pegelwechsel ignorieren	
	sei 			; interrupts freigeben
; ------------------------------------------------------------------------------
	rcall LCD_CLEAR
	rcall ANZEIGE_BEGRUESSUNG
	rcall WAIT_1s
	rcall LCD_CLEAR
	STS(adr_MENUE),NULL
	rcall MENUE
; ##############################################################################
; ##############################################################################
; ##############################################################################
LOOP:
	WDR
	rcall TASTEN_ABFRAGE
	rcall MENUE
	rcall ANZEIGE_ERROR
	rcall TASTEN_WAIT
	rcall PROGRAMM_CHECK

	LDS temp,(adr_OW_BYTE_ZAEHLER)
	cpi temp,19
	brlo LOOP
	STS(adr_OW_BYTE_ZAEHLER),NULL
	rcall AUSWERTUNG
rjmp LOOP
; ##############################################################################
; ##############################################################################
; ##############################################################################
; BYRE-0: MATCH-ROM	
; BYRE-1: ROM-ID-0	
; BYRE-2: ROM-ID-1	
; BYRE-3: ROM-ID-2	
; BYRE-4: ROM-ID-3	
; BYRE-5: ROM-ID-4	
; BYRE-6: ROM-ID-5	
; BYRE-7: ROM-ID-6	
; BYRE-8: ROM-ID-7	
; BYRE-9: SCRATCHPAD read 
; BYRE-10: SCRATCHPAD-0
; BYRE-11: SCRATCHPAD-1
; BYRE-12: SCRATCHPAD-2
; BYRE-13: SCRATCHPAD-3
; BYRE-14: SCRATCHPAD-4
; BYRE-15: SCRATCHPAD-5
; BYRE-16: SCRATCHPAD-6
; BYRE-17: SCRATCHPAD-7
; BYRE-18: SCRATCHPAD-8
AUSWERTUNG:
	CLC 									; Clear Carry	
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN aus		
	LDS temp,(adr_OW_RX_DATA256+0)	; BYRE-0: MATCH-ROM	
	cpi temp,(OW_COMMAND_MATCH_ROM)
	breq AUSWERTUNG_MATCH_ROM_FERTIG
	ret
AUSWERTUNG_MATCH_ROM_FERTIG:
;-------------------------------------------------------------------------------
 	ldi ZL,low (adr_OW_RX_DATA256+1)
    ldi ZH,high(adr_OW_RX_DATA256+1) 
	rcall ONE_WIRE_ROM_Z_CRC7
	brcs AUSWERTUNG_ROM_CRC_FERTIG
	ret
AUSWERTUNG_ROM_CRC_FERTIG:
;-------------------------------------------------------------------------------
	rcall ROM_LISTE_EINTRAG

	LDS temp,(adr_OW_RX_DATA256+1); BYRE-1: ROM-ID-0	
	LDS temp1,(adr_OW_ROM_ID_BEREICH8+0)
	cp temp,temp1
	breq AUSWERTUNG_w2
	ret
AUSWERTUNG_w2:
	LDS temp,(adr_OW_RX_DATA256+2); BYRE-2: ROM-ID-1	
	LDS temp1,(adr_OW_ROM_ID_BEREICH8+1)
	cp temp,temp1
	breq AUSWERTUNG_w3
	ret
AUSWERTUNG_w3:
	LDS temp,(adr_OW_RX_DATA256+3); BYRE-3: ROM-ID-2	
	LDS temp1,(adr_OW_ROM_ID_BEREICH8+2)
	cp temp,temp1
	breq AUSWERTUNG_w4
	ret
AUSWERTUNG_w4:
	LDS temp,(adr_OW_RX_DATA256+4); BYRE-4: ROM-ID-3	
	LDS temp1,(adr_OW_ROM_ID_BEREICH8+3)
	cp temp,temp1
	breq AUSWERTUNG_w5
	ret
AUSWERTUNG_w5:
	LDS temp,(adr_OW_RX_DATA256+5); BYRE-5: ROM-ID-4	
	LDS temp1,(adr_OW_ROM_ID_BEREICH8+4)
	cp temp,temp1
	breq AUSWERTUNG_w6
	ret
AUSWERTUNG_w6:
	LDS temp,(adr_OW_RX_DATA256+6); BYRE-6: ROM-ID-5	
	LDS temp1,(adr_OW_ROM_ID_BEREICH8+5)
	cp temp,temp1
	breq AUSWERTUNG_w7
	ret
AUSWERTUNG_w7:
	LDS temp,(adr_OW_RX_DATA256+7); BYRE-7: ROM-ID-6	
	LDS temp1,(adr_OW_ROM_ID_BEREICH8+6)
	cp temp,temp1
	breq AUSWERTUNG_w8
	ret
AUSWERTUNG_w8:
	LDS temp,(adr_OW_RX_DATA256+8); BYRE-8: ROM-ID-7	
	LDS temp1,(adr_OW_ROM_ID_BEREICH8+7)
	cp temp,temp1
	breq AUSWERTUNG_w9
	ret
AUSWERTUNG_w9:
	LDS temp,(adr_OW_RX_DATA256+9); BYRE-9: SCRATCHPAD read 
	cpi temp,(OW_FUNCTION_READ_SCRATCHPAD)
	breq AUSWERTUNG_KOPIE
	ret
AUSWERTUNG_KOPIE:
;-------------------------------------------------------------------------------
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN an	
	LDS temp,(adr_OW_RX_DATA256+10); BYRE-10: SCRATCHPAD-0
	STS(adr_OW_SCRATCHPAD_BEREICH9+0),temp
	LDS temp,(adr_OW_RX_DATA256+11); BYRE-11: SCRATCHPAD-1
	STS(adr_OW_SCRATCHPAD_BEREICH9+1),temp
	LDS temp,(adr_OW_RX_DATA256+12); BYRE-12: SCRATCHPAD-2
	STS(adr_OW_SCRATCHPAD_BEREICH9+2),temp
	LDS temp,(adr_OW_RX_DATA256+13); BYRE-13: SCRATCHPAD-3
	STS(adr_OW_SCRATCHPAD_BEREICH9+3),temp
	LDS temp,(adr_OW_RX_DATA256+14); BYRE-14: SCRATCHPAD-4
	STS(adr_OW_SCRATCHPAD_BEREICH9+4),temp
	LDS temp,(adr_OW_RX_DATA256+15); BYRE-15: SCRATCHPAD-5
	STS(adr_OW_SCRATCHPAD_BEREICH9+5),temp
	LDS temp,(adr_OW_RX_DATA256+16); BYRE-16: SCRATCHPAD-6
	STS(adr_OW_SCRATCHPAD_BEREICH9+6),temp
	LDS temp,(adr_OW_RX_DATA256+17); BYRE-17: SCRATCHPAD-7
	STS(adr_OW_SCRATCHPAD_BEREICH9+7),temp
	LDS temp,(adr_OW_RX_DATA256+18); BYRE-18: SCRATCHPAD-8
	STS(adr_OW_SCRATCHPAD_BEREICH9+8),temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
.include "OW_SNIFFER_SONSTIGES.asm"
.include "OW_SNIFFER_WAIT.asm"
.include "OW_SNIFFER_EXT_INTERRUPT.asm"
.include "OW_SNIFFER_OW.asm"
.include "OW_SNIFFER_LCD_ini.asm"
.include "OW_SNIFFER_LCD.asm"
.include "OW_SNIFFER_MENUE.asm"
.include "OW_SNIFFER_BERECHNUNGEN.asm"
.include "OW_SNIFFER_EEPROM.asm"
; ##############################################################################
; ##############################################################################
; ##############################################################################
; TEXTE																			
TEXT_BEGRUESSUNG_1:
.db "1-WIRE Sniffer ",0
TEXT_BEGRUESSUNG_2:
.db "ATmega8 4MHz ",0
TEXT_BEGRUESSUNG_3:
.db "OLED 20x4",0
TEXT_BEGRUESSUNG_4:
.db "03/2017",0
