; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; LCD 2x16 4x16 4x20 ZEICHEN													
;																				
; LCD-INITIALISIERUNG															
LCD_INITIALISIERUNG:
	; auf LOW				
	cbi (LCD_DATA0_PORT),(LCD_DATA0)
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	cbi (LCD_EN_PORT),(LCD_EN)
	cbi (LCD_RS_PORT),(LCD_RS)
	; auf Ausgang			
	sbi (LCD_DATA0_DDR),(LCD_DATA0)
	sbi (LCD_DATA1_DDR),(LCD_DATA1)
	sbi (LCD_DATA2_DDR),(LCD_DATA2)
	sbi (LCD_DATA3_DDR),(LCD_DATA3)
	sbi (LCD_RS_DDR),(LCD_RS)
	sbi (LCD_EN_DDR),(LCD_EN)
	; INITIALISIERUNG		
    cbi (LCD_RS_PORT),(LCD_RS)	; RS aus (low)				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)  	; x03 muss 3mal hintereinander gesendet werden zur Initialisierun
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	rcall LCD_ENABLE					; 1	
	rcall LCD_ENABLE					; 2	
	rcall LCD_ENABLE					; 3	
    ldi temp, 0b00000010        ;4bit-Modus einstellen		
 	rcall LCD_COMMAND_TEMP
    ldi temp, 0b00000001        ; DISPLAY lschen			
 	rcall LCD_COMMAND_TEMP
    ldi temp, 0b00001111        ; DISPLAY ein / CURSOR blinken
 	rcall LCD_COMMAND_TEMP
    ldi temp, 0b00000110        ; Cursor Auto-Increment		
 	rcall LCD_COMMAND_TEMP
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; LCD-INITIALISIERUNG															
OLED_INITIALISIERUNG:
	; auf LOW				
	cbi (LCD_DATA0_PORT),(LCD_DATA0)
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	cbi (LCD_EN_PORT),(LCD_EN)
	cbi (LCD_RS_PORT),(LCD_RS)
	; auf Ausgang			
	sbi (LCD_DATA0_DDR),(LCD_DATA0)
	sbi (LCD_DATA1_DDR),(LCD_DATA1)
	sbi (LCD_DATA2_DDR),(LCD_DATA2)
	sbi (LCD_DATA3_DDR),(LCD_DATA3)
	sbi (LCD_RS_DDR),(LCD_RS)
	sbi (LCD_EN_DDR),(LCD_EN)
	sbi (LCD_POWER_DDR),(LCD_POWER_PIN_NR)
	; HARDWARE-RESET		
	;cbi (LCD_POWER_PORT),(LCD_POWER_PIN_NR); ohne Transistor !
	sbi (LCD_POWER_PORT),(LCD_POWER_PIN_NR); mit Transistor  !
	rcall wait_100ms
	;sbi (LCD_POWER_PORT),(LCD_POWER_PIN_NR); ohne Transistor !
	cbi (LCD_POWER_PORT),(LCD_POWER_PIN_NR); mit Transistor  !
	rcall wait_100ms
;	send_nibble(0x03); //Be sure to	
;	send_nibble(0x03); //be in		
;	send_nibble(0x03); //8-Bit-Mode	
	; INITIALISIERUNG		
    cbi (LCD_RS_PORT),(LCD_RS) 			; RS aus/COMMAND (low)				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)  	; x03 muss 3mal hintereinander gesendet werden zur Initialisierun
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	rcall LCD_ENABLE					; 1	
	rcall wait_1ms
	rcall LCD_ENABLE					; 2	
	rcall wait_1ms
	rcall LCD_ENABLE					; 3	
	rcall wait_1ms
;	send_nibble(0x02); //Switch to 4 Bit										
	cbi (LCD_DATA0_PORT),(LCD_DATA0)
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
	rcall LCD_ENABLE
	rcall wait_1ms
;	WriteIns(0x28);//4-Bit-Mode													
    ldi temp, 0x28
 	rcall LCD_COMMAND_TEMP
;	WriteIns(0x17);//Character mode and internel power on						
    ldi temp, (0x17)
 	rcall LCD_COMMAND_TEMP
;	WriteIns(0x06);//entry mode set increment cursor by 1 not shifting display	
    ldi temp, 0x06
 	rcall LCD_COMMAND_TEMP
;	WriteIns(0x0C); //display on												
    ldi temp, (0x0C)
 	rcall LCD_COMMAND_TEMP
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																		  		
;erzeugt den Enable-Puls												  		
;																		  		
LCD_ENABLE:
	sbi (LCD_EN_PORT),(LCD_EN) 		   	; Enable high		
 	rcall wait_10us            		  	; kurze PAUSE		
	cbi (LCD_EN_PORT),(LCD_EN)     	  	; Enable low		
	rjmp wait_50us            		 	; kurze PAUSE		
; ##############################################################################
; ##############################################################################
; ##############################################################################
; sendet ein Datenbyte an das LCD										  		
;																		  		
; INPUT: temp															  		
;																		  		
; rcall LCD_DATA			; DATENBYTE an LCD inp: temp 				  		
;																		  		
LCD_DATA_TEMP:
	sbi LCD_RS_PORT, LCD_RS 			; RS ein/auf DATA (high)				
LCD_DATA_RS:
	cbi (LCD_DATA0_PORT),(LCD_DATA0)	; alle auf LOW							
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	SBRC temp,4							; SPRUNG, wenn BIT clear				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)
	SBRC temp,5
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	SBRC temp,6
	sbi (LCD_DATA2_PORT),(LCD_DATA2)
	SBRC temp,7
	sbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	rcall lcd_enable        			; Enable-Routine aufrufen				
;-------------------------------------------------------------------------------
	cbi (LCD_DATA0_PORT),(LCD_DATA0)	; auf LOW								
	cbi (LCD_DATA1_PORT),(LCD_DATA1)
	cbi (LCD_DATA2_PORT),(LCD_DATA2)
	cbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	SBRC temp,0							; SPRUNG, wenn BIT clear				
	sbi (LCD_DATA0_PORT),(LCD_DATA0)
	SBRC temp,1
	sbi (LCD_DATA1_PORT),(LCD_DATA1)
	SBRC temp,2
	sbi (LCD_DATA2_PORT),(LCD_DATA2)
	SBRC temp,3
	sbi (LCD_DATA3_PORT),(LCD_DATA3)
;-------------------------------------------------------------------------------
	rcall lcd_enable        			; Enable-Routine aufrufen				
	rcall wait_10us						; Pause 								
	sbi LCD_RS_PORT, LCD_RS 			; vorsichtshalber RS ein/auf DATA (high)
ret				                       
; ##############################################################################
; ##############################################################################
; ##############################################################################
;sendet einen Befehl an das LCD;wie lcd_data, nur ohne RS zu setzen		  		
;																		  		
; INPUT: temp															  		
;																		  		
LCD_COMMAND_TEMP:                            
    cbi (LCD_RS_PORT),(LCD_RS) 			;	 RS aus (low)				
	rcall LCD_DATA_RS
	rjmp  wait_5ms						; Pause (wichtig)				
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Display lschen														  		
LCD_CLEAR:
   	ldi temp, 0b00000001
    rcall LCD_COMMAND_TEMP
	rjmp  LCD_ZEILE1
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR GO-HOME														  		
LCD_ZEILE1:
 	ldi temp, 0b00000010
	rjmp LCD_COMMAND_TEMP 
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR Sprung in ZEILE2												  		
LCD_ZEILE2:
 	ldi temp, 0b11000000 
	rjmp LCD_COMMAND_TEMP 
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR Sprung in ZEILE3														
LCD_ZEILE3:
	ldi temp, 0b10010100  	; LCD 4x20	
	;ldi temp, 0b10010000 	; LCD 4x16	
	rcall LCD_COMMAND_TEMP
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; KURSOR Sprung in ZEILE4												  		
LCD_ZEILE4:
	ldi temp, 0b11010100	; LCD 4x20	
	;ldi temp, 0b11010000 	; LCD 4x16	
	rjmp LCD_COMMAND_TEMP 
; ##############################################################################
; ##############################################################################
; ##############################################################################
; " -999,9 ... +999,9"															
ANZEIGE_TEMPERATUR_KOMMA_TEMP1_2:
;	ldi temp1,LOW (0)
;	ldi temp2,HIGH(0)
	tst temp2
	brpl ATK_p
	ldi temp,'-'			; VORZEICHEN	
	rcall LCD_DATA_TEMP	
	com temp1				; invertieren	
	com temp2
	add temp1,EINS
	adc temp2,NULL
	rjmp ATK_w
ATK_p:
	ldi temp,' '			; VORZEICHEN	
	rcall LCD_DATA_TEMP	
ATK_w:
	cpi temp2,HIGH(9999)
	brlo ATK_RUN
	breq ATK_L
	brsh ATK_ERROR
ATK_L:
	cpi temp1,LOW(9999)
	brlo ATK_RUN
	breq ATK_RUN
	brsh ATK_ERROR
;-------------------------------------------------------------------------------
ATK_ERROR:
	rcall LCD_MINUS2
	rcall LCD_MINUS2
	rcall LCD_MINUS2
ret
;-------------------------------------------------------------------------------
ATK_RUN:
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32
ATK_4:
	cpi temp4,'0'
	breq ATK_3
	mov temp, temp4			; 4.
	rcall LCD_DATA_TEMP	
	mov temp, temp3			; 3.
	rcall LCD_DATA_TEMP	
	mov temp, temp2			; 2.
	rcall LCD_DATA_TEMP	
	rcall LCD_PUNKT			; PUNKT
	mov temp, temp1			; 1.
	rjmp LCD_DATA_TEMP
ATK_3:
	cpi temp3,'0'
	breq ATK_2
	mov temp, temp3			; 3.
	rcall LCD_DATA_TEMP	
	mov temp, temp2			; 2.
	rcall LCD_DATA_TEMP	
	rcall LCD_PUNKT			; PUNKT
	mov temp, temp1			; 1.
	rcall LCD_DATA_TEMP
	rjmp LCD_SPACE			; SPACE	
ATK_2:
	mov temp, temp2			; 2.
	rcall LCD_DATA_TEMP	
	rcall LCD_PUNKT			; PUNKT
	mov temp, temp1			; 1.
	rcall LCD_DATA_TEMP
	rcall LCD_SPACE			; SPACE	
	rjmp  LCD_SPACE			; SPACE	
	ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
ANZEIGE_2_STELLEN_TEMP1:
	cpi temp1,(99+1)
	brlo ANZEIGE_2_STELLEN_TEMP1_RUN
	rjmp LCD_FRAGEZEICHEN2
;-------------------------------------------------------------------------------
ANZEIGE_2_STELLEN_TEMP1_RUN:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	cpi temp2,'0'
	brne ANZEIGE_2_STELLEN_TEMP1_w
	ldi temp2,' '
ANZEIGE_2_STELLEN_TEMP1_w:
	rcall LCD_AUSGABE_ZAHL_2_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
ANZEIGE_3_STELLEN_TEMP1:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1 + TEMP2																	
ANZEIGE_5_STELLEN_TEMP1_TEMP2:
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_5_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1															  		
; z.B. +32767																	
; z.B. -32768																	
ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2:
	tst temp2
	brmi ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2_n
	ldi temp, '+'				; VORZEICHEN	
	rcall LCD_DATA_TEMP
ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2_p:
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
	rcall LCD_AUSGABE_ZAHL_5_STELLEN_KURZ
	ret
ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2_n:
	ldi temp, '-'				; VORZEICHEN	
	rcall LCD_DATA_TEMP
	COM temp1					; BETRAG bilden	
	COM temp2
	add temp1,EINS
	adc temp2,NULL
	rjmp ANZEIGE_5_STELLEN_NEGATIV_TEMP1_TEMP2_p
;######################################################################## 	
;######################################################################## 	
;######################################################################## 	
; INPUT: TEMP1...TEMP9 (temp)												
LCD_AUSGABE_ZAHL_10_STELLEN_KURZ:
	; temp !
	rcall LCD_DATA_TEMP			; 10.ZEICHEN 	
LCD_AUSGABE_ZAHL_9_STELLEN_KURZ:
	mov temp, temp9			; 9.ZEICHEN 
	rcall LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_8_STELLEN_KURZ:
	mov temp, temp8			; 8.ZEICHEN 
	rcall LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_7_STELLEN_KURZ:
	mov temp, temp7			; 7.ZEICHEN 
	rcall LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_6_STELLEN_KURZ:
	mov temp, temp6			; 6.ZEICHEN 
	rcall LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_5_STELLEN_KURZ:
	mov temp, temp5			; 5.ZEICHEN 
	rcall LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_4_STELLEN_KURZ:
	mov temp, temp4			; 4.ZEICHEN 
	rcall LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_3_STELLEN_KURZ:
	mov temp, temp3			; 3.ZEICHEN 
	rcall LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_2_STELLEN_KURZ:
	mov temp, temp2			; 2.ZEICHEN 
	rcall LCD_DATA_TEMP	
LCD_AUSGABE_ZAHL_1_STELLEN_KURZ:
	mov temp, temp1			; 1.ZEICHEN (1-er Stelle)	
	rcall LCD_DATA_TEMP
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
; STAND: 09.12.2011															
;																			
;	Value: 0...	9.999.999.999												
;																			
;	INPUT: 	temp1	(BYTE1)													
;	 		temp2	(BYTE2)													
;			temp3	(BYTE3)													
;			temp4	(BYTE4)													
;																			
;	OUTPUT:	temp1	(		     1-er Stelle)								
;			temp2	(		    10-er Stelle)								
;			temp3	(          100-er Stelle)								
;			temp4	(        1.000-er Stelle)								
;			temp5	(       10.000-er Stelle)								
;			temp6	(      100.000-er Stelle)								
;			temp7	(    1.000.000-er Stelle)								
;			temp8	(   10.000.000-er Stelle)								
;			temp9	(  100.000.000-er Stelle)								
;			temp	(1.000.000.000-er Stelle)								
; 																			
; rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...9 (temp)		
; 																			
FUNKTION_HEX_ASC_32:
;---------------------------------------------------------------------------
	clr temp			
FUNKTION_HEX_ASC_109:	; 1.100.000.000
	inc temp
	subi temp1, BYTE1    (1000000000)
	sbci temp2, BYTE2    (1000000000)
	sbci temp3, BYTE3    (1000000000)
	sbci temp4, BYTE4    (1000000000)
	brcc FUNKTION_HEX_ASC_109
	subi temp, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-1000000000)
	sbci temp2, BYTE2   (-1000000000)
	sbci temp3, BYTE3   (-1000000000)
	sbci temp4, BYTE4   (-1000000000)
;---------------------------------------------------------------------------
	clr temp9			
FUNKTION_HEX_ASC_108:	; 100.000.000
	inc temp9
	subi temp1, BYTE1    (100000000)
	sbci temp2, BYTE2    (100000000)
	sbci temp3, BYTE3    (100000000)
	sbci temp4, BYTE4    (100000000)
	brcc FUNKTION_HEX_ASC_108
	subi temp9, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-100000000)
	sbci temp2, BYTE2   (-100000000)
	sbci temp3, BYTE3   (-100000000)
	sbci temp4, BYTE4   (-100000000)
;---------------------------------------------------------------------------
	clr temp8
FUNKTION_HEX_ASC_107:	; 10.000.000
	inc temp8
	subi temp1, BYTE1    (10000000)
	sbci temp2, BYTE2    (10000000)
	sbci temp3, BYTE3    (10000000)
	sbci temp4, BYTE4    (10000000)
	brcc FUNKTION_HEX_ASC_107
	subi temp8, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-10000000)
	sbci temp2, BYTE2   (-10000000)
	sbci temp3, BYTE3   (-10000000)
	sbci temp4, BYTE4   (-10000000)
;---------------------------------------------------------------------------
	clr temp7
FUNKTION_HEX_ASC_106:	; 1.000.000
	inc temp7
	subi temp1, BYTE1    (1000000)
	sbci temp2, BYTE2    (1000000)
	sbci temp3, BYTE3    (1000000)
	brcc FUNKTION_HEX_ASC_106
	subi temp7, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-1000000)
	sbci temp2, BYTE2   (-1000000)
	sbci temp3, BYTE3   (-1000000)
;---------------------------------------------------------------------------
	clr temp6
FUNKTION_HEX_ASC_105:	; 100.000	
	inc temp6
	subi temp1, BYTE1    (100000)
	sbci temp2, BYTE2    (100000)
	sbci temp3, BYTE3    (100000)
	brcc FUNKTION_HEX_ASC_105
	subi temp6, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1   (-100000)
	sbci temp2, BYTE2   (-100000)
	sbci temp3, BYTE3   (-100000)
;---------------------------------------------------------------------------	clr temp
	clr temp5
FUNKTION_HEX_ASC_104:	; 10.000	
	inc temp5
	subi temp1, BYTE1    (10000)
	sbci temp2, BYTE2    (10000)
	sbci temp3, BYTE3    (10000)
	brcc FUNKTION_HEX_ASC_104
	subi temp5, (-48+1)	; HEX->ASC	
	subi temp1, BYTE1  (-10000)
	sbci temp2, BYTE2  (-10000)
	sbci temp3, BYTE3  (-10000)
;---------------------------------------------------------------------------
	clr temp4
FUNKTION_HEX_ASC_103:	; 1.000		
	inc temp4
	subi temp1, low  (1000)
	sbci temp2, HIGH (1000)
	brcc FUNKTION_HEX_ASC_103
	subi temp4, (-48+1)	; HEX->ASC	
	subi temp1, low  (-1000)
	sbci temp2, HIGH (-1000)
;---------------------------------------------------------------------------
	clr temp3
FUNKTION_HEX_ASC_102:	; 100		
	inc temp3
	subi temp1, low  (100)
	sbci temp2, HIGH (100)
	brcc FUNKTION_HEX_ASC_102
	subi temp3, (-48+1)	; HEX->ASC	
	subi temp1, low  (-100)
	sbci temp2, HIGH (-100)
;---------------------------------------------------------------------------
	clr temp2
FUNKTION_HEX_ASC_101:	; 10		
	inc temp2
	subi temp1, low  (10)
	brcc FUNKTION_HEX_ASC_101
	subi temp2, (-48+1)	; HEX->ASC	
	subi temp1, low  (-10)
;---------------------------------------------------------------------------
FUNKTION_HEX_ASC_100:	; 1			
	subi temp1, -48		; HEX->ASC	
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
; INP: temp1																
; OUT: (z.B."FF") 															
;																			
; rcall ANZEIGE_HEX_TEMP1 ; inp: temp1										
;																			
ANZEIGE_HEX_TEMP1:
	; SICHERUNGSKOPIE						
	push temp
	push temp1
	; oberes NIBBLE bearbeiten				
	mov temp,temp1	
	swap temp						; NIBBLES tausch	
	rcall ANZEIGE_HEX_UMWANDLUNG	; INP/OUT: temp		
	rcall LCD_DATA_TEMP					; ANZEIGE			
	; unteres NIBBLE bearbeiten				
	mov temp,temp1	
	rcall ANZEIGE_HEX_UMWANDLUNG	; INP/OUT: temp		
	rcall LCD_DATA_TEMP					; ANZEIGE			
	; SICHERUNGSKOPIE wieder herstellen		
	pop temp1
	pop temp
	ret
;-------------------------------------------------------------------------------
ANZEIGE_HEX_UMWANDLUNG:
	; BITMUSTER	
	andi temp,0b00001111
	; vergleich	
	cpi temp,10
	brsh ANZEIGE_HEX_UMWANDLUNG_A_F
ANZEIGE_HEX_UMWANDLUNG_0_9:
	subi temp,-48
	ret
ANZEIGE_HEX_UMWANDLUNG_A_F:
	subi temp,-48-7
	ret
;######################################################################## 
;########################################################################
;######################################################################## 
ANZEIGE_TEXT:
	LPM temp, Z+   			; aus Tabelle laden und Zeiger um 1 erhhen	
	tst temp  			
	brne ANZEIGE_TEXT_w
	ret
ANZEIGE_TEXT_w:
	rcall LCD_DATA_TEMP			; Anzeige
	rjmp ANZEIGE_TEXT
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_SPACE5:
	ldi temp, ' '		; SPACE
	rcall LCD_DATA_TEMP
LCD_SPACE4:
	ldi temp, ' '		; SPACE
	rcall LCD_DATA_TEMP
LCD_SPACE3:
	ldi temp, ' '		; SPACE
	rcall LCD_DATA_TEMP
LCD_SPACE2:
	ldi temp, ' '		; SPACE
	rcall LCD_DATA_TEMP
LCD_SPACE:
	ldi temp, ' '		; SPACE
	rjmp LCD_DATA_TEMP
;######################################################################## 
LCD_PUNKT3:
	ldi temp, '.'		; . 
	rcall LCD_DATA_TEMP	
	rcall LCD_DATA_TEMP		; . 
LCD_PUNKT:
	ldi temp, '.'		; . 
	rjmp LCD_DATA_TEMP
;######################################################################## 
LCD_DOPPEL_PUNKT:
	ldi temp, ':'		; : 
	rjmp LCD_DATA_TEMP
;######################################################################## 
LCD_FRAGEZEICHEN2:
	ldi temp, '?'		; ? 
	rcall LCD_DATA_TEMP
LCD_FRAGEZEICHEN:
	ldi temp, '?'		; ? 
	rjmp LCD_DATA_TEMP
;######################################################################## 
LCD_PLUS:
	ldi temp, '+'		; + 
	rjmp LCD_DATA_TEMP
;######################################################################## 
LCD_MINUS2:
	ldi temp, '-'		; - 
	rcall LCD_DATA_TEMP	
LCD_MINUS:
	ldi temp, '-'		; - 
	rjmp LCD_DATA_TEMP
;######################################################################## 
LCD_UNTERSTRICH:
	ldi temp, '_'		; - 
	rjmp LCD_DATA_TEMP	
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_A:
	ldi temp, 'A'	
	rjmp LCD_DATA_TEMP
LCD_B:
	ldi temp, 'B'	
	rjmp LCD_DATA_TEMP
LCD_C:
	ldi temp, 'C'	
	rjmp LCD_DATA_TEMP
LCD_D:
	ldi temp, 'D'	
	rjmp LCD_DATA_TEMP
LCD_E:
	ldi temp, 'E'	
	rjmp LCD_DATA_TEMP
LCD_F:
	ldi temp, 'F'	
	rjmp LCD_DATA_TEMP
LCD_G:
	ldi temp, 'G'	
	rjmp LCD_DATA_TEMP
LCD_H:
	ldi temp, 'H'	
	rjmp LCD_DATA_TEMP
LCD_I:
	ldi temp, 'I'	
	rjmp LCD_DATA_TEMP
LCD_J:
	ldi temp, 'J'	
	rjmp LCD_DATA_TEMP
LCD_K:
	ldi temp, 'K'	
	rjmp LCD_DATA_TEMP
LCD_L:
	ldi temp, 'L'	
	rjmp LCD_DATA_TEMP
LCD_M:
	ldi temp, 'M'	
	rjmp LCD_DATA_TEMP
LCD_N:
	ldi temp, 'N'	
	rjmp LCD_DATA_TEMP
LCD_O:
	ldi temp, 'O'	
	rjmp LCD_DATA_TEMP
LCD_P:
	ldi temp, 'P'	
	rjmp LCD_DATA_TEMP
LCD_Q:
	ldi temp, 'Q'	
	rjmp LCD_DATA_TEMP
LCD_R:
	ldi temp, 'R'	
	rjmp LCD_DATA_TEMP
LCD_S:
	ldi temp, 'S'	
	rjmp LCD_DATA_TEMP
LCD_T:
	ldi temp, 'T'	
	rjmp LCD_DATA_TEMP
LCD_U:
	ldi temp, 'U'	
	rjmp LCD_DATA_TEMP
LCD_V:
	ldi temp, 'V'	
	rjmp LCD_DATA_TEMP
LCD_W:
	ldi temp, 'W'	
	rjmp LCD_DATA_TEMP
LCD_X:
	ldi temp, 'X'	
	rjmp LCD_DATA_TEMP
LCD_Y:
	ldi temp, 'Y'	
	rjmp LCD_DATA_TEMP
LCD_Z:
	ldi temp, 'Z'	
	rjmp LCD_DATA_TEMP


LCD_A_:
	ldi temp, 'a'	
	rjmp LCD_DATA_TEMP
LCD_B_:
	ldi temp, 'b'	
	rjmp LCD_DATA_TEMP
LCD_C_:
	ldi temp, 'c'	
	rjmp LCD_DATA_TEMP
LCD_D_:
	ldi temp, 'd'	
	rjmp LCD_DATA_TEMP
LCD_E_:
	ldi temp, 'e'	
	rjmp LCD_DATA_TEMP
LCD_F_:
	ldi temp, 'f'	
	rjmp LCD_DATA_TEMP
LCD_G_:
	ldi temp, 'g'	
	rjmp LCD_DATA_TEMP
LCD_H_:
	ldi temp, 'h'	
	rjmp LCD_DATA_TEMP
LCD_I_:
	ldi temp, 'i'	
	rjmp LCD_DATA_TEMP
LCD_J_:
	ldi temp, 'j'	
	rjmp LCD_DATA_TEMP
LCD_K_:
	ldi temp, 'k'	
	rjmp LCD_DATA_TEMP
LCD_L_:
	ldi temp, 'l'	
	rjmp LCD_DATA_TEMP
LCD_M_:
	ldi temp, 'm'	
	rjmp LCD_DATA_TEMP
LCD_N_:
	ldi temp, 'n'	
	rjmp LCD_DATA_TEMP
LCD_O_:
	ldi temp, 'o'	
	rjmp LCD_DATA_TEMP
LCD_P_:
	ldi temp, 'p'	
	rjmp LCD_DATA_TEMP
LCD_Q_:
	ldi temp, 'q'	
	rjmp LCD_DATA_TEMP
LCD_R_:
	ldi temp, 'r'	
	rjmp LCD_DATA_TEMP
LCD_S_:
	ldi temp, 's'	
	rjmp LCD_DATA_TEMP
LCD_T_:
	ldi temp, 't'	
	rjmp LCD_DATA_TEMP
LCD_U_:
	ldi temp, 'u'	
	rjmp LCD_DATA_TEMP
LCD_V_:
	ldi temp, 'v'	
	rjmp LCD_DATA_TEMP
LCD_W_:
	ldi temp, 'w'	
	rjmp LCD_DATA_TEMP
LCD_X_:
	ldi temp, 'x'	
	rjmp LCD_DATA_TEMP
LCD_Y_:
	ldi temp, 'y'	
	rjmp LCD_DATA_TEMP
LCD_Z_:
	ldi temp, 'z'	
	rjmp LCD_DATA_TEMP





LCD_0:
	ldi temp, '0'	
	rjmp LCD_DATA_TEMP
LCD_1:
	ldi temp, '1'	
	rjmp LCD_DATA_TEMP
LCD_2:
	ldi temp, '2'	
	rjmp LCD_DATA_TEMP
LCD_3:
	ldi temp, '3'	
	rjmp LCD_DATA_TEMP
LCD_4:
	ldi temp, '4'	
	rjmp LCD_DATA_TEMP
LCD_5:
	ldi temp, '5'	
	rjmp LCD_DATA_TEMP
LCD_6:
	ldi temp, '6'	
	rjmp LCD_DATA_TEMP
LCD_7:
	ldi temp, '7'	
	rjmp LCD_DATA_TEMP
LCD_8:
	ldi temp, '8'	
	rjmp LCD_DATA_TEMP
LCD_9:
	ldi temp, '9'	
	rjmp LCD_DATA_TEMP



;######################################################################## 
;######################################################################## 
;######################################################################## 

