;                                                                               
;              |                                          |                     
;          ____|      ____________________________________|_____                
;              |     |     |                              |                     
;  "1" SLOT    |  6  |     9       64                     |                     
;              |_____|                                    |                     
;              |                                       	  |                     
;              |           Samples                     	  |                     
;              |                                       	  |                     
;          ____|                                    ______|_____                
;              |           15                      |      |                     
; "0" SLOT     |           |        60             |  10  |                     
;              |___________________________________|      |                     
;              |                                       	  |                     
;              |                                          |                     
;                                                                               
;                                                      	                        
;          ____                    ______          _______________|             
;              |                  |      |        |               |             
; RESET        |                  |      | Samples|               |             
;              |__________________|      |____|___|               |             
;               <------480--------><---70----><--------410------->|             
;                                                                 |             
;                                                                               
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INITIALISIERUNG																
;																				
OW_INITIALISIERUNG:
	cbi (OW_DDR), (OW_PIN_NR)	; AUF EINGANG	
	sbi (OW_PORT),(OW_PIN_NR)	; PULL-UP ein	
	;  1-WIRE-ROM-ID					
	ldi temp1,ROM_ID_BYTE0		; FAM	
	ldi temp2,ROM_ID_BYTE1
	ldi temp3,ROM_ID_BYTE2
	ldi temp4,ROM_ID_BYTE3
	ldi temp5,ROM_ID_BYTE4
	ldi temp6,ROM_ID_BYTE5
	ldi temp7,ROM_ID_BYTE6
	ldi temp8,ROM_ID_BYTE7		; CRC	
	STS(adr_OW_ROM_ID_BEREICH8+0),temp1
	STS(adr_OW_ROM_ID_BEREICH8+1),temp2
	STS(adr_OW_ROM_ID_BEREICH8+2),temp3
	STS(adr_OW_ROM_ID_BEREICH8+3),temp4
	STS(adr_OW_ROM_ID_BEREICH8+4),temp5
	STS(adr_OW_ROM_ID_BEREICH8+5),temp6
	STS(adr_OW_ROM_ID_BEREICH8+6),temp7
	STS(adr_OW_ROM_ID_BEREICH8+7),temp8
 	; CRC								
	rcall ONE_WIRE_ROM_CRC_CHECK		; wichtig !	
	STS(adr_OW_ROM_ID_BEREICH8+7),R17	; KORREKTUR	
	STS(adr_ERROR_CODE),NULL
	sbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR); ROT  aus	
	rcall ONE_WIRE_ROM_CRC_CHECK		; wichtig !	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ONE_WIRE_ROM_CRC_CHECK:
 	ldi ZL,low (adr_OW_ROM_ID_BEREICH8+0)
    ldi ZH,high(adr_OW_ROM_ID_BEREICH8+0) 
	rcall ONE_WIRE_ROM_Z_CRC7
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
EXT_INT0:
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB an	
	in	KOPIE_SREG,SREG
	movw KOPIE_TEMP,temp	; temp+temp1
	movw KOPIE_ZL,ZL		; ZL+ZH		
; ------------------------------------------------------------------------------
; Zeit nutzen fr div. Aktionen			
	LDS temp,(adr_OW_RX_DATA256+0)			; ROM-COMMAND	
	cpi temp,(OW_COMMAND_SEARCH_ROM)		; SEARCH_ROM ?	
	brne OW_RX_NO_SEARCH_ROM				; nein			
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN aus		
	rjmp OW_RP_CHECK						; ja-->RP_CHECK			
OW_RX_NO_SEARCH_ROM:
; ------------------------------------------------------------------------------
	ldi ZL,LOW (adr_OW_RX_DATA256)		; Z initialisieren		
	ldi ZH,HIGH(adr_OW_RX_DATA256)
	LDS temp,(adr_OW_BYTE_ZAEHLER)
	add ZL,temp	
	adc ZH,NULL
	SEC 								; set Carry				
	ROL OW_RX_BIT_ZAEHLER				; links ber C			
	rcall WAIT_5us						; PAUSE	(ev. anpassen)	
;	rcall WAIT_5us
; ------------------------------------------------------------------------------
; SAMPLES nach 15s (OW_RX_BYTE)		
	CLC									; Clear Carry			
	sbic (OW_PIN),(OW_PIN_NR)			; springe, wenn BIT(PIN) low	
	SEC 								; set Carry				
	ROR OW_RX_BYTE						; rechts ber C			
	SBRS OW_RX_BIT_ZAEHLER,7			; RX-Byte fertig ?		
	rjmp OW_RP_CHECK					; nein-->RP_CHECK		
	clr OW_RX_BIT_ZAEHLER				; ja					
; ------------------------------------------------------------------------------
; RX BYTES in das DATENFELD				
	ST Z,OW_RX_BYTE						; SAVE					
	LDS temp,(adr_OW_BYTE_ZAEHLER)
	inc temp							; ZAEHLER+1				
	STS(adr_OW_BYTE_ZAEHLER),temp
	brne OW_RX_OK						; berlauf ?			
	cbi (LED_ROT_PORT),(LED_ROT_PIN_NR)	; ROT  an				
OW_RX_OK:
; ------------------------------------------------------------------------------
	cpi temp,1							; ZAEHLER=1	?			
	brne OW_HIST_FERTIG					; nein-->fertig			
 	LDS temp,(adr_OW_HIST_ROM_OLD)
	cp temp, OW_RX_BYTE					; OLD=RX BYTE ?			
	breq OW_HIST_FERTIG					; ja-->fertig			
	STS(adr_OW_HIST_ROM_OLD),OW_RX_BYTE ; OLD=RX BYTE			

	LDS temp1,(adr_OW_HIST_ROM_COUNTER) 
	cpi temp1,18
	brsh OW_HIST_FERTIG					; ja-->fertig			
 	ldi ZL,low (adr_OW_HIST_ROM_BEREICH)
    ldi ZH,high(adr_OW_HIST_ROM_BEREICH) 
	add ZL,temp1
	adc ZH,NULL

	LDS temp,(adr_OW_RX_DATA256+0)			; ROM-COMMAND	
	ST Z,temp
	inc temp1
	STS(adr_OW_HIST_ROM_COUNTER),temp1
OW_HIST_FERTIG:
; ##############################################################################
; ##############################################################################
; ##############################################################################
; RESET-PRESENCE-CHECK															
OW_RP_CHECK:
	clr ZL
	clr ZH
OW_RP_s:
	sbic (OW_PIN),(OW_PIN_NR)	; springe, wenn BIT(PIN) low
	rjmp OW_RESET_PRESENCE_AUSWERTUNG
	adiw ZL,1					; Z+1					
	brcc OW_RP_s				; OW_RP_UEBERLAUF ?		
; ------------------------------------------------------------------------------
OW_RP_UEBERLAUF:
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  an	
	rjmp OW_RP_UEBERLAUF
; ------------------------------------------------------------------------------
OW_RESET_PRESENCE_AUSWERTUNG:
	cpi ZH,HIGH(300)				; vergleich (HIGH)
	brlo OW_RP_CHECK_OK
	breq OW_RESET_PRESENCE_L
	brsh OW_RP_ERKANNT
OW_RESET_PRESENCE_L:
	cpi ZL,LOW(300)				; vergleich (LOW)		
	brlo OW_RP_CHECK_OK
	rjmp OW_RP_ERKANNT
OW_RP_CHECK_OK:
	rjmp OW_FERTIG
; ##############################################################################
; ##############################################################################
; ##############################################################################
OW_RP_ERKANNT:
	STS(adr_OW_ZAEHLER_RP_L),ZL				; speichern (Wartungszwecke)
	STS(adr_OW_ZAEHLER_RP_H),ZH
	clr OW_RX_BIT_ZAEHLER
	STS(adr_OW_BYTE_ZAEHLER),NULL
	clr temp
 	ldi ZL,low (adr_OW_RX_DATA256)
    ldi ZH,high(adr_OW_RX_DATA256) 
OW_RP_ERKANNT_s:
	ST Z+,NULL
	dec temp
	brne OW_RP_ERKANNT_s
; ------------------------------------------------------------------------------
	rcall WAIT_100us
; ------------------------------------------------------------------------------
OW_FERTIG:
	OUT	SREG,KOPIE_SREG
	movw temp,KOPIE_TEMP	; temp+temp1
	movw ZL,KOPIE_ZL		; ZL+ZH		
	sbi (LED_GELB_PORT),(LED_GELB_PIN_NR)	; GELB aus	
	out GIFR,VOLL				; eventuelle Pegelwechsel ignorieren
reti
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; ##############################################################################
; CRC Berechnung bernommen und abgendert von: http://s-huehn.de				
; CRC-Berechnung Application Note 27 von Dallas/Maxim							
;																				
; INP: Z																		
; OUT: C + R17																	
;																				
ONE_WIRE_ROM_Z_CRC7:
    ldi     r19, 7                          ;7 Bytes berechnen			
    ldi     r20, 0x18                       ;Konstante fr Berechnung
    clr     r17                            ;CRC-Startwert = 0 setzen
ONE_WIRE_CRC7_100: 
	LD      r18, Z+                         ;Byte aus Puffer holen
    mov     r21, r18                        ;Byte zwischenspeichern
    ldi     r16, 8                          ;8 Verschiebungen
ONE_WIRE_CRC7_200: 
	eor     r18, r17                      	;CRC berechnen
    ror     r18                             ;Ergebnis in Carry schieben
    mov     r18, r17                      	;letzten CRC-Wert holen
    brcc    ONE_WIRE_CRC7_300                          ;war Ergebnis = 0? ja -> weiter
    eor     r18, r20                        ;sonst CRC-Wert updaten
ONE_WIRE_CRC7_300: 
	ror     r18                             ;neuen CRC-Wert positionieren
    mov     r17, r18          	            ;und speichern
    mov     r18, r21                        ;restliche Bits holen
    bst     r18, 0                          ;LSB sichern, nchste Bitposition
    ror     r18                             ;gesichertes Bit als MSB einsetzen
    bld     r18, 7                          ;(Ersatz fr RR-Befehl)
    mov     r21, r18                        ;und Wert zwischenspeichern
    dec     r16                             ;alle Verschiebungen erledigt?
    brne    ONE_WIRE_CRC7_200               ;nein -> Schleife
    dec     r19                             ;alle Bytes bearbeitet?
    brne    ONE_WIRE_CRC7_100               ;nein -> Schleife
;-------------------------------------------------------------------------------
	LD temp,Z+								; CRC laden
	cp temp,r17								; VERGLEICH
	brne ONE_WIRE_CRC7_ERROR
	SEC										; Set Carry		
	ret
;-------------------------------------------------------------------------------
ONE_WIRE_CRC7_ERROR:
	ldi temp,(ERROR_CRC_ROM_ID)
	rcall ERROR_SAVE_TEMP					; ERROR-SAVE	
	CLC		 								; Clear Carry	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SCRATCHPAD_CRC8_C:
 	ldi ZL,low (adr_OW_SCRATCHPAD_BEREICH9) ; Z-Zeiger 					
    ldi ZH,high(adr_OW_SCRATCHPAD_BEREICH9) 
    ldi     r19, 8                          ;8 Bytes berechnen			
    ldi     r20, 0x18                       ;Konstante fr Berechnung
    clr     r17                            	;CRC-Startwert = 0 setzen
SCRATCHPAD_CRC8_100: 
	LD      r18, Z+                         ;Byte aus Puffer holen
    mov     r21, r18                        ;Byte zwischenspeichern
    ldi     r16, 8                          ;8 Verschiebungen
SCRATCHPAD_CRC8_200: 
	eor     r18, r17                      	;CRC berechnen
    ror     r18                             ;Ergebnis in Carry schieben
    mov     r18, r17                      	;letzten CRC-Wert holen
    brcc    SCRATCHPAD_CRC8_300             ;war Ergebnis = 0? ja -> weiter
    eor     r18, r20                        ;sonst CRC-Wert updaten
SCRATCHPAD_CRC8_300: 
	ror     r18                             ;neuen CRC-Wert positionieren
    mov     r17, r18          	            ;und speichern
    mov     r18, r21                        ;restliche Bits holen
    bst     r18, 0                          ;LSB sichern, nchste Bitposition
    ror     r18                             ;gesichertes Bit als MSB einsetzen
    bld     r18, 7                          ;(Ersatz fr RR-Befehl)
    mov     r21, r18                        ;und Wert zwischenspeichern
    dec     r16                             ;alle Verschiebungen erledigt?
    brne    SCRATCHPAD_CRC8_200        		;nein -> Schleife		
    dec     r19                             ;alle Bytes bearbeitet?	
    brne    SCRATCHPAD_CRC8_100    		 	;nein -> Schleife		
;-------------------------------------------------------------------------------
	; Ergebnis in R17	
	LDS R16,(adr_OW_SCRATCHPAD_BEREICH9+8)
	cp R16,R17
	brne SCRATCHPAD_CRC8_C_ERROR
SCRATCHPAD_CRC8_C_OK:
	SEC				; Set Carry		
	ret
SCRATCHPAD_CRC8_C_ERROR:
	ldi temp,(ERROR_CRC_ROM_ID)
	rcall ERROR_SAVE_TEMP		; ERROR-SAVE	
	CLC 			; Clear Carry	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SCRATCHPAD_CLEAR:
	STS(adr_OW_SCRATCHPAD_BEREICH9+0),NULL
	STS(adr_OW_SCRATCHPAD_BEREICH9+1),NULL
	STS(adr_OW_SCRATCHPAD_BEREICH9+2),NULL
	STS(adr_OW_SCRATCHPAD_BEREICH9+3),NULL
	STS(adr_OW_SCRATCHPAD_BEREICH9+4),NULL
	STS(adr_OW_SCRATCHPAD_BEREICH9+5),NULL
	STS(adr_OW_SCRATCHPAD_BEREICH9+6),NULL
	STS(adr_OW_SCRATCHPAD_BEREICH9+7),NULL
	STS(adr_OW_SCRATCHPAD_BEREICH9+8),NULL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################



