; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Ein Byte aus EEPROM holen und Z-Zeiger + 1									
;																				
EEPROM_READ_Z_PLUS_TEMP:
	sbic EECR,EEWE 		; Wait for completion of previous write
	rjmp EEPROM_READ_Z_PLUS_TEMP
	out  EEARH, ZH		; ADRESSE setzen						
	out  EEARL, ZL
	sbi  EECR,EERE		; Start eeprom read by writing EERE		
	in 	 temp,EEDR		; Read data from data register			
	adiw ZL,1			; ADRESSE +1 							
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Ein Byte im EEPROM ablegen und Z-Zeiger + 1									
;																				
EEPROM_WRITE_Z_PLUS_TEMP:
	mov temp6,temp
	rcall EEPROM_READ_Z_PLUS_TEMP
	sbiw ZL,1	; Z-1
	cp temp,temp6
	brne EEPROM_WRITE_Z_PLUS_RUN
	adiw ZL,1	; Z+1
	ret
EEPROM_WRITE_Z_PLUS_RUN:
	sbic EECR,EEWE		; Wait for completion of previous write
	rjmp EEPROM_WRITE_Z_PLUS_RUN
	WDR
	out  EEARH,ZH		; ADRESSE setzen						
	out  EEARL,ZL
	out  EEDR, temp6	; Write data  to data register			
	sbi  EECR, EEMWE	; Write logical one to EEMWE			
	sbi  EECR, EEWE		; Start eeprom write by setting EEWE	
	adiw ZL,1			; Z+1									
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
EEPROM_KONFIGURATION_LADEN:
	; WERKSEINSTELLUNG ?	
	clr ZL
	clr ZH
	rcall EEPROM_READ_Z_PLUS_TEMP
	cpi temp,(EEPROM_KENNUNG_WERKSEINSTELLUNG)
	breq EEPROM_KONFIGURATION_LADEN_RUN
	rcall LCD_CLEAR
	rcall LCD_W
	rcall LCD_E
	rcall LCD_R
	rcall LCD_K
	rcall WAIT_1s
	ldi temp,(EEPROM_KENNUNG_WERKSEINSTELLUNG)
	STS(adr_WERKSEINSTELLUNG),temp
	ret
EEPROM_KONFIGURATION_LADEN_RUN:
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB an	
	ldi XL,LOW (SRAM_START)						; X=SRAM-ADRESSE	
	ldi XH,HIGH(SRAM_START)
	ldi YL,LOW (EEPROM_ANZAHL_BYTES)			; Y=ANZAHL			
	ldi YH,HIGH(EEPROM_ANZAHL_BYTES)
	ldi ZL,LOW (0)								; Z=EEPROM-ADRESSE	
	ldi ZH,HIGH(0)
EEPROM_KONFIGURATION_LADEN_RUN_s:
	WDR
	rcall EEPROM_READ_Z_PLUS_TEMP	
	ST X+,temp
	sbiw YL,1
	tst YH
	brne EEPROM_KONFIGURATION_LADEN_RUN_s
	tst YL
	brne EEPROM_KONFIGURATION_LADEN_RUN_s
	sbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
EEPROM_KONFIGURATION_SAVE:
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB an	
	; ZEILE1	
	rcall LCD_CLEAR
	rcall LCD_S
	rcall LCD_A
	rcall LCD_V
	rcall LCD_E
	ldi XL,LOW (SRAM_START)					; X=SRAM-ADRESSE	
	ldi XH,HIGH(SRAM_START)
	ldi YL,LOW (EEPROM_ANZAHL_BYTES)		; Y=ANZAHL			
	ldi YH,HIGH(EEPROM_ANZAHL_BYTES)
	ldi ZL,LOW (0)							; Z=EEPROM-ADRESSE	
	ldi ZH,HIGH(0)
EEPROM_KONFIGURATION_SAVE_s:
	WDR
	LD temp,X+
	rcall EEPROM_WRITE_Z_PLUS_TEMP
	sbiw Y,1
	tst YL
	brne EEPROM_KONFIGURATION_SAVE_s
	tst YH
	brne EEPROM_KONFIGURATION_SAVE_s
	sbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################


