; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; SLEEP+INT0+INT1 (externer Interrupt) konfigurieren							
;																				
; MCUCR => SE SM2 SM1 SM0 ISC11 ISC10 ISC01 ISC00 								
; SM2 SM1 SM0 Sleep Mode														
; 0   0   0   Idle																
; 0   0   1   ADC Noise Reduction												
; 0   1   0   Power-down														
; 0   1   1   Power-save														
; 1   0   0   Reserved															
; 1   0   1   Reserved															
; 1   1   0   Standby(1)														
;																				
;ISC11 ISC10 Description														
; 0 	0 	The low level of INT1 generates an interrupt request.				
; 0 	1 	Any logical change on INT1 generates an interrupt request.			
; 1 	0 	The falling edge of INT1 generates an interrupt request.			
; 1 	1 	The rising edge of INT1 generates an interrupt request.				
;																				
;ISC01 ISC00 Description														
; 0 	0 	The low level of INT0 generates an interrupt request.				
; 0 	1 	Any logical change on INT0 generates an interrupt request.			
;*1 	0 	The falling edge of INT0 generates an interrupt request.			
; 1 	1 	The rising  edge of INT0 generates an interrupt request.			
;																				
EXTERNER_INTERUPT_INITIALISIEREN:
	ldi temp,(1<<SE)|(0<<SM2)|(0<<SM1)|(0<<SM0)|(0<<ISC11)|(0<<ISC10)|(1<<ISC01)|(0<<ISC00) 
	out MCUCR,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; INT0+INT1 (externer Interrupt)aktivieren										
;																				
; GICR => INT1 INT0 - - - - IVSEL IVCE 											
; General Interrupt Control														
;																				
EXTERNER_INTERRUPT_AKTIVIEREN:
	ldi temp, (0<<INT1)|(1<<INT0)|(0<<IVSEL)|(0<<IVCE)   
    out GICR, temp 
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
