; ##############################################################################
; ##############################################################################
; ##############################################################################
NEUSTART_MIT_WDR:
	WDR
	in temp, MCUCSR
	andi temp,0b00001000
	tst temp
	breq NEUSTART_MIT_WDR_FEHLER
	; MCUCSR clear		
	out MCUCSR,NULL
	ret
NEUSTART_MIT_WDR_FEHLER:
	rjmp NEUSTART_MIT_WDR_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Watchdog aktivieren (max. Zeit)												
WDR_INITIALISIEREN:
	ldi TEMP,(1<<WDCE)|(1<<WDE)  
	out wdtcr,TEMP       
	ldi TEMP,(1<<WDE) | (1<<WDP2)|(1<<WDP1)|(1<<WDP0) 
	out wdtcr,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
PROGRAMM_CHECK:
	; NULL		
	tst NULL
	brne PROGRAMM_CHECK_FEHLER
	; EINS		
	mov temp,EINS
	cpi temp,1
	brne PROGRAMM_CHECK_FEHLER
	; VOLL		
	mov temp,VOLL
	cpi temp,255
	brne PROGRAMM_CHECK_FEHLER
	; SRAM CHECK
	LDS temp,(adr_SRAM_CHECK)
	cpi temp,'S'
	brne PROGRAMM_CHECK_FEHLER
	ret
; SCHLEIFE, bis WDR zubeit		
PROGRAMM_CHECK_FEHLER:
	rjmp PROGRAMM_CHECK_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
SRAM_CLEAR:
	ldi ZL, LOW (SRAM_START)
	ldi ZH, HIGH(SRAM_START)
	ldi temp,0
SRAM_CLEAR_w:
	ST z+,temp
	cpi ZH, HIGH(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	cpi ZL, LOW(RAMEND-1)	; Vergleich?		
	brlo SRAM_CLEAR_w		; kleiner => SPRUNG	
	breq SRAM_CLEAR_w		; gleich  => SPRUNG	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
REGISTER_CLEAR:
	clr R0
	clr R1
	clr R2
	clr R3
	clr R4
	clr R5
	clr R6
	clr R7
	clr R8
	clr R9
	clr R10
	clr R11
	clr R12
	clr R13
	clr R14
	clr R15
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; PORT B+C+D CLEAR																
PORT_CLEAR:
	ldi temp, 0b00000000	
	out DDRB, temp
	out DDRC, temp
	out DDRD, temp
	out PORTB,temp				
	out PORTC,temp				
	out PORTD,temp	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_INITIALISIERUNG:
	; auf AUSGANG								
	sbi (LED_GRUEN_DDR),(LED_GRUEN_PIN_NR)		; GRN	
	sbi (LED_GELB_DDR) ,(LED_GELB_PIN_NR)		; GELB	
	sbi (LED_ROT_DDR)  ,(LED_ROT_PIN_NR)		; ROT	
	sbi (LED_TASTEN_DDR),(LED_TASTEN_PIN_NR)	; TASTEN
	sbi (BEEP_DDR),(BEEP_PIN_NR)				; BEEP	
	; LEDs an									
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  an	
	cbi (LED_TASTEN_PORT) ,(LED_TASTEN_PIN_NR)	; Tasten an	
	cbi (BEEP_PORT) ,(BEEP_PIN_NR)				; BEEP an	
	sbi (BEEP_PORT) ,(BEEP_PIN_NR)				; BEEP aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_TEST:
	rcall WAIT_100ms
	sbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)	; ROT  aus	
	rcall WAIT_100ms
	sbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)	; GELB aus	
	rcall WAIT_100ms
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)	; GRN aus	
	rcall WAIT_100ms
	sbi (LED_TASTEN_PORT) ,(LED_TASTEN_PIN_NR)	; Tasten aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
STOP_PROGRAMM:
	WDR
	rjmp STOP_PROGRAMM
; ##############################################################################
; ##############################################################################
; ##############################################################################
BEEP_TASTE:
	cbi (BEEP_PORT) ,(BEEP_PIN_NR)				; BEEP an	
	rcall WAIT_5ms
	sbi (BEEP_PORT) ,(BEEP_PIN_NR)				; BEEP aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
BEEP_KURZ:
	LDS temp,(adr_BEEP_OFF)
	tst temp
	breq BEEP_KURZ_RUN
	ret
; ------------------------------------------------------------------------------
BEEP_KURZ_RUN:
	cbi (BEEP_PORT) ,(BEEP_PIN_NR)				; BEEP an	
	rcall WAIT_10ms
	sbi (BEEP_PORT) ,(BEEP_PIN_NR)				; BEEP aus	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TASTEN_INITIALISIERUNG:
	; auf EINGANG						
	cbi (TASTE_A_DDR),(TASTE_A_PIN_NR) 
	cbi (TASTE_B_DDR),(TASTE_B_PIN_NR) 
	cbi (TASTE_C_DDR),(TASTE_C_PIN_NR) 
	cbi (TASTE_D_DDR),(TASTE_D_PIN_NR) 
	; PULL UP ein						
	sbi (TASTE_A_PORT),(TASTE_A_PIN_NR) 		
	sbi (TASTE_B_PORT),(TASTE_B_PIN_NR) 		
	sbi (TASTE_C_PORT),(TASTE_C_PIN_NR) 		
	sbi (TASTE_D_PORT),(TASTE_D_PIN_NR) 		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TASTEN_ABFRAGE:
	; TASTEN-WAIT			
	LDS temp,(adr_TASTE)
	tst temp
	breq TASTEN_ABFRAGE_RUN
;-------------------------------------------------------------------------------
TASTEN_ABFRAGE_RUN:
	clr temp1
	sbis (TASTE_A_PIN),(TASTE_A_PIN_NR)	; springe, wenn...	
	ori	temp1,(TASTE_MENUE_PLUS)	; 2
	sbis (TASTE_B_PIN),(TASTE_B_PIN_NR)	; springe, wenn...	
	ori	temp1,(TASTE_MENUE_MINUS); 4
	sbis (TASTE_C_PIN),(TASTE_C_PIN_NR)	; springe, wenn...	
	ori	temp1,(TASTE_MINUS)		; 16
	sbis (TASTE_D_PIN),(TASTE_D_PIN_NR)	; springe, wenn...	
	ori	temp1,(TASTE_PLUS)		; 8
	STS(adr_TASTE),temp1				; SAVE				
;-------------------------------------------------------------------------------
	tst temp1
	brne TASTEN_ABFRAGE_ACTION
	ret
;-------------------------------------------------------------------------------
TASTEN_ABFRAGE_ACTION:
	rcall BEEP_TASTE
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	cpi temp1,(TASTE_PLUS+TASTE_MINUS)
	breq TASTEN_ABFRAGE_RESET
	cpi temp1,(TASTE_MINUS)
	breq TASTEN_ABFRAGE_MINUS
	ret
;-------------------------------------------------------------------------------
TASTEN_ABFRAGE_MINUS:
	sbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  aus	
	sbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN aus	
	STS(adr_ERROR_CODE),NULL
	rcall SCRATCHPAD_CLEAR
	rcall HIST_ROM_CLEAR
	ret
;-------------------------------------------------------------------------------
TASTEN_ABFRAGE_RESET:
	CLI 										; Global Interrupt Disable
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  an	
	cbi (LED_TASTEN_PORT) ,(LED_TASTEN_PIN_NR)	; Tasten an	
	rcall WAIT_100ms
	rjmp RESET
; ##############################################################################
; ##############################################################################
; ##############################################################################
TASTEN_WAIT:
	LDS temp,(adr_TASTE)
	tst temp
	brne TASTEN_WAIT_RUN
	ret
TASTEN_WAIT_RUN:
	rcall WAIT_100ms
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
TASTE_PLUS_MINUS_TEMP1:
	LDS temp,(adr_TASTE)
	cpi temp,(TASTE_PLUS)
	breq TASTE_PLUS_MINUS_TEMP1_P
	cpi temp,(TASTE_MINUS)
	breq TASTE_PLUS_MINUS_TEMP1_M
	ret
TASTE_PLUS_MINUS_TEMP1_P:
	inc temp1
	ret
TASTE_PLUS_MINUS_TEMP1_M:
	dec temp1
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
NEUSTART:
	cbi (LED_GRUEN_PORT),(LED_GRUEN_PIN_NR)		; GRN an	
	cbi (LED_GELB_PORT) ,(LED_GELB_PIN_NR)		; GELB an	
	cbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  an	
	rjmp NEUSTART
; ##############################################################################
; ##############################################################################
; ##############################################################################
ERROR_SAVE_TEMP:
	cbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  an	
	STS(adr_ERROR_CODE),temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ROM_LISTE_EINTRAG:
	rcall ROM_LISTE_SEARCH_C		; vorhanden ?	
	brcs ROM_LISTE_EINTRAG_FERTIG	
	rcall ROM_LISTE_NEW				; neuer Eintrag	
ROM_LISTE_EINTRAG_FERTIG:
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ROM_LISTE_SEARCH_C:
	LDS temp1,(adr_OW_RX_DATA256+1)
	LDS temp2,(adr_OW_RX_DATA256+2)
	LDS temp3,(adr_OW_RX_DATA256+3)
	LDS temp4,(adr_OW_RX_DATA256+4)
	LDS temp5,(adr_OW_RX_DATA256+5)
	LDS temp6,(adr_OW_RX_DATA256+6)
	LDS temp7,(adr_OW_RX_DATA256+7)
	LDS temp8,(adr_OW_RX_DATA256+8)
 	ldi ZL,low (adr_ROM_LISTE)
    ldi ZH,high(adr_ROM_LISTE) 
	ldi temp9,60
ROM_LISTE_SEARCH_s:
	rcall ROM_LISTE_SEARCH_DETAIL
	brcs ROM_LISTE_SEARCH_FERTIG
	dec temp9
	brne ROM_LISTE_SEARCH_s
ROM_LISTE_SEARCH_FERTIG:
	ret	
;-------------------------------------------------------------------------------
ROM_LISTE_SEARCH_DETAIL:
	CLC 			; Clear Carry	
	LD temp,Z+
	cp temp,temp1
	breq ROM_LISTE_SEARCH_DETAIL_2
	adiw ZL,7
	ret
ROM_LISTE_SEARCH_DETAIL_2:
	LD temp,Z+
	cp temp,temp2
	breq ROM_LISTE_SEARCH_DETAIL_3
	adiw ZL,6
	ret
ROM_LISTE_SEARCH_DETAIL_3:
	LD temp,Z+
	cp temp,temp3
	breq ROM_LISTE_SEARCH_DETAIL_4
	adiw ZL,5
	ret
ROM_LISTE_SEARCH_DETAIL_4:
	LD temp,Z+
	cp temp,temp4
	breq ROM_LISTE_SEARCH_DETAIL_5
	adiw ZL,4
	ret
ROM_LISTE_SEARCH_DETAIL_5:
	LD temp,Z+
	cp temp,temp5
	breq ROM_LISTE_SEARCH_DETAIL_6
	adiw ZL,3
	ret
ROM_LISTE_SEARCH_DETAIL_6:
	LD temp,Z+
	cp temp,temp6
	breq ROM_LISTE_SEARCH_DETAIL_7
	adiw ZL,2
	ret
ROM_LISTE_SEARCH_DETAIL_7:
	LD temp,Z+
	cp temp,temp7
	breq ROM_LISTE_SEARCH_DETAIL_8
	adiw ZL,1
	ret
ROM_LISTE_SEARCH_DETAIL_8:
	SEC				; Set Carry		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ROM_LISTE_NEW:
	LDS temp,(adr_OW_ANZAHL_SLAVES)
	cpi temp,(ANZAHL_SLAVES_MAX)
	brlo ROM_LISTE_NEW_RUN
	cbi (LED_ROT_PORT)  ,(LED_ROT_PIN_NR)		; ROT  an	
	ret
;-------------------------------------------------------------------------------
ROM_LISTE_NEW_RUN:
 	ldi YL,low (adr_OW_RX_DATA256+1)
    ldi YH,high(adr_OW_RX_DATA256+1) 
 	ldi ZL,low (adr_ROM_LISTE)
    ldi ZH,high(adr_ROM_LISTE) 
	LDS temp,(adr_OW_ANZAHL_SLAVES)
	ldi temp1,8
	MUL temp,temp1	; mal 8	
	add ZL,R0
	adc ZH,R1
	inc temp		; +1	
	STS(adr_OW_ANZAHL_SLAVES),temp

	LD temp,Y+
	ST Z+,temp
	LD temp,Y+
	ST Z+,temp
	LD temp,Y+
	ST Z+,temp
	LD temp,Y+
	ST Z+,temp
	LD temp,Y+
	ST Z+,temp
	LD temp,Y+
	ST Z+,temp
	LD temp,Y+
	ST Z+,temp
	LD temp,Y+
	ST Z+,temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################



