LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
use IEEE.std_logic_textio.all;
use STD.textio.all;
use IEEE.numeric_std.all;
use ieee.math_real.all;

entity TEM_uni_5_adc_stream_bench is
end TEM_uni_5_adc_stream_bench;

architecture Behavioral of TEM_uni_5_adc_stream_bench is

component TEM_uni_5_adc_stream is Port(
	-- Trenz Board
	clk: in std_logic;
	sysled: out std_logic;
	-- UM232H
	D: out std_logic_vector(7 downto 0); --inout
	RXF: in std_logic;
	TXE: in std_logic;
	RD: out std_logic;
	WR: out std_logic;
	SIWU: out std_logic;
	CLKOUT: in std_logic; --60MHz FTDI
	OE: out std_logic;
	PWRSAV: out std_logic;
	--UM232H_RX: in std_logic;
	--UM232H_TX: out std_logic;
	-- Board LEDs
	LED_r: out std_logic;
	LED_o: out std_logic;
	-- FT232RL UART
	FT232RL_RX: in std_logic;
	FT232RL_TX: out std_logic;
	-- ADCs
	AD7356_12_nCS: out std_logic;
	AD7356_12_SCK: out std_logic;
	AD7356_12_SDO_A: in std_logic;
	AD7356_12_SDO_B: in std_logic;
	AD7356_34_nCS: out std_logic;
	AD7356_34_SCK: out std_logic;
	AD7356_34_SDO_A: in std_logic;
	AD7356_34_SDO_B: in std_logic;
	AD7356_56_nCS: out std_logic;
	AD7356_56_SCK: out std_logic;
	AD7356_56_SDO_A: in std_logic;
	AD7356_56_SDO_B: in std_logic);
end component;

signal clk: std_logic:='0';
signal D: std_logic_vector(7 downto 0):=(others => '0'); --inout
signal WR : std_logic:='0';
signal RXF: std_logic:='0';
signal TXE: std_logic:='0';
signal CLKOUT: std_logic:='0'; --60MHz FTDI

signal FT232RL_RX: std_logic:='1';
signal FT232RL_TX: std_logic:='1';

signal rand_num_1k : integer := 0;
signal rand_num_715ps : integer := 0;
signal txe_counter: integer range 0 to 127:=0;
signal D_old_u, D_u : unsigned(11 downto 0):=(others => '0');
signal SR: std_logic_vector(15 downto 0):=(others => '0');
signal oddeven: integer := 0;
signal fail: std_logic:='0';

begin

clk <= not clk after 20 ns;
CLKOUT <= not CLKOUT after 8.333 ns;


process
    variable seed1, seed2: positive;               -- seed values for random generator
    variable rand: real;   -- random real-number value in range 0 to 1.0  
	begin
    uniform(seed1, seed2, rand);   -- generate random number
    rand_num_1k <= integer(rand*1000.0) +30;  -- rescale to 0..1000, convert integer part
	rand_num_715ps <= 1+integer(rand*6.15);
    wait for 100 ns;
end process;

stim_proc: process
begin
	wait until rising_edge(CLKOUT);
	txe_counter <= txe_counter +1;
	if txe_counter = 127 then
		wait for rand_num_715ps*1ns;
		TXE <= '1';
		wait for rand_num_1k*1ns;
		wait until rising_edge(CLKOUT);
		wait for rand_num_715ps*1ns;
		TXE <= '0';
		txe_counter <= 0;
	end if;
end process;
	
write_io: process
	file my_output : TEXT open WRITE_MODE is "file_io.txt";
	variable my_line : LINE;
	variable whatsTheTime : time;
begin		
	wait until rising_edge(CLKOUT);
	fail <= '0';
	if WR = '0' and TXE = '0' then
		D_old_u <= D_u;
		SR <= SR(7 downto 0) & D;
		if oddeven = 1 then
			if SR(8) = '1' and SR(0) = '0' then
				if SR(15 downto 14) /= "00" then
					fail <= '1';
				end if;
				D_u <= unsigned(SR(13 downto 9) & SR(7 downto 1));
				oddeven <= 0;
			else
				fail <= '1';
			end if;
		else
			oddeven <= 1;
		end if;
			
		if fail = '1' then
			whatsTheTime := now;
			write(my_line,string'("FAIL - "));
			write(my_line,to_integer(D_old_u));
			write(my_line,string'(" - "));
			write(my_line,to_integer(D_u));
			write(my_line,string'(" - "));
			write(my_line,to_integer(unsigned(SR(15 downto 8))));
			write(my_line,string'(","));
			write(my_line,to_integer(unsigned(SR(7 downto 0))));
			write(my_line,string'(","));
			write(my_line,oddeven);
			write(my_line,string'(" - "));
			write(my_line,whatsTheTime);
			writeline(output,my_line);
		end if;
	end if;
end process;

process begin --01110110 6*8+6 0 111 0
FT232RL_RX <= '1';
wait for 10 us;
FT232RL_RX <= '0';
wait for 1*1085 ns;
FT232RL_RX <= '1';
wait for 3*1085 ns;
FT232RL_RX <= '0';
wait for 3*1085 ns;
FT232RL_RX <= '1';
wait for 1*1085 ns;
FT232RL_RX <= '0';
wait for 1*1085 ns;
FT232RL_RX <= '1';
wait;
end process;

uut: TEM_uni_5_adc_stream port map(
	clk => clk,
	sysled => open,
	D => D,
	RXF => '0',
	TXE => '0',
	RD => open,
	WR => WR,
	SIWU => open,
	CLKOUT => CLKOUT, --60MHz FTDI
	OE => open,
	PWRSAV => open,
	LED_r => open,
	LED_o => open,
	-- FT232RL UART
	FT232RL_RX => FT232RL_RX,
	FT232RL_TX => FT232RL_TX,
	AD7356_12_nCS => open,
	AD7356_12_SCK => open,
	AD7356_12_SDO_A => '1',
	AD7356_12_SDO_B => '1',
	AD7356_34_nCS => open,
	AD7356_34_SCK => open,
	AD7356_34_SDO_A => '1',
	AD7356_34_SDO_B => '1',
	AD7356_56_nCS => open,
	AD7356_56_SCK => open,
	AD7356_56_SDO_A => '1',
	AD7356_56_SDO_B => '1');

end Behavioral;
