library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use ieee.numeric_std.ALL;

entity ADUM_AD7356 is Port(
	clk80 : in std_logic;
	data_ready : out std_logic;
	data_a : out std_logic_vector(11 downto 0);
	data_b : out std_logic_vector(11 downto 0);
	AD7356_nCS : out std_logic;
	AD7356_SCK : out std_logic;
	AD7356_SDO_A : in std_logic;
	AD7356_SDO_B : in std_logic);
end ADUM_AD7356;

architecture Behavioral of ADUM_AD7356 is

signal counter :unsigned(3 downto 0):=(others => '0');
signal data_buffer_a, data_buffer_b : std_logic_vector(11 downto 0):=(others => '0');

begin

AD7356_SCK <= clk80 when counter > 1 else '1';

process begin
	wait until falling_edge(clk80);
	if counter > 4 or counter < 1 then
		data_buffer_a <= data_buffer_a(10 downto 0) & AD7356_SDO_A;
		data_buffer_b <= data_buffer_b(10 downto 0) & AD7356_SDO_B;
	end if;
    
	if counter = 1 then
        data_a <= data_buffer_a;
        data_b <= data_buffer_b;
    end if;
end process;

process begin
	wait until rising_edge(clk80);
	counter <= counter +1;
	
	AD7356_nCS <= '0';
	if counter < 1 or counter > 14 then
		AD7356_nCS <= '1';
	end if;
	if counter = 2 then data_ready <= '1'; else data_ready <= '0'; end if;
end process;

end Behavioral;