; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Eine Cluster Nummer in Physischen Sektor umrechnen.							
; Die erste Cluster-Nummer im Datenberech der SD-Karte ist die 2 !!!			
;																				
; INP:	(adr_CLUSTER_DATENSATZ_NR_L)	; Datensatznummer in FAT				
;		(adr_CLUSTER_DATENSATZ_NR_H)											
; 		gltige WERTE sind 2 bis ...											
;																				
; OUT:	(adr_SD_PHYS_SEKTOR_BYTE1)												
;		(adr_SD_PHYS_SEKTOR_BYTE2)												
;		(adr_SD_PHYS_SEKTOR_BYTE3)												
;		(adr_SD_PHYS_SEKTOR_BYTE4)												
;																				
;																				
BERECHNUNG_CLUSTER_NR_IN_PHYSISCHER_SEKTOR_NR:
	; CLEAR			
	clr temp1
	clr temp2
	clr temp3
	clr temp4
	; CLUSTER NUMMER laden				
	LDS ZL,(adr_CLUSTER_DATENSATZ_NR_L)
	LDS ZH,(adr_CLUSTER_DATENSATZ_NR_H)
	; CLUSTER NUMMER aufbereiten (-2)	
	sbiw ZL,2
	; NULL-PRFUNG						
	tst ZL
	brne BERECHNUNG_CLUSTER_NR_w
	tst ZH
	brne BERECHNUNG_CLUSTER_NR_w
	rjmp BERECHNUNG_CLUSTER_NR_ww
	; SCHLEIFE (SEKTOREN pro CLUSTER mal CLUSTER NUMMER)
BERECHNUNG_CLUSTER_NR_w:
	; SEKTOREN pro CLUSTER	
	LDS temp5,(adr_FAT_SEKTOREN_PRO_CLUSTER)		
BERECHNUNG_CLUSTER_NR_s:
	add temp1,temp5
	adc temp2,NULL
	adc temp3,NULL
	adc temp4,NULL
	sbiw ZL,1
	tst ZL
	brne BERECHNUNG_CLUSTER_NR_s
	tst ZH
	brne BERECHNUNG_CLUSTER_NR_s

BERECHNUNG_CLUSTER_NR_ww:
	; START SEKTOR DATENBEREICH	
	LDS temp5,(adr_FAT_START_SEKTOR_DATENBEREICH_L)
	LDS temp6,(adr_FAT_START_SEKTOR_DATENBEREICH_H)
	clr temp7
	clr temp8
	; addieren					
	add temp1,temp5
	adc temp2,temp6
	adc temp3,temp7
	adc temp4,temp8
	; speichern	PHYSISCHER SEKTOR
	STS(adr_SD_PHYS_SEKTOR_BYTE1),temp1
	STS(adr_SD_PHYS_SEKTOR_BYTE2),temp2
	STS(adr_SD_PHYS_SEKTOR_BYTE3),temp3
	STS(adr_SD_PHYS_SEKTOR_BYTE4),temp4

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; einen leeren Cluster in der FAT suchen										
;																				
;	OUT: 	(adr_CLUSTER_NEXT_FREE_L)											
;			(adr_CLUSTER_NEXT_FREE_H)											
;																				
;	rcall NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN 	; OUT: (adr_CLUSTER_NEXT_FREE	
;																				
NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN:
	; CLUSTER_DATENSATZ_NR initialisieren
	STS (adr_CLUSTER_DATENSATZ_NR_L),NULL
	STS (adr_CLUSTER_DATENSATZ_NR_H),NULL
NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN_SCHLEIFE:
	; FAT EINTRAG auslesen, bis (x00 x00) gefunden wurde	
	WDR
	rcall FAT_TABELLE_EINTRAG_AUSLESEN 
	LDS temp1,(adr_CLUSTER_INHALT_BYTE_L)
	LDS temp2,(adr_CLUSTER_INHALT_BYTE_H)	
	; vergleich	
	tst temp1
	brne NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN_SCHLEIFE_w
	tst temp2
	brne NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN_SCHLEIFE_w
	; gefunden		
	LDS temp1,(adr_CLUSTER_DATENSATZ_NR_L)
	LDS temp2,(adr_CLUSTER_DATENSATZ_NR_H)
	; speichern		
	STS(adr_CLUSTER_NEXT_FREE_L),temp1
	STS(adr_CLUSTER_NEXT_FREE_H),temp2
	ret
NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN_SCHLEIFE_w:
	; CLUSTER_DATENSATZ_NR +1	
	LDS temp1,(adr_CLUSTER_DATENSATZ_NR_L)
	LDS temp2,(adr_CLUSTER_DATENSATZ_NR_H)
	add temp1,EINS
	adc temp2,NULL
	STS (adr_CLUSTER_DATENSATZ_NR_L),temp1
	STS (adr_CLUSTER_DATENSATZ_NR_H),temp2
	rjmp NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN_SCHLEIFE
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; eine Datei belegt einen oder mehrere Cluster, hier wird der letzt Cluster		
; einer Datei gesucht.															
; Und der letzte beschriebene Sektor im letzten Cluster							
;																				
;	OUT:	(adr_CLUSTER_ENDECLUSTER_L)											
;			(adr_CLUSTER_ENDECLUSTER_H)											
;																				
;			(adr_CLUSTER_LAST_SEKTOR)											
;																				
;			(adr_CLUSTER_LAST_BYTE_L)											
;			(adr_CLUSTER_LAST_BYTE_H)											
;																				
LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN:
;-------------------------------------------------------------------------------
; den ENDE-CLUSTER in FAT suchen												
;-------------------------------------------------------------------------------
	; INITIALISIEREN auf STARTCLUSTER			
	LDS temp1,(adr_DATEI_STARTCLUSTER_L)
	LDS temp2,(adr_DATEI_STARTCLUSTER_H)
	STS (adr_CLUSTER_DATENSATZ_NR_L),temp1
	STS (adr_CLUSTER_DATENSATZ_NR_H),temp2
LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE:
	; FAT EINTRAG auslesen, bis letzter FAT Eintrag (xFF xFF) gefunden wurde	
	WDR
	rcall FAT_TABELLE_EINTRAG_AUSLESEN 
	; AUSWERTUNG (ist es der letzte Cluster)	
	LDS temp1,(adr_CLUSTER_INHALT_BYTE_L)
	LDS temp2,(adr_CLUSTER_INHALT_BYTE_H)
	cpi temp1,255
	brne LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE_w
	cpi temp2,255
	brne LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE_w
	rjmp LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_GEFUNDEN
LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE_w:	 
	; Inhalt bernehmen und erneut FAT einlesen 
	LDS temp1,(adr_CLUSTER_INHALT_BYTE_L)
	LDS temp2,(adr_CLUSTER_INHALT_BYTE_H)
	STS(adr_CLUSTER_DATENSATZ_NR_L),temp1
	STS(adr_CLUSTER_DATENSATZ_NR_H),temp2	
	rjmp LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE		
LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_GEFUNDEN:
	; gefunden => speichern						
	LDS temp1,(adr_CLUSTER_DATENSATZ_NR_L)
	LDS temp2,(adr_CLUSTER_DATENSATZ_NR_H)
	STS(adr_CLUSTER_ENDECLUSTER_L),temp1
	STS(adr_CLUSTER_ENDECLUSTER_H),temp2
;-------------------------------------------------------------------------------
; den letzten Sector in letzten CLUSTER berechnen								
;-------------------------------------------------------------------------------
	; DATEIGRSSE lt. Directory	(z.B. 512)				
	LDS temp1,(adr_DATEI_GROESSE_BYTE1)
	LDS temp2,(adr_DATEI_GROESSE_BYTE2)
	LDS temp3,(adr_DATEI_GROESSE_BYTE3)
	LDS temp4,(adr_DATEI_GROESSE_BYTE4)
	; ANZAHL der belegten Sektoren ermitteln (durch 512 = 9x rechts)
	mov temp1,temp2	; 8 x rechts (durch  256)
	mov temp2,temp3
	mov temp3,temp4
	clr temp4
	LSR temp4		; :2
	ROR temp3	
	ROR temp2	
	ROR temp1	
	; SEKTOREN pro CLUSTER (z.B. 16)						
	LDS temp5,(adr_FAT_SEKTOREN_PRO_CLUSTER)
	; solange subtrahieren, bis Zahl negativ wird
LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE_S2:
	; SEKTOREN pro CLUSTER subtrahieren 		
	sub temp1,temp5
	sbc temp2,NULL
	sbc temp3,NULL
	sbc temp4,NULL
	; ist ZAHL negativ						
	tst temp4
	brmi LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_w
	; gleich NULL ?							
	tst temp1
	brne LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE_S2
	tst temp2
	brne LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE_S2
	tst temp3
	brne LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE_S2
	tst temp4
	brne LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_SCHLEIFE_S2

LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN_w:
	; 1 x SEKTOREN pro CLUSTER addieren		
	add temp1,temp5
	adc temp2,NULL
	adc temp3,NULL
	adc temp4,NULL
	; SPEICHERN		(Bsp: bei 511Byte=0 512BYTE=1 8192Byte=16)		
	STS(adr_CLUSTER_LAST_SEKTOR),temp1
;-------------------------------------------------------------------------------
; das letzte Byte im letzten Sector in letzten CLUSTER berechnen (sollte immer NULL sein)	
;-------------------------------------------------------------------------------
	; Dateigre laden	
	LDS temp1,(adr_DATEI_GROESSE_BYTE1)
	LDS temp2,(adr_DATEI_GROESSE_BYTE2)
	; BITMUSTER			
	andi temp2,0b00000001
	; speichern			
	STS(adr_CLUSTER_LAST_BYTE_L),temp1
	STS(adr_CLUSTER_LAST_BYTE_H),temp2
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################



