; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_BEGRUESSUNG:
	; ZEILE1	
	rcall LCD_CLEAR
	ldi ZH, high(TEXT_BEGRUESSUNG_1*2)	; TEXT 
	ldi ZL,  low(TEXT_BEGRUESSUNG_1*2)
	rcall ANZEIGE_TEXT
	; ZEILE2	
	rcall LCD_ZEILE2
	ldi ZH, high(TEXT_BEGRUESSUNG_2*2)	; TEXT 
	ldi ZL,  low(TEXT_BEGRUESSUNG_2*2)
	rcall ANZEIGE_TEXT
	; ZEILE3	
	rcall LCD_ZEILE3
	ldi ZH, high(TEXT_BEGRUESSUNG_3*2)	; TEXT	
	ldi ZL,  low(TEXT_BEGRUESSUNG_3*2)
	rcall ANZEIGE_TEXT
	; ZEILE4	
	rcall LCD_ZEILE4
	ldi ZH, high(TEXT_BEGRUESSUNG_4*2)	; TEXT 
	ldi ZL,  low(TEXT_BEGRUESSUNG_4*2)
	rcall ANZEIGE_TEXT
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_HAUPT_MENUE:
	; ZEILE1	
	rcall LCD_CLEAR
	; ZEIT		
	rcall ANZEIGE_ZEIT_KURZ
	; DATEIGRSSE				
	rcall ANZEIGE_DATEIGROESSE_KURZ

	; ZEILE2	
	rcall LCD_ZEILE2
	rcall ANZEIGE_DATUM_KURZ
	; Datensatznummer	
	LDS temp1,(adr_DATEN_DATENSATZNUMMER_L)
	LDS temp2,(adr_DATEN_DATENSATZNUMMER_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_8_STELLEN_KURZ


	; ZEILE3	
	rcall LCD_ZEILE3
	; ZEILE4	
	rcall LCD_ZEILE4
	; ADC4
	LDS temp1,(adr_ADC_4_L)
	LDS temp2,(adr_ADC_4_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_8_STELLEN_KURZ
	rcall LCD_SPACE
	; ADC5
	LDS temp1,(adr_ADC_5_L)
	LDS temp2,(adr_ADC_5_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_8_STELLEN_KURZ


ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_FAT_INFO:
	; ZEILE1	
	rcall LCD_CLEAR
	; BYTES pro SEKTOR		
	ldi temp, 'B'
	rcall LCD_DATA
	ldi temp, '/'
	rcall LCD_DATA
	ldi temp, 'S'
	rcall LCD_DATA
	rcall LCD_DOPPEL_PUNKT	; ":"
	LDS temp1,(adr_FAT_BYTES_PRO_SEKTOR_L)
	LDS temp2,(adr_FAT_BYTES_PRO_SEKTOR_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
	rcall LCD_SPACE
	rcall LCD_SPACE
	; SEKTOREN pro CLUSTER	
	ldi temp, 'S'
	rcall LCD_DATA
	ldi temp, '/'
	rcall LCD_DATA
	ldi temp, 'C'
	rcall LCD_DATA
	rcall LCD_DOPPEL_PUNKT	; ":"
	LDS temp1,(adr_FAT_SEKTOREN_PRO_CLUSTER)
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
;-------------------------------------------------------------------------------
	; ZEILE2	
	rcall LCD_ZEILE2
	; Anzahl reservierte Sektoren	
	ldi temp, 'R'
	rcall LCD_DATA
	ldi temp, 'S'
	rcall LCD_DATA
	rcall LCD_DOPPEL_PUNKT	; ":"
	LDS temp1,(adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_L)
	LDS temp2,(adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
	rcall LCD_SPACE

	; Anzahl FAT KOPIEN					
	LDS temp1,(adr_FAT_KOPIEN)
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_AUSGABE_ZAHL_1_STELLEN_KURZ
	rcall LCD_SPACE
	; SEKTOREN pro FAT					
	ldi temp, 'S'
	rcall LCD_DATA
	ldi temp, '/'
	rcall LCD_DATA
	ldi temp, 'F'
	rcall LCD_DATA
	rcall LCD_DOPPEL_PUNKT	; ":"
	LDS temp1,(adr_FAT_SEKTOREN_PRO_FAT_L)
	LDS temp2,(adr_FAT_SEKTOREN_PRO_FAT_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
;-------------------------------------------------------------------------------
	; ZEILE3	
	rcall LCD_ZEILE3
	; START_SEKTOR FAT 1				
	ldi temp, 'S'
	rcall LCD_DATA
	ldi temp, 'F'
	rcall LCD_DATA
	ldi temp, '1'
	rcall LCD_DATA
	rcall LCD_DOPPEL_PUNKT	; ":"

	LDS temp1,(adr_FAT_START_SEKTOR_FAT_1_L)
	LDS temp2,(adr_FAT_START_SEKTOR_FAT_1_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
	rcall LCD_SPACE
	rcall LCD_SPACE
	; START_SEKTOR FAT 2				
	ldi temp, 'S'
	rcall LCD_DATA
	ldi temp, 'F'
	rcall LCD_DATA
	ldi temp, '2'
	rcall LCD_DATA
	rcall LCD_DOPPEL_PUNKT	; ":"

	LDS temp1,(adr_FAT_START_SEKTOR_FAT_2_L)
	LDS temp2,(adr_FAT_START_SEKTOR_FAT_2_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
;-------------------------------------------------------------------------------
	; ZEILE4	
	rcall LCD_ZEILE4
	; START_SEKTOR ROOT-DIRECTOTY		
	ldi temp, 'S'
	rcall LCD_DATA
	ldi temp, 'R'
	rcall LCD_DATA
	ldi temp, 'D'
	rcall LCD_DATA
	rcall LCD_DOPPEL_PUNKT	; ":"

	LDS temp1,(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_L)
	LDS temp2,(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
	rcall LCD_SPACE
	rcall LCD_SPACE
	; START_SEKTOR DATENBEREICH			
	ldi temp, 'S'
	rcall LCD_DATA
	ldi temp, 'D'
	rcall LCD_DATA
	ldi temp, 'A'
	rcall LCD_DATA
	rcall LCD_DOPPEL_PUNKT	; ":"

	LDS temp1,(adr_FAT_START_SEKTOR_DATENBEREICH_L)
	LDS temp2,(adr_FAT_START_SEKTOR_DATENBEREICH_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_DIRECTORY_EINZELNER_DATENSATZ:
	; ZEILE1	
	rcall LCD_CLEAR
	LDS temp,(adr_DATEI_NAME_BYTE1)
	rcall LCD_DATA
	LDS temp,(adr_DATEI_NAME_BYTE2)
	rcall LCD_DATA
	LDS temp,(adr_DATEI_NAME_BYTE3)
	rcall LCD_DATA
	LDS temp,(adr_DATEI_NAME_BYTE4)
	rcall LCD_DATA
	LDS temp,(adr_DATEI_NAME_BYTE5)
	rcall LCD_DATA
	LDS temp,(adr_DATEI_NAME_BYTE6)
	rcall LCD_DATA
	LDS temp,(adr_DATEI_NAME_BYTE7)
	rcall LCD_DATA
	LDS temp,(adr_DATEI_NAME_BYTE8)
	rcall LCD_DATA

	; DATEIGRSSE				
	rcall ANZEIGE_DATEIGROESSE_KURZ

	; ZEILE2 
	rcall LCD_ZEILE2
	; START_CLUSTER		
	ldi temp, 'S'
	rcall LCD_DATA
	ldi temp, 'C'
	rcall LCD_DATA
	LDS temp1,(adr_DATEI_STARTCLUSTER_L)
	LDS temp2,(adr_DATEI_STARTCLUSTER_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_6_STELLEN_KURZ
	rcall LCD_SPACE



	; ZEILE3 
	rcall LCD_ZEILE3
	; letzter CLUSTER der Datei lt. FAT + Directory
	ldi temp, 'L'
	rcall LCD_DATA
	ldi temp, 'C'
	rcall LCD_DATA
	LDS temp1,(adr_CLUSTER_ENDECLUSTER_L)
	LDS temp2,(adr_CLUSTER_ENDECLUSTER_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_6_STELLEN_KURZ
	rcall LCD_SPACE

	; letzter beschriebene Sektor im letzten Cluster der Datei lt. FAT + Directory	
	ldi temp, 'L'
	rcall LCD_DATA
	ldi temp, 'S'
	rcall LCD_DATA

	LDS temp1,(adr_CLUSTER_LAST_SEKTOR)
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ

	; ZEILE4 
	rcall LCD_ZEILE4
	; nchster LEERE CLUSTER in der FAT			
	ldi temp, 'F'
	rcall LCD_DATA
	ldi temp, 'C'
	rcall LCD_DATA

	LDS temp1,(adr_CLUSTER_NEXT_FREE_L)
	LDS temp2,(adr_CLUSTER_NEXT_FREE_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_6_STELLEN_KURZ
	rcall LCD_SPACE

	ldi temp, 'L'
	rcall LCD_DATA
	ldi temp, 'B'
	rcall LCD_DATA

	LDS temp1,(adr_CLUSTER_LAST_BYTE_L)
	LDS temp2,(adr_CLUSTER_LAST_BYTE_H)
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_3_STELLEN_KURZ


ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_DATEIGROESSE_KURZ:
	; DATEIGRSSE				
	LDS temp1,(adr_DATEI_GROESSE_BYTE1)
	LDS temp2,(adr_DATEI_GROESSE_BYTE2)
	LDS temp3,(adr_DATEI_GROESSE_BYTE3)
	LDS temp4,(adr_DATEI_GROESSE_BYTE4)
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_FORMAT
	rcall LCD_AUSGABE_ZAHL_8_STELLEN_KURZ
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_ZEIT_KURZ:
	; ZEIT	
	LDS temp1,(adr_hh)
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_AUSGABE_ZAHL_2_STELLEN_KURZ	

	rcall LCD_DOPPEL_PUNKT

	; MINUTE	
	LDS temp1,(adr_mm)
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_AUSGABE_ZAHL_2_STELLEN_KURZ	

	rcall LCD_DOPPEL_PUNKT

	; SEKUNDE	
	LDS temp1,(adr_ss)
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_AUSGABE_ZAHL_2_STELLEN_KURZ	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ANZEIGE_DATUM_KURZ:
	; ZEIT	
	LDS temp1,(adr_TAG)
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_AUSGABE_ZAHL_2_STELLEN_KURZ	

	rcall LCD_PUNKT

	; MINUTE	
	LDS temp1,(adr_MONAT)
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_AUSGABE_ZAHL_2_STELLEN_KURZ	

	rcall LCD_PUNKT

	; SEKUNDE	
	LDS temp1,(adr_JAHR)
	clr temp2
	clr temp3
	clr temp4
	rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8
	rcall LCD_AUSGABE_ZAHL_2_STELLEN_KURZ	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INPUT: TEMP1																	
ANZEIGE_2_STELLEN_HEX_ASC:
	clr temp2
	clr temp3
	clr temp4
 	rcall FUNKTION_HEX_ASC_32				; INPUT: temp1...4 OUTPUT: Temp1...8			
	rcall LCD_AUSGABE_ZAHL_2_STELLEN_KURZ
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
; INPUT: TEMP1...TEMP8													  
; rcall LCD_AUSGABE_ZAHL_8_STELLEN_KURZ	; INP: TEMP1...8				  
LCD_AUSGABE_ZAHL_9_STELLEN_KURZ:
	mov temp, temp9			; 9.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_8_STELLEN_KURZ:
	mov temp, temp8			; 8.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_7_STELLEN_KURZ:
	mov temp, temp7			; 7.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_6_STELLEN_KURZ:
	mov temp, temp6			; 6.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_5_STELLEN_KURZ:
	mov temp, temp5			; 5.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_4_STELLEN_KURZ:
	mov temp, temp4			; 4.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_3_STELLEN_KURZ:
	mov temp, temp3			; 3.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_2_STELLEN_KURZ:
	mov temp, temp2			; 2.ZEICHEN 
	rcall LCD_DATA	
LCD_AUSGABE_ZAHL_1_STELLEN_KURZ:
	mov temp, temp1			; 1.ZEICHEN (1-er Stelle)	
	rcall LCD_DATA
ret
;######################################################################## 	
;######################################################################## 	
;######################################################################## 	
; formatiert die LCD AUSGABE mit 1000-er Punkt								
; 	Bsp. "00012345 => "___12.345"											
;	INPUT/Output TEMP1														
;	INPUT/Output TEMP2														
;	INPUT/Output TEMP3														
;	INPUT/Output TEMP4														
;	INPUT/Output TEMP5														
;	INPUT/Output TEMP6														
; 	INPUT/Output TEMP8														
; 	      Output TEMP9														
LCD_FORMAT:
;   1000-er Trennzeichen einfgen	
	mov temp9,temp7
	ldi temp8,'.'
	mov temp7,temp6
	mov temp6,temp5
	mov temp5,temp4
	ldi temp4,'.'
; Nullstellen-Unterdrckung			
	cpi temp9, '0'
	brne LCD_FORMAT_fertig
	ldi temp9, '_'
	ldi temp8, '_'
	cpi temp7, '0'
	brne LCD_FORMAT_fertig
	ldi temp7, '_'
	cpi temp6, '0'
	brne LCD_FORMAT_fertig
	ldi temp6, '_'
	cpi temp5, '0'
	brne LCD_FORMAT_fertig
	ldi temp5, '_'
	ldi temp4, '_'
	cpi temp3, '0'
	brne LCD_FORMAT_fertig
	ldi temp3, '_'
	cpi temp2, '0'
	brne LCD_FORMAT_fertig
	ldi temp2, '_'
	cpi temp1, '0'
	brne LCD_FORMAT_fertig
	ldi temp1, '_'
LCD_FORMAT_fertig:
ret
;######################################################################## 	
;########################################################################	
;######################################################################## 	
;																			
;	Value: 0...	99.999.999													
;																			
;	INPUT: 	temp1	(BYTE1)													
;	 		temp2	(BYTE2)													
;			temp3	(BYTE3)													
;			temp4	(BYTE4)													
;																			
;	OUTPUT:	temp1	(		   1-er Stelle)									
;			temp2	(		  10-er Stelle)									
;			temp3	(        100-er Stelle)									
;			temp4	(      1.000-er Stelle)									
;			temp5	(     10.000-er Stelle)									
;			temp6	(    100.000-er Stelle)									
;			temp7	(  1.000.000-er Stelle)									
;			temp8	( 10.000.000-er Stelle)									
; 																			
; rcall FUNKTION_HEX_ASC_32	; INPUT: temp1...4 OUTPUT: Temp1...8			
; 																			
FUNKTION_HEX_ASC_32:
	clr temp
FUNKTION_HEX_ASC_10000000:; 10.000.000
	inc temp
	subi temp1, BYTE1    (10000000)
	sbci temp2, BYTE2    (10000000)
	sbci temp3, BYTE3    (10000000)
	sbci temp4, BYTE4    (10000000)
	brcc FUNKTION_HEX_ASC_10000000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp8) auf dem Stack sichern            
	subi temp1, BYTE1   (-10000000)
	sbci temp2, BYTE2   (-10000000)
	sbci temp3, BYTE3   (-10000000)
	sbci temp4, BYTE4   (-10000000)
	clr temp
FUNKTION_HEX_ASC_1000000:
	inc temp
	subi temp1, BYTE1    (1000000)
	sbci temp2, BYTE2    (1000000)
	sbci temp3, BYTE3    (1000000)
	brcc FUNKTION_HEX_ASC_1000000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp7) auf dem Stack sichern            
	subi temp1, BYTE1   (-1000000)
	sbci temp2, BYTE2   (-1000000)
	sbci temp3, BYTE3   (-1000000)
	clr temp
FUNKTION_HEX_ASC_100000:
	inc temp
	subi temp1, BYTE1    (100000)
	sbci temp2, BYTE2    (100000)
	sbci temp3, BYTE3    (100000)
	brcc FUNKTION_HEX_ASC_100000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp6) auf dem Stack sichern            
	subi temp1, BYTE1   (-100000)
	sbci temp2, BYTE2   (-100000)
	sbci temp3, BYTE3   (-100000)
	clr temp
FUNKTION_HEX_ASC_10000:
	inc temp
	subi temp1, BYTE1    (10000)
	sbci temp2, BYTE2    (10000)
	sbci temp3, BYTE3    (10000)
	brcc FUNKTION_HEX_ASC_10000
	dec  temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp5) auf dem Stack sichern            
	subi temp1, BYTE1  (-10000)
	sbci temp2, BYTE2  (-10000)
	sbci temp3, BYTE3  (-10000)
	clr temp
FUNKTION_HEX_ASC_1000:
	inc temp
	subi temp1, low  (1000)
	sbci temp2, HIGH (1000)
	brcc FUNKTION_HEX_ASC_1000
	dec temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp4) auf dem Stack sichern            
	subi temp1, low  (-1000)
	sbci temp2, HIGH (-1000)
	clr temp
FUNKTION_HEX_ASC_100:
	inc temp
	subi temp1, low  (100)
	sbci temp2, HIGH (100)
	brcc FUNKTION_HEX_ASC_100
	dec temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp3) auf dem Stack sichern            
	subi temp1, low  (-100)
	sbci temp2, HIGH (-100)
	clr temp
FUNKTION_HEX_ASC_10:
	inc temp
	subi temp1, low  (10)
	sbci temp2, HIGH (10)
	brcc FUNKTION_HEX_ASC_10
	dec temp
	subi temp, -48		; HEX->ASC
	push temp           ; temp (wird temp2) auf dem Stack sichern            
	subi temp1, low  (-10)
	sbci temp2, HIGH (-10)
FUNKTION_HEX_ASC_1:	
	subi temp1, -48		; HEX->ASC

	pop	TEMP2			; LESEN vom STACK (KOPIE)
	pop	TEMP3			; LESEN vom STACK (KOPIE)
	pop	TEMP4			; LESEN vom STACK (KOPIE)
	pop	TEMP5			; LESEN vom STACK (KOPIE)
	pop	TEMP6			; LESEN vom STACK (KOPIE)
	pop	TEMP7			; LESEN vom STACK (KOPIE)
	pop	TEMP8			; LESEN vom STACK (KOPIE)
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Initialisierung: muss ganz am Anfang des Programms aufgerufen werden
LCD_INITIALISIERUNG:
 
	ldi temp, 0b00000011        ;muss 3mal hintereinander gesendet werden zur Initialisierung
	rcall LCD_COMMAND
	rcall wait5ms
	rcall LCD_COMMAND
	rcall wait5ms
	rcall LCD_COMMAND
	rcall wait5ms

    ldi temp, 0b00000010        ;4bit-Modus einstellen
	rcall LCD_COMMAND
	rcall wait5ms

    ldi temp, 0b00000001        ; DISPLAY lschen			
 	rcall LCD_COMMAND
	rcall wait5ms
    ldi temp, 0b00001111        ; DISPLAY ein / CURSOR blinken
	rcall LCD_COMMAND
	rcall wait5ms
    ldi temp, 0b00000110        ; Cursor Auto-Increment
 	rcall LCD_COMMAND
	rcall wait5ms


ret
;######################################################################## 
;######################################################################## 
;																		  
;erzeugt den Enable-Puls												  
;																		  
LCD_ENABLE:
           sbi LCD_E_PORT, LCD_E       ; Enable high		
 		   rcall wait50us              ; kurze PAUSE		
		   cbi LCD_E_PORT, LCD_E       ; Enable low			
 		   rcall wait50us              ; kurze PAUSE		
ret                          
;######################################################################## 
;######################################################################## 
;######################################################################## 
; sendet ein Datenbyte an das LCD										  
;																		  
; INPUT: temp															  
;																		  
; rcall LCD_DATA			; DATENBYTE an LCD inp: temp 				  
;																		  
LCD_DATA:
	push temp             	; "Sicherungskopie" 			
	push temp             	; "Sicherungskopie" 			
    swap temp               ; Vertauschen					
   	andi temp, 0b00001111   ; oberes Nibble auf Null setzen	
	out LCD_PORT,temp		; ausgeben						
    
	sbi LCD_RS_PORT, LCD_RS ; RS ein (high)					
	rcall lcd_enable        ; Enable-Routine aufrufen		
                         
    pop temp				; Kopie wieder laden	 		
   	andi temp, 0b00001111   ; oberes Nibble auf Null setzen	
	out LCD_PORT,temp		; ausgeben						
   
    sbi LCD_RS_PORT, LCD_RS ; RS ein  (high)	     		
	rcall lcd_enable        ; Enable-Routine aufrufen		
    pop temp				; Kopie wieder laden	 		
ret				                       
;######################################################################## 
;######################################################################## 
;######################################################################## 
;sendet einen Befehl an das LCD;wie lcd_data, nur ohne RS zu setzen		  
;																		  
; INPUT: temp															  
;																		  
LCD_COMMAND:                            
    push temp				; "Sicherungskopie" 			
    push temp				; "Sicherungskopie" 			
    swap temp				; Vertauschen					
    andi temp, 0b00001111   ; oberes Nibble auf Null setzen	
	out LCD_PORT,temp		; ausgeben						

    cbi LCD_RS_PORT, LCD_RS ; RS aus (low)					
	rcall lcd_enable		; Enable-Routine aufrufen		
           
	pop temp				; Kopie wieder laden			
  	andi temp, 0b00001111   ; oberes Nibble auf Null setzen	
	out LCD_PORT,temp		; ausgeben						
           
	cbi LCD_RS_PORT, LCD_RS ; RS aus (low)       			
	rcall lcd_enable		; Enable-Routine aufrufen		
	rcall wait5ms			; Pause (wichtig)				
    pop temp				; Kopie wieder laden	 		
ret
;######################################################################## 
;########################################################################
;######################################################################## 
ANZEIGE_TEXT:
	LPM temp, Z+   			; aus Tabelle laden und Zeiger um 1 erhhen	
	tst temp  			
	breq ANZEIGE_TEXT_e 	; Sprung	
	rcall LCD_DATA			; Anzeige	
	rjmp ANZEIGE_TEXT
	ANZEIGE_TEXT_e:
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
; Display lschen														  
LCD_CLEAR:
   	ldi temp, 0b00000001
    rcall lcd_command
ret
;######################################################################## 
; KURSOR GO-HOME														  
LCD_GO_HOME:
 	ldi temp, 0b00000010
	rcall lcd_command 
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
; KURSOR Sprung in ZEILE2
LCD_ZEILE2:
 			ldi temp, 0b11000000 
			rcall lcd_command 
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_ZEILE3:
	ldi temp, 0b10010000 
	rcall lcd_command 
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_ZEILE4:
	ldi temp, 0b11010000 
	rcall lcd_command 
ret
;######################################################################## 
;########################################################################
;######################################################################## 
LCD_SPACE:
	ldi temp, ' '		; SPACE
	rcall LCD_DATA	
ret
;######################################################################## 
;########################################################################
;######################################################################## 
LCD_PUNKT:
	ldi temp, '.'		; PUNKT
	rcall LCD_DATA	
ret
;######################################################################## 
;########################################################################
;######################################################################## 
LCD_3_PUNKT:
	ldi temp, '.'		; PUNKT
	rcall LCD_DATA	
	rcall LCD_DATA	
	rcall LCD_DATA	
ret
;######################################################################## 
;########################################################################
;######################################################################## 
LCD_DOPPEL_PUNKT:
	ldi temp, ':'		; DOPPELPUNKT
	rcall LCD_DATA	
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_TEXT_OK:
	rcall LCD_SPACE
	ldi temp, 'O'		; DOPPELPUNKT
	rcall LCD_DATA	
	ldi temp, 'K'		; DOPPELPUNKT
	rcall LCD_DATA	
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 
LCD_TEXT_ERROR:
	ldi temp, 'E'
	rcall LCD_DATA
	ldi temp, 'R'
	rcall LCD_DATA
	ldi temp, 'R'
	rcall LCD_DATA
	ldi temp, 'O'
	rcall LCD_DATA
	ldi temp, 'R'
	rcall LCD_DATA
	rcall wait_1s
ret
;######################################################################## 
;######################################################################## 
;######################################################################## 