; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
;	OUT:	(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_L)								
;			(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_H)								
;																				
MASTER_BOOTSEKTOR_EINLESEN_UND_AUSWERTEN:
	; SEKTOR 0								
	STS(adr_SD_PHYS_SEKTOR_BYTE1),NULL
	STS(adr_SD_PHYS_SEKTOR_BYTE2),NULL
	STS(adr_SD_PHYS_SEKTOR_BYTE3),NULL
	STS(adr_SD_PHYS_SEKTOR_BYTE4),NULL
	; SEKTOR einlesen und im SRAM ablegen	
	rcall SD_CMD17			

	; Anzahl reservierte Sektoren (BOOT) herausfiltern		
	LDS temp1,(adr_SD_DATEN+0x1C6)
	LDS temp2,(adr_SD_DATEN+0x1C7)
	STS(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_L),temp1
	STS(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_H),temp2
	; FEHLERPRFUNG							
	LDS temp,(adr_SD_DATEN+0x1FE)
	; vergleich	x55							
	cpi temp,0x55
	brne BOOTSEKTOR_EINLESEN_FEHLER
	; FEHLERPRFUNG							
	LDS temp,(adr_SD_DATEN+0x1FF)
	; vergleich	xAA							
	cpi temp,0xAA
	brne BOOTSEKTOR_EINLESEN_FEHLER
	ret
;-------------------------------------------------------------------------------
BOOTSEKTOR_EINLESEN_FEHLER:
	; TEXT ERROR		
	rcall LCD_TEXT_ERROR

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
;	INP:	(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_L)								
;			(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_H)								
;																				
;	OUT:	(adr_FAT_BYTES_PRO_SEKTOR_L)										
;			(adr_FAT_BYTES_PRO_SEKTOR_H)										
;																				
;			(adr_FAT_SEKTOREN_PRO_CLUSTER)										
;																				
;			(adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_L)								
;			(adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_H)								
;																				
;			(adr_FAT_SEKTOREN_PRO_FAT_L)										
;			(adr_FAT_SEKTOREN_PRO_FAT_H)										
;																				
;			(adr_FAT_START_SEKTOR_FAT_1_L)										
;			(adr_FAT_START_SEKTOR_FAT_1_H)										
;																				
;			(adr_FAT_START_SEKTOR_FAT_2_L)										
;			(adr_FAT_START_SEKTOR_FAT_2_H)										
;																				
;			(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_L)								
;			(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_H)								
;																				
;			(adr_FAT_START_SEKTOR_DATENBEREICH_L)								
;			(adr_FAT_START_SEKTOR_DATENBEREICH_H)								
;																				
;																				
VOLUME_BOOT_SEKTOR_EINLESEN_UND_AUSWERTEN:
	; SEKTOR								
	LDS temp1,(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_L)
	LDS temp2,(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_H)
	STS(adr_SD_PHYS_SEKTOR_BYTE1),temp1
	STS(adr_SD_PHYS_SEKTOR_BYTE2),temp2
	STS(adr_SD_PHYS_SEKTOR_BYTE3),NULL
	STS(adr_SD_PHYS_SEKTOR_BYTE4),NULL
	; SEKTOR einlesen und im SRAM ablegen	
	rcall SD_CMD17			
	; ANZAHL BYTES pro SEKTOR herausfiltern	
	LDS temp1,(adr_SD_DATEN+0x0B)
	LDS temp2,(adr_SD_DATEN+0x0C)
	STS(adr_FAT_BYTES_PRO_SEKTOR_L),temp1
	STS(adr_FAT_BYTES_PRO_SEKTOR_H),temp2
	; ANZAHL SEKTOREN pro CLUSTER herausfiltern	
	LDS temp1,(adr_SD_DATEN+0xD)
	STS(adr_FAT_SEKTOREN_PRO_CLUSTER),temp1
	; Anzahl reservierte Sektoren (VOLUME-BOOT) herausfiltern
	LDS temp1,(adr_SD_DATEN+0x0E)
	LDS temp2,(adr_SD_DATEN+0x0F)
	STS(adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_L),temp1
	STS(adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_H),temp2
	; Anzahl FAT KOPIEN herausfiltern		
	LDS temp1,(adr_SD_DATEN+0x10)
	STS(adr_FAT_KOPIEN),temp1
	; ANZAHL SEKTOREN pro FAT herausfiltern 
	LDS temp1,(adr_SD_DATEN+0x16)
	LDS temp2,(adr_SD_DATEN+0x17)	
	STS(adr_FAT_SEKTOREN_PRO_FAT_L),temp1
	STS(adr_FAT_SEKTOREN_PRO_FAT_H),temp2
;-------------------------------------------------------------------------------
	; BERECHNUNG STARTSEKTOR FAT1 	
	LDS temp1,(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_L)
	LDS temp2,(adr_FAT_RESERVIERTE_SEKTOREN_BOOT_H)
	LDS temp3,(adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_L)
	LDS temp4,(adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_H)
	add temp1,temp3
	adc temp2,temp4
	STS(adr_FAT_START_SEKTOR_FAT_1_L),temp1
	STS(adr_FAT_START_SEKTOR_FAT_1_H),temp2
	; BERECHNUNG STARTSEKTOR FAT2 	
	LDS temp1,(adr_FAT_START_SEKTOR_FAT_1_L)
	LDS temp2,(adr_FAT_START_SEKTOR_FAT_1_H)
	LDS temp3,(adr_FAT_SEKTOREN_PRO_FAT_L)
	LDS temp4,(adr_FAT_SEKTOREN_PRO_FAT_H)
	; Schleife	
	LDS temp,(adr_FAT_KOPIEN)
	; kleiner 2 ?
	cpi temp,2
	brlo VOLUME_BOOT_SEKTOR_EINLESEN_F2S
	dec temp
VOLUME_BOOT_SEKTOR_EINLESEN_F2:
	add temp1,temp3
	adc temp2,temp4
	dec temp
	brne VOLUME_BOOT_SEKTOR_EINLESEN_F2
	; speichern	
VOLUME_BOOT_SEKTOR_EINLESEN_F2S:
	STS(adr_FAT_START_SEKTOR_FAT_2_L),temp1
	STS(adr_FAT_START_SEKTOR_FAT_2_H),temp2
	; BERECHNUNG STARTSEKTOR ROOT DIREKTORY	
	LDS temp1,(adr_FAT_START_SEKTOR_FAT_2_L)
	LDS temp2,(adr_FAT_START_SEKTOR_FAT_2_H)
	LDS temp3,(adr_FAT_SEKTOREN_PRO_FAT_L)
	LDS temp4,(adr_FAT_SEKTOREN_PRO_FAT_H)
	add temp1,temp3
	adc temp2,temp4
	STS(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_L),temp1
	STS(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_H),temp2
	; BERECHNUNG STARTSEKTOR DATENBEREICH	
	LDS temp1,(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_L)
	LDS temp2,(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_H)
	; + 32 Sektoren
	ldi temp3, low(32)
	ldi temp4,HIGH(32)
	add temp1,temp3
	adc temp2,temp4
	STS(adr_FAT_START_SEKTOR_DATENBEREICH_L),temp1
	STS(adr_FAT_START_SEKTOR_DATENBEREICH_H),temp2
	
;-------------------------------------------------------------------------------
	; FEHLERPRFUNG	vergleich "F"	
	LDS temp,(adr_SD_DATEN+0x36)
	cpi temp,'F'
	brne VOLUME_BOOT_SEKTOR_EINLESEN_FEHLER
	; FEHLERPRFUNG	vergleich "A"	
	LDS temp,(adr_SD_DATEN+0x37)
	cpi temp,'A'
	brne VOLUME_BOOT_SEKTOR_EINLESEN_FEHLER
	; FEHLERPRFUNG	vergleich "T"	
	LDS temp,(adr_SD_DATEN+0x38)
	cpi temp,'T'
	brne VOLUME_BOOT_SEKTOR_EINLESEN_FEHLER
	; FEHLERPRFUNG	vergleich x55	
	LDS temp,(adr_SD_DATEN+0x1FE)
	cpi temp,0x55
	brne VOLUME_BOOT_SEKTOR_EINLESEN_FEHLER
	; FEHLERPRFUNG	vergleich xAA	
	LDS temp,(adr_SD_DATEN+0x1FF)
	cpi temp,0xAA
	brne VOLUME_BOOT_SEKTOR_EINLESEN_FEHLER
ret
;-------------------------------------------------------------------------------
VOLUME_BOOT_SEKTOR_EINLESEN_FEHLER:
	; TEXT ERROR		
	rcall LCD_TEXT_ERROR

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
;	OUT:	FEHLER_CODE															
;																				
FAT_EINLESEN_UND_AUSWERTEN:
	; Sektir laden		
	LDS temp1,(adr_FAT_START_SEKTOR_FAT_1_L)
	LDS temp2,(adr_FAT_START_SEKTOR_FAT_1_H)
	; sektor speichern	
	STS(adr_SD_PHYS_SEKTOR_BYTE1),temp1
	STS(adr_SD_PHYS_SEKTOR_BYTE2),temp2
	STS(adr_SD_PHYS_SEKTOR_BYTE3),NULL
	STS(adr_SD_PHYS_SEKTOR_BYTE4),NULL
	; SEKTOR einlesen und im SRAM ablegen	
	rcall SD_CMD17	; INP: 	(adr_SD_PHYS_SEKTOR_BYTE)
	; FEHLERPRFUNG	vergleich xF8	
	LDS temp,(adr_SD_DATEN+0)
	cpi temp,(0xF8)
	brne FAT_EINLESEN_FEHLER
	; FEHLERPRFUNG	vergleich xFF	
	LDS temp,(adr_SD_DATEN+1)
	cpi temp,(0xFF)
	brne FAT_EINLESEN_FEHLER
	; FEHLERPRFUNG	vergleich xFF	
	LDS temp,(adr_SD_DATEN+2)
	cpi temp,(0xFF)
	brne FAT_EINLESEN_FEHLER
	; FEHLERPRFUNG	vergleich xFF	
	LDS temp,(adr_SD_DATEN+3)
	cpi temp,(0xFF)
	brne FAT_EINLESEN_FEHLER
	ret
FAT_EINLESEN_FEHLER:
	; TEXT ERROR		
	rcall LCD_TEXT_ERROR

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Die Direktory besteht aus 32 Sektoren. Ein Eintrag (Datensatz)				
; in der Directory besteht aus 32 Bytes 										
;																				
; INP: 	  (adr_FAT_DIREKTORY_DATENSATZ_NR_L)									
;		  (adr_FAT_DIREKTORY_DATENSATZ_NR_H)									
;																				
; OUT:	  (adr_DATEI_NAME_BYTE1)	; Dateinname								
;		  (adr_DATEI_NAME_BYTE2)												
;		  (adr_DATEI_NAME_BYTE3)												
;		  (adr_DATEI_NAME_BYTE4)												
;		  (adr_DATEI_NAME_BYTE5)												
;		  (adr_DATEI_NAME_BYTE6)												
;		  (adr_DATEI_NAME_BYTE7)												
;		  (adr_DATEI_NAME_BYTE8)												
;		  (adr_DATEI_ERWEITERUNG_BYTE1)	; Dateierweiterung						
;		  (adr_DATEI_ERWEITERUNG_BYTE2)											
;		  (adr_DATEI_ERWEITERUNG_BYTE3)											
;		  (adr_DATEI_ATTRIBUTE)			; Dateiattribute						
;		  (adr_DATEI_NTRES)				; fr WIN NT (sollte immer Null sein)	
;		  (adr_DATEI_TIME_TENTH)		; Millisekunden							
;		  (adr_DATEI_TIME_BYTE1)		; Zeit der Erstellung					
;		  (adr_DATEI_TIME_BYTE2)												
;		  (adr_DATEI_DATE_BYTE1)		; Datum der Erstellung					
;		  (adr_DATEI_DATE_BYTE2)												
;		  (adr_DATEI_LST_DATE_BYTE1)	; Datum des letzten Zugriffs			
;		  (adr_DATEI_LST_DATE_BYTE2)											
;		  (adr_DATEI_FST_CLUS_HI_BYTE1)	; sollte immer NULL sein				
;		  (adr_DATEI_FST_CLUS_HI_BYTE2)											
;		  (adr_DATEI_WRT_TIME_BYTE1)	; Zeit des letzten Schreibvorgangs		
;		  (adr_DATEI_WRT_TIME_BYTE2)											
;		  (adr_DATEI_WRT_DATE_BYTE1)	; Datum des letzten Schreibvorgangs		
;		  (adr_DATEI_WRT_DATE_BYTE2)											
;		  (adr_DATEI_STARTCLUSTER_L)	; START-CLUSTER lt. Directory			
;		  (adr_DATEI_STARTCLUSTER_H)											
;		  (adr_DATEI_GROESSE_BYTE1)		; DATEI-Gre lt. Directory				
;		  (adr_DATEI_GROESSE_BYTE2)												
;		  (adr_DATEI_GROESSE_BYTE3)												
;		  (adr_DATEI_GROESSE_BYTE4)												
;																				
DIRECTORY_DATENSATZ_AUSLESEN:
	; DATENSATZ-NR laden	
	LDS temp1,(adr_FAT_DIREKTORY_DATENSATZ_NR_L)
	LDS temp2,(adr_FAT_DIREKTORY_DATENSATZ_NR_H)
	; durch 16 (16 Datenstze pro Sektor)	
	LSR temp2
	ROR temp1
	LSR temp2
	ROR temp1
	LSR temp2
	ROR temp1
	LSR temp2
	ROR temp1
	; START_SEKTOR_ROOT_DIRECTORY laden	
	LDS temp3,(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_L)
	LDS temp4,(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_H)
	; addieren							
	add temp1,temp3
	adc temp2,temp4
	clr temp3
	clr temp4
	; speichern					
	STS(adr_SD_PHYS_SEKTOR_BYTE1),temp1
	STS(adr_SD_PHYS_SEKTOR_BYTE2),temp2
	STS(adr_SD_PHYS_SEKTOR_BYTE3),temp3
	STS(adr_SD_PHYS_SEKTOR_BYTE4),temp4
	;###########################
	; SEKTOR einlesen			
	rcall SD_CMD17	
	; Z-initialisieren			
	ldi ZL, low(adr_SD_DATEN)
	ldi ZH,high(adr_SD_DATEN)
	; DATENSATZ-NR laden 		
	LDS temp1,(adr_FAT_DIREKTORY_DATENSATZ_NR_L)
	LDS temp2,(adr_FAT_DIREKTORY_DATENSATZ_NR_H)
	; BITMUSTER					
	andi temp1,0b00001111
	andi temp2,0b00000000
	; mal 32					
	LSL temp1
	ROL temp2
	LSL temp1
	ROL temp2
	LSL temp1
	ROL temp2
	LSL temp1
	ROL temp2
	LSL temp1
	ROL temp2
	; Z-berechnen				
	add ZL,temp1
	adc ZH,temp2
;-------------------------------------------------------------------------------
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_NAME_BYTE1),temp			; Dateinname								
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_NAME_BYTE2),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_NAME_BYTE3),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_NAME_BYTE4),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_NAME_BYTE5),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_NAME_BYTE6),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_NAME_BYTE7),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_NAME_BYTE8),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_ERWEITERUNG_BYTE1),temp	; Dateierweiterung						
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_ERWEITERUNG_BYTE2),temp											
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_ERWEITERUNG_BYTE3),temp											
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_ATTRIBUTE),temp			; Dateiattribute						
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_NTRES),temp				; fr WIN NT (sollte immer Null sein)	
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_TIME_TENTH),temp			; Millisekunden							
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_TIME_BYTE1),temp			; Zeit der Erstellung					
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_TIME_BYTE2),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_DATE_BYTE1),temp			; Datum der Erstellung					
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_DATE_BYTE2),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_LST_DATE_BYTE1),temp		; Datum des letzten Zugriffs			
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_LST_DATE_BYTE2),temp											
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_FST_CLUS_HI_BYTE1),temp	; sollte immer NULL sein				
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_FST_CLUS_HI_BYTE2),temp											
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_WRT_TIME_BYTE1),temp		; Zeit des letzten Schreibvorgangs		
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_WRT_TIME_BYTE2),temp											
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_WRT_DATE_BYTE1),temp		; Datum des letzten Schreibvorgangs		
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_WRT_DATE_BYTE2),temp											
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_STARTCLUSTER_L),temp		; START-CLUSTER lt. Directory			
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_STARTCLUSTER_H),temp											
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_GROESSE_BYTE1),temp		; DATEI-Gre lt. Directory				
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_GROESSE_BYTE2),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_GROESSE_BYTE3),temp												
	LD temp,Z+	; laden 	Z+1	
	STS(adr_DATEI_GROESSE_BYTE4),temp		
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; INP:	(adr_FAT_CLUSTER_DATENSATZ_NR_L)	; INHALT CLUSTER EINTRAG in FAT		
;		(adr_FAT_CLUSTER_DATENSATZ_NR_H)										
;																				
; OUT:	(adr_FAT_CLUSTER_INHALT_BYTE_L)		; INHALT CLUSTER EINTRAG in FAT		
;  		(adr_FAT_CLUSTER_INHALT_BYTE_H)											
;																				
FAT_TABELLE_EINTRAG_AUSLESEN:
	; CLUSTER NUMMER					
	LDS temp1,(adr_CLUSTER_DATENSATZ_NR_L)
	LDS temp2,(adr_CLUSTER_DATENSATZ_NR_H)
	clr temp3
	clr temp4
	; SEKTOR errechnen					
	; durch 256							
	mov temp1,temp2
	clr temp2
	; START-SEKTOR FAT 1				
	LDS temp5,(adr_FAT_START_SEKTOR_FAT_1_L)
	LDS temp6,(adr_FAT_START_SEKTOR_FAT_1_H)
	clr temp7
	clr temp8
	; ADDIEREN						
	add temp1,temp5
	adc temp2,temp6
	adc temp3,temp7
	adc temp4,temp8
	; speichern	PHYSISCHE ADRESSE	
	STS(adr_SD_PHYS_SEKTOR_BYTE1),temp1
	STS(adr_SD_PHYS_SEKTOR_BYTE2),temp2
	STS(adr_SD_PHYS_SEKTOR_BYTE3),temp3
	STS(adr_SD_PHYS_SEKTOR_BYTE4),temp4
	; SEKTOR einlesen			
	rcall SD_CMD17
	; POSITION des EINTRAGEs bestimmen
	LDS temp1,(adr_CLUSTER_DATENSATZ_NR_L)
	LDS temp2,(adr_CLUSTER_DATENSATZ_NR_H)
	clr temp2
	; mal 2						
	LSL temp1
	ROL temp2
	; Z-ZEIGER initialisieren	
	ldi ZL, LOW(adr_SD_DATEN)
	ldi ZH,HIGH(adr_SD_DATEN)
	; addieren					
	add ZL,temp1
	adc ZH,temp2	
	; einlesen und speichern	
	LD temp1,Z+
	LD temp2,Z+
	STS(adr_CLUSTER_INHALT_BYTE_L),temp1
	STS(adr_CLUSTER_INHALT_BYTE_H),temp2
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Directory komplett nach einer Datei durchsuchen								
;																				
; OUT:	(adr_FAT_DIREKTORY_DATENSATZ_NR_L)										
;		(adr_FAT_DIREKTORY_DATENSATZ_NR_H)										
;																				
;		FEHLER_CODE (0=kein Fehler)												
;																				
DATEI_SUCHEN:
	; LCD ZEILE1 
	rcall LCD_CLEAR
	ldi temp, 's'
	rcall LCD_DATA
	ldi temp, 'u'
	rcall LCD_DATA
	ldi temp, 'c'
	rcall LCD_DATA
	ldi temp, 'h'
	rcall LCD_DATA
	ldi temp, 'e'
	rcall LCD_DATA
	rcall LCD_3_PUNKT
	; FEHLERCODE	
	clr FEHLER_CODE
	; NULL			
	STS (adr_FAT_DIREKTORY_DATENSATZ_NR_L),NULL
	STS (adr_FAT_DIREKTORY_DATENSATZ_NR_H),NULL
DATEI_SUCHEN_START:
	; DATENSATZ laden	
	rcall DIRECTORY_DATENSATZ_AUSLESEN ; INP: SRAM
	; VERGLEICH			
	LDS temp1,(adr_NAME_BYTE1)
	LDS temp2,(adr_DATEI_NAME_BYTE1)
	cp temp1,temp2
	breq DATEI_SUCHEN_w1
	rjmp DATEI_SUCHEN_WEITER
DATEI_SUCHEN_w1:
	; VERGLEICH			
	LDS temp1,(adr_NAME_BYTE2)
	LDS temp2,(adr_DATEI_NAME_BYTE2)
	breq DATEI_SUCHEN_w2
	rjmp DATEI_SUCHEN_WEITER
DATEI_SUCHEN_w2:
	; VERGLEICH			
	LDS temp1,(adr_NAME_BYTE3)
	LDS temp2,(adr_DATEI_NAME_BYTE3)
	cp temp1,temp2
	breq DATEI_SUCHEN_w3
	rjmp DATEI_SUCHEN_WEITER
DATEI_SUCHEN_w3:
	; VERGLEICH			
	LDS temp1,(adr_NAME_BYTE4)
	LDS temp2,(adr_DATEI_NAME_BYTE4)
	cp temp1,temp2
	breq DATEI_SUCHEN_w4
	rjmp DATEI_SUCHEN_WEITER
DATEI_SUCHEN_w4:
	; VERGLEICH			
	LDS temp1,(adr_NAME_BYTE5)
	LDS temp2,(adr_DATEI_NAME_BYTE5)
	cp temp1,temp2
	breq DATEI_SUCHEN_w5
	rjmp DATEI_SUCHEN_WEITER
DATEI_SUCHEN_w5:
	; VERGLEICH			
	LDS temp1,(adr_NAME_BYTE6)
	LDS temp2,(adr_DATEI_NAME_BYTE6)
	cp temp1,temp2
	breq DATEI_SUCHEN_w6
	rjmp DATEI_SUCHEN_WEITER
DATEI_SUCHEN_w6:
	; VERGLEICH			
	LDS temp1,(adr_NAME_BYTE7)
	LDS temp2,(adr_DATEI_NAME_BYTE7)
	cp temp1,temp2
	breq DATEI_SUCHEN_w7
	rjmp DATEI_SUCHEN_WEITER
DATEI_SUCHEN_w7:
	; VERGLEICH			
	LDS temp1,(adr_NAME_BYTE8)
	LDS temp2,(adr_DATEI_NAME_BYTE8)
	cp temp1,temp2
	breq DATEI_SUCHEN_w8
	rjmp DATEI_SUCHEN_WEITER
;-----------------------------------------------
DATEI_SUCHEN_w8:
	; VERGLEICH			
	LDS temp1,(adr_ERWEITERUNG_BYTE1)
	LDS temp2,(adr_DATEI_ERWEITERUNG_BYTE1)
	cp temp1,temp2
	breq DATEI_SUCHEN_w9
	rjmp DATEI_SUCHEN_WEITER
DATEI_SUCHEN_w9:
	; VERGLEICH			
	LDS temp1,(adr_ERWEITERUNG_BYTE2)
	LDS temp2,(adr_DATEI_ERWEITERUNG_BYTE2)
	cp temp1,temp2
	breq DATEI_SUCHEN_w10
	rjmp DATEI_SUCHEN_WEITER
DATEI_SUCHEN_w10:
	; VERGLEICH			
	LDS temp1,(adr_ERWEITERUNG_BYTE3)
	LDS temp2,(adr_DATEI_ERWEITERUNG_BYTE3)
	cp temp1,temp2
	breq DATEI_SUCHEN_GEFUNDEN
;-----------------------------------------------
DATEI_SUCHEN_WEITER:
	; ZHLER			
	LDS temp1,(adr_FAT_DIREKTORY_DATENSATZ_NR_L)
	LDS temp2,(adr_FAT_DIREKTORY_DATENSATZ_NR_H)	
	add temp1,EINS
	adc temp2,NULL
	STS (adr_FAT_DIREKTORY_DATENSATZ_NR_L),temp1
	STS (adr_FAT_DIREKTORY_DATENSATZ_NR_H),temp2
	; SCHLEIFE			
	WDR
	cpi temp2,high(512-1)
	breq DATEI_SUCHEN_www
	rjmp DATEI_SUCHEN_START
DATEI_SUCHEN_www:
	cpi temp1, low(512-1)
	breq DATEI_SUCHEN_ERROR
	rjmp DATEI_SUCHEN_START
;--------------------------------------------------
DATEI_SUCHEN_ERROR:
	; FEHLER_CODE		
	ldi temp,100
	mov FEHLER_CODE,temp
	; ANZEIGE ERROR		
	rcall LCD_TEXT_ERROR
	ret
;--------------------------------------------------
DATEI_SUCHEN_GEFUNDEN:
	; NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN	
	ldi temp,'3'
	rcall LCD_DATA
	rcall NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN
	; DIRECTORY DATENSATZ laden			
	ldi temp,'2'
	rcall LCD_DATA
	rcall DIRECTORY_DATENSATZ_AUSLESEN ; INP: SRAM
	; LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN
	ldi temp,'1'
	rcall LCD_DATA
	rcall LETZTEN_BESCHRIEBENEN_CLUSTER_DER_DATEI_SUCHEN

	rcall LCD_TEXT_OK
	rcall wait_1s
ret
