; ##############################################################################
; ##############################################################################
; ##############################################################################
NEUSTART_MIT_WDR:
	WDR
	in temp, MCUCSR
	andi temp,0b00001000
	tst temp
	breq NEUSTART_MIT_WDR_FEHLER
	; MCUCSR clear		
	out MCUCSR,NULL
	ret
NEUSTART_MIT_WDR_FEHLER:
	rjmp NEUSTART_MIT_WDR_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
USART_INITIALISIEREN:
	ldi temp,TAKT/(BAUD*16)-1  		; Baudrate 
	out UBRRL,temp
   	ldi temp, (1<<URSEL)|(3<<UCSZ0)	; Frame-Format: 8 Bit
    out UCSRC, temp
    cbi UCSRB, RXCIE                ; Interrupt bei Empfang	de-aktivieren		   
    cbi UCSRB, RXEN 				; RX (Empfang) de-aktivieren       
	sbi UCSRB, TXEN  				; TX 		   aktivieren          
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 	INPUT: temp1														
;																		
;	rcall SENDEN	; INP: TEMP											
;																		
SENDEN:
	WDR 					; Watch-Dog-RESET					
	sbis UCSRA,UDRE     	; Warten bis UDR frei             	
	rjmp senden				; Sprung							
	out UDR, temp			; senden							
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
PROGRAMM_CHECK:
	; NULL	
	tst NULL
	brne PROGRAMM_CHECK_FEHLER
	; EINS	
	mov temp,EINS
	cpi temp,1
	brne PROGRAMM_CHECK_FEHLER
	; VOLL	
	mov temp,VOLL
	cpi temp,255
	brne PROGRAMM_CHECK_FEHLER
	ret
; SCHLEIFE, bis WDR zubeit		
PROGRAMM_CHECK_FEHLER:
	rjmp PROGRAMM_CHECK_FEHLER
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_TEST:
	STS(adr_LED_GRUEN_ON),EINS	; GRN	
	rcall wait_100ms
	STS(adr_LED_GELB_ON),EINS	; GELB	
	rcall wait_100ms
	STS(adr_LED_ROT_ON),EINS	; ROT	
	rcall wait_100ms
	STS(adr_LED_ORANGE_ON),EINS	; ORANGE

	rcall wait_1s

	STS(adr_LED_GRUEN_ON),NULL	; GRN	
	STS(adr_LED_GELB_ON),NULL	; GELB	
	STS(adr_LED_ROT_ON),NULL	; ROT	
	STS(adr_LED_ORANGE_ON),NULL	; ORANGE

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNCTION_TEMP1_BIS_TEMP4_PLUS_EINS:
	; ADDIEREN						
	add temp1,EINS
	adc temp2,NULL
	adc temp3,NULL
	adc temp4,NULL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
FUNCTION_TEMP1_BIS_TEMP4_MINUS_EINS:
	; SUBTRAHIEREN						
	sub temp1,EINS
	sbc temp2,NULL
	sbc temp3,NULL
	sbc temp4,NULL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;Pause nach jeder bertragung;50us Pause
wait50us:                              
           	ldi  temp, 255
wait50us_: 
			dec  temp
           	brne wait50us_
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;Lngere Pause fr manche Befehle;5ms Pause
wait5ms:                               
	push temp1           ; temp1 auf dem Stack sichern            
	push temp2           ; temp2 auf dem Stack sichern            
;------------
        ldi temp1,110
	   	clr temp2

wait5ms_:
   		wdr				; WATCH-DOG	
		dec  temp2
        brne wait5ms_
        dec  temp1
        brne wait5ms_
;------------
	pop temp2      		; temp2 wiederherstellen                    
	pop temp1      		; temp1 wiederherstellen                    
ret

; ##############################################################################
; ##############################################################################
; ##############################################################################
; bei 16 MHz Takt ca. 0,1s Pause												
WAIT_100ms:
	push temp1          ; temp1 auf dem Stack sichern            
	push temp2          ; temp2 auf dem Stack sichern            
	push temp3          ; temp3 auf dem Stack sichern            

;------------
	ldi	temp3,6			;(6 bei 16MHz)			
	clr temp2
	clr	temp1			
WAIT_100ms_w:	
	wdr
	dec	 temp1
	brne WAIT_100ms_w
	dec	 temp2		
	brne WAIT_100ms_w
	dec	 temp3
	brne WAIT_100ms_w
;------------
	pop temp3      		; temp3 wiederherstellen                    
	pop temp2      		; temp2 wiederherstellen                    
	pop temp1      		; temp1 wiederherstellen                    
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; bei 16 MHz Takt ca.1s Pause													
WAIT_1s:
	push temp1          ; temp1 auf dem Stack sichern            
	push temp2          ; temp2 auf dem Stack sichern            
	push temp3          ; temp3 auf dem Stack sichern            

;------------
	ldi	temp3,60		;(60 bei 16MHz)			
	clr temp2
	clr	temp1			
wait1s_w:	
	wdr
	dec	temp1
	brne	wait1s_w
	dec	temp2		
	brne	wait1s_w
	dec	temp3
	brne	wait1s_w
;------------
	pop temp3      		; temp3 wiederherstellen                    
	pop temp2      		; temp2 wiederherstellen                    
	pop temp1      		; temp1 wiederherstellen                    
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################