; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_OFF:
	; SPI_OFF				
	out SPCR,NULL
	out SPSR,NULL
	; auf LOW				
	cbi PORTB,SPI_B_CS
	cbi PORTB,SPI_B_MOSI
	cbi PORTB,SPI_B_MISO
	cbi PORTB,SPI_B_SCK
	; PORTS auf AUSGANG		
	sbi DDRB,SPI_B_CS
	sbi DDRB,SPI_B_MOSI
	sbi DDRB,SPI_B_MISO
	sbi DDRB,SPI_B_SCK

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SPI_INITIALISIERUNG:


	; PORTS auf AUSGANG/EINGANG		
	sbi DDRB,SPI_B_CS
	sbi DDRB,SPI_B_MOSI
	cbi DDRB,SPI_B_MISO
	sbi DDRB,SPI_B_SCK
	; setzen						
	sbi PORTB,SPI_B_CS
	cbi PORTB,SPI_B_MISO
	; diese PAUSE ist wichtig		
	rcall wait_100ms

; SPCR => SPIE SPE DORD MSTR CPOL CPHA SPR1 SPR0 (SPI Control Register)		
; 																			
; SPIE: SPI Interrupt Enable												
; SPE:  SPI Enable															
; DORD: Data Order															
; MSTR: Master/Slave Select													
; CPOL: Clock Polarity														
; CPHA: Clock Phase															
;						   Leading Edge 	Trailing Edge 		SPI Mode	
;		CPOL = 0, CPHA = 0 Sample (Rising) 	Setup (Falling) 		0		
;		CPOL = 0, CPHA = 1 Setup (Rising) 	Sample (Falling) 		1		
;		CPOL = 1, CPHA = 0 Sample (Falling) Setup (Rising) 			2		
;		CPOL = 1, CPHA = 1 Setup (Falling) 	Sample (Rising) 		3		
; SPR1: SPI Clock Rate Select 1												
; SPR0: SPI Clock Rate Select 0												
; 		SPR1 SPR0 SCK Frequency												
;  		0    0   fosc/4														
;  		0    1   fosc/16													
;  		1    0   fosc/64													
;  	*	1    1   fosc/128													
;																			
; Enable SPI, Master, set clock rate fck/128								
	ldi temp,(0<<SPIE)|(1<<SPE)|(0<<DORD)|(1<<MSTR)|(0<<CPOL)|(0<<CPHA)|(1<<SPR1)|(1<<SPR0)
	out SPCR,temp

; SPSR => SPIF WCOL - - - - - SPI2X  (SPI Status Register )					
;																			
; SPIF:  SPI Interrupt Flag													
; WCOL:  Write COLlision Flag												
; SPI2X: Double SPI Speed Bit												
;																			
; Double SPI Speed = off													
	ldi temp,(0<<SPI2X)
	out SPSR,temp	

ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; input: TEMP																	
;																				
;	rcall SPI_SENDEN_EINLESEN	; INP: TEMP OUT: temp							
;																				
SPI_SENDEN_EINLESEN:
	; Start transmission of data 	
	out SPDR,temp
	; Wait for transmission complete
SPI_SENDEN_w:
	sbis SPSR,SPIF
	rjmp SPI_SENDEN_w
	; DATENBYTE EINLESEN			
	in temp, SPDR	; einlesen  
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; OUT: temp																		
;																				
; rall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp									
; 																				
SPI_DUMMY_SENDEN_EINLESEN:
	; DUMMY (xFF)					
	ldi temp, 0xFF
	; Start transmission of data 	
	out SPDR,temp
	; Wait for transmission complete
SPI_SENDEN_DUMMY_w:
	sbis SPSR,SPIF
	rjmp SPI_SENDEN_DUMMY_w
	; DATENBYTE EINLESEN			
	in temp, SPDR	; einlesen  
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SD_KARTE_INITIALISIERUNG:
	; ZEILE1	
	rcall LCD_CLEAR
	ldi temp,'i'
	rcall LCD_DATA
	ldi temp,'n'
	rcall LCD_DATA
	ldi temp,'i'
	rcall LCD_DATA
	rcall LCD_3_PUNKT
	; ZEILE2	
	rcall LCD_ZEILE2
;-------------------------------------------------------------------------------
	rcall SPI_OFF		; SPI_OFF

;	cbi PORTD,RELAIS_D	; RELAIS 
;	rcall wait_1s
;	sbi PORTD,RELAIS_D	
			
	rcall SPI_INITIALISIERUNG	; SPI_INITIALISIERUNG	
;-------------------------------------------------------------------------------
	ldi temp, '1'
	rcall LCD_DATA
	rcall SD_CMD0	; RESET				
;-------------------------------------------------------------------------------
	ldi temp, '2'
	rcall LCD_DATA
	rcall SD_CMD1	; Initialisierung	
;-------------------------------------------------------------------------------
	ldi temp, '3'
	rcall LCD_DATA
	rcall SD_CMD16	; Blocklnge setzen (512Byte)
;-------------------------------------------------------------------------------
	ldi temp, '4'
	rcall LCD_DATA
	rcall MASTER_BOOTSEKTOR_EINLESEN_UND_AUSWERTEN
;-------------------------------------------------------------------------------
	ldi temp, '5'
	rcall LCD_DATA
	rcall VOLUME_BOOT_SEKTOR_EINLESEN_UND_AUSWERTEN
;-------------------------------------------------------------------------------
	ldi temp, '6'
	rcall LCD_DATA
	rcall FAT_EINLESEN_UND_AUSWERTEN
;-------------------------------------------------------------------------------
	rcall SD_CHACHE_RESET	; CHACHE reset		
	rcall LCD_TEXT_OK
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; RESET																			
SD_CMD0:
	; CS auf HIGH	
	sbi PORTB,SPI_B_CS	
	; DUMMY	; mindestens 74 CLOCKS senden, CS und MOSI auf HIGH		
	ldi temp1,255
SD_CMD0_DUMMY:
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	dec temp1
	brne SD_CMD0_DUMMY

	; Karte in den IDLE MODUS versetzen		
	; (CMD0) 0x40 0x00 0x00 0x00 0x00 0x95	
	ldi temp1, 0x40
	ldi temp2, 0x00
	ldi temp3, 0x00
	ldi temp4, 0x00
	ldi temp5, 0x00
	ldi temp6, 0x95
	rcall SD_KARTE_KOMMANDO_SENDEN_6_BYTES ; INP:temp1...6 OUT: temp
	; vergleich		
	cpi temp,0x01
	breq SD_CMD0_OK
SD_CMD0_SCHLEIFE:
	; DUMMY senden	
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; vergleich		
	cpi temp,0x01
	breq SD_CMD0_OK
	rjmp SD_CMD0_SCHLEIFE

SD_CMD0_OK:
	sbi PORTB,SPI_B_CS		; CD auf HIGH
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Initialisierung																
SD_CMD1:
	; CD auf HIGH	
	sbi PORTB,SPI_B_CS			
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; (CMD1) 0x41 0x00 0x00 0x00 0x00 0x00	; KARTE in den BETRIEBSMODUS	
	ldi temp1, 0x41
	ldi temp2, 0x00
	ldi temp3, 0x00
	ldi temp4, 0x00
	ldi temp5, 0x00
	ldi temp6, 0x00
	rcall SD_KARTE_KOMMANDO_SENDEN_6_BYTES ; INP:temp1...6 OUT: temp
	; vergleich		
	cpi temp, 0x00
	breq SD_CMD1_OK
SD_CMD1_SCHLEIFE:
	; DUMMY senden	
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; vergleich		
	cpi temp, 0xFF	
	breq SD_CMD1_SCHLEIFE
	; vergleich		
	cpi temp,0x00
	breq SD_CMD1_OK
	; CD auf HIGH	
	sbi PORTB,SPI_B_CS		
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rjmp SD_CMD1

SD_CMD1_OK:
	sbi PORTB,SPI_B_CS		; CD auf HIGH
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; Blocklnge setzen (512Byte)													
SD_CMD16:
	; CD auf HIGH	
	sbi PORTB,SPI_B_CS			
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; (CMD16) 0x50 0x00 0x00 0x00 0x00 0x00	; auf 512Bytes
	ldi temp1, 0x50
	ldi temp2, 0x00
	ldi temp3, 0x00
	ldi temp4, 0x02
	ldi temp5, 0x00
	ldi temp6, 0x00
	rcall SD_KARTE_KOMMANDO_SENDEN_6_BYTES ; INP:temp1...6 OUT: temp
	cpi temp, 0x00
	breq SD_CMD16_OK
SD_CMD16_SCHLEIFE:
	; DUMMY senden	
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; vergleich	
	cpi temp, 0xFF	
	breq SD_CMD16_SCHLEIFE
	; vergleich	
	cpi temp,0x00
	breq SD_CMD16_OK
	; CD auf HIGH
	sbi PORTB,SPI_B_CS		
	rjmp SD_CMD16

SD_CMD16_OK:
	sbi PORTB,SPI_B_CS		; CD auf HIGH
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 512 BYTES einlesen															
SD_CMD17:
	; alte physische Ardesse laden	
	LDS temp1,(adr_SD_PHYS_SEKTOR_OLD_BYTE1)
	LDS temp2,(adr_SD_PHYS_SEKTOR_OLD_BYTE2)
	LDS temp3,(adr_SD_PHYS_SEKTOR_OLD_BYTE3)
	LDS temp4,(adr_SD_PHYS_SEKTOR_OLD_BYTE4)
	; physische Ardesse laden		
	LDS temp5,(adr_SD_PHYS_SEKTOR_BYTE1)
	LDS temp6,(adr_SD_PHYS_SEKTOR_BYTE2)
	LDS temp7,(adr_SD_PHYS_SEKTOR_BYTE3)
	LDS temp8,(adr_SD_PHYS_SEKTOR_BYTE4)
	; physische Ardesse speichern 	
	STS(adr_SD_PHYS_SEKTOR_OLD_BYTE1),temp5
	STS(adr_SD_PHYS_SEKTOR_OLD_BYTE2),temp6
	STS(adr_SD_PHYS_SEKTOR_OLD_BYTE3),temp7
	STS(adr_SD_PHYS_SEKTOR_OLD_BYTE4),temp8
	; vergleich						
	cp temp1,temp5
	brne SD_CMD17_START
	cp temp2,temp6
	brne SD_CMD17_START
	cp temp3,temp7
	brne SD_CMD17_START
	cp temp4,temp8
	brne SD_CMD17_START

	ret		; hiermit kann der CHACHE deaktiviert werden 


SD_CMD17_START:
	; CD auf HIGH	
	sbi PORTB,SPI_B_CS			
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; (CMD17) 0x51 0x00 0x.. 0x.. 0x.. 0x00	; auf 512Bytes
	ldi temp1, 0x51
	LDS temp2,(adr_SD_PHYS_SEKTOR_BYTE4)
	LDS temp3,(adr_SD_PHYS_SEKTOR_BYTE3)
	LDS temp4,(adr_SD_PHYS_SEKTOR_BYTE2)
	LDS temp5,(adr_SD_PHYS_SEKTOR_BYTE1)
	; Umrechnen von SEKTOR in physikalische ADRESSE	 (mal 512 (9xlinks))	
	ldi temp,9
SD_CMD17_SCHLEIFE_w:
	LSL temp5
	ROL temp4
	ROL temp3
	ROL temp2
	dec temp
	brne SD_CMD17_SCHLEIFE_w 	

	ldi temp6, 0x00
	rcall SD_KARTE_KOMMANDO_SENDEN_6_BYTES ; INP:temp1...6 OUT: temp
	; vergleich	
	cpi temp, 0x00	
	breq SD_CMD17_SCHLEIFE_B
SD_CMD17_SCHLEIFE_A:
	; DUMMY		
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; vergleich	
	cpi temp, 0x00	
	breq SD_CMD17_SCHLEIFE_B
	rjmp SD_CMD17_SCHLEIFE_A
SD_CMD17_SCHLEIFE_B:
	; DUMMY		
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	cpi temp, 0xFE	
	breq SD_CMD17_SCHLEIFE_C
	rjmp SD_CMD17_SCHLEIFE_B
SD_CMD17_SCHLEIFE_C:
	; sichern					
	push YL
	push YH
	push ZL
	push ZH
	; Z-ZEIGER initialisieren	
	ldi ZL, LOW(adr_SD_DATEN)
	ldi ZH,HIGH(adr_SD_DATEN)
	; Y-Schleife initialisieren	
	ldi YL,  LOW(512)
	ldi YH, HIGH(512)
SD_CMD17_SCHLEIFE_Cw:
	; DATENBYTES einlesen
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; speichern in Z+1	
	ST Z+,temp
	; Y-1				
	sbiw YL,1 
	tst YH
	brne SD_CMD17_SCHLEIFE_Cw
	tst YL
	brne SD_CMD17_SCHLEIFE_Cw
	; wiederherstellen 
	pop ZH
	pop ZL
	pop YH
	pop YL
	; CRC einlesen		
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	sbi PORTB,SPI_B_CS		; CD auf HIGH
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; 512 BYTES SCHREIBEN															
SD_CMD24:
	; CHACHE reset		
	rcall SD_CHACHE_RESET

	; CD auf HIGH	
	sbi PORTB,SPI_B_CS			
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; (CMD24) 0x58 0x00 0x.. 0x.. 0x.. 0x00		
	ldi temp1, 0x58
	LDS temp2,(adr_SD_PHYS_SEKTOR_BYTE4)
	LDS temp3,(adr_SD_PHYS_SEKTOR_BYTE3)
	LDS temp4,(adr_SD_PHYS_SEKTOR_BYTE2)
	LDS temp5,(adr_SD_PHYS_SEKTOR_BYTE1)
	ldi temp6, 0x00
	; Umrechnen von SEKTOR in physikalische ADRESSE	 (mal 512 (9xlinks))	
	ldi temp,9
SD_CMD24_SCHLEIFE_w:
	LSL temp5
	ROL temp4
	ROL temp3
	ROL temp2
	dec temp
	brne SD_CMD24_SCHLEIFE_w 

	rcall SD_KARTE_KOMMANDO_SENDEN_6_BYTES ; INP:temp1...6 OUT: temp
	; vergleich	
	cpi temp, 0x00	
	breq SD_CMD17_SCHLEIFE_B
SD_CMD24_SCHLEIFE_A:
	; DUMMY		
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; vergleich	
	cpi temp, 0x00	
	breq SD_CMD24_SCHLEIFE_B
	rjmp SD_CMD24_SCHLEIFE_A
SD_CMD24_SCHLEIFE_B:
	; DUMMY		
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; xFE senden	
	ldi temp,0xFE
	rcall SPI_SENDEN_EINLESEN	; INP: TEMP OUT: temp
	; sichern					
	push YL
	push YH
	push ZL
	push ZH
	; Z-ZEIGER initialisieren	
	ldi ZL, LOW(adr_SD_DATEN)
	ldi ZH,HIGH(adr_SD_DATEN)
	; Y-Schleife initialisieren	
	ldi YL,  LOW(512)
	ldi YH, HIGH(512)
SD_CMD24_SCHLEIFE_C:
	; BYTES senden Z+1			
	LD temp,Z+
	rcall SPI_SENDEN_EINLESEN	; INP: TEMP OUT: temp
	; Y-1				
	sbiw YL,1 
	tst YH
	brne SD_CMD24_SCHLEIFE_C
	tst YL
	brne SD_CMD24_SCHLEIFE_C
	; wiederherstellen 
	pop ZH
	pop ZL
	pop YH
	pop YL
	; CRC senden		
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; vergleich	
	cpi temp, 0xE5	
	breq SD_CMD24_SCHLEIFE_E

SD_CMD24_SCHLEIFE_D:
	; DUMMY		
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; vergleich	
	cpi temp, 0xE5	
	breq SD_CMD24_SCHLEIFE_E
	rjmp SD_CMD24_SCHLEIFE_D

SD_CMD24_SCHLEIFE_E:
	; DUMMY		
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	; vergleich	
	cpi temp, 0xFF
	breq SD_CMD24_SCHLEIFE_Ew
	rjmp SD_CMD24_SCHLEIFE_E

SD_CMD24_SCHLEIFE_Ew:
	sbi PORTB,SPI_B_CS		; CD auf HIGH
	; DUMMY			
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
	rcall SPI_DUMMY_SENDEN_EINLESEN	; OUT:temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; INP: temp1...6																
; OUT: temp (vom letzten BYTE)													
;																				
; rcall SD_KARTE_KOMMANDO_SENDEN_6_BYTES ; INP:temp1...6 OUT: temp				
;																				
SD_KARTE_KOMMANDO_SENDEN_6_BYTES:
	; CS auf LOW		
	cbi PORTB,SPI_B_CS	
	; kurze PAUSE		
	nop
	nop
	; temp1...6 senden	
	mov temp,temp1
	rcall SPI_SENDEN_EINLESEN	; INP: TEMP OUT: temp
	mov temp,temp2
	rcall SPI_SENDEN_EINLESEN	; INP: TEMP OUT: temp
	mov temp,temp3
	rcall SPI_SENDEN_EINLESEN	; INP: TEMP OUT: temp
	mov temp,temp4
	rcall SPI_SENDEN_EINLESEN	; INP: TEMP OUT: temp
	mov temp,temp5
	rcall SPI_SENDEN_EINLESEN	; INP: TEMP OUT: temp
	mov temp,temp6
	rcall SPI_SENDEN_EINLESEN	; INP: TEMP OUT: temp
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
SD_CHACHE_RESET:
	STS(adr_SD_PHYS_SEKTOR_OLD_BYTE1),VOLL
	STS(adr_SD_PHYS_SEKTOR_OLD_BYTE2),VOLL
	STS(adr_SD_PHYS_SEKTOR_OLD_BYTE3),VOLL
	STS(adr_SD_PHYS_SEKTOR_OLD_BYTE4),VOLL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################