; ##############################################################################
; ##############################################################################
; ##############################################################################
TIMER1_INITIALISIERUNG:
;																			
; Timer1 (16Bit ) Vorteiler 												
;																			
; TCCR1B ==> ICNC1 ICES1 RESERVIERT WGM13 WGM12 CS12 CS11 CS10 				
;																			
;CS12 CS11 CS10 Description													
;	0	0 	0 	No clock source. (Timer/Counter stopped)					
;	0 	0 	1 	clkI/O/1    (No prescaling)									
;	0 	1 	0 	clkI/O/8    (From prescaler)								
;	0 	1 	1 	clkI/O/64   (From prescaler)								
; *	1 	0 	0 	clkI/O/256  (From prescaler)								
; 	1 	0 	1 	clkI/O/1024 (From prescaler)								
;	1 	1 	0 	External clock source on T1 pin. Clock on falling edge.		
;	1 	1 	1 	External clock source on T1 pin. Clock on rising edge.		
;																			
	ldi temp,(1<<CS12)|(0<<CS11) |(0<<CS10)
	out TCCR1B,temp          
; Timer 1 Startwert 	
	ldi temp,HIGH(TIMERWERT1)
	out tcnt1H,temp         
	ldi temp,LOW (TIMERWERT1) 
	out tcnt1L,temp     
;																			
; Timer 0+1+2 berlauf-Int aktivieren (Timer/Counter Interrupt Mask)		
;																			
; TIMSK ==> OCIE2 TOIE2 TICIE1 OCIE1A OCIE1B TOIE1 R TOIE0  				
;																			
	ldi temp,(0<<OCIE2)|(0<<TOIE2)|(0<<TICIE1)|(0<<OCIE1A)|(0<<OCIE1B)|(1<<TOIE1)|(0<<TOIE0)
	out TIMSK,temp     
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
; bei 16 MHz ==> 1s Takt														
TIM1_OVF:
	push TEMP		    ; Sichern von "TEMP" im Stack
	in	 TEMP,SREG		; Einlesen des SREG 
	push TEMP	    	; Schreiben von  SREG  im Stack (KOPIE)
	push TEMP1
	push TEMP2
	push TEMP3
	push TEMP4
; ----------------------------------
; Timer Startwert	 				
	ldi temp,HIGH(TIMERWERT1)
	out tcnt1H,temp         
	ldi temp,LOW (TIMERWERT1) 
	out tcnt1L,temp
; -------------------------------
	rcall ZEIT
	rcall ABFRAGE_TASTATUR
	rcall LED_ORANGE
	rcall LED_GRUEN
	rcall LED_GELB
	rcall LED_ROT
; ----------------------------------
	pop TEMP4
	pop TEMP3
	pop TEMP2
	pop TEMP1
	pop	TEMP			; LESEN von SREG vom STACK (KOPIE)
	out	SREG,TEMP		; Wiederherstellen von SREG
	pop	TEMP			; Wiederherstellen von "TEMP" 				
reti
; ##############################################################################
; ##############################################################################
; ##############################################################################
ZEIT:
	LDS temp,(adr_ss10)	; aus SRAM laden	
	inc temp
	STS (adr_ss10),temp	; in SRAM speichern	
	cpi temp,10
	brsh ZEIT_SS
	ret
ZEIT_SS:
	STS (adr_ss10),NULL	; in SRAM speichern	

	; FREIGABE_PROGRAMM
	STS(adr_FREIGABE_PROGRAMM),EINS

	LDS temp,(adr_ss)	; aus SRAM laden	
	inc temp
	STS (adr_ss),temp	; in SRAM speichern	
	cpi temp,60
	brsh ZEIT_MM
	ret	
ZEIT_MM:
	STS (adr_ss),NULL	; in SRAM speichern	
	; FREIGABE SD Speicherung	
	STS(adr_FREIGABE_SD_SPEICHERUNG),EINS

	LDS temp,(adr_mm)	; aus SRAM laden	
	inc temp
	STS (adr_mm),temp	; in SRAM speichern	
	cpi temp,60
	brsh ZEIT_HH
	ret	
ZEIT_HH:
	STS (adr_mm),NULL	; in SRAM speichern	

	LDS temp,(adr_hh)	; aus SRAM laden	
	inc temp
	STS (adr_hh),temp	; in SRAM speichern	
	cpi temp,24
	brsh ZEIT_TAG
	ret	
ZEIT_TAG:
	STS (adr_hh),NULL	; in SRAM speichern	


	LDS temp,(adr_TAG)
	inc temp
	STS (adr_TAG),temp


	rcall ZEIT_TAGE_MONAT			; OUT: temp1 (Anzahl der Tage im Monat)

	LDS temp,(adr_TAG)

	cp temp, temp1					; VERGLEICH	
	brlo ZEIT_ZAEHLER_TAG_FERTIG	; kleiner => Sprung fertig
	breq ZEIT_ZAEHLER_TAG_FERTIG	; gleich  => SPRUNG fertig
	brsh ZEIT_ZAEHLER_MONAT
ZEIT_ZAEHLER_TAG_FERTIG:
	ret
;													
ZEIT_ZAEHLER_MONAT:
	STS (adr_TAG),EINS

	LDS temp,(adr_MONAT)
	inc temp
	STS (adr_MONAT),temp
	cpi temp,13
	brsh ZEIT_ZAEHLER_JAHR
	ret
;													
ZEIT_ZAEHLER_JAHR:
	STS (adr_MONAT),EINS

	LDS temp,(adr_JAHR)
	inc temp
	STS (adr_JAHR),temp

ret
;###################################################################
;###################################################################
;###################################################################
; OUTPUT: TEMP1 => ANZAHl der TAGE im MONAT							
ZEIT_TAGE_MONAT:
	; MONAT laden	
	LDS temp,(adr_MONAT)

	cpi temp,1					;1
	breq ZEIT_TAGE_MONAT_31
	cpi temp,2					;2
	breq ZEIT_TAGE_MONAT_28
	cpi temp,3					;3
	breq ZEIT_TAGE_MONAT_31
	cpi temp,4					;4
	breq ZEIT_TAGE_MONAT_30
	cpi temp,5					;5
	breq ZEIT_TAGE_MONAT_31
	cpi temp,6					;6
	breq ZEIT_TAGE_MONAT_30
	cpi temp,7					;7
	breq ZEIT_TAGE_MONAT_31
	cpi temp,8					;8
	breq ZEIT_TAGE_MONAT_31
	cpi temp,9					;9
	breq ZEIT_TAGE_MONAT_30
	cpi temp,10					;10
	breq ZEIT_TAGE_MONAT_31
	cpi temp,11					;11
	breq ZEIT_TAGE_MONAT_30
	cpi temp,12					;12
	breq ZEIT_TAGE_MONAT_31
	rjmp ZEIT_TAGE_MONAT_31

ZEIT_TAGE_MONAT_28:
	ldi temp1,28
	ret
ZEIT_TAGE_MONAT_30:
	ldi temp1,30
	ret
ZEIT_TAGE_MONAT_31:
	ldi temp1,31
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
ABFRAGE_TASTATUR:
	; auf Eingang umschalten, PULL-UPS ein	
	cbi DDRD,LED_D_ORANGE
	sbi PORTD,LED_D_ORANGE
	; auf Eingang umschalten, PULL-UPS ein	
	cbi DDRD,LED_D_GRUEN
	sbi PORTD,LED_D_GRUEN
	; auf Eingang umschalten, PULL-UPS ein	
	cbi DDRD,LED_D_GELB
	sbi PORTD,LED_D_GELB
	; auf Eingang umschalten, PULL-UPS ein	
	cbi DDRD,LED_D_ROT
	sbi PORTD,LED_D_ROT
	; TASTE schon gedrckt ?				
	LDS temp,(adr_TASTE)
	tst temp
	breq ABFRAGE_TASTATUR_w
	ret
ABFRAGE_TASTATUR_w:
	; einlesen								
	in temp, PIND
	; Bitmuster		
	com temp
	andi temp,0b11110000
	; speichern		
	STS(adr_TASTE),temp
	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_ORANGE:
	LDS temp,(adr_LED_ORANGE_ON)
	tst temp
	brne LED_ORANGE_ON
	ret
LED_ORANGE_ON:
	; auf AUSGANG umschalten und auf LOW	
	sbi DDRD,LED_D_ORANGE
	cbi PORTD,LED_D_ORANGE
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_GRUEN:
	LDS temp,(adr_LED_GRUEN_ON)
	tst temp
	brne LED_GRUEN_ON
	ret
LED_GRUEN_ON:
	; auf AUSGANG umschalten und auf LOW	
	sbi DDRD,LED_D_GRUEN
	cbi PORTD,LED_D_GRUEN
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_GELB:
	LDS temp,(adr_LED_GELB_ON)
	tst temp
	brne LED_GELB_ON
	ret
LED_GELB_ON:
	; auf AUSGANG umschalten und auf LOW	
	sbi DDRD,LED_D_GELB
	cbi PORTD,LED_D_GELB
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
LED_ROT:
	LDS temp,(adr_LED_ROT_ON)
	tst temp
	brne LED_ROT_ON
	ret
LED_ROT_ON:
	; auf AUSGANG umschalten und auf LOW	
	sbi DDRD,LED_D_ROT
	cbi PORTD,LED_D_ROT
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################