; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Einen leeren Datensatz in der Directory und in der FAT suchen und beschreiben	
;																				
DATEI_ANLEGEN:
	; Freien Direktory-Entrag suchen 						
	STS(adr_FAT_DIREKTORY_DATENSATZ_NR_L),NULL
	STS(adr_FAT_DIREKTORY_DATENSATZ_NR_H),NULL
DATEI_ANLEGEN_DIRECTORY_SCHLEIFE:
	; Direktory Datensatz einlesen
	WDR
	rcall DIRECTORY_DATENSATZ_AUSLESEN		; INP: (adr_FAT_DIREKTORY_DATENSATZ_NR)
	; ATTRIBUT auswerten		
	LDS temp,(adr_DATEI_ATTRIBUTE)
	tst temp
	brne DATEI_ANLEGEN_DIRECTORY_SCHLEIFE_w
	; START-CLUSTER auswerten	
	LDS temp,(adr_DATEI_STARTCLUSTER_L)
	tst temp
	brne DATEI_ANLEGEN_DIRECTORY_SCHLEIFE_w
	LDS temp,(adr_DATEI_STARTCLUSTER_H)
	tst temp
	brne DATEI_ANLEGEN_DIRECTORY_SCHLEIFE_w
	; DATEI-GRSSE auswerten	
	LDS temp,(adr_DATEI_GROESSE_BYTE1)
	tst temp
	brne DATEI_ANLEGEN_DIRECTORY_SCHLEIFE_w
	LDS temp,(adr_DATEI_GROESSE_BYTE2)
	tst temp
	brne DATEI_ANLEGEN_DIRECTORY_SCHLEIFE_w
	LDS temp,(adr_DATEI_GROESSE_BYTE3)
	tst temp
	brne DATEI_ANLEGEN_DIRECTORY_SCHLEIFE_w
	LDS temp,(adr_DATEI_GROESSE_BYTE4)
	tst temp
	brne DATEI_ANLEGEN_DIRECTORY_SCHLEIFE_w
	rjmp DATEI_ANLEGEN_DIRECTORY_LEEREN_DATENSATZ_GEFUNDEN
DATEI_ANLEGEN_DIRECTORY_SCHLEIFE_w:
	; Datensatznummer +1
	LDS temp1,(adr_FAT_DIREKTORY_DATENSATZ_NR_L)
	LDS temp2,(adr_FAT_DIREKTORY_DATENSATZ_NR_H)
	add temp1,EINS
	adc temp2,NULL
	STS(adr_FAT_DIREKTORY_DATENSATZ_NR_L),temp1
	STS(adr_FAT_DIREKTORY_DATENSATZ_NR_H),temp2
	rjmp DATEI_ANLEGEN_DIRECTORY_SCHLEIFE
DATEI_ANLEGEN_DIRECTORY_LEEREN_DATENSATZ_GEFUNDEN:
;-------------------------------------------------------------------------------
	; in (adr_FAT_DIREKTORY_DATENSATZ_NR) 					
	; ist die Position des leeren Datensatzes gespeichert	
;-------------------------------------------------------------------------------
	; Leeren  Eintrag in FAT_Tabelle suchen	
	rcall NEXT_LEEREN_CLUSTER_IN_FAT_SUCHEN 	; OUT: (adr_CLUSTER_NEXT_FREE)	
	; in FAT TABELLE Eintrag schreiben	xFF xFF			
	LDS temp1,(adr_CLUSTER_NEXT_FREE_L)
	LDS temp2,(adr_CLUSTER_NEXT_FREE_H)
	STS (adr_CLUSTER_DATENSATZ_NR_L),temp1	; Datensatznummer
	STS (adr_CLUSTER_DATENSATZ_NR_H),temp2
	STS(adr_CLUSTER_INHALT_BYTE_L),VOLL		; INHALT	
	STS(adr_CLUSTER_INHALT_BYTE_H),VOLL
	rcall FAT_TABELLE_EINTRAG_SCHREIBEN		; INP: (adr_CLUSTER_DATENSATZ_NR) (adr_CLUSTER_INHALT_BYTE)
	; START-CLUSTER speichern				
	LDS temp1,(adr_CLUSTER_NEXT_FREE_L)
	LDS temp2,(adr_CLUSTER_NEXT_FREE_H)
	STS (adr_DATEI_STARTCLUSTER_L),temp1
	STS (adr_DATEI_STARTCLUSTER_H),temp2
	; in Direktory Eintrag schreiben					
	rcall DIRECTORY_DATENSATZ_SCHREIBEN				; INP: (adr_ ....)
	; DATEI suchen								
	rcall DATEI_SUCHEN
	; letzter beschriebene Sektor = NULL !!!	
	STS(adr_CLUSTER_LAST_SEKTOR),NULL
	; letzte Byte im letzten Sector= NULL !!!	
	STS(adr_CLUSTER_LAST_BYTE_L),NULL
	STS(adr_CLUSTER_LAST_BYTE_H),NULL
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Die Direktory besteht aus 32 Sektoren. Ein Eintrag (Datensatz)				
; in der Directory besteht aus 32 Bytes 										
;																				
; INP: 	  (adr_FAT_DIREKTORY_DATENSATZ_NR_L)									
;		  (adr_FAT_DIREKTORY_DATENSATZ_NR_H)									
;																				
; 		  (adr_NAME_BYTE1)				; Dateinname							
;		  (adr_NAME_BYTE2)														
;		  (adr_NAME_BYTE3)														
;		  (adr_NAME_BYTE4)														
;		  (adr_NAME_BYTE5)														
;		  (adr_NAME_BYTE6)														
;		  (adr_NAME_BYTE7)														
;		  (adr_NAME_BYTE8)														
;		  (adr_ERWEITERUNG_BYTE1)		; Dateierweiterung						
;		  (adr_ERWEITERUNG_BYTE2)												
;		  (adr_ERWEITERUNG_BYTE3)												
;		  (adr_DATEI_ATTRIBUTE)			; Dateiattribute						
;		  (adr_DATEI_NTRES)				; fr WIN NT (sollte immer Null sein)	
;		  (adr_DATEI_TIME_TENTH)		; Millisekunden							
;		  (adr_DATEI_TIME_BYTE1)		; Zeit der Erstellung					
;		  (adr_DATEI_TIME_BYTE2)												
;		  (adr_DATEI_DATE_BYTE1)		; Datum der Erstellung					
;		  (adr_DATEI_DATE_BYTE2)												
;		  (adr_DATEI_LST_DATE_BYTE1)	; Datum des letzten Zugriffs			
;		  (adr_DATEI_LST_DATE_BYTE2)											
;		  (adr_DATEI_FST_CLUS_HI_BYTE1)	; sollte immer NULL sein				
;		  (adr_DATEI_FST_CLUS_HI_BYTE2)											
;		  (adr_DATEI_WRT_TIME_BYTE1)	; Zeit des letzten Schreibvorgangs		
;		  (adr_DATEI_WRT_TIME_BYTE2)											
;		  (adr_DATEI_WRT_DATE_BYTE1)	; Datum des letzten Schreibvorgangs		
;		  (adr_DATEI_WRT_DATE_BYTE2)											
;		  (adr_DATEI_STARTCLUSTER_L)	; START-CLUSTER lt. Directory			
;		  (adr_DATEI_STARTCLUSTER_H)											
;		  (adr_DATEI_GROESSE_BYTE1)		; DATEI-Gre lt. Directory				
;		  (adr_DATEI_GROESSE_BYTE2)												
;		  (adr_DATEI_GROESSE_BYTE3)												
;		  (adr_DATEI_GROESSE_BYTE4)												
;																				
DIRECTORY_DATENSATZ_SCHREIBEN:
	; DATENSATZ-NR laden	
	LDS temp1,(adr_FAT_DIREKTORY_DATENSATZ_NR_L)
	LDS temp2,(adr_FAT_DIREKTORY_DATENSATZ_NR_H)
	; durch 16 (16 Datenstze pro Sektor)	
	LSR temp2
	ROR temp1
	LSR temp2
	ROR temp1
	LSR temp2
	ROR temp1
	LSR temp2
	ROR temp1
	; START_SEKTOR_ROOT_DIRECTORY laden	
	LDS temp3,(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_L)
	LDS temp4,(adr_FAT_START_SEKTOR_ROOT_DIRECTORY_H)
	; addieren							
	add temp1,temp3
	adc temp2,temp4
	clr temp3
	clr temp4
	; speichern					
	STS(adr_SD_PHYS_SEKTOR_BYTE1),temp1
	STS(adr_SD_PHYS_SEKTOR_BYTE2),temp2
	STS(adr_SD_PHYS_SEKTOR_BYTE3),temp3
	STS(adr_SD_PHYS_SEKTOR_BYTE4),temp4
	; SEKTOR einlesen			
	rcall SD_CMD17	
	; Z-initialisieren			
	ldi ZL, low(adr_SD_DATEN)
	ldi ZH,high(adr_SD_DATEN)
	; DATENSATZ-NR laden 		
	LDS temp1,(adr_FAT_DIREKTORY_DATENSATZ_NR_L)
	LDS temp2,(adr_FAT_DIREKTORY_DATENSATZ_NR_H)
	; BITMUSTER					
	andi temp1,0b00001111
	andi temp2,0b00000000
	; mal 32					
	LSL temp1
	ROL temp2
	LSL temp1
	ROL temp2
	LSL temp1
	ROL temp2
	LSL temp1
	ROL temp2
	LSL temp1
	ROL temp2
	; Z-berechnen				
	add ZL,temp1
	adc ZH,temp2
;-------------------------------------------------------------------------------
	; laden und Z+1
	LDS temp,(adr_NAME_BYTE1)		; Dateinname							
	ST Z+,temp
	LDS temp,(adr_NAME_BYTE2)												
	ST Z+,temp
	LDS temp,(adr_NAME_BYTE3)												
	ST Z+,temp
	LDS temp,(adr_NAME_BYTE4)												
	ST Z+,temp
	LDS temp,(adr_NAME_BYTE5)												
	ST Z+,temp
	LDS temp,(adr_NAME_BYTE6)												
	ST Z+,temp
	LDS temp,(adr_NAME_BYTE7)												
	ST Z+,temp
	LDS temp,(adr_NAME_BYTE8)												
	ST Z+,temp
	LDS temp,(adr_ERWEITERUNG_BYTE1)	; Dateierweiterung						
	ST Z+,temp
	LDS temp,(adr_ERWEITERUNG_BYTE2)											
	ST Z+,temp
	LDS temp,(adr_ERWEITERUNG_BYTE3)											
	ST Z+,temp	
	; ATTRIBUT setzen		
	LDS temp,(adr_DATEI_ATTRIBUTE)			; Dateiattribute						
	ldi temp, 0b00100000
	ST Z+,temp
	LDS temp,(adr_DATEI_NTRES)				; fr WIN NT (sollte immer Null sein)	
	ST Z+,temp
	LDS temp,(adr_DATEI_TIME_TENTH)		; Millisekunden							
	ST Z+,temp
	LDS temp,(adr_DATEI_TIME_BYTE1)		; Zeit der Erstellung					
	ST Z+,temp
	LDS temp,(adr_DATEI_TIME_BYTE2)												
	ST Z+,temp
	LDS temp,(adr_DATEI_DATE_BYTE1)		; Datum der Erstellung					
	ST Z+,temp
	LDS temp,(adr_DATEI_DATE_BYTE2)												
	ST Z+,temp
	LDS temp,(adr_DATEI_LST_DATE_BYTE1)	; Datum des letzten Zugriffs			
	ST Z+,temp
	LDS temp,(adr_DATEI_LST_DATE_BYTE2)											
	ST Z+,temp
	LDS temp,(adr_DATEI_FST_CLUS_HI_BYTE1)	; sollte immer NULL sein				
	ST Z+,temp
	LDS temp,(adr_DATEI_FST_CLUS_HI_BYTE2)											
	ST Z+,temp
	LDS temp,(adr_DATEI_WRT_TIME_BYTE1)	; Zeit des letzten Schreibvorgangs		
	ST Z+,temp
	LDS temp,(adr_DATEI_WRT_TIME_BYTE2)											
	ST Z+,temp
	LDS temp,(adr_DATEI_WRT_DATE_BYTE1)	; Datum des letzten Schreibvorgangs		
	ST Z+,temp
	LDS temp,(adr_DATEI_WRT_DATE_BYTE2)											
	ST Z+,temp
	LDS temp,(adr_DATEI_STARTCLUSTER_L)	; START-CLUSTER lt. Directory			
	ST Z+,temp
	LDS temp,(adr_DATEI_STARTCLUSTER_H)											
	ST Z+,temp
	LDS temp,(adr_DATEI_GROESSE_BYTE1)	; DATEI-Gre lt. Directory				
	ST Z+,temp
	LDS temp,(adr_DATEI_GROESSE_BYTE2)												
	ST Z+,temp
	LDS temp,(adr_DATEI_GROESSE_BYTE3)												
	ST Z+,temp
	LDS temp,(adr_DATEI_GROESSE_BYTE4)	
	ST Z+,temp
	; Sektor schreiben	
	rcall SD_CMD24	; INP: (adr_SD_PHYS_SEKTOR_BYTE)	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Ein Eintrag in der FAT besteht aus 2 Byte 									
;																				
; INP:	(adr_CLUSTER_DATENSATZ_NR_L)	; INHALT CLUSTER EINTRAG in FAT			
;		(adr_CLUSTER_DATENSATZ_NR_H)											
;																				
; 		(adr_CLUSTER_INHALT_BYTE_L)		; INHALT CLUSTER EINTRAG in FAT			
;  		(adr_CLUSTER_INHALT_BYTE_H)												
;																				
; rcall FAT_TABELLE_EINTRAG_SCHREIBEN	; INP: (adr_CLUSTER_DATENSATZ_NR) (adr_CLUSTER_INHALT_BYTE)
;																				
FAT_TABELLE_EINTRAG_SCHREIBEN:
	; CLUSTER NUMMER					
	LDS temp1,(adr_CLUSTER_DATENSATZ_NR_L)
	LDS temp2,(adr_CLUSTER_DATENSATZ_NR_H)
	clr temp3
	clr temp4
	; SEKTOR errechnen					
	; durch 256							
	mov temp1,temp2
	clr temp2
	; START-SEKTOR FAT 1				
	LDS temp5,(adr_FAT_START_SEKTOR_FAT_1_L)
	LDS temp6,(adr_FAT_START_SEKTOR_FAT_1_H)
	clr temp7
	clr temp8
	; ADDIEREN						
	add temp1,temp5
	adc temp2,temp6
	adc temp3,temp7
	adc temp4,temp8
	; speichern	PHYSISCHE ADRESSE	
	STS(adr_SD_PHYS_SEKTOR_BYTE1),temp1
	STS(adr_SD_PHYS_SEKTOR_BYTE2),temp2
	STS(adr_SD_PHYS_SEKTOR_BYTE3),temp3
	STS(adr_SD_PHYS_SEKTOR_BYTE4),temp4
	; SEKTOR einlesen			
	rcall SD_CMD17
	; POSITION des EINTRAGEs bestimmen
	LDS temp1,(adr_CLUSTER_DATENSATZ_NR_L)
	LDS temp2,(adr_CLUSTER_DATENSATZ_NR_H)
	clr temp2
	; mal 2						
	LSL temp1
	ROL temp2
	; Z-ZEIGER initialisieren	
	ldi ZL, LOW(adr_SD_DATEN)
	ldi ZH,HIGH(adr_SD_DATEN)
	; addieren					
	add ZL,temp1
	adc ZH,temp2	
	; speichern	
	LDS temp1,(adr_CLUSTER_INHALT_BYTE_L)
	LDS temp2,(adr_CLUSTER_INHALT_BYTE_H)
	ST Z+,temp1
	ST Z+,temp2
	; Sektor schreiben	
	rcall SD_CMD24	; INP: (adr_SD_PHYS_SEKTOR_BYTE)	
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
;																				
; Es werden immer 512 Bytes an die Vorhandene Datei angehngt					
;																				
DATEI_WRITE:
; ------------------------------------------------------------------------------
	; nach Datei suchen	
	rcall DATEI_SUCHEN
	; Fehlerprfung		
	tst FEHLER_CODE
	breq DATEI_WRITE_512_CHECK
	rcall DATEI_ANLEGEN
	rjmp DATEI_WRITE_RUN
; ------------------------------------------------------------------------------
; DATEIGRSSE untersuchen (muss ein Vielfaches von 512 sein)					
; ------------------------------------------------------------------------------
DATEI_WRITE_512_CHECK:
	; das letzte Byte im letzten Sector laden (Sollte immer NULL sein)
	LDS temp1,(adr_CLUSTER_LAST_BYTE_L)
	LDS temp2,(adr_CLUSTER_LAST_BYTE_H)
	; Vergleich	
	tst temp1
	brne DATEI_WRITE_512_CHECK_ERROR
	andi temp2,0b00000001
	tst temp2
	brne DATEI_WRITE_512_CHECK_ERROR
	rjmp DATEI_WRITE_RUN
; ------------------------------------------------------------------------------
; DATEI mit Leer-Zeichen auffllen												
; ------------------------------------------------------------------------------
DATEI_WRITE_512_CHECK_ERROR:
	; INITIALISIEREN auf SCHREIB_CLUSTER			
	LDS temp1,(adr_CLUSTER_ENDECLUSTER_L)
	LDS temp2,(adr_CLUSTER_ENDECLUSTER_H)
	STS (adr_CLUSTER_DATENSATZ_NR_L),temp1
	STS (adr_CLUSTER_DATENSATZ_NR_H),temp2
	; BERECHNUNG_CLUSTER_NR_IN_PHYSISCHER_SEKTOR_NR
	rcall BERECHNUNG_CLUSTER_NR_IN_PHYSISCHER_SEKTOR_NR	; INP: (adr_CLUSTER_DATENSATZ_NR)
	; Physischen Sektor laden								
	LDS temp1,(adr_SD_PHYS_SEKTOR_BYTE1)
	LDS temp2,(adr_SD_PHYS_SEKTOR_BYTE2)
	LDS temp3,(adr_SD_PHYS_SEKTOR_BYTE3)
	LDS temp4,(adr_SD_PHYS_SEKTOR_BYTE4)
	; letzten beschriebenen Sektor in diesem Cluster LADEN	
	LDS temp5,(adr_CLUSTER_LAST_SEKTOR)
	; hinzuaddieren 					
	add temp1,temp5
	adc temp2,NULL
	adc temp3,NULL
	adc temp4,NULL
	; Physischen Sektor speichern		
	STS(adr_SD_PHYS_SEKTOR_BYTE1),temp1
	STS(adr_SD_PHYS_SEKTOR_BYTE2),temp2
	STS(adr_SD_PHYS_SEKTOR_BYTE3),temp3
	STS(adr_SD_PHYS_SEKTOR_BYTE4),temp4
; ------------------------------------------------------------------------------
	; SEKTOR einlesen und im SRAM ablegen	
	rcall SD_CMD17	; INP: 	(adr_SD_PHYS_SEKTOR_BYTE)	
	; Z-ZEIGER						
	ldi ZL, LOW(adr_SD_DATEN)
	ldi ZH,HIGH(adr_SD_DATEN)	
	; letzte BYTE POSITION laden	
	LDS temp1,(adr_CLUSTER_LAST_BYTE_L)
	LDS temp2,(adr_CLUSTER_LAST_BYTE_H)
	; addieren						
	add ZL,temp1
	adc ZH,temp2
	; mit SPACE auffllen			
DATEI_WRITE_512_CHECK_ERROR_SCHLEIFE:
	ldi temp,' '; SPACE	
	ST Z+,temp
	cpi ZH, HIGH(adr_SD_DATEN+512-1)
	brne DATEI_WRITE_512_CHECK_ERROR_SCHLEIFE
	cpi ZL, LOW(adr_SD_DATEN+512-1)
	brne DATEI_WRITE_512_CHECK_ERROR_SCHLEIFE
	; Zeilenumbruch einfgen		
	; Z-ZEIGER						
	ldi ZL, LOW(adr_SD_DATEN+510)
	ldi ZH,HIGH(adr_SD_DATEN+510)
	ldi temp, 13
	ST Z+,temp
	ldi temp, 10
	ST Z+,temp

	; Sektor schreiben												
	rcall SD_CMD24	; INP: (adr_SD_PHYS_SEKTOR_BYTE)	
; ------------------------------------------------------------------------------

	; DATEIGRSSE lt. Directory			
	LDS temp1,(adr_DATEI_GROESSE_BYTE1)
	LDS temp2,(adr_DATEI_GROESSE_BYTE2)
	LDS temp3,(adr_DATEI_GROESSE_BYTE3)
	LDS temp4,(adr_DATEI_GROESSE_BYTE4)
DATEI_WRITE_512_CHECK_ERROR_S:
	; + 1 addieren
	rcall FUNCTION_TEMP1_BIS_TEMP4_PLUS_EINS
	; addieren, bis ein vielfaches von 512 erreicht ist	
	tst temp1
	brne DATEI_WRITE_512_CHECK_ERROR_S 
	mov temp5,temp2
	andi temp5,00000001
	tst temp5
	brne DATEI_WRITE_512_CHECK_ERROR_S 
	; speichern							
	STS (adr_DATEI_GROESSE_BYTE1),temp1
	STS (adr_DATEI_GROESSE_BYTE2),temp2
	STS (adr_DATEI_GROESSE_BYTE3),temp3
	STS (adr_DATEI_GROESSE_BYTE4),temp4
	; neuen Direktory-EINTRAG schreiben
	rcall DIRECTORY_DATENSATZ_SCHREIBEN		; INP: (adr_ ...)
	rjmp DATEI_WRITE

; ------------------------------------------------------------------------------
; Wurde der zuletzt beschriebene Cluster schon komplett gefllt, 				
; muss ein neuer Cluster angelegt werden ?										
; ------------------------------------------------------------------------------
DATEI_WRITE_RUN:
	LDS temp1,(adr_CLUSTER_LAST_SEKTOR)			; letzten Sektor im letzten Cluster laden	
	LDS temp2,(adr_FAT_SEKTOREN_PRO_CLUSTER)	; SEKTOREN pro Cluster laden				
	cp temp1,temp2								; Vergleich									
	brne DATEI_WRITE_CLUSTER_OK
	; den komplett belegten Cluster um-nummerieren auf Nummer des free Clusters	
	LDS temp1,(adr_CLUSTER_ENDECLUSTER_L)
	LDS temp2,(adr_CLUSTER_ENDECLUSTER_H)
	STS (adr_CLUSTER_DATENSATZ_NR_L),temp1	; Datensatznummer	
	STS (adr_CLUSTER_DATENSATZ_NR_H),temp2
	LDS temp1,(adr_CLUSTER_NEXT_FREE_L)	
	LDS temp2,(adr_CLUSTER_NEXT_FREE_H)
	STS (adr_CLUSTER_INHALT_BYTE_L),temp1	; INHALT 			
	STS (adr_CLUSTER_INHALT_BYTE_H),temp2
	rcall FAT_TABELLE_EINTRAG_SCHREIBEN		; INP: (adr_CLUSTER_DATENSATZ_NR) (adr_CLUSTER_INHALT_BYTE)	
	; den free Cluster als belegt markieren (xFF xFF)
	LDS temp1,(adr_CLUSTER_NEXT_FREE_L)	
	LDS temp2,(adr_CLUSTER_NEXT_FREE_H)
	STS (adr_CLUSTER_DATENSATZ_NR_L),temp1	; Datensatznummer	
	STS (adr_CLUSTER_DATENSATZ_NR_H),temp2
	STS (adr_CLUSTER_INHALT_BYTE_L),VOLL	; INHALT 			
	STS (adr_CLUSTER_INHALT_BYTE_H),VOLL
	rcall FAT_TABELLE_EINTRAG_SCHREIBEN		; INP: (adr_CLUSTER_DATENSATZ_NR) (adr_CLUSTER_INHALT_BYTE)	
	; letzter Schreibsektor auf NULL					
	STS(adr_CLUSTER_LAST_SEKTOR),NULL
	; ENDE-Cluster auf einen neuen free Cluster setzen	
	LDS temp1,(adr_CLUSTER_NEXT_FREE_L)
	LDS temp2,(adr_CLUSTER_NEXT_FREE_H)
	STS(adr_CLUSTER_ENDECLUSTER_L),temp1
	STS(adr_CLUSTER_ENDECLUSTER_H),temp2
; ------------------------------------------------------------------------------
; einen Sektor schreiben														
; ------------------------------------------------------------------------------
DATEI_WRITE_CLUSTER_OK:
	; ZEILE1										
	rcall LCD_CLEAR
	ldi temp, 'w'
	rcall LCD_DATA
	ldi temp, 'r'
	rcall LCD_DATA
	ldi temp, 'i'
	rcall LCD_DATA
	ldi temp, 't'
	rcall LCD_DATA
	ldi temp, 'e'
	rcall LCD_DATA
	rcall LCD_3_PUNKT
	; INITIALISIEREN auf SCHREIB_CLUSTER			
	LDS temp1,(adr_CLUSTER_ENDECLUSTER_L)
	LDS temp2,(adr_CLUSTER_ENDECLUSTER_H)
	STS (adr_CLUSTER_DATENSATZ_NR_L),temp1
	STS (adr_CLUSTER_DATENSATZ_NR_H),temp2
	; BERECHNUNG_CLUSTER_NR_IN_PHYSISCHER_SEKTOR_NR
	rcall BERECHNUNG_CLUSTER_NR_IN_PHYSISCHER_SEKTOR_NR	; INP: (adr_CLUSTER_DATENSATZ_NR)
	; Physischen Sektor laden								
	LDS temp1,(adr_SD_PHYS_SEKTOR_BYTE1)
	LDS temp2,(adr_SD_PHYS_SEKTOR_BYTE2)
	LDS temp3,(adr_SD_PHYS_SEKTOR_BYTE3)
	LDS temp4,(adr_SD_PHYS_SEKTOR_BYTE4)
	; letzten beschriebenen Sektor in diesem Cluster LADEN	
	LDS temp5,(adr_CLUSTER_LAST_SEKTOR)
	; hinzuaddieren 					
	add temp1,temp5
	adc temp2,NULL
	adc temp3,NULL
	adc temp4,NULL
	; Physischen Sektor speichern		
	STS(adr_SD_PHYS_SEKTOR_BYTE1),temp1
	STS(adr_SD_PHYS_SEKTOR_BYTE2),temp2
	STS(adr_SD_PHYS_SEKTOR_BYTE3),temp3
	STS(adr_SD_PHYS_SEKTOR_BYTE4),temp4
; ------------------------------------------------------------------------------
	; hier werden die zu scheibenden DATEN der SD-Karte vorbereitet	
	rcall SD_DATEN
	; Sektor schreiben												
	rcall SD_CMD24	; INP: (adr_SD_PHYS_SEKTOR_BYTE)	
; ------------------------------------------------------------------------------
	; DATEIGRSSE lt. Directory		
	LDS temp1,(adr_DATEI_GROESSE_BYTE1)
	LDS temp2,(adr_DATEI_GROESSE_BYTE2)
	LDS temp3,(adr_DATEI_GROESSE_BYTE3)
	LDS temp4,(adr_DATEI_GROESSE_BYTE4)
	; + 512			
	ldi temp5, LOW (512)
	ldi temp6, HIGH(512)	
	add temp1,temp5
	adc temp2,temp6
	adc temp3,NULL
	adc temp4,NULL	
	; speichern		
	STS (adr_DATEI_GROESSE_BYTE1),temp1
	STS (adr_DATEI_GROESSE_BYTE2),temp2
	STS (adr_DATEI_GROESSE_BYTE3),temp3
	STS (adr_DATEI_GROESSE_BYTE4),temp4
	; neuen Direktory-EINTRAG schreiben
	rcall DIRECTORY_DATENSATZ_SCHREIBEN		; INP: (adr_ ...)
	; LCD			
	rcall LCD_TEXT_OK
	rcall wait_1s
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################
