

;												
; SD-KARTE und ATmega8							
; Bernhard.Erfurt@gmx.de						
; 03/2008										
;												

;												
; Anschlussbelegung PINS						
;												
; PB0 ==> 										
; PB1 ==> 										
; PB2 ==> SD-KARTE (CS)							
; PB3 ==> SD-KARTE								
; PB4 ==> SD-KARTE								
; PB5 ==> SD-KARTE								
; PB6 ==> Quarz									
; PB7 ==> Quarz									
;												
; PC0 ==> LCD									
; PC1 ==> LCD									
; PC2 ==> LCD									
; PC3 ==> LCD									
; PC4 ==> LCD									
; PC5 ==> LCD									
;												
; PD0 ==> RX									
; PD1 ==> TX									
; PD2 ==> 										
; PD3 ==> SD-KARTE-RELAIS (L=OFF)				
; PD4 ==> LED ORANGE+ TASTE						
; PD5 ==> LED GRN	+ TASTE						
; PD6 ==> LED GELB	+ TASTE						
; PD7 ==> LED ROT	+ TASTE						
;												


; ATmega8 										
.include "m8def.inc"
; KONSTANTEN									
.equ TAKT		=16000000			; 16 MHz	
; USART											
.equ BAUD		=57600
; TIMER-WERTE									
.equ TIMERWERT1	=65536-6250		;(2 hoch 16 minus....15625) bei 16MHz + Vorteiler 256 => 0,1s 	
; SPI											
.equ SPI_B_CS	= 2
.equ SPI_B_MOSI	= 3
.equ SPI_B_MISO	= 4
.equ SPI_B_SCK	= 5
; LEDS 											
.equ LED_D_ORANGE		= 4
.equ LED_D_GRUEN		= 5
.equ LED_D_GELB			= 7
.equ LED_D_ROT			= 6
; RELAIS (SD-KARTE)								
.equ RELAIS_D			= 3
; TASTATUR										
.equ TASTE_PLUS			= 32
.equ TASTE_MINUS		= 64
.equ TASTE_ENTER		=128
.equ TASTE_ESCAPE		= 16


; LCD											
.equ LCD_PORT				= PORTC
.equ LCD_D0					= 0
.equ LCD_D1					= 1
.equ LCD_D2					= 2
.equ LCD_D3					= 3
; LCD RS (Befehl/DATEN)							
.equ LCD_RS_PORT			= PORTB
.equ LCD_RS					= 0
; LCD_ENABLE									
.equ LCD_E_PORT				= PORTB
.equ LCD_E					= 1


; SRAM-BELEGUNG ATmega8							
.equ adr_DATEN					= 0x0060			; 0x0060 START Adresse 		

.equ adr_FREIGABE_PROGRAMM		=0x0060+0			; PROGRAMMFREIGABE	
.equ adr_FREIGABE_SD_SPEICHERUNG=0x0060+1			; Freigabe zum speichern der SD - DATEN	
.equ adr_TASTE					=0x0060+2			; Tastaturwert		
.equ adr_MENUE					=0x0060+3			; MENUE-AUSWAHL		

.equ adr_DATEN_DATENSATZNUMMER_L=0x0060+4			; Datensatznummer fr SD - DATEN		
.equ adr_DATEN_DATENSATZNUMMER_H=0x0060+5

.equ adr_ss10					=0x0060+10			; ZEIT (zehntel)
.equ adr_ss						=0x0060+11
.equ adr_mm						=0x0060+12
.equ adr_hh						=0x0060+13
.equ adr_TAG					=0x0060+14
.equ adr_MONAT					=0x0060+15
.equ adr_JAHR					=0x0060+16

.equ adr_ADC_0_L				=0x0060+17
.equ adr_ADC_0_H				=0x0060+18
.equ adr_ADC_1_L				=0x0060+19
.equ adr_ADC_1_H				=0x0060+20
.equ adr_ADC_2_L				=0x0060+21
.equ adr_ADC_2_H				=0x0060+22
.equ adr_ADC_3_L				=0x0060+23
.equ adr_ADC_3_H				=0x0060+24
.equ adr_ADC_4_L				=0x0060+25
.equ adr_ADC_4_H				=0x0060+26
.equ adr_ADC_5_L				=0x0060+27
.equ adr_ADC_5_H				=0x0060+28

.equ adr_LED_ORANGE_ON			=0x0060+35
.equ adr_LED_GRUEN_ON			=0x0060+36
.equ adr_LED_GELB_ON			=0x0060+37
.equ adr_LED_ROT_ON				=0x0060+38

.equ adr_NAME_BYTE1				=0x0060+39		; DATEINAME			
.equ adr_NAME_BYTE2				=0x0060+40
.equ adr_NAME_BYTE3				=0x0060+41
.equ adr_NAME_BYTE4				=0x0060+42
.equ adr_NAME_BYTE5				=0x0060+43
.equ adr_NAME_BYTE6				=0x0060+44
.equ adr_NAME_BYTE7				=0x0060+45
.equ adr_NAME_BYTE8				=0x0060+46
.equ adr_ERWEITERUNG_BYTE1		=0x0060+47		; DATEI-Erweiterung	
.equ adr_ERWEITERUNG_BYTE2		=0x0060+48
.equ adr_ERWEITERUNG_BYTE3		=0x0060+49

.equ adr_SD_PHYS_SEKTOR_BYTE1	= 0x0060+120		; Physische Adresse eines Sektors (Bootsektor=0)
.equ adr_SD_PHYS_SEKTOR_BYTE2	= 0x0060+121
.equ adr_SD_PHYS_SEKTOR_BYTE3	= 0x0060+122
.equ adr_SD_PHYS_SEKTOR_BYTE4	= 0x0060+123

.equ adr_SD_PHYS_SEKTOR_OLD_BYTE1= 0x0060+124		; fr Chache		
.equ adr_SD_PHYS_SEKTOR_OLD_BYTE2= 0x0060+125
.equ adr_SD_PHYS_SEKTOR_OLD_BYTE3= 0x0060+126
.equ adr_SD_PHYS_SEKTOR_OLD_BYTE4= 0x0060+127

.equ adr_FAT_RESERVIERTE_SEKTOREN_BOOT_L	=0x0060+150		;  Anzahl reservierter Sektoren (Boot Sektor)
.equ adr_FAT_RESERVIERTE_SEKTOREN_BOOT_H	=0x0060+151

.equ adr_FAT_BYTES_PRO_SEKTOR_L				= 0x0060+152 	; Bytes pro Sektor		
.equ adr_FAT_BYTES_PRO_SEKTOR_H				= 0x0060+153 

.equ adr_FAT_SEKTOREN_PRO_CLUSTER			= 0x0060+154 	; Sektoren pro Cluster	

.equ adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_L	=0x0060+155 	; Anzahl reservierter Sektoren (Volume Boot Sektor)
.equ adr_FAT_RESERVIERTE_SEKTOREN_VOLUME_H	=0x0060+156

.equ adr_FAT_KOPIEN							=0x0060+157 	; Anzahl FAT Kopien	

.equ adr_FAT_SEKTOREN_PRO_FAT_L				=0x0060+158 	; Anzahl FAT Kopien	
.equ adr_FAT_SEKTOREN_PRO_FAT_H				=0x0060+159

.equ adr_FAT_START_SEKTOR_FAT_1_L			= 0x0060+160	; START SEKTOR FAT1
.equ adr_FAT_START_SEKTOR_FAT_1_H			= 0x0060+161

.equ adr_FAT_START_SEKTOR_FAT_2_L			= 0x0060+162	; START SEKTOR FAT2
.equ adr_FAT_START_SEKTOR_FAT_2_H			= 0x0060+163

.equ adr_FAT_START_SEKTOR_ROOT_DIRECTORY_L	= 0x0060+164	; START SEKTOR ROOT-DIRECTORY	
.equ adr_FAT_START_SEKTOR_ROOT_DIRECTORY_H	= 0x0060+165

.equ adr_FAT_START_SEKTOR_DATENBEREICH_L	= 0x0060+166	; START SEKTOR DATENBEREICH		
.equ adr_FAT_START_SEKTOR_DATENBEREICH_H	= 0x0060+167

.equ adr_CLUSTER_DATENSATZ_NR_L				= 0x0060+168	; CLUSTER DATENSATZNUMMER in FAT	
.equ adr_CLUSTER_DATENSATZ_NR_H				= 0x0060+169

.equ adr_CLUSTER_INHALT_BYTE_L				= 0x0060+170	; CLUSTER INHALT (lt. CLUSTER DATENSATZNUMMER) in FAT	
.equ adr_CLUSTER_INHALT_BYTE_H				= 0x0060+171

.equ adr_CLUSTER_ENDECLUSTER_L				= 0x0060+172	; letzter CLUSTER der Datei lt. FAT + Directory
.equ adr_CLUSTER_ENDECLUSTER_H				= 0x0060+173

.equ adr_CLUSTER_LAST_SEKTOR				= 0x0060+174	; letzter beschriebene Sektor im letzten Cluster der Datei lt. FAT + Directory

.equ adr_CLUSTER_LAST_BYTE_L				= 0x0060+175	; letztes beschriebenes Bytes im letzten beschriebenen Sektor der Datei lt. FAT + Directory
.equ adr_CLUSTER_LAST_BYTE_H				= 0x0060+176

.equ adr_CLUSTER_NEXT_FREE_L				= 0x0060+177	; nchster LEERE CLUSTER in der FAT			
.equ adr_CLUSTER_NEXT_FREE_H				= 0x0060+178

.equ adr_DATEI_SEKTOR_ZAEHLER				= 0x0060+179	; HILFSZHLER	

.equ adr_FAT_DIREKTORY_DATENSATZ_NR_L		= 0x0060+200	; DATENSATZ-NUMMER fr DIRECTORY
.equ adr_FAT_DIREKTORY_DATENSATZ_NR_H		= 0x0060+201

.equ adr_DATEI_NAME_BYTE1					= 0x0060+250	; Dateinname						
.equ adr_DATEI_NAME_BYTE2					= 0x0060+251
.equ adr_DATEI_NAME_BYTE3					= 0x0060+252
.equ adr_DATEI_NAME_BYTE4					= 0x0060+253
.equ adr_DATEI_NAME_BYTE5					= 0x0060+254
.equ adr_DATEI_NAME_BYTE6					= 0x0060+255
.equ adr_DATEI_NAME_BYTE7					= 0x0060+256
.equ adr_DATEI_NAME_BYTE8					= 0x0060+257
.equ adr_DATEI_ERWEITERUNG_BYTE1			= 0x0060+258	; Dateierweiterung	
.equ adr_DATEI_ERWEITERUNG_BYTE2			= 0x0060+259
.equ adr_DATEI_ERWEITERUNG_BYTE3			= 0x0060+260
.equ adr_DATEI_ATTRIBUTE					= 0x0060+261	; Dateiattribute	
.equ adr_DATEI_NTRES						= 0x0060+262	; fr WIN NT (sollte immer Null sein)
.equ adr_DATEI_TIME_TENTH					= 0x0060+263	; Millisekunden			
.equ adr_DATEI_TIME_BYTE1					= 0x0060+264	; Zeit der Erstellung	
.equ adr_DATEI_TIME_BYTE2					= 0x0060+265	
.equ adr_DATEI_DATE_BYTE1					= 0x0060+266	; Datum der Erstellung			
.equ adr_DATEI_DATE_BYTE2					= 0x0060+267
.equ adr_DATEI_LST_DATE_BYTE1				= 0x0060+268	; Datum des letzten Zugriffs	
.equ adr_DATEI_LST_DATE_BYTE2				= 0x0060+269
.equ adr_DATEI_FST_CLUS_HI_BYTE1			= 0x0060+270	; sollte immer NULL sein
.equ adr_DATEI_FST_CLUS_HI_BYTE2			= 0x0060+271		
.equ adr_DATEI_WRT_TIME_BYTE1				= 0x0060+272	; Zeit des letzten Schreibvorgangs
.equ adr_DATEI_WRT_TIME_BYTE2				= 0x0060+273	
.equ adr_DATEI_WRT_DATE_BYTE1				= 0x0060+274	; Datum des letzten Schreibvorgangs
.equ adr_DATEI_WRT_DATE_BYTE2				= 0x0060+275
.equ adr_DATEI_STARTCLUSTER_L				= 0x0060+276	; START-CLUSTER lt. Directory	
.equ adr_DATEI_STARTCLUSTER_H				= 0x0060+277
.equ adr_DATEI_GROESSE_BYTE1				= 0x0060+378	; DATEI-Gre lt. Directory	
.equ adr_DATEI_GROESSE_BYTE2				= 0x0060+379
.equ adr_DATEI_GROESSE_BYTE3				= 0x0060+380
.equ adr_DATEI_GROESSE_BYTE4				= 0x0060+381

.equ adr_DATEI_GROESSE_IST_BYTE1			= 0x0060+382	; DATEI-Gre (HILFS-ZHLER)
.equ adr_DATEI_GROESSE_IST_BYTE2			= 0x0060+383
.equ adr_DATEI_GROESSE_IST_BYTE3			= 0x0060+384
.equ adr_DATEI_GROESSE_IST_BYTE4			= 0x0060+385

.equ adr_SD_DATEN							= 0x0060+386	; DATENBYTES				

; EEPROM-BELEGUNG ATmega8						
.equ adr_EEPROM_DATEN			= 0

; REGISTER										

.def FEHLER_CODE= R8

.def NULL 		= R10
.def EINS	 	= R11
.def VOLL   	= R12

.def temp 		= R16
.def temp1 		= R17
.def temp2 		= R18
.def temp3 		= R19
.def temp4 		= R20
.def temp5 		= R21
.def temp6 		= R22
.def temp7 		= R23
.def temp8 		= R24
.def temp9 		= R25


.cseg					;Beginn eines Code-Segmentes
.org 0					;Startadresse=0

rjmp RESET      		; Reset Handler                           				
rjmp INTERRUPT_ERROR	;rjmp EXT_INT0   ; IRQ0 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp EXT_INT1   ; IRQ1 Handler                      	
rjmp INTERRUPT_ERROR	;rjmp TIM2_COMP  ; Timer2 Compare Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM2_OVF   ; Timer2 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_CAPT  ; Timer1 Capture Handler            	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPA ; Timer1 CompareA Handler           	
rjmp INTERRUPT_ERROR	;rjmp TIM1_COMPB ; Timer1 CompareB Handler           	
rjmp TIM1_OVF   	  	; Timer1 Overflow Handler       						
rjmp INTERRUPT_ERROR	;rjmp TIM0_OVF   ; Timer0 Overflow Handler           	
rjmp INTERRUPT_ERROR	;rjmp SPI_STC    ; SPI Transfer Complete Handler     	
rjmp INTERRUPT_ERROR	;rjmp ZEICHEN_EINLESEN 	; USART RX Complete Handler     
rjmp INTERRUPT_ERROR	;rjmp USART_UDRE ; UDR Empty Handler                 	
rjmp INTERRUPT_ERROR	;rjmp USART_TXC  ; USART TX Complete Handler         	
rjmp INTERRUPT_ERROR	;rjmp ADC        ; ADC Conversion Complete Handler   	
rjmp INTERRUPT_ERROR	;rjmp EE_RDY     ; EEPROM Ready Handler              	
rjmp INTERRUPT_ERROR	;rjmp ANA_COMP   ; Analog Comparator Handler         	
rjmp INTERRUPT_ERROR	;rjmp TWSI       ; Two-wire Serial Interface Handler 	
rjmp INTERRUPT_ERROR	;rjmp SPM_RDY    ; Store Program Memory Ready Handler	


; Bei unkorrekten Interrupt aufrufen erfolgt ein RESET ber WDR	
INTERRUPT_ERROR:
	wdr	
INTERRUPT_ERROR_SCHLEIFE:
	rjmp INTERRUPT_ERROR_SCHLEIFE

RESET:                        
; STACK initialisieren								
	ldi temp, LOW(RAMEND)
    out SPL, temp
    ldi temp, HIGH(RAMEND)
    out SPH, temp
; Watchdog aktivieren (max. Zeit)					
	ldi TEMP,(1<<WDCE)|(1<<WDE)  
	out wdtcr,TEMP       
	ldi TEMP,(1<<WDE) | (1<<WDP2)|(1<<WDP1)|(1<<WDP0) 
	out wdtcr,temp
; SRAM_CLEAR										
	ldi ZL, LOW (adr_DATEN)
	ldi ZH, HIGH(adr_DATEN)
	clr temp
SRAM_CLEAR_w:
	ST z+,temp
	cpi ZH, HIGH(RAMEND); Vergleich?		
	brlo SRAM_CLEAR_w	; kleiner => SPRUNG	
	cpi ZL, LOW(RAMEND)	; Vergleich?		
	brlo SRAM_CLEAR_w	; kleiner => SPRUNG	
	breq SRAM_CLEAR_w	; gleich  => SPRUNG	
; PORT B initialisieren								
	ldi temp, 0b00101111	; SPI , LCD
	out DDRB, temp
; PORT B setzen										
	out PORTB, temp				
; PORT C initialisieren								
	ldi temp, 0b00001111	; ADC, LCD	
	out DDRC, temp
; PORT C setzen										
	out PORTC, temp				
; PORT D initialisieren								
	ldi temp, 0b11111000	; LEDs/RELAIS/TX/RX	
	out DDRD, temp
; PORT D setzen										
	out PORTD, temp				


			


; STARTWERTE										
	; NULL				
	clr NULL
	; EINS				
	ldi temp,1
	mov EINS,temp
	; 255				
	ldi temp,255
	mov VOLL,temp
	; FEHLER_CODE		
	clr FEHLER_CODE
	; ZEIT NULL			
	STS(adr_hh),NULL
	STS(adr_mm),NULL
	STS(adr_ss),NULL
	; DATUM				
	ldi temp1,1
	ldi temp2,1
	ldi temp3,1
	STS(adr_TAG),  temp1
	STS(adr_MONAT),temp2
	STS(adr_JAHR), temp3
	; DATEINAME			
	ldi temp1,'D'
	ldi temp2,'A'
	ldi temp3,'T'
	ldi temp4,'E'
	ldi temp5,'I'
	ldi temp6,'1'
	ldi temp7,' '
	ldi temp8,' '
	STS(adr_NAME_BYTE1),temp1
	STS(adr_NAME_BYTE2),temp2
	STS(adr_NAME_BYTE3),temp3
	STS(adr_NAME_BYTE4),temp4
	STS(adr_NAME_BYTE5),temp5
	STS(adr_NAME_BYTE6),temp6
	STS(adr_NAME_BYTE7),temp7
	STS(adr_NAME_BYTE8),temp8
	ldi temp1,'T'
	ldi temp2,'X'
	ldi temp3,'T'
	STS(adr_ERWEITERUNG_BYTE1),temp1
	STS(adr_ERWEITERUNG_BYTE2),temp2
	STS(adr_ERWEITERUNG_BYTE3),temp3
; CHACHE reset										
	rcall SD_CHACHE_RESET
; LCD_INITIALISIERUNG								
	rcall LCD_INITIALISIERUNG
; ANZEIGE_BEGRUESSUNG								
	rcall ANZEIGE_BEGRUESSUNG
; NEUSTART_MIT_WDR									
	rcall NEUSTART_MIT_WDR
; USART_INITIALISIEREN								
	rcall USART_INITIALISIEREN
; SPI_INITIALISIERUNG								
	rcall SPI_INITIALISIERUNG
; TIMER1_INITIALISIERUNG							
	rcall TIMER1_INITIALISIERUNG
; ADC_INITIALISIERUNG								
	rcall ADC_INITIALISIERUNG
; Interrupts freigeben								
	sei

; ##############################################################################
; ##############################################################################
; ##############################################################################

; LED-TEST											
	rcall LED_TEST

; SD_KARTE_INITIALISIERUNG			
	rcall SD_KARTE_INITIALISIERUNG	
	rcall wait_1s
	rcall ANZEIGE_FAT_INFO
	rcall wait_1s
	rcall wait_1s
	rcall wait_1s
	rcall DATEI_WRITE
	rcall DATEI_WRITE
	rcall DATEI_WRITE
	rcall ANZEIGE_DIRECTORY_EINZELNER_DATENSATZ
	rcall wait_1s	
	rcall wait_1s
	rcall wait_1s

; ##############################################################################
; ##############################################################################
; ##############################################################################
LOOP:
	WDR		; Watch-Dog-RESET	

	LDS temp,(adr_FREIGABE_PROGRAMM)
	tst temp
	breq LOOP
; ------------------------------------------------------------------------------
	STS(adr_FREIGABE_PROGRAMM),NULL	; Programmfreigabe	
	STS(adr_LED_GRUEN_ON),EINS		; Grn an	
	STS(adr_LED_GELB_ON),EINS		; 
	STS(adr_LED_ORANGE_ON),EINS		; 

	rcall MESSEN_4
	rcall MESSEN_5

	rcall SD_CHACHE_RESET
	rcall DIRECTORY_DATENSATZ_AUSLESEN

	
	rcall MENUE_AUSWERTUNG

	rcall BERECHNUNG_DATEN_AUF_SD_KARTE_SPEICHERN


; ------------------------------------------------------------------------------
	rcall PROGRAMM_CHECK

	STS(adr_LED_GELB_ON),NULL		; 
rjmp LOOP
; ##############################################################################
; ##############################################################################
; ##############################################################################
BERECHNUNG_DATEN_AUF_SD_KARTE_SPEICHERN:
	LDS temp,(adr_FREIGABE_SD_SPEICHERUNG)
	tst temp
	brne BERECHNUNG_DATEN_AUF_SD_KARTE_SPEICHERN_START
	ret
BERECHNUNG_DATEN_AUF_SD_KARTE_SPEICHERN_START:
	; NULL		
	STS(adr_FREIGABE_SD_SPEICHERUNG),NULL
	; speichern	
	rcall DATEI_WRITE
ret
; ##############################################################################
; ##############################################################################
; ##############################################################################


.include "SD_LCD.asm"
.include "SD_SPI.asm"
.include "SD_READ.asm"
.include "SD_WRITE.asm"
.include "SD_FAT.asm"
.include "SD_DATEN.asm"
.include "SD_MENUE.asm"
.include "SD_TIMER.asm"
.include "SD_SONSTIGES.asm"
.include "SD_ADC.asm"

; ##############################################################################
; ##############################################################################
; ##############################################################################


TEXT_BEGRUESSUNG_1:
.db "SD-KARTE",0
TEXT_BEGRUESSUNG_2:
.db "ATmega8",0
TEXT_BEGRUESSUNG_3:
.db "Version 8",0
TEXT_BEGRUESSUNG_4:
.db "25.Marz 2008",0



