#ifndef UART_H_
#define UART_H_

#include <stdbool.h>

enum uart_e        { UART0, UART1, UART2, UART3 };
enum uart_bits_e   { DATABIT_5, DATABIT_6, DATABIT_7, DATABIT_8 };
enum uart_parity_e { P_NONE, P_ODD, P_EVEN };
enum uart_stop_e   { STOPBIT_1, STOPBIT_2 };
enum uart_layout_e { LAYOUT_FIRST, LAYOUT_SECOND, LAYOUT_THIRD };
enum uart_baudrate_e { BAUD_600, BAUD_1200, BAUD_2400, BAUD_4800, BAUD_9600, BAUD_14400, BAUD_19200, BAUD_28800, BAUD_38400, BAUD_56000, BAUD_57600, BAUD_115200 };

/* Connect uart with IO pins.
 * The possible layout depends on the uart being used:
 * 
 * UART0:
 * LAYOUT_FIRST (P0.2, P0.3)
 * 
 * UART1:
 * LAYOUT_FIRST (P0.15, P0.16 [,P0.17, P0.22]), LAYOUT_SECOND (P2.0, P2.1 [,P2.2, P2.7])
 * 
 * UART2:
 * LAYOUT_FIRST (P0.10, P0.11), LAYOUT_SECOND (P2.8, P2.9)
 * 
 * UART3:
 * LAYOUT_FIRST (P0.0, P0.1), LAYOUT_SECOND (P0.25, P0.26), LAYOUT_THIRD (P4.28, P4.29)  
 */
void uart_enable(enum uart_e uart, enum uart_layout_e layout, bool bUseHandshaking);

void uart_setBaudrate(enum uart_e uart, enum uart_baudrate_e baudrate);
void uart_setDivider(enum uart_e uart, unsigned divider, unsigned mulval, unsigned divaddval);
void uart_setMode(enum uart_e uart, enum uart_bits_e bits, enum uart_parity_e parity, enum uart_stop_e stopbits);

void uart_writeData(enum uart_e uart, unsigned char data);
void uart_setReadCallback(enum uart_e uart, int (*cb)(int));

#endif /*UART_H_*/
