/*****************************************************************************
 *   timer.h:  Header file for NXP LPC23xx/24xx Family Microprocessors
 *
 *   Copyright(C) 2006, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2006.07.13  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#ifndef __TIMER_H 
#define __TIMER_H

#define TIME_INTERVAL	(Fpclk/1000000u - 2 - 1)

typedef unsigned int timer_t;

void timer_init(void);
timer_t currentTimer(void);
timer_t elapsedTime(timer_t prevTime);
timer_t elapsedTime_us(timer_t prevTime);
void delay_ms(unsigned ms);
void delay_us(unsigned us);

#endif
