/*****************************************************************************
 *   timer.c:  Timer C file for NXP LPC23xx/24xx Family Microprocessors
 *
 *   Copyright(C) 2006, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2006.09.01  ver 1.00    Prelimnary version, first Release
 *
******************************************************************************/
#include "LPC23xx.h"		/* LPC23xx/24xx Peripheral Registers	*/
#include "irq.h"
#include "timer.h"

#include "defines.h"

#if 1
/******************************************************************************
** Function name:		Timer0Handler
**
** Descriptions:		Timer/Counter 0 interrupt handler
**				executes each 10ms @ 60 MHz CPU Clock
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
#ifdef __GNUC__
void Timer0Handler (void); // avoid missing proto warning - mthomas
#endif
void Timer0Handler (void) __irq 
{  
    T0IR = 1;			/* clear interrupt flag */
	
    VICVectAddr = 0;		/* Acknowledge Interrupt */
}
#endif

/******************************************************************************
** Function name:		init_timer
**
** Descriptions:		Initialize timer, set timer interval, reset timer,
**						install timer interrupt handler
**
** parameters:			None
** Returned value:		true or false, if the interrupt handler can't be
**						installed, return false.
** 
******************************************************************************/
void timer_init() 
{
	T0PR  = 72-1;
    
#if 0
	T0MR0 = 204800;
    T0MCR = 1;				/* Interrupt and Reset on MR0 */
    install_irq( TIMER0_INT, (void *)Timer0Handler, HIGHEST_PRIORITY );
#endif
    
    T0TCR = _BV(0);
}

timer_t currentTimer()
{
	timer_t ret;
	
	ret = T0TC;
	if (ret == 0) ret = 1;
	
	return ret;
}

timer_t elapsedTime(timer_t prevTime)
{
	return (currentTimer() - prevTime) / 1024;
}

timer_t elapsedTime_us(timer_t prevTime)
{
	return (currentTimer() - prevTime);
}

void delay_ms(unsigned ms)
{
	timer_t time;
	
	time = currentTimer();
	while (elapsedTime(time) < ms);
}

void delay_us(unsigned us)
{
	timer_t time;
	
	time = currentTimer();
	while (elapsedTime_us(time) < us);
}
