#include <avr/io.h>
#include <inttypes.h>
#include <string.h>
#include <stdio.h>
#include <stdint.h> 
#include <avr/interrupt.h>
#define F_CPU 8000000UL
#include <util/delay.h>
#include "rs232.h"
#define cpuclock 8000000L
#define XTAL	8000000L


//----------------------PORT DEFINITION
//PORT CS
#define port_spi_alt_cs()		DDRC|=(1<<2); //CS FUNK
#define port_spi_ss()			DDRB|=(1<<0); //CS SS
#define port_spi_flash_cs()			DDRC|=(1<<0); //CS LED
#define port_spi_sd_cs()			DDRC|=(1<<1); //CS LED


//PORT SPI
#define port_spi_sck()	DDRB|=(1<<1); //SCK
#define port_spi_mosi()	DDRB|=(1<<2);//MOSI
#define port_spi_miso()	DDRB&=~(1<<3);//MISO

#define alt_cs_high()	PORTC|=(1<<2); //HEIGH FUNK CS
#define alt_cs_low()	PORTC&=~(1<<2); //LOW FUNK CS

#define flash_cs_high()	PORTC|=(1<<0); //HEIGH 7seg CS
#define flash_cs_low()	PORTC&=~(1<<0); //LOW 7seg CS

#define sd_cs_high()	PORTC|=(1<<1); //HEIGH 16LED CS
#define sd_cs_low()	PORTC&=~(1<<1); //LOW 16LED CS


#define ss_high()		PORTB|=(1<<0); //HEIGH SS



#define PORT_GPSLED()	DDRD|=(1<<7); //POWER UP
#define gps_led_high()	PORTD|=(1<<7); //HEIGH FUNK PWUP
#define gps_led_low()	PORTD&=~(1<<7); //LOW FUNK PWUP

#define PORT_LOGGERLED()	DDRD|=(1<<6); //POWER UP
#define logger_led_high()	PORTD|=(1<<6); //HEIGH FUNK PWUP
#define logger_led_low()	PORTD&=~(1<<6); //LOW FUNK PWUP
#define logger_blink()	PORTD^=(1<<6); //LOW FUNK PWUP




extern unsigned char read_SPI(void);
extern unsigned char Write_SPI(unsigned char data);
void waitms(int ms);
void DelayUs(unsigned int N);
uint8_t gps_out;
