#include "main.h"

unsigned char rbuffer;

void init_rs232(unsigned int baud0,unsigned int baud1);
void send_UART(char *s);
int uart_putchar (char c);



void init_rs232(unsigned int baud0,unsigned int baud1)
{
baud0=cpuclock/((baud0*16L)-1);
baud1=cpuclock/((baud1*16L)-1);

//UART 0 INIT
UBRR0H= (unsigned char)(baud0>>8);
UBRR0L = (unsigned char) baud0;
UCSR0A = 0x00;			/* USART operates at normal speed */
UCSR0B = (	(1<<RXCIE) | (1<<RXEN));		/* Enable receiver */
UCSR0C = (	(0<<UMSEL) |	/* Configure for asynchronous operation */
				(0<<UPM1)  |	/* No parity */
				(0<<UPM0)  |
				(0<<USBS)  |	/* 1 stopbit */
				(1<<UCSZ1) |	/* 8 data bits */
				(1<<UCSZ0));


//UART 1 INIT
UBRR1H= (unsigned char)(baud1>>8);
UBRR1L = (unsigned char) baud1;
UCSR1B= ((1<<RXCIE)|(1<<RXEN) | (1<<TXEN));
UCSR0C = (	(0<<UMSEL) |	/* Configure for asynchronous operation */
				(0<<UPM1)  |	/* No parity */
				(0<<UPM0)  |
				(0<<USBS)  |	/* 1 stopbit */
				(1<<UCSZ1) |	/* 8 data bits */
				(1<<UCSZ0));

  }









int uart_putchar (char c)
{
	
	//Warten solange bis Zeichen gesendet wurde
	loop_until_bit_is_set(UCSR1A, UDRE);
	UDR1 = c;
	return (0);
}

 //zum Senden ber die UART 1
void send_UART(char *s)
{
 while (*s)
    {   /* so lange *s != '\0' also ungleich dem "String-Endezeichen" */
      loop_until_bit_is_set(UCSR1A, UDRE);
 UDR1=(*s);
        s++;
    }


}



