/*
 * DLA_mini.asm
 *
 *  Created: 26.07.2017 09:58:39
 *   Author: bernommen von Michael Ulbrich
 */ 
.include "m16def.inc"
;Takt fr ATmega16 = 16MHz extern!
; 29.06.2009 FW 0.8
; einstellbare Bufferlnge eingebaut mglich 4k, 8k, 16k und 32k
;*****************************************************************
; Definitionen fr Mega16
; Belegungen der Ports:
;*****************************************************************
;PA0 ADC0		Triggerbyte 0
;PA1 ADC1		Triggerbyte 1
;PA2 ADC2		Triggerbyte 2
;PA3 ADC3		Triggerbyte 3
;PA4 ADC4		Triggerbyte 4
;PA5 ADC5		Triggerbyte 5
;PA6 ADC6		Triggerbyte 6
;PA7 ADC7		Triggerbyte 7
;--------------------------------------
;PB0 XCK/T0		Daten 0
;PB1 T1			Daten 1
;PB2 INT2/AIN0  Daten 2
;PB3 OC0/AIN1   Daten 3
;PB4 SS			Daten 4
;PB5 MOSI		Daten 5
;PB6 MISO		Daten 6
;PB7 SCK		Daten 7
;--------------------------------------
;PC0 SCL		Triggermaske 0
;PC1 SDA		Triggermaske 1
;PC2 TCK		Triggermaske 2
;PC3 IMS		Triggermaske 3
;PC4 TDO		Triggermaske 4
;PC5 TDI		Triggermaske 5
;PC6 TOSC1		Triggermaske 6
;PC7 TOSC2		Triggermaske 7
;--------------------------------------
;PD0		RxD			RS232 Eingang
;PD1		TxD			RS232 Ausgang
;PD2		INT0		Eingang externe Triggerauswertung, H Trigger
;PD3		INT1		Umschaltung Sample/Lesen, H Lesen, L Sample			(MU NOCH AUSPROBIERT WERDEN OB H oder L!)
;PD4	    OC1B 		Input-Buffer TriState H, aktiv L
;PD5		OC1A		Clock fr Ram-Adresszhler
;PD6		ICP1		Clock-Mux B
;PD7		OC2			Clock-Mux A
;--------------------------------------
;Byte 1	Triggerbyte
;Byte 2	Triggermaske
;Byte 3	Timerintervall			(AVR Timerwert)
;Byte 4	TimerScale				(AVR Prescaler)
;Byte 5	Pretrigger	1...8, 12,5%, 25%, ... 87,5%, 0% (8)
;Byte 6	ungenutzt
;Byte 7	Mode
;--------------------------------------
;Mode0: send_version
;Mode1: frei
;Mode2: frei
;Mode3: frei
;Mode4: frei
;Mode5: frei
;Mode6: frei
;Mode7: frei
;Mode8: frei
;Mode9: frei
;Mode10: test_bin_count
;Mode11: int_clock_int_trigger
;--------------------------------------
;kompletten RAM nach dem Samplen kommentarlos zum PC schicken 
;--------------------------------------
;0xF0 wird fter als maximale Steuerbyte-Anzahl vom PC gesendet als Software-Reset
;*****************************************************************
;Abfragewerte der PC Software zur Hardwareerkennung vorgeben
.equ	HW_VER		= '1'
.equ	HW_REV		= '1'
.equ	FW_VER		= '1'
.equ	FW_REV		= '0'
;--- Allgemeines -----------------------------------------------
.equ F_CPU           = 16000000
.equ CYCLES_PER_US   = ((F_CPU+500000)/1000000)
.equ UART_BAUD_RATE  = 500000
;.equ UART_BAUD_SELECT = (F_CPU/(UART_BAUD_RATE*16))-1		; U2X nicht gesetzt (Ergebnis entspricht = 1)
.equ UART_BAUD_SELECT = (F_CPU/(UART_BAUD_RATE*8))-1		; U2X gesetzt (Ergebnis entspricht = 3)
;--- Daten ------------------------------------------------
;Eingangsport fr die Daten bestimmen
.equ DATEN_DDR	= DDRB		;Datenrichtungsregister bestimmen
.equ DATEN_PORT	= PORTB		;Datenausgangsport bestimmen
.equ DATEN_IN	= PINB		;Dateneingangsport bestimmen
;--------------------------------------
;Port bestimmen, der die Kontrolle ber die Samplehardware hat.
.equ CTRL_PORT	= PORTD		;Ausgangsport zur Kontrolle der Samplehardware
.equ CTRL_PIN	= PIND		;Eingangsport zur Kontrolle der Samplehardware
;--------------------------------------
;Portpins bestimmen die die Kontrolle der Samplehardware bernehmen
.equ TRIG_IN	= PD2		;Eingang externe Triggerauswertung, H Trigger
.equ C_SAMPLE	= PD3		;Umschaltung Sample/Lesen, H Lesen, L Sample			
.equ C_BUFFER	= PD4		;Input-Buffer TriState H, aktiv L
.equ C_CLOCK	= PD5		;Takt fr Ram-Adresszhler (OC1A) = Erzeugung eines Taktes aus den 16MHz des ATmega16 fr den Adresszhler des Sample-RAMS.
.equ MUX_A		= PD6		;Bit0 fr die Selektion der Taktfrequenz am 74AC151
.equ MUX_B		= PD7		;Bit1 fr die Selektion der Taktfrequenz am 74AC151
;--------------------------------------
.equ T_PORT		= PORTA		;Ausgabeport fr die Triggermaske zum 74HC688 hin.
;--------------------------------------
.equ M_PORT		= PORTC		;Ausgabeport fr die Datenmaske zu den 74AC32 und weiter zum 74HC688 hin. (Ausblenden von nicht zu samplenden Datenleitungen)
;--------------------------------------
;OCR1A als Taktausgabe selektieren. Werte fr Stop Ausgabe von Takten und Start der Ausgabe von Takten fr den OCR1A.
.equ CLK_STOP	= (1<<WGM12);Timer Stop, CTC-Mode vom OCR1A
.equ CLK_START	= (1<<WGM12) | (1<<CS10); Timer Start, Prescale 1 vom OCR1A
;--------------------------------------
;Steuerleitungen fr den 74AC151 fr die verschiedenen Takte
.equ MUX_INT	= 0b00000000;Kanal 0 des 74AC151 fr den Intern erzeugten Takt
.equ MUX_40MHZ	= 0b01000000;Kanal 1 des 74AC151 fr den 40MHz Takt, geteilt aus dem 80MHz Oszillator
.equ MUX_20MHz	= 0b10000000;Kanal 2 des 74AC151 fr den 20MHz Takt
.equ MUX_80MHZ	= 0b11000000;Kanal 3 des 74AC151 fr den 80MHz Takt, geteilt aus dem 80MHz Oszillator
.equ MUX_MASKE	= 0b00111111;Alle anderen Bits ausschlieen
;--------------------------------------
;Befehle die zur Kommunikation mit der PC Software bentigt werden
.equ CMD_RESTART = 0xF0
;--------------------------------------
;Bestimmung der verschiedenen internen Samplefrequenzen.
.equ CLK_80M	= 0		; ->  12,5ns
.equ CLK_40M	= 0		; ->  25ns
.equ CLK_20M	= 0		; ->  50ns
.equ CLK_8M		= 0		; -> 125ns
.equ CLK_4M		= 1		; -> 250ns
.equ CLK_2M		= 3		; -> 500ns
.equ CLK_800k	= 9 	; -> 1,25s
.equ CLK_400k	= 19 	; -> 1,25s
.equ CLK_200k	= 39	; -> 5s
.equ CLK_80k 	= 99	; -> 12,5s
.equ CLK_40k	= 199	; -> 20s
.equ CLK_20k	= 399	; -> 50s
.equ CLK_8k		= 999	; -> 125s
.equ CLK_4k		= 1999	; -> 200s
.equ CLK_2k		= 3999	; -> 500s
.equ CLK_800	= 9999	; -> 1,25ms
;--------------------------------------
;Bestimmung wieviel SRAM als Sample-RAM eingebaut sind. Diesen Wert immer als HEX Wert angeben auch wenn dieser HEX Wert von 32 eigentlich dezimal 50 darstellt! 
;.equ RAM_SIZE   = 0x04	;Fr 4kByte
;.equ RAM_SIZE   = 0x16	;Fr 16kByte in HEX = Erkennung fr das PC Programm!	
.equ RAM_SIZE   = 0x32	;Fr 32kByte
;--------------------------------------
;Die verschiedenen Modes welche durch die PC Software ausgelst werden knnen. 
.equ MODE_MAX	= 12	; maximale Anzahl Funktionen in der Tabelle
;**************************** Ram-Reservierungen ******************
;--- Internes Ram ------------------------------------------------
.DSEG
.ORG 0x100
BUF_LEN_L:	.byte		1			; Samplebufferlnge Hier wird zwischengespeichert, wie gro der Samplespeicher ist.
BUF_LEN_H:	.byte 		1
.;**************************** Register-Bits **************************
;--- lower Register -----------------------------------------------
.def MUL_L			= r0
.def MUL_H			= r1
.def BUF_LEN_REG	= r2
.def NULL			= r3
;--- higher Register ----------------------------------------------
.def PRE_TRIGGER	= r16
.def MODE			= r17
.def TRIG_BYTE		= r18
.def SREG_SAVE		= r19
.def TIMER_L		= r20
.def TIMER_H		= r21
.def TRIG_MASK		= r22
.def TIMER_WERT		= r23
.def TEMP_1			= r24
.def TEMP_0			= r25
;r26/r27, r28/r29, r30/r31 fr X,Y,Z reserviert 
;--- Macros -------------------------------------------------------
.macro  load_p				; ldt 16Bit @1 nach @0 High und @0 Low
ldi     @0H,HIGH(@1)
ldi     @0L,LOW(@1)
.endmacro
;****************************** Verktor-Liste ****************************
.CSEG
rjmp    Reset
.ORG	URXCaddr
rjmp	irq_rx				; fr Break-Funktion
;*************************************************************************************************
;****************************** Programm-Beginn **************************************************
;*************************************************************************************************
.ORG	INT_VECTORS_SIZE
;*********************************************************************
;  Initialisierungsroutine
;*********************************************************************
;Hardware initialisieren
Reset:
ldi TEMP_0, low(RAMEND)		;Stack an das interne RAM-Ende
out SPL, TEMP_0
ldi TEMP_0, high(RAMEND)
out SPH, TEMP_0
;Port A *************************************************************
ser	TEMP_0					;Register mit FF laden (alle Bytes HIGH)
out	PORTA, TEMP_0			;Port A jedes TRIGGER-Byte auf HIGH setzen
ser	TEMP_0					;Register mit FF laden (alle Bytes HIGH) und damit alle Bits als Ausgang
out	DDRA, TEMP_0			;Richtung des Port A festlegen
;Port B *************************************************************
ser	TEMP_0					;Register mit FF laden (alle Bytes HIGH)
out	PORTB, TEMP_0			;Da die Datenrichtung als Eingang fungiert, werden hiermit die PULLUP Widerstnde initialisiert
clr	TEMP_0					;Register mit 00 laden (alle Bytes LOW) und damit alle Bits als Eingang
out	DDRB, TEMP_0			;Richtung des Port B festlegen
;Port C *************************************************************
ser	TEMP_0					;Register mit FF laden (alle Bytes HIGH)
out	PORTC, TEMP_0			;Port C jedes DATENMASKEN-Byte auf HIGH setzen
ser	TEMP_0					;Register mit FF laden (alle Bytes HIGH) und damit alle Bits als Ausgang
out	DDRC, TEMP_0			;Richtung des Port C festlegen
;Port D *************************************************************
ldi	TEMP_0, ~((1<<C_CLOCK) | (1<<MUX_A) | (1<<MUX_B)) ;PD5, PD6 und PD7 auf 0 LOW setzen. LOW weil ~ davor steht! 0b00011111 
out	PORTD, TEMP_0			;Ram lesen, Buffer TriState, Takt H ( /WE inaktiv)
ldi	TEMP_0, (1<<C_SAMPLE) | (1<<C_BUFFER) | (1<<C_CLOCK) | (1<<MUX_A) | (1<<MUX_B) ;in temp_0 = 0b11111000 HIGH=Ausgang LOW=Eingang PD0 und PD1 = RX und TX, PD2 = Triggereingang
out	DDRD, TEMP_0			;Datenrichtung der Bits am Port D setzen
;UART ***************************************************************
ldi TEMP_0, high(UART_BAUD_SELECT)
out UBRRH, TEMP_0								;Baudrate HIGH Byte schreiben (sollte 500000 Baud fr FTDI232RL sein!)
ldi TEMP_0, low(UART_BAUD_SELECT)
out UBRRL, TEMP_0								;Baudrate LOW Byte schreiben (sollte 500000 Baud fr FTDI232RL sein!)
ldi TEMP_0, (1<<U2X)							;U2X setzen
out UCSRA, TEMP_0
ldi TEMP_0, (1<<TXEN) | (1<<RXEN) | (1<<RXCIE)	;RX und TX einschalten, RXCIE = Wenn der Empfang eines Bytes beendet dann den Interrupt auslsen!
out UCSRB,TEMP_0
ldi TEMP_0, (1<<URSEL) | (1<<UCSZ1) | (1<<UCSZ0);URSEL = immer 1 wenn man UCSRC beschreiben will, UCSZ0 und UCSZ1 = 8 Datenbits
out UCSRC, TEMP_0
;*********************************************************************				 
;Software initialisieren
clr	NULL					;Register r3 lschen, Dient als 0 Trger bei 16-Bit Berechnungen
load_p  Y, 32768			;Ramgre 32k
;load_p  Y, 16384			;Ramgre 16k
;load_p  Y, 4096			;Ramgre 4k
sts	BUF_LEN_L, YL			;Ramgre im internen SRAM ablegen
sts	BUF_LEN_H, YH
;*********************************************************************
;Main-Loop (Hauptprogramm)
;*********************************************************************
main:	
;Warten auf Anweisungen kommend von der PC Software			
rcall uart_receive_byte		;7 Mode ,Warten bis ein Byte empfangen wurde.
cpi TEMP_0, CMD_RESTART		;Command-Byte?, Prfen ob es 0xF0 war fr Softwarerestart
breq main  					;Wenn es 0xF0 war, dann zurck zum Anfang der Hauptschleife und erneut auf ein reinkommendes Byte warten.
mov	MODE, TEMP_0			;Wenn es nicht 0xF0 war, dann den empfangenen Wert nach MODE (Register r17) verschieben. Denn dieser Wert wird bestimmen welchen Mode ein Sample hat.
rcall uart_receive_byte		;1 Triggerbyte, Nun sollte als nchstes der Wert fr das Triggerbyte von der PC Software folgen
mov	TRIG_BYTE, TEMP_0		;Den empfangenen Wert von der PC Software fr den Trigger in das Register TRIG_BYTE (r18) ablegen
rcall uart_receive_byte		;2 Triggermaske, Jetzt sollte die Datenmaske von der PC Software folgen
mov	TRIG_MASK, TEMP_0		;Den empfangenen Wert von der PC Software fr die Datenmaske in das Register TRIG_MASK (r22) ablegen
rcall uart_receive_byte		;3 Timerintervall, Jetzt sollte das Timing von der PC Software folgen
cpi	TEMP_0, CMD_RESTART		;Reset-Byte?, Prfen, ob es 0xF0 ist.
breq main					;Wenn es 0xF0 war, dann zurck zum Anfang der Hauptschleife und erneut auf ein reinkommendes Byte warten.
mov	TIMER_WERT, TEMP_0		;Wenn es nicht 0xF0 war, dann den empfangenen Wert nach TIMER_WERT (Register r23) verschieben. 
rcall uart_receive_byte		;5 Pretrigger, Jetzt sollte die Angabe folgen, die den Wert fr den Bereich, der angezeigt werden soll, vor Eintreffen eines Triggers enthlt.
cpi	TEMP_0, CMD_RESTART		;Reset-Byte? War es 0xF0 ?
breq main					;Wenn es 0xF0 war, dann zurck zum Anfang der Hauptschleife und erneut auf ein reinkommendes Byte warten.
mov	PRE_TRIGGER, TEMP_0		;Wenn es nicht 0xF0 war, dann den empfangenen Wert nach PRE_TRIGGER (Register r16) verschieben. 
rcall uart_receive_byte		;6 zustzliches 1. LS164	???????????WIRD DAS BERHAUPT GESENDET?, Weil nicht mehr bentigt!???????????????????????????????????
rcall uart_receive_byte		;7 zustzliches 2. LS164    ???????????WIRD DAS BERHAUPT GESENDET?, Weil nicht mehr bentigt!???????????????????????????????????
cpi	MODE, MODE_MAX			;ungltiger Mode, Jetzt den als erstes empfangenes Byte abgelegten MODE Wert (r17) mit dem Maximum was an Modes berhaupt mglich ist berprfen.
brsh main					;Ist der MODE-Wert gleich oder grer als MODE_MAX (12) dann ist ein Fehler aufgetreten und es mu zurck zum Anfang gesprungen werden.
;Auswerten, welche Funktion aus der Tabelle verwendet werden soll.
load_p	Z,(2*tab_funktion)	;Wenn der MODE- Wert aber unterhalb MODE_MAX (12) war, lade ZH und ZL mit der Startadresse der entsprechenden Funktion aus der .dw Tabelle heraus.
lsl	MODE					;Wert von MODE einmal nach links schieben und somit verdoppeln
add	ZL, MODE				;Jetzt auf die Startadresse des Modeprogramms aufaddieren
adc	ZH, NULL				;Das HIGH Byte mit 0 addieren, so das nur maximal das Carrybit mit addiert wird!
lpm	YL, Z+					;Funtionsadresse holen
lpm	YH, Z
mov	ZL, YL					;und nach Z fr ICALL
mov	ZH, YH
icall						;Aufruf einer Unterroutine wo die Adresse dafr in Z liegt. Das jann sein "send_version:", "dummy:", "test_bin_count:" oder "int_clock_int_trigger:".
cpi MODE, 10				;Prfen ob MODE = 10 war
brlo main					;Wenn weniger als 10 dann zurck zum Anfang
;Alle Daten aus dem SRAM zur PC Software senden.
rcall send_daten			;Wenn mehr als 10 dann sende die Daten aus dem Sample-SRAM 
rjmp main					;Grundstzlich zurck zum Anfang
;******************************* INTERRUPT ROUTINE ******************************
irq_rx:						;Einsprung Interrupt zur Unterbrechnung eines Samples
in	SREG_SAVE, SREG			;Das Statusregister in r19 sichern
lds	YL, UDR0				;Byte von der UART abholen
in YL, UDR					;Eigentliches Byte auslesen
ldi	YL, 1					;Restzhler auf Minimum
ldi	YH, 0
sbr	SREG_SAVE, (1<<SREG_T)	;Das T Bit im abgespeicherten Status Register setzen
out	SREG, SREG_SAVE			;Das Statusregister wieder zurck schreiben und auch aktualisieren.
reti						;Raus aus dem Interrupt
;*****************************************************************************************
;**************************** Allgemeine Routinen UNTERPROGRAMME**************************
;*****************************************************************************************
;******************************* Sub-UART **********************************
; Sub: Sendet ein Byte aus TEMP_0 ber UART
; Parameter:    -
; Return:       -
; Scratch-Reg:  -
;***************************************************************************
uart_send_byte:
sbis UCSRA, UDRE            ;Send-Register leer ?
rjmp uart_send_byte         ;nein
out UDR, TEMP_0				;wenn Senderegister leer dann neuen Wert bergeben
ret							;zurck zum aufrufenden Programm
;******************************* Sub-UART **********************************
; Sub: Empfngt Byte ber UART
; Parameter:    -
; Return:       TEMP_0 Datenbyte
; Scratch-Reg:  -
;***************************************************************************
uart_receive_byte:
sbis UCSRA, RXC				;Schon was angekommen?
rjmp uart_receive_byte		;nein
in TEMP_0, UDR				;Wenn ja dann in temp reinholen
;uart_receive_byte_end:
ret							;Zurck zum aufrufenden Programmteil
;*********************************************************************
; Sub: Send den Buffer-Inhalt
; Parameter:    Z zeigt auf erste Bufferposition
; Return:       -
; Scratch-Reg:  TEMP_0, Y, Z
;*********************************************************************
send_daten:					;Einsprungsmarke um die Daten aus dem Sample-SRAM zu senden
lds	YL, BUF_LEN_L			;alle Daten senden, Komplette RAM gre laden
lds	YH, BUF_LEN_H
cpi YH, high(0x8000)        ;Prfen, ob der Inhalt von Y 32k sind?
brne send_daten_loop_1		;Wenn keine 32k dann sende 4, 8 oder max 16k
lsr YH                      ;untere 16k von 32k senden
ror YL
;Erste 16k Senden
send_daten_loop_1:			;EInsprungsmarke fr das Senden der Daten bis alle Bytes an das PC-Programm gesendet wurden.
in TEMP_0, DATEN_IN			;Byte holen	aus Sample-SRAM	
rcall uart_send_byte		;ber die UART an das PC Programm senden
sbi	CTRL_PORT, C_CLOCK		;Adresse weiterschalten durch erzeugung einer HIGH Taktflanke
nop							;Kurz warten fr taktbernahme und Adressbernahme
cbi	CTRL_PORT, C_CLOCK		;Taktfalnke wieder zurck auf LOW
sbiw Y, 1					;Anzahl bzw. Adresse der auszulesenden Bytes aus dem Sample-SRAM um 1 verringern
brne send_daten_loop_1		;Solange Y nicht 0 ist, weiter ein weiteres Byte aus dem Sample-SRAM holen und dem PC Programm senden.
;RAM-Speichergre erneut laden um zu prfen ob weitere 16k gesendet werden mssen, oder ob hier das Senden beendet ist.
lds YL,BUF_LEN_L			;Komplette RAM gre laden
lds YH,BUF_LEN_H
cpi YH,high(0x8000)         ;Prfen, ob der Inhalt von Y 32k sind?
brne send_daten_end         ;Wenn keine 32k, dann das Senden von Daten beenden
;Warten auf ein beliebiges empfangenes Byte von der PC Software. Mu gemacht werden, damit der interne Puffer des FT232RL ber 16k Funktioniert!
rcall uart_receive_byte     ;Warten auf beliebiges empfangene Byte
;Weitere 16k senden...
lsr YH                      ;obere 16k von 32k senden
ror YL
;Zweite 16k Senden
send_daten_loop_2:			;Einsprungsmarke fr das Senden der Daten bis alle Bytes an das PC-Programm gesendet wurden.
in TEMP_0, DATEN_IN			;Byte holen	aus Sample-SRAM	
rcall uart_send_byte		;ber die UART an das PC Programm senden
sbi	CTRL_PORT, C_CLOCK		;Adresse weiterschalten durch erzeugung einer HIGH Taktflanke
nop							;Kurz warten fr taktbernahme und Adressbernahme
cbi	CTRL_PORT, C_CLOCK		;Taktfalnke wieder zurck auf LOW
sbiw Y, 1					;Anzahl bzw. Adresse der auszulesenden Bytes aus dem Sample-SRAM um 1 verringern
brne send_daten_loop_2		;Solange Y nicht 0 ist, weiter ein weiteres Byte aus dem Sample-SRAM holen und dem PC Programm senden.
;Programmeinsprung zum beenden wenn weniger als 32k gesendet werden mssen.
send_daten_end:
ret							;Zurck zum Aufrufenden Programmteil.
;*********************************************************************
; Sub: Gibt den REC-Interrupt frei fr Break
; Parameter:    -
; Return:       -
; Scratch-Reg:  TEMP_0
;*********************************************************************
enable_break:
sbis UCSRA, RXC				;noch Daten zu holen?
rjmp enable_break_ok		;Wenn keine Daten mehr aus dem Receivedbuffer geholt werden mssen, dann kann der IRQ eingeschaltet werden.
in TEMP_0, UDR				;Wenn aber noch Daten im Received Buffer liegen, dann erst mal rausholen und verwerfen.
rjmp enable_break			;Nochmals nachsehen, ob weitere Daten im Receivedbuffer liegen.
enable_break_ok:			;Einsprungsmarke wenn der Receivedbuffer leer ist und der IRQ eingeschaltet werden kann.
sei							;Globalen Interrupt zwar freigeben, dient aber alleine nur fr Braek freigeben	
ret							;zurck zum aufrufenden Programm
;*********************************************************************
; Sub: Lscht den Buffer
; Parameter:    -
; Return:       -
; Scratch-Reg:  TEMP_0, Y
;*********************************************************************
clear_buffer:
lds	YL, BUF_LEN_L			;Vorgegebene Gre des Sample-SRAM aus dem internen SRAM laden
lds	YH, BUF_LEN_H
sbi	CTRL_PORT, C_SAMPLE		;Umschalten auf Mode Sample. PORTD Pin PD3 auf HIGH
ser TEMP_0					;Register mit 0xFF laden was dafr genutzt werden wird um alle Pins des PORTB als Ausgnge zu schalten.
out	DATEN_DDR, TEMP_0		;alle Pins des PORTB als Ausgnge schalten
clear_buffer_loop:			;Schleife zum befllen aller Speicherstellen des Sample SRAMs mit 0xFF
out	DATEN_PORT, TEMP_0		;0xFF in die Speicherzelle schreiben
sbi	CTRL_PORT, C_CLOCK		;internen Clockausgang auf HIGH Pegel setzen PORTD Pin PD3
nop							;Kurzen Moment zur bernahme warten
cbi	CTRL_PORT, C_CLOCK		;internen Clockausgang auf LOW Pegel setzen PORTD Pin PD3
sbiw Y, 1					;Die in Y liegende 16-Bit Adresse um 1 herunter zhlen
brne clear_buffer_loop		;Solange Y nicht 0 ist wird zur Speicherung der nchsten Zelle gesprungen.
cbi	CTRL_PORT, C_CLOCK		;internen Clockausgang auf LOW Pegel setzen PORTD Pin PD3
out	TCCR1A, NULL			;Takterzeugung am Pin PD3 abschalten und Pin PD3 somit zur "normalen" Funktion umschalten
clr TEMP_0					;Temp auf 0x00
out	DATEN_DDR, TEMP_0		;Richtung des Datenportes PORTB auf Eingang umschalten
cbi	CTRL_PORT, C_SAMPLE		;Umschalten in den Lesemodus
ret							;Zurck zum Aufrufenden Programmteil
;*********************************************************************
; Sub: Setzt Timing und Pre-Trigger Position und gibt Break frei
; Parameter:    -
; Return:       -
; Scratch-Reg:  TEMP_0, Z, Y
;*********************************************************************
set_timing:
rcall clear_buffer			;Lschen bzw. beschreiben aller Speicherstellen des Sample-RAM mit 0xFF
load_p	Z, (2*tab_timer_intervall) ;In Z die Startadresse fr die Auswahl der verschiedenen Timerintervalle laden
set_timing_loop:			;Schleife fr die Erkennung welcher Timerwert benutzt werden mu
;herausfinden, welche Samplefrequenz bentigt wird und in die Register speichern die spter OCR1A setzen werden.
mov TEMP_0, TIMER_WERT		;Wert, der vom PC-Programm gesendet wurde, der beinhaltet welche Samplefrequenz bentigt wird, nach TEMP_0 verschieben.
ldi TEMP_1, 6				;Lnge eines Eintrags. Jede Auswahl eines Timing besteht aus 3 16Bit Worten. deshalb nun hier den Multiplikator fr einen Schritt zur nchsten Ausweahl (6 x 1Byte) laden.
mul TEMP_0, TEMP_1			;Jetzt den von der PC-Software vorgegebenen Samplefrequenzwert mit 6 Multiplizieren.
add ZL, MUL_L				;Das Multiplikationsergebnis liegt immer in r0 (MUL_L) und r1 (MUL_H) und mu nun zur Z-Startadresse der Timingauswahltabelle hinzuaddiert werden.
adc ZH, MUL_H           
lpm	TIMER_L, Z+				;vordefinierten Timerwert fr die ausgewhlte Frequenz holen. Jetzt den LOW-Teil (r20) des 16-Bit Wortes fr den Timerwert aus dem Flash holen und die Adresse Z um 1 vergrern.
lpm	TIMER_H, Z+				;Jetzt den HIGH-Teil (r21) des 16-Bit Wortes fr den Timerwert aus dem Flash holen und die Adresse Z um 1 vergrern.
;den Zweiten Wert aus der Tabelle holen und 3x durch 2 teilen, so das eine Teilung durch 8 erfolgt. Der geteilte Wert verbleibt in X und wird spter fr die Berechnung des Pretriggers bentigt.
lpm	YL, Z+					;Wert fr vollen Ram holen. Zweiten vorgegebenen 16-Bit Wert (LOW-Teil) aus der Tabelle holen und die Adresse Z um 1 vergrern.
lpm	YH, Z+					;Zweiten vorgegebenen 16-Bit Wert (HIGH-Teil) aus der Tabelle holen und die Adresse Z um 1 vergrern.
mov	XL, YL					;Y nach X kopieren fr Division / 8 (Pretrigger)
mov	XH, YH					;den Restwert RAM Y nach X kopieren
lsr	XH						;Den Wert nun einmal rechts schieben also geteilt durch 2!
ror	XL
lsr	XH						;Den Wert nun ein zweites mal nach rechts schieben also nochmal geteilt durch 2! Somit Teilung durch 4
ror	XL
lsr	XH						;Den Wert nun ein drittes mal nach rechts schieben also nochmal geteilt durch 2! Somit Teilung durch 8
ror	XL						;/8, 8 Abschnitte fr Pretrigger 
;Ausgewhlten Wert des Pretriggers nach Temp_0 verschieben, prfen ob berhaupt ein Pretrigger bentigt wird (Wert = kleiner 8, Wert = 8 = kein Pretrigger)
;Wenn der Pretrigger kleiner 8 dann den in X berechneten 1/8 Y-Wert einmal vom zweiten vollen Y-Tabelenwert ( Rest-Zhler fr vollen Bereich ) einmal abziehen.
;Schleife solange wiederholen und jeweils 1/8 vom Gesamtwert in Y abziehen bis in Temp_0 der wert 8 erreicht ist. Je kleiner der Pretrigger Wert war, desto mehr mu von Y abgezogen werden.
mov	TEMP_0, PRE_TRIGGER		;Empfangenen Wert der PC-Software fr den Pretrigger nach TEMP_0 verschieben
set_timer_trig_loop:		;Schleife zur berechnung des Triggers
cpi	TEMP_0, 8				;= 100%, Den von der PC-Software vorgegebenen Wert mit 8 vergleichen
breq set_timer_trig_ok		;ja, ok, Wenn der Wert 8 war, dann braucht nichts mehr weiter gemacht werden und der Trigger ist somit ok.
inc	TEMP_0					;erhhen bis 8. War der Wert weniger als 8, dann den Vorgegebenen Wert um 1 erhhen
sub	YL, XL					;1/8 abziehen Jetzt von dem vorgegebenen Wert aus der Tabelle 1/8 subtrahieren also verkleinern
sbc	YH, XH
rjmp set_timer_trig_loop	;zurck zum Anfang der Schleife 
;Jetzt ist der Wert, wo das Auslesen des Speichers beginnen soll ermittelt. X ist nun wieder frei und es wird in X der Dritte Wert aus der Tabelle geladen.
set_timer_trig_ok:			;Einsprungsmarke wenn der Trigger bereits OK war.
lpm	XL, Z+					;Wartezeit holen. Dritten 16-Bit Wert aus der Tabelle holen fr LOW-Teil und die Adresse Z um 1 vergrern.
lpm	XH, Z					;HIGH Teil des dritten Wertes aus der Tabelle holen und die Z Adresse nicht mehr weiter inkrementieren.
;Triggermasken ausgeben
out	T_PORT, TRIG_BYTE		;Jetzt den von der PC-Software empfangenen Wert aus dem Register r18 (TRIG_BYTE) auf PORTA ausgeben
out	M_PORT, TRIG_MASK		;Jetzt den von der PC-Software empfangenen Wert aus dem Register r22 (TRIG_MASK) auf PORTC ausgeben
;Jetzt prfen, welchen Wert der Timer_Wert hatt. Kleiner 3 dann 0, 1 oder 2 was 80, 40, und 20 MHz entspricht. Wenn extern Getacktet werden mu dann ist das Timing hiermit beendet.
cpi	TIMER_WERT, 3			;20MHz oder grer? Prfe TIMER_WERT (r23) mit 3
brlo set_timer_ok			;ja, externer Quarztakt. Solange der Wert unterhalb von 3 ist, also 0,1,oder 2 ist der Externe 80MHz, 40MHz oder 20MHz Takt ausgewhlt.
;Ist im Timer_Wert 3 oder grer, dann mu intern getaktet werden und OCR1A des Timers 1 so gesetzt werden, wie die interne Taktfrequenz sein soll.
;Als erstes wird der Multiplexer auf internen Takt umgestellt.
set_timer_ctc:				;Ist der Timerwert grer also 3 fr 8MHz 4 fr 4MHz 5 fr 2MHz usw. dann geht es hier weiter.
in TEMP_0, CTRL_PORT		;MUX auf intern setzen. Den Controlport PORTD in TEMP_0 laden.
andi TEMP_0, MUX_MASKE		;Die oberen beiden Bits ausblenden (PD7 und PD6)
ori	TEMP_0, MUX_INT			;Jetzt mit ODER Verknpfen fr Takt aus internen Quelle am 74AC151
out	CTRL_PORT, TEMP_0		;Jetzt den neuen Stand des Controlportes wieder setzen auf PORTD
;Timer 1 einschalten und OCR1AH und L fr die bentigte Taktfrequenz beschreiben.
ldi	TEMP_0, (1<<COM1A0)		;16Bit-Timer auf Toggle OC1A Den Timer zur Erzeugung interner Taktfrequenzen einschalten
out	TCCR1A, TEMP_0			;TImer vorbereiten... Toggle OC1A on compare match
out	OCR1AH, TIMER_H			;Timerwert raus. Den vorab abgeholten ersten Timerwert aus der Tabelle als Steuerung fr den Zhler1 HIGH einschreiben
out	OCR1AL, TIMER_L			;Das ganze auch fr LOW
;Zhlerstand des Timer 1 mit einem Zhlerwert weniger als Startzhlerstand setzen, damit gleich ein Takt ausgegeben werden kann und dann den Timer auf CTC Mode einschalten und Taktimpulse ausgeben.
subi TIMER_L, 1				;Jetzt von dem Timerwert 1 abziehen
sbci TIMER_H, 0
out	TCNT1H, TIMER_H			;Counter-Register auf Timerwert -1 damit beim ersten Takt getoggelt wird
out	TCNT1L, TIMER_L			;Das Zhlregister des Zhler1 mit einem Wert weniger als den Maximalen Toggel-Wert beschreiben, damit nach einem Takt auch gleich am OCR1A Ausgang ein Takt erzeugt wird!
ldi	TEMP_0, CLK_STOP		;WGM12 Bit3 mit HIGH laden
out	TCCR1B, TEMP_0			;WGM12 Bit auf HIGH setzen = CTC Mode eingeschaltet aber Takt mit CS10 noch nicht freigegeben! Taktfrequenz wird noch nicht ausgegeben!
set_timer_ok:				;Einsprungsmarke wenn der Externe Takt generiert von dem 80MHz Quarzoszillator ausgewhlt bzw. bentigt wurde.			
rcall enable_break			;RX-Interrupt zum Abbruch Einschalten, aber vorher noch den RX Buffer leeren.
ret							;zurck zum Aufrufenden Programmteil
;*********************************************************************
; Liest Daten, interner Takt, alle Triggervarianten
; Parameter:    -
; Return:       -
; Scratch-Reg:  TEMP_0, Z, Y, X
;*********************************************************************
int_clock_sample:				
rcall set_timing			;Setzt Timing und Pre-Trigger Position und gibt Break frei
clt							;T aus dem Statusregister als Trigger-Flag, erstmal lschen
cbi	CTRL_PORT, C_BUFFER		;am PORTD pin PD4 auf LOW setzen = Eingang aktiv bzw. 74ACT541 lt die Daten vom Eingang rein.
sbi	CTRL_PORT, C_SAMPLE		;am PORTD pin PD3 auf HIGH setzen = Mode Sample = Schreiben am externen SRAM starten = Sample START
cpi	TIMER_WERT, 3			;Das Register 23 mit dem Wert 3 vergleichen. War vorher vom PC Programm gesendet wurden. 20/40/80MHz?
brsh int_clock_sample_set	;nein, max. 10MHz, ist der Timerwert gleich oder Grer 3 dann ist die Maximale Samplefrequenz nur 10MHz und es mu zur Erzeugung eines Taktes vom ATmega16 aus gesprungen werden.
;Wenn extern getacktet wird, dann erst einmal prfen ob 20MHz eingestellt waren oder nicht und die Daten fr den Multiplexer schon mal vorbereiten.
in TEMP_0, CTRL_PORT		;Wenn kleiner 3 dann lade den Controlport PORTD in temp ein
andi TEMP_0, MUX_MASKE		;alle Bits die mit der Taktschaltung vom 74AC151 zu tun haben ausblenden. Also Bit7 und Bit6 auf LOW um sicher zu stellen das jetzt kein Takt angeschaltet ist!
ori	TEMP_0, MUX_20MHZ		;MUX auf 20MHz, ODER Verknpfung mit 0b11000000 fr 20MHz machen
cpi	TIMER_WERT, 2			;Das Register 23 mit dem Wert 2 vergleichen. War vorher vom PC Programm gesendet wurden. 20MHz? 
breq ext_clock_sample_set	;Wenn der von der PC Software empfangene Timerwert 2 war, dann ist klar das die 20MHz nun ausgewhlt sind!
;Wenn keine 20MHz waren, dann prfen auf 40MHz und die Daten fr den Multiplexer schon mal vorbereiten
andi TEMP_0, MUX_MASKE		;Wenn der von der PC Software empfangene Timerwert aber nicht 2 war, so mu nun erst einmal die beiden Pin PD7 und PD6 wieder auf LOW gebracht werden, um fr die nchste Frequenz abzufragen.
ori	TEMP_0, MUX_40MHz		;MUX auf 40MHz, ODER Verknpfung mit 0b01000000 fr 40MHz machen
cpi	TIMER_WERT, 1			;Das Register 23 mit dem Wert 1 vergleichen. War vorher vom PC Programm gesendet wurden. 40MHz? 
breq ext_clock_sample_set	;Wenn der von der PC Software empfangene Timerwert 1 war, dann ist klar das die 40MHz nun ausgewhlt sind!
;Wenn keine 40MHz waren, dann prfen auf 80MHz und die Daten fr den Multiplexer schon mal vorbereiten
andi TEMP_0, MUX_MASKE		;Wenn der von der PC Software empfangene Timerwert aber nicht 1 war, so mu nun erst einmal die beiden Pin PD7 und PD6 wieder auf LOW gebracht werden, um fr die nchste Frequenz abzufragen.
ori	TEMP_0, MUX_80MHz		;MUX auf 80MHz , ODER Verknpfung mit 0b10000000 fr 80MHz machen. Hier braucht nicht mehr weiter der Timerwert abgefragt werden, da es sowieso keine Hhere bzw. andere Frequenz mehr gibt!
;Einsprung fr das Einschalten des Multiplexers fr die entsprechend ausgewhlte Taktfrequenz
ext_clock_sample_set:		;Einsprung zum Starten der ausgewhlten Frequenz
out	CTRL_PORT, TEMP_0		;Jetzt die Ausgewhlte Frequenz am 74Ac151 einschalten und damit den Adressenzhler in Gang setzen.
rjmp int_clock_sample_loop	;Grundstzlich immer springen zum Warten auf den Trigger
;Einsprung wenn intern getaktet wird...
int_clock_sample_set:		;Einsprungsmarke fr den Fall, das eine intern erzeugte Frequenz ausgewhlt wurden ist. also der TIMER_WERT 3 oder hher gewesen ist.
ldi	TEMP_1, CLK_START		;WGM12 und CS10 fr TCCR1B Register mit HIGH laden
out  TCCR1B, TEMP_1			;jetzt den Internen Takt einschalten!
;Ab hier wird der RAM getaktet und die anliegenden Daten werden mit der entsprechenden Taktgeschwindigkeit eingeschrieben. Der ATmega16 wartet ab hier auf einen Trigger.
int_clock_sample_loop:      ;Dauernde Schleife die einfach nur auf Trigger wartet...
sbic CTRL_PIN, TRIG_IN      ;#2 Solange der Triggereingang also PD2 an PIND noch HIGH ist, wird der SET Befehl bersprungen.
set							;#1 Trigger erkannt T-Bit im Status Register wird gesetzt.
brts int_clock_sample_wait	;#1 T wird auch vom Break-IRQ gesetzt, Y ist dann 1!, Wenn das T-Bit im Statusregister gesetzt ist dann springe zum weiteren Ablauf.
rjmp int_clock_sample_loop  ;#2  ein Durchlauf 6 Takte -> 300ns, bei 80NHz max. 30 Takte Abweichung Und nochmal den Triggereingang prfen
;Hier geht es weiter, wenn der Trigger erkannt wurde und das T-Bit gesetzt wurde. 
;Jetzt mu eine Wartezeit ablaufen die abhngig vom ausgewhlten Takt ist und wo die entsprechenden Werte in der Tabelle stehen!
int_clock_sample_wait:		;Einsprungsmarke wenn ein Trigger aufgetreten ist.
sbiw Y, 1					;#2 Rest-Zhler 1 vom RESTZHLERWERT abziehen (zweiter Wert aus der Tabelle)
breq int_clock_sample_end	;#1   --	fertig
mov	ZL, XL					;#1 Wartezeit setzen
mov	ZH, XH					;#1
int_clock_sample_wait_loop:
nop                         ;#1
sbiw Z, 1					;#2 noch warten? (Dritter Wert aus der Tabelle)
breq int_clock_sample_wait 	;#2 nein - #1 ja
nop                         ;#1 - 10
nop                         ;#1
nop                         ;#1
nop                         ;#1
rjmp int_clock_sample_wait_loop ;#2
;Wenn die Wartezeit beendet ist...
int_clock_sample_end:		;Einsprung wenn das Sample beendet ist
cli							;Alle Interrupts abschalten
;Multiplexer abschalten und somit Taktsignal stoppen
in TEMP_0, CTRL_PORT		;PORTD in Register TEMP_0 laden
andi TEMP_0, MUX_MASKE		;UND Verknpfung mit 0b00111111 machen
out	CTRL_PORT, TEMP_0		;Auf den PORTD wieder zurck schreiben, Das Ganze schaltet den Takt am 74AC151 ab!
;Falls der Interne Takt benutzt wurde, diesen nun stoppen.
ldi	TEMP_0, CLK_STOP		;CTC mit OCR1A, Prescale Stop ,Den intern erzeugten Takt am ATmega16 abschalten
out	TCCR1B, TEMP_0			;Register des Zhlers1 schreiben
cbi	CTRL_PORT, C_CLOCK		;Den Pin PD5 am PORTD auf LOW, damit ist sichergestellt das der PIN auch LOW bleibt wenn der Pin seine normale Funktion nach OCR1A wieder bekommt.
out	TCCR1A, NULL            ;Clock Toggle vom Timer AUS! Zhler1 = stillstand PIN PD5 hat nun wieder "normale" Funktion!
sbi	CTRL_PORT, C_BUFFER		;Eingang inaktiv. Den Pin PD4 vom PORTD auf HIGH setzen und damit den 74ACT541 auf Tristate setzen.
cbi	CTRL_PORT, C_SAMPLE		;Mode Lesen einschalten
ret							;Zurck zum aufrufenden Programmteil
;*********************************************************************
; Sub: 0 Liest Daten, interner Takt, interner Trigger
; Parameter:    -
; Return:       -
; Scratch-Reg:  -
;*********************************************************************
int_clock_int_trigger:		;Einsprungsmarke fr das icall
rcall int_clock_sample		;Aufruf der eigentlichen Funktion
ret 						;zurck zum aufrufenden Programmteil, in diesem Falle war es "icall"
;*********************************************************************
; Sub: 2-4 Dummy-Funktion
; Parameter:    -
; Return:       -
; Scratch-Reg:  -
;*********************************************************************
dummy:						;Einsprungsamrke fr den Fall das ein MODE aufgerufen werden soll, der garnicht existiert!
ret							;Nach dem Aufruf durch "icall" gleich wieder zurck zur nchsten Adresse nach der Einsprungsmarke.
;*********************************************************************
; Sub: 5 Erzeugt Testpattern binary Counter
; Parameter:    -
; Return:       -
; Scratch-Reg:  Y, Z
;*********************************************************************
test_bin_count:
ldi	TEMP_0, (1<<COM1A0)			;Toggle OC1A on compare match
out	TCCR1A, TEMP_0
ldi	TEMP_0, high(CLK_2M)		;Timing setzen fr Takt von 2 MHz Wert = 3 fr 500nS fr einen Taktzyklus
out	OCR1AH, TEMP_0				;Als Maximum Wert fr den 16 Bit Zhler 1 wo der dann OC1A toggeln wird.
ldi	TEMP_0, low(CLK_2M)
out	OCR1AL, TEMP_0
ldi	TEMP_0, high(CLK_2M-1)		;TCNT auf 1 vor Compare setzen
out	TCNT1H, TEMP_0				;damit mit einem Takt ohne Verzgerung gestartet wird
ldi	TEMP_0, low(CLK_2M-1)		;bzw. begonnen wird
out	TCNT1L, TEMP_0
ldi	TEMP_0, CLK_STOP			;CTC mit OCR1A, Prescale Stop (WGM12 Bit auf 1 setzen)
out	TCCR1B, TEMP_0
lds	YL, BUF_LEN_L				;Jetzt die angegebene Pufferlenge (Speichergre) aus dem SRAM holen
lds	YH, BUF_LEN_H
sbi	CTRL_PORT, C_SAMPLE			;Mode Sample Adressenzhler nun mit 2MHz Takten
ser  TEMP_0						;Alles auf 0xFF setzen
out	DATEN_DDR, TEMP_0			;Richtung des Datenportes auf Ausgang setzen
ldi	TEMP_1, CLK_START			;CTC mit OCR1A, internen Takt starten mit WGM12 Bit und CS10 Bit des Vorteilers auf HIGH setzen. CS10 = 1 = keine Teilung, also volle 16MHz vom externen Quarz des ATmega16.
out	TCCR1B, TEMP_1				;Register Zhler 1 schreiben
test_bin_count_loop:			;
out	DATEN_PORT, YL   			;#1  und raus, LOW Wert der Speichergre als Wert ausgeben
nop								;#1
nop								;#1	Warten bis das Taktsignal am OCR1A am Ausgang des 74AC151 einen Schreibimpuls erzeugt hat -> 8 Takte pro Loop = 2MHz
nop								;#1
sbiw Y, 1						;#2	1 vom 16 Bit Wert in Y abziehen
brne test_bin_count_loop		;#2	Solange Y noch keine 0 ist, weiter die Schleife durchfhren
ldi	TEMP_0, CLK_STOP			;CTC mit OCR1A, Prescale Stop Den Zhler 1 stoppen und somit keinen Takt mehr am OCR1A!
out	TCCR1B, TEMP_0				;In das Zhler1 Register schreiben.
cbi	CTRL_PORT, C_CLOCK			;setze am Port D PD5 auf LOW damit sicher gestellt ist, das der Taktpin auf LOW liegt!
out	TCCR1A, NULL				;Setze das Zhlerregister auf Null damit normaler Datenbit an PD5 wieder hergestellt
clr TEMP_0						;Register alles auf 0x00
out	DATEN_DDR, TEMP_0			;Alle Pins am Port B auf Eingang schalten 
cbi	CTRL_PORT, C_SAMPLE			;Umschalten auf Lesemodus zum Auslesen der eingesampelten Daten
ldi	PRE_TRIGGER, 8				;Register r16 mit 8 laden, wird bentigt beim Unterprogramm SET_TIMING um zu erklren das keine Verschiebung des Anfangswertes nach Zeitlich hinten erfolgt.
ret								;zurck zum aufrufenden Programmteil, in diesem Falle war es "icall"
;*********************************************************************
; Sub: 6 Erzeugt Testpattern 0x55/0xAA
; Parameter:    -
; Return:       -
; Scratch-Reg:  Y, Z
;*********************************************************************
test_pattern:
ldi	TEMP_0, (1<<COM1A0)			;Toggle OC1A
out	TCCR1A, TEMP_0
ldi	TEMP_0, high(CLK_2M)		;Timing setzen
out	OCR1AH, TEMP_0
ldi	TEMP_0, low(CLK_2M)
out	OCR1AL, TEMP_0
ldi	TEMP_0, high(CLK_2M-1)		;TCNT auf 1 vor Compare setzen
out	TCNT1H, TEMP_0				;damit mit einem Takt ohne Verzgerung
ldi	TEMP_0, low(CLK_2M-1)		;begonnen wird
out	TCNT1L, TEMP_0
ldi	TEMP_0, CLK_STOP			;CTC mit OCR1A, Prescale Stop
out	TCCR1B, TEMP_0
lds	YL, BUF_LEN_L
lds	YH, BUF_LEN_H
sbi	CTRL_PORT, C_SAMPLE			;Mode Sample
ser TEMP_0
out	DATEN_DDR, TEMP_0
ldi	TEMP_0, 0x55
ldi	TEMP_1, CLK_START			;CTC mit OCR1A, Prescale Stop
out	TCCR1B, TEMP_1
test_pattern_loop:
out	DATEN_PORT, TEMP_0     		;#1  und raus
com	TEMP_0    					;#1
nop								;#1
nop								;#1
sbiw Y, 1						;#2
brne test_pattern_loop			;#2	-> 8 Takte pro Loop = 2MHz
ldi	TEMP_0, CLK_STOP				;CTC mit OCR1A, Prescale Stop
out	TCCR1B, TEMP_0	
cbi	CTRL_PORT, C_CLOCK
out	TCCR1A, NULL
clr TEMP_0
out	DATEN_DDR, TEMP_0
cbi	CTRL_PORT, C_SAMPLE			;Mode Lesen
ldi	PRE_TRIGGER, 8
ret
;*********************************************************************
; Sub: 7 Erzeugt Testpattern walking zero
; Parameter:    -
; Return:       -
; Scratch-Reg:  Y, Z
;*********************************************************************
test_zero:
ldi	TEMP_0, (1<<COM1A0)			;Toggle OC1A
out	TCCR1A, TEMP_0
ldi	TEMP_0, high(CLK_2M)		;Timing setzen
out	OCR1AH, TEMP_0
ldi	TEMP_0, low(CLK_2M)
out	OCR1AL, TEMP_0
ldi	TEMP_0, high(CLK_2M-1)		;TCNT auf 1 vor Compare setzen
out	TCNT1H, TEMP_0				;damit mit einem Takt ohne Verzgerung
ldi	TEMP_0, low(CLK_2M-1)		;begonnen wird
out	TCNT1L, TEMP_0
ldi	TEMP_0, CLK_STOP			;CTC mit OCR1A, Prescale Stop
out	TCCR1B, TEMP_0
lds	YL, BUF_LEN_L
lds	YH, BUF_LEN_H
sbi	CTRL_PORT, C_SAMPLE			;Mode Sample
ser TEMP_0
out	DATEN_DDR, TEMP_0
ldi	TEMP_0, 0b11111110			;Bit 0 ist 0 zum durchschieben	
ldi	TEMP_1, CLK_START			;CTC mit OCR1A, Prescale Stop
out	TCCR1B, TEMP_1
test_zero_loop:
out	DATEN_PORT, TEMP_0     		;#1
bst	TEMP_0, 7      				;#1 Bit 7 merken
lsl	TEMP_0    	  				;#1
bld	TEMP_0, 0	      			;#1 ehemaliges Bit 7 in Bit 0 kopieren
sbiw Y, 1						;#2
brne test_zero_loop				;#2	-> 8 Takte pro Loop = 2MHz
ldi	TEMP_0, CLK_STOP				;CTC mit OCR1A, Prescale Stop
out	TCCR1B, TEMP_0
cbi	CTRL_PORT, C_CLOCK
out	TCCR1A, NULL
clr TEMP_0
out	DATEN_DDR, TEMP_0
cbi	CTRL_PORT, C_SAMPLE			;Mode Lesen
ldi	PRE_TRIGGER, 8
ret
;*********************************************************************
; Sub: sendet Version, Das was zur PC Software als Hardwareerkennung dient senden
; Parameter:    -
; Return:       -
; Scratch-Reg:  Y, Z
;*********************************************************************
send_version:
load_p	Z, (2*text_version)	;Das was zur PC Software als Hardwareerkennung dient laden
send_version_loop:
lpm	TEMP_0, Z+				;Erstes Zeichen laden
tst	TEMP_0					;Prfen auf 0
breq send_version_ram_size	;Wenn der Text alles gesendet wurde und die 0 erkannt wurde, dann mu noch die RAM Gre gesendet werden.
rcall uart_send_byte		;War der komplette text noch nicht gesendet und somit keine 0 aus dem Flash gelesen, dann sende das Textzeichen zum PC Programm.
rjmp send_version_loop		;Zurck um das nchste Zeichen aus dem Flash zu laden, zu prfen und gegebenenfals zu senden.
send_version_ram_size:		;Einsprungsmarke wenn alle Textzeichen zum PC Programm gesendet wurden und nun noch die RAM Gre gesendet werden mu.
ldi	TEMP_0, RAM_SIZE		;Hexadezimalen Wert der verwendeten Speichergre 0x04 fr 4k 0x20 fr 32K laden HEX32 = 0b00110010
swap TEMP_0					;High-Nibble Die unteren 4 Bits nach oben und die oberen 4 Bits nach Unten verschieben. von 0b00110010 nach 0b00100011
andi TEMP_0, 0x0F			;Jetzt zu diesem Wert noch mit 0b00001111 UND-Vergleichen. Somit erhlt man 0b00000011
ori	TEMP_0, '0'				;Jetzt Oderverknpfung mit ASCII 0 also 48 0b00110000 ergibt 0b00110011 = 51 = ASCII 3
cpi  TEMP_0, '0'			;Prfen ob es ASCII 0 also 48 noch ist.
brne send_version_ok		;Wenn es keine ASCII 0 (48) ist dann sende den ermittelten Wert
ldi TEMP_0, ' '				;Wenn es immer noch ASCII 0 war dann lade temp mit ASCII Freizeichen (32) und sende dieses.
send_version_ok:			;Einsprungsmarke um die Gre des Speichers an das PC Programm zu senden.
rcall uart_send_byte		;Senden der ersten Stelle der RAM-gre
ldi	TEMP_0, RAM_SIZE		;erneut den Hexadezimalen Wert der verwendeten Speichergre 0x04 fr 4k 0x20 fr 32K laden 0b00110010
andi TEMP_0, 0x0F			;Die unteren 4 Bits mit UND verknpfen. 0b00001111 -> 0b00000010
ori	TEMP_0, '0'				;Jetzt mit ASCII 0 ODER verknpfen 0b00110000 ergibt 0b00110010 = 50 = ASCII 2
rcall uart_send_byte		;Jetzt die zweite Stelle der RAM gre senden
ldi	TEMP_0, 'k'				;Das kleine k in ASCII laden
rcall uart_send_byte		;Das kleine k senden
ldi	TEMP_0, 'B'				;Das groe B in ASCII laden
rcall uart_send_byte		;Das groe B senden
;send_version_end:			;
ret							;zurck zum aufrufenden Programmteil, in diesem Falle war es "icall"
;*********************************************************************
; Sub: sendet eingestellte Buffergre
; Parameter:    -
; Return:       -
; Scratch-Reg:  -
;*********************************************************************
send_ram_size:
load_p	Z, (2*text_ram)
send_ram_size_loop:
lpm	TEMP_0, Z+
tst	TEMP_0
breq send_ram_size_end
rcall uart_send_byte
rjmp send_ram_size_loop
send_ram_size_end:
ldi TEMP_0, RAM_SIZE			    ;maximale Ramgre
swap TEMP_0
andi TEMP_0, 0x0F
ori TEMP_0, '0'             
cpi TEMP_0, '0'
brne send_ram_size_ok
ldi TEMP_0, ' '
send_ram_size_ok:
rcall uart_send_byte
ldi TEMP_0, RAM_SIZE			    ;maximale Ramgre
andi TEMP_0, 0x0F
ori TEMP_0, '0'             
rcall uart_send_byte
ldi TEMP_0, 'k'
rcall uart_send_byte
ldi TEMP_0, 'B'
rcall uart_send_byte
ret
;**************************************************************************************************************
;Texte, Daten und Werte aus dem Flash
;**************************************************************************************************************
text_version:		;Erkennung zur Kommunikation mit der PC-Software
.db	"MiniLog 80MHz Hardware v",HW_VER,".",HW_REV," - Software v",FW_VER,".",FW_REV," - Ram: ",0
;----------------------------------------------------------------------
text_ram:
.db	"Sample-Buffer: ",0
;----------------------------------------------------------------------
tab_funktion:
.dw send_version            ; 0	int_clock_int_trigger
.dw dummy                   ; 1
.dw dummy                   ; 2
.dw dummy                   ; 3
.dw dummy                   ; 4
.dw dummy                   ; 5 test_bin_count
.dw dummy                   ; 6 test_pattern
.dw dummy                   ; 7 test_zero
.dw dummy                   ; 8
.dw dummy                   ; 9
.dw test_bin_count          ;10
.dw	int_clock_int_trigger	;11
;----------------------------------------------------------------------
tab_timer_intervall:
.dw	CLK_80M					;1    80MHz ->    12,5ns Der Wert fr "CLK_80M" der als .EQU Wert vorgegeben ist, wird in die beiden Register TIMER_L und TIMER_H gespeichert.
;.dw	81					;fr 4k
;.dw    324					;fr 16k
.dw 648						;fr 32k
.dw	1						;1 = eine Warteschleife von 10 internen Takten, Entspricht 1,6MHz bzw. 625nS
;--------------------
.dw	CLK_40M					;1    40MHz ->    25ns 
;.dw 163					;fr 4K
;.dw 652					;fr 16k
.dw 1304					;fr 32k
.dw	1						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_20M					;1    20MHz ->    50ns 
;.dw 327 					;fr 4k
;.dw 1308					;fr 16k 
.dw 2616					;fr 32k
.dw	1						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_8M					;2    8MHz ->    125ns
;.dw 819					;fr 4k
;.dw 3276					;fr 16k
.dw 6552					;fr 32k
.dw	1						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_4M					;5    4MHz ->    250ns
;.dw 1638					;fr 4k
;.dw 6552					;fr 16k
.dw 13104					;fr 32k
.dw	1						;Warteschleife, 10 Takte, -> 1,6MHz 
;--------------------
.dw	CLK_2M					;10   2MHz ->    500ns
;.dw 3276					;fr 4k
;.dw 13104					;fr 16k
.dw 26208					;fr 32k
.dw	1						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_800K				;20   800kHz ->    1,25s
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	2						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_400K				;50  200kHz ->     2,5s
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	4 						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_200K				;100  100kHz ->    5s
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	8						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_80K					;200   50kHz ->   12,5s
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	20						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_40K					;500   20kHz ->   25s
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	40						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_20K					;1000   10kHz ->  50s
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	80						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_8K					;2000    5kHz ->  127s
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	200						;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------	
.dw	CLK_4K					;5000    2kHz ->  250s
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	400 					;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------
.dw	CLK_2K					;10000   1kHz ->  500s
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	800 					;Warteschleife, 10 Takte, -> 1,6MHz
;--------------------						
.dw	CLK_800					;10000   1kHz ->   1,25ms
;.dw 4096					;fr 4k
;.dw 16384					;fr 16k
.dw 32768					;fr 32k
.dw	2000					;Warteschleife, 10 Takte, -> 1,6MHz
