/*
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;		LCD-Routinen		;;
;;		============		;;
;;		(c)Simon			;;
;;	4-Bit-Interface			;;
;;	DB4-DB7:	PC0-PC3		;;
;;	RS:		PC4				;;
;;	E:		PC5				;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
*/
#include <avr/io.h>
#include <avr/pgmspace.h>
#include "lcd.h"
#include "types.h"
#include "delay.h"


// Port
#define LCD PORTC
#ifdef ADC_TEMPO
#define LCD2 PORTB
#define EN_PIN 0
#else
#define EN_PIN 5
#endif


// Commands
#define LCD_CLEAR 0x01
#define LCD_HOME 0x02
#define LCD_MODE 0x04
#define LCD_ON 0x08
#define LCD_SHIFT 0x10
#define LCD_FUNCSET 0x20


prog_uchar DISP_TEXT[TEXTCNT][LINESIZE] = {
#ifndef COMPACT16x2
"                        ",
"Mr.WavE by Simon L.     ",
"Booting...              ",
"Scanning...    File #   ",
"MMC ERROR: Toggle Power ",
"FILE DATA ERROR: Stopped",
"F:###/### Sec:#### ###kB",
"Playing...     File #   ",
"Pause          File #   ",
"Ready for Rec  File #   ",
"Recording...   File #   ",
"INPUT BUFFER RAN FULL!  ",
"Tempo:   Trans:         ",
"NO FILES ON CARD        ",
"Deleting file...        ",
"o=exit,<>=edit,UP/DN=sel",
"1. Sample Rate =        ",
"2. Channels =           ",
"3. Start Sector =       ",
"4. Repeat mode =        ",
"5. Backlight =          "
#else
"                ",
"MrWave by Simon ",
"Booting...      ",
"Scanning.. F:   ",
"CARD ERROR      ",
"FILE DATA ERROR ",
"F:###/### S:####",
"Playing... F:   ",
"Pause      F:   ",
"Ready Rec. F:   ",
"Recording. F:   ",
"INPUTBUFFER FULL",
"S:   T:         ",
"NO FILES ON CARD",
"Deleting file...",
"o=exit, <>=edit ",
"1.SmplRate=     ",
"2.Channels=     ",
"3.SSector=      ",
"4.Repeatmode=   ",
"5.Backlight=    "
#endif
};


void lcd_enable(void);

// Sendet ein Datenbyte an das LCD
void lcd_data(u08 d) {
	LCD = (d>>4)|0x10;
	lcd_enable();
	LCD = (d&0x0f)|0x10;
	lcd_enable();
	delay_us(50);
}

// Sendet einen Befehl an das LCD
void lcd_command(u08 d) {
	LCD = (d>>4);
	lcd_enable();
	LCD = (d&0x0f);
	lcd_enable();
	delay_us(50);
}

// Erzeugt den Enable-Puls
void lcd_enable(void) {
#ifdef ADC_TEMPO
	LCD2 |= 1 << EN_PIN;
	delay_us(1);
	LCD2 &= ~(1 << EN_PIN);
#else
	LCD |= 1 << EN_PIN;
	delay_us(1);
	LCD &= ~(1 << EN_PIN);
#endif
}

// Sendet den Befehl zur Lschung des Displays
void lcd_clear(void) {
	lcd_command(LCD_CLEAR);
}

// Gibt einen String aus
void lcd_string(u08 idx, u08 row) {
	u08 i;
	lcd_setcur(0, row);
	for (i=0; i<LINESIZE; i++)
		lcd_data((u08)pgm_read_byte( &(DISP_TEXT[idx][i]) ));
}

// Setzt den Cursor
void lcd_setcur(u08 x, u08 y) {
	if (y==1)
		x += 64;
	lcd_command(0x80+x);
}

// Hexadezimale Ausgabe Nibble
void lcd_nibble(u08 d) {
	if (d > 9)
		lcd_data(d+'A'-10);
	else
		lcd_data(d+'0');
}

// Hexadezimale Ausgabe u08
void lcd_hex_u08(u08 d) {
	lcd_nibble(d>>4);
	lcd_nibble(d&0x0f);
}

// Hexadezimale Ausgabe u16
void lcd_hex_u16(u16 d) {
	lcd_hex_u08((u08)(d>>8));
	lcd_hex_u08((u08)d);
}

/*// Hexadezimale Ausgabe u32
void lcd_hex_u32(u32 d) {
	lcd_hex_u08((u08)(d>>24));
	lcd_hex_u08((u08)(d>>16));
	lcd_hex_u08((u08)(d>>8));
	lcd_hex_u08((u08)d);
}
*/
// Dezimale Zahlen 0..255
void lcd_number(u08 d, u08 n) {
	u08 zehner=0, hunderter=0;
	while (d >= 100) {
		d -= 100;
		hunderter++;
	}
	while (d >= 10) {
		d -= 10;
		zehner++;
	}
	if (hunderter || n)
		lcd_data(hunderter+'0');
	lcd_data(zehner+'0');
	lcd_data(d+'0');
}

// Dezimale Zahlen 0..9999
void lcd_number_k(u16 d) {
	u08 zehner=0, hunderter=0, tausender=0;
	while (d >= 1000) {
		d -= 1000;
		tausender++;
	}
	while (d >= 100) {
		d -= 100;
		hunderter++;
	}
	while (d >= 10) {
		d -= 10;
		zehner++;
	}
	lcd_data(tausender+'0');
	lcd_data(hunderter+'0');
	lcd_data(zehner+'0');
	lcd_data(d+'0');
}

// Dezimale Zahlen 0..65536
void lcd_number_10k(u16 d) {
	u08 zehner=0, hunderter=0, tausender=0, zehntausender=0;
	while (d >= 10000) {
		d -= 10000;
		zehntausender++;
	}
	while (d >= 1000) {
		d -= 1000;
		tausender++;
	}
	while (d >= 100) {
		d -= 100;
		hunderter++;
	}
	while (d >= 10) {
		d -= 10;
		zehner++;
	}
	lcd_data(zehntausender+'0');
	lcd_data(tausender+'0');
	lcd_data(hunderter+'0');
	lcd_data(zehner+'0');
	lcd_data(d+'0');
}

// Initialisierung: Muss ganz am Anfang des Programms aufgerufen werden
void lcd_init(void) {
	delay_ms(250);
	LCD = 0x03;
	lcd_enable();
	delay_ms(5);
	lcd_enable();
	delay_ms(5);
	lcd_enable();
	delay_ms(5);
	LCD = 0x02;
	lcd_enable();
	delay_ms(5);
	lcd_command(0x28);
	lcd_command(0x0c);
	lcd_command(0x04);
	lcd_command(LCD_CLEAR);
	delay_ms(5);
}
