#ifndef _LCD_H_
#define _LCD_H_

#include "types.h"


// Text
#define TEXTCNT		21

#define DISP_BLANK 	0
#define DISP_MAIN 	1
#define DISP_BOOT	2
#define DISP_OK		3
#define DISP_CARDERR	4
#define DISP_FILEERR	5
#define DISP_SELECT	6
#define DISP_PLAY	7
#define DISP_PAUSE	8
#define DISP_RECRD	9
#define DISP_REC	10
#define DISP_BUFERR	11
#define DISP_TEMPO	12
#define DISP_NOFILE	13
#define DISP_DELETE	14
#define DISP_MENU	15
#define DISP_SMPLR	16
#define DISP_CHNR	17
#define DISP_MSSECT	18
#define DISP_MREP	19
#define DISP_MLIGHT	20

//#define COMPACT16x2

#ifdef COMPACT16x2
	#define LINESIZE	16
	#define MAX_LINES	2

	#define LINE_MAIN 0
	#define LINE_BOOT 1
	#define LINE_OK 1
	#define LINE_CARDERR 1
	#define LINE_FILEERR 1
	#define TEMPO_X 2
	#define TEMPO_Y 1
	#define LINE_PLAY 0
	#define LINE_TEMPO 1
	#define PLAYFNUM_X 13
	#define PLAYFNUM_Y 0
	#define DWAHL_X 12
	#define DWAHL_Y 0
	#define STOPFNUM_X 2
	#define STOPFNUM_Y 1
	#define STOPSECT_X 12
	#define STOPSECT_Y 1
	#define LINE_PAUSE 0
	#define LINE_MAIN 0
	#define LINE_SELECT 1
	#define NAME_LINE 0
	#define FCNT_X 6
	#define FCNT_Y 1
	#define LINE_NOFILE 1
	#define LINE_MENU 1
	#define LINE_OPTION 0
	#define SMPLR_X 11
	#define CHNR_X 11
	#define SSECT_X 10
	#define REP_X 13
	#define LIGHT_X 12
	#define TRANS_X 7
	#define TRANS_Y 1
	#define TIME_X 11
	#define TIME_Y 1
	#define LINE_RECRD 0
	#define RECFNUM_X 13
	#define RECFNUM_Y 0
	#define LINE_REC_BLANK 1
	#define LINE_REC 0
	#define LINE_DELETE 1
	#define LINE_BUFERR 1
	#define BOOTFNUM_X 13
	#define BOOTFNUM_Y 1
	#define BOOTSECT_X 12
	#define BOOTSECT_Y 0
#else
	#define LINESIZE	24
	#define MAX_LINES	2

	#define LINE_MAIN 0
	#define LINE_BOOT 1
	#define LINE_OK 1
	#define LINE_CARDERR 1
	#define LINE_FILEERR 1
	#define TEMPO_X 6
	#define TEMPO_Y 1
	#define LINE_PLAY 0
	#define LINE_TEMPO 1
	#define PLAYFNUM_X 21
	#define PLAYFNUM_Y 0
	#define DWAHL_X 20
	#define DWAHL_Y 0
	#define STOPFNUM_X 2
	#define STOPFNUM_Y 1
	#define STOPSECT_X 14
	#define STOPSECT_Y 1
	#define LINE_PAUSE 0
	#define LINE_MAIN 0
	#define LINE_SELECT 1
	#define NAME_LINE 0
	#define FCNT_X 6
	#define FCNT_Y 1
	#define FSIZE_X 19
	#define FSIZE_Y 1
	#define LINE_NOFILE 1
	#define LINE_MENU 1
	#define LINE_OPTION 0
	#define SMPLR_X 17
	#define CHNR_X 17
	#define SSECT_X 18
	#define REP_X 20
	#define LIGHT_X 18
	#define TIME_X 19
	#define TIME_Y 1
	#define LINE_RECRD 0
	#define RECFNUM_X 21
	#define RECFNUM_Y 0
	#define LINE_REC_BLANK 1
	#define LINE_REC 0
	#define LINE_DELETE 1
	#define LINE_BUFERR 1
	#define BOOTFNUM_X 21
	#define BOOTFNUM_Y 1
	#define BOOTSECT_X 20
	#define BOOTSECT_Y 0
#endif

// Functions
void lcd_data(u08 d);
void lcd_command(u08 c);
void lcd_clear(void);
void lcd_string(u08 idx, u08 row);
void lcd_setcur(u08 x, u08 y);
void lcd_init(void);
void lcd_nibble(u08 d);
void lcd_hex_u08(u08 d);
void lcd_hex_u16(u16 d);
//void lcd_hex_u32(u32 d);
void lcd_number(u08 d, u08 n);
void lcd_number_k(u16 d);
void lcd_number_10k(u16 d);

#endif
