/*******************************************************
 Author:					Manfred Langemann
 mailto:					Manfred.Langemann t t-online.de
 Begin of project:			05.09.2007
 Latest version generated:	24.10.2007
 Filename:					RFM12.h
 Description:    			Implementation of RFM12 Interface.
 							Transmit or Receive data via
							RFM12 transceiver module

 *******************************************************/
#ifndef _RFM12
#define _RFM12

#define	RFM12_MAX_DATA_BYTES 513

#define	RXTX_CHANNEL_INDOOR_OUTDOOR	1
#define	RXTX_CHANNEL_INDOOR_DISPLAY	2
/*
** Public RFM12 Interface Functions Prototypes
*/
volatile uint8_t *RFM12_Init (uint8_t RXTX_channel); // initialize module
uint8_t	RFM12_TX_Data (volatile uint8_t *Data, uint16_t Number);	// transmit number of bytes from array
void 	RFM12_Enable_IRQ_Receive_Data (void); 	// Enable to receive data via INT0 interrupt
void	RFM12_Disable_IRQ_Receive_Data (void);	// Disable to receive data via INT0 interrupt
uint8_t RFM12_RX_Status    (uint16_t *Numbytes_Received,
							uint16_t *CRC_Word,
							uint16_t *CRC_Word_Received,
							uint8_t  *Max_Numbytes_Exceeded); // Return status of RX
#endif
