#ifndef __CONFIG_H__
#define __CONFIG_H__
/*
 * file:    Config.h
 * purpose: abstract device
 */


// DAC is the output of the function generator
#define PORT_DAC            PORTB
#define DDR_DAC             DDRB

// 3 Pins for the encoder (user interface)
#define PORT_RIGHT_ENCODE   PIND
#define DDR_RIGHT_ENCODE    DDRD
#define PIN_RIGHT_ENCODE    PD1
#define PORT_LEFT_ENCODE    PIND
#define DDR_LEFT_ENCODE     DDRD
#define PIN_LEFT_ENCODE     PD2
#define PORT_PUSH_ENCODE    PIND
#define DDR_PUSH_ENCODE     DDRD
#define PIN_PUSH_ENCODE     PD3

// serial communication for display
#define PORT_CLOCK_COMM     PORTB
#define DDR_CLOCK_COMM      DDRB
#define PIN_CLOCK_COMM      PB7
#define PORT_DATA_COMM      PORTB
#define DDR_DATA_COMM       DDRB
#define PIN_DATA_COMM       PB6
#define PORT_SYNC_COMM      PORTD
#define DDR_SYNC_COMM       DDRD
#define PIN_SYNC_COMM       PD6      

#define BUTTON_SAMPLING     4                              // check button 4 times

#endif
