/*
 * file:    SPI.c
 * purpose: communication via SPI protocol
 */
#include <inttypes.h>
#include <avr/io.h>
#include "Config.h"
#include "SPI.h"


void spiInit() {
   DDR_SPI |= 1 << PIN_MOSI | 1 << PIN_SCK;
   SPCR     = 1 << SPE | 1 << MSTR;
   SPSR    |= 1 << SPI2X;
}


void spiBusySend(uint8_t * pBuf, uint8_t size) {
   uint8_t i=0;

   do {
      spiBusySendByte(pBuf[i++]);
   } while (i < size);
}


void spiBusySendByte(uint8_t b) {
   SPDR = b;

   while (!(SPSR & (1 << SPIF)));
}
