#ifndef __SEGMENTLED_H__
#define __SEGMENTLED_H__
/*
 * file:    SegmentLed.h
 * purpose: define values for display via 7-segment led-displays
 *
 *     =a=
 *    f   b
 *     =g=
 *    e   c
 *     =d=  dot  
 */

// we use shift register to activate led segments
// each digit is represented by one byte / shift register
// each bit is tied to one segment:
#define A_SEG   0x01
#define B_SEG   0x02
#define C_SEG   0x04
#define D_SEG   0x08
#define E_SEG   0x10
#define F_SEG   0x20
#define G_SEG   0x40
#define DOT_SEG 0x80

// some common symbols to display
#define SEG_0  (A_SEG | B_SEG | C_SEG | D_SEG | E_SEG | F_SEG        )
#define SEG_1  (        B_SEG | C_SEG                                )
#define SEG_2  (A_SEG | B_SEG |         D_SEG | E_SEG |         G_SEG)
#define SEG_3  (A_SEG | B_SEG | C_SEG | D_SEG |                 G_SEG)
#define SEG_4  (        B_SEG | C_SEG |                 F_SEG | G_SEG)
#define SEG_5  (A_SEG |         C_SEG | D_SEG |         F_SEG | G_SEG)
#define SEG_6  (A_SEG |         C_SEG | D_SEG | E_SEG | F_SEG | G_SEG)
#define SEG_7  (A_SEG | B_SEG | C_SEG                                )
#define SEG_8  (A_SEG | B_SEG | C_SEG | D_SEG | E_SEG | F_SEG | G_SEG)
#define SEG_9  (A_SEG | B_SEG | C_SEG | D_SEG |         F_SEG | G_SEG)
#define SEG_A  (A_SEG | B_SEG | C_SEG |         E_SEG | F_SEG | G_SEG)
#define SEG_B  (A_SEG | B_SEG | C_SEG | D_SEG | E_SEG | F_SEG | G_SEG)
#define SEG_C  (A_SEG |                 D_SEG | E_SEG | F_SEG        )
#define SEG_E  (A_SEG |                 D_SEG | E_SEG | F_SEG | G_SEG)
#define SEG_F  (A_SEG |                         E_SEG | F_SEG | G_SEG)
#define SEG_G  (A_SEG |         C_SEG | D_SEG | E_SEG | F_SEG | G_SEG)
#define SEG_H  (        B_SEG | C_SEG |         E_SEG | F_SEG | G_SEG)
#define SEG_I  (        B_SEG | C_SEG                                )
#define SEG_J  (        B_SEG | C_SEG | D_SEG                        )
#define SEG_L  (                        D_SEG | E_SEG | F_SEG        )
#define SEG_O  (A_SEG | B_SEG | C_SEG | D_SEG | E_SEG | F_SEG        )
#define SEG_P  (A_SEG | B_SEG |                 E_SEG | F_SEG | G_SEG)
#define SEG_R  (A_SEG | B_SEG | C_SEG |         E_SEG | F_SEG | G_SEG)
#define SEG_S  (A_SEG |         C_SEG | D_SEG |         F_SEG | G_SEG)
#define SEG_T  (A_SEG |                         E_SEG | F_SEG        )
#define SEG_U  (        B_SEG | C_SEG | D_SEG | E_SEG | F_SEG        )


#endif
