#ifndef __UI_H__
#define __UI_H__
/*
 * file:    UI.h
 * purpose: declarations for handling of user interface
 */
#ifndef __INTTYPES_H_
#include <inttypes.h>
#endif
#ifndef __PGMSPACE_H_
#include <avr/pgmspace.h>
#endif
#ifndef __SEGMENTLED_H__
#include "SegmentLed.h"
#endif
#ifndef __DDS_H__
#include "DDS.h"
#endif

#define CHOICE_STATE    1
#define EXEC_STATE      2
#define NEXT_STATE      3
#define COUNTER_STATE   4

#ifdef EXTERN
#undef EXTERN
#endif

#ifdef PLACE_GLOBALS_HERE
#define EXTERN
#else
#define EXTERN extern
#endif

struct sm {
   uint8_t      level;
   uint8_t      pDisplay[3];
   uint8_t      type; 
   uint16_t     max;
   prog_uchar * pNext;
   uint16_t *   pVar;
   void       (*pFunc)();
};

#ifdef PLACE_GLOBALS_HERE
prog_uchar nxtMode[] = { 1, 2 };
prog_uchar nxtFG[]   = { 3 };
prog_uchar nxtFreq[] = { 4 };
prog_uchar nxtWave[] = { 5, 6, 7, 8, 0 };
#endif

EXTERN struct sm PROGMEM ui[]
#ifdef PLACE_GLOBALS_HERE
 = {
/* mode               */ { 0, { SEG_F, 0, 0 },     CHOICE_STATE,  sizeof(nxtMode), nxtMode, &work.mode, 0 },    
/* function generator */ { 1, { SEG_G, SEG_E, 0 }, NEXT_STATE,    sizeof(nxtFG),   nxtFG,   0,          0 },                  
/* frequency counter  */ { 2, { SEG_C, SEG_O, 0 }, EXEC_STATE,    0,               0,       0,          &countFrequency },
/* FG: frequency      */ { 3, { 0, 0, 0},          COUNTER_STATE, 0xFFFF,          nxtFreq, &work.step, 0 },
/* FG: wave form      */ { 4, { SEG_S, SEG_F, 0 }, CHOICE_STATE,  sizeof(nxtWave), nxtWave, &work.wave, 0 },
/* FG: sine           */ { 5, { SEG_S, SEG_I, 0 }, EXEC_STATE,    0,               0,       0,          &genSine },
/* FG: sawtooth       */ { 6, { SEG_S, SEG_A, 0 }, EXEC_STATE,    0,               0,       0,          &genSawtooth },
/* FG: triangle       */ { 7, { SEG_T, SEG_A, 0 }, EXEC_STATE,    0,               0,       0,          &genTriangle },
/* FG: square         */ { 8, { SEG_S, SEG_O, 0 }, EXEC_STATE,    0,               0,       0,          &genSquare }
}
#endif
;
#endif
