/*
 * file:    Util.c
 * purpose: collect handy functions
 */
#include <inttypes.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include "Util.h"


static uint32_t PROGMEM tab[] = { 1000000000, 100000000, 10000000, 1000000,
  	                              100000, 10000, 1000, 100, 10, 1, 0 };

/*
 * Die Routine l2a() wandelt die Zahl 'l' in eine ASCII-Zeichenkette, die in
 * s[12] abgelegt wird: Vorzeichen, max. 10 Ziffern, Abschluss -> 12 Byte.
 * 
 * Zeitaufwendige Divisionen werden durch Subtraktionen ersetzt, was deutlich
 * schneller ausgef?hrt wird.
 * 
 * Bei Bedarf kann 'long' durch 'int' ersetzt werden; hierdurch wird der
 * Code reduziert, die Ausfuerung beschleunigt, aber der Wertebereich auf
 * -32768 bis 32767 begrenzt.
 * Nach Anpassung kann diese Routine auch dazu verwendet werden, die Mantisse
 * von float Zahlen sehr schnell zu wandeln.
 * 
 * Michael Nowak, 2004-11-09, www.mino-elektronik.de
 */
void l2a(int32_t l, uint8_t *s)                            // l -> zu wandelnde Zahl, *s -> Ergebnis
{
   uint32_t temp;                                          // fuer schnellere Ausfuehrung
   uint8_t  i=0;
   uint8_t  j;                                             // i -> tab-index, j -> aktuelle Ziffer

   if (l) {			                                       // wert ist != 0
      if (l < 0) {
         l = -l;
         *s++ = '-';                                       // wenn negativ
      }
      while (tab[i] > l) i++;	                           // 1. gueltige Ziffer suchen, Vornullen entfernen
      do {
         temp = tab[i];                                    // temp vermeidet wiederholte Indizierung
         j = '0';			                               // Startwert = Ziffer '0'
         if (temp) {                                       // nur wenn gueltige Tabellenwerte
    	    for (;j <= '9'; j++) {                         // mehr als '9' darf's nicht werden
    	       l -= temp;		                           // solange subtrahieren
    	       if (l < 0) {                                // bis < 0: das war einmal zu viel
    	          l += temp;                               // daher wieder korrigieren
    	          break;                                   // for-Schleife ist fertig
    	       }
    	    }
    	    *s++ = j;                                      // Ziffer ablegen
   	        i++;                                           // naechst kleinere Stelle auswerten
         }
      } while(temp);		                               // bis Tabelle abgearbeitet
   } else *s++ = '0';                                      // falls Zahl == 0, nur eine '0' erzeugen
   *s = 0;			                                       // string abschlie?en
}

 
     
