#include <inttypes.h>
#include <avr/io.h>
#include <avr/pgmspace.h>
#include "Config.h"
#define PLACE_GLOBALS_HERE
#include "DDS.h"
#include "Data.h"
#include "Counter.h"
#include "UI.h"
#include "SPI.h"
#include "Util.h"

void updateDisplay();


/*
 * handling of user interface has low priority so happens here
 */
void main() {
   struct sm * pUI;
   init(); 

   do {
      if (work.btPush > BUTTON_SAMPLING) {                 // push button of turning encoder switches level
         if (ui[work.level].type == EXEC_STATE) {
             run = 1;
             (*ui[work.level].pFunc)();

             work.level = 0;
         } else {
             work.level++;

             if (work.level > sizeof(ui))
                work.level = 0;
         }
         work.btPush = 0;
      }

      if (ui[work.level].type == NEXT_STATE) {             // entries with NEXT_STATE are silent entries
                                                           // just to have an option to display
         work.level = ui[work.level].pNext[0];             // skip to real entry
      }  
         
      work.display[0] = 0;
      work.display[1] = 0;
      work.display[2] = 0;
      work.display[3] = 0;
      work.display[4] = 0;
      work.display[5] = 0;

      pUI = ui + work.level;

      if (pUI->type == COUNTER_STATE) {
         l2a(*pUI->pVar, work.display);
      } else {
         uint8_t i=0;

         for (i=0; i < sizeof(pUI->pDisplay) && pUI->pDisplay[i]; i++) 
            work.display[i] = pUI->pDisplay[i];

         if (pUI->type == CHOICE_STATE) {
            struct sm * pChoice = ui + *pUI->pVar;

            for (i=0; i < sizeof(pChoice->pDisplay) && pChoice->pDisplay[i] && i < sizeof(work.display) -3; i++) 
               work.display[i+2] = pChoice->pDisplay[i];
         }         
      }

      updateDisplay();
   } while (1);
}


/*
 * control of led-segments is handled through shift registers with output latch
 * aka 74HC595
 * Each digit has its own shift register.
 * Transfer of the 5 Bytes is done hidden and after that, the sync line is strobed
 * which causes the shift register to update their latches.
 */
void updateDisplay() {
   spiBusySend(work.display, sizeof(work.display));

   PORT_SYNC_COMM |= 1 << PIN_SYNC_COMM;
   asm volatile ("nop");
   PORT_SYNC_COMM &= (uint8_t) ~(1 << PIN_SYNC_COMM);
}
