/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        30.05.2008
 Description:    Erzeugen eines PAL Video Signals

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
----------------------------------------------------------------------------*/

#include <avr/interrupt.h>
#include <avr/io.h>
#include "usart.h"
#include "video.h"

//------------------------------------------------------------------------------
//Hier startet das Hauptprogramm
int main (void) 
{
    // Serielle Schnittstelle initialisieren
    usart_init(9600); 
    usart_write("Compiliert am "__DATE__" um "__TIME__"\r\n");
    usart_write("Compiliert mit GCC Version "__VERSION__"\r\n");
	for(unsigned long a=0;a<1000000;a++){asm("nop");};
  
    video_init();
    sei();
    
    video_clear ();
    video_print (5,5,"TEST");
    video_print (0,7," ");
    
    for(unsigned int a = 0;a<255;a++)
    {
        screen_buffer[a+168] = a;
    }
    
    video_print (0,0,"012345678911111111112222");
    video_print (0,1,"          01234567890123");
    
    while(1)
    {
    }
}

