/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        30.05.2008
 Description:    Erzeugung eines PAL Videosignals

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/

#include "video.h"
#include "font.h"
    
volatile unsigned char  screen_buffer[CHAR_COLS * CHAR_ROWS]; //Bildspeicher
volatile unsigned int	line_count = 0;     // Aktuelle Display-Zeile
volatile unsigned char  char_line_count = 0;
volatile unsigned int   char_new_max = CHAR_COLS; 
volatile unsigned int   image_counter = 0;

//------------------------------------------------------------------------------
//Init Pal-Video
void video_init (void)
{
    //Sync Signal on PORT B1
    SYNC_OUTPUT;
    
	//No prescaling 
	TCCR1B |= (1<<CS10);
  
    OCR1A = TCNT1 + HSYNC_64_US;
    //Output Compare A Match Interrupt Enable  
    TIMSK |= (1 << OCIE1A);
    
    //Setup Serial Peripheral Interface
    DDRB |= (1<<PB3)|(1<<PB5)|(1<<PB2);  
    //Setup Serial Peripheral Interface (SPI) 
    SPCR |= (1<<SPE)|(1<<MSTR)|(1<<DORD);	
    //SPSR |= (1<<SPI2X);//Speed 2x
    
    video_clear();
	return;
}

//------------------------------------------------------------------------------
//Ausgabe eines Strings auf dem Bildschirm
void video_print(unsigned char x,unsigned char y,char *pstr)
{
    char chr = 0;
    unsigned int tmp = (y * CHAR_COLS) + x;
    
	while (*pstr)
	{
        chr = *pstr++;
        //if (chr >= 32) chr -= 32;
        screen_buffer[tmp++] = chr;
	}
}

//------------------------------------------------------------------------------
//Lschen des Bildschirms
void video_clear (void)
{
    for (unsigned int a = 0;a<(CHAR_COLS*CHAR_ROWS);a++)
    {
        screen_buffer[a]=0;
    }
}

//------------------------------------------------------------------------------
// Timer1 Compare-Match Interrupt Handler 
ISR (TIMER1_COMPA_vect)
{
    TCNT1 = 0;
    SYNC_LOW; //Sync ein 
    if (++line_count < LINE) //Ausgabe der Zeilen
    {	
        OCR1A = HSYNC_64_US; 
        //Synchronpuls 4.8s
		while (TCNT1 < HSYNC_DURATION); 
		SYNC_HIGH; //Sync aus
        
		if (line_count < START || image_counter >= (CHAR_COLS*CHAR_ROWS)) return;

        //Horizontaloffset
        while (TCNT1L < H_OFFSET);
         
        unsigned int tmp = char_line_count;
        tmp += ((unsigned int)&FONT);
 
		while(image_counter < char_new_max)
		{
                SPDR = ~(pgm_read_byte(tmp + (screen_buffer[image_counter++]*10)));
		}
        
        if((char_line_count++) > 8)
        {
            char_line_count = 0;
            char_new_max += CHAR_COLS;
        }
        image_counter = char_new_max - CHAR_COLS;
        return;
    }
    
    OCR1A = HSYNC_32_US;
    
    if (line_count < VORTRABANT)
    {
        while (TCNT1 < HALF_HSYNC_DURATION);
        SYNC_HIGH;
        return;
    }
    
    if (line_count < HAUPTIMPULS)
    {
        SYNC_HIGH;
        while (TCNT1 < HALF_HSYNC_DURATION);
        SYNC_LOW;
        return;
    }
    
    if (line_count < NACHTRABANT)
    {
        while (TCNT1 < HALF_HSYNC_DURATION);
        SYNC_HIGH;
    }
    else
    {
        while (TCNT1 < HALF_HSYNC_DURATION); 
        SYNC_HIGH;	  
        line_count = 0;
        char_line_count = 0;
        image_counter = 0;
        char_new_max = CHAR_COLS;
    }
}



