/*----------------------------------------------------------------------------
 Copyright:      Radig Ulrich  mailto: mail@ulrichradig.de
 Author:         Radig Ulrich
 Remarks:        
 known Problems: none
 Version:        30.05.2008
 Description:    Gen. PAL Video

 Dieses Programm ist freie Software. Sie knnen es unter den Bedingungen der 
 GNU General Public License, wie von der Free Software Foundation verffentlicht, 
 weitergeben und/oder modifizieren, entweder gem Version 2 der Lizenz oder 
 (nach Ihrer Option) jeder spteren Version. 

 Die Verffentlichung dieses Programms erfolgt in der Hoffnung, 
 da es Ihnen von Nutzen sein wird, aber OHNE IRGENDEINE GARANTIE, 
 sogar ohne die implizite Garantie der MARKTREIFE oder der VERWENDBARKEIT 
 FR EINEN BESTIMMTEN ZWECK. Details finden Sie in der GNU General Public License. 

 Sie sollten eine Kopie der GNU General Public License zusammen mit diesem 
 Programm erhalten haben. 
 Falls nicht, schreiben Sie an die Free Software Foundation, 
 Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA. 
------------------------------------------------------------------------------*/

#ifndef _VIDEO_H
 #define _VIDEO_H
 
    #include <avr/interrupt.h>
    #include <avr/pgmspace.h>
    #include <avr/io.h>
    #include "usart.h"

    //16 Mhz = 0.0625uS
    //#define F_CPU 16000000
    
    //20 Mhz = 0.05uS
    #define F_CPU 20000000
  
  #if (F_CPU == 20000000)
    #define CHAR_COLS           24 
    #define CHAR_ROWS           24  

    #define HSYNC_32_US         640
    #define HSYNC_64_US         1280
    #define HSYNC_DURATION      96
    #define HALF_HSYNC_DURATION 48
    #define H_OFFSET            208
  #endif
  
  #if (F_CPU == 16000000)
    #define CHAR_COLS           19  
    #define CHAR_ROWS           24  

    #define HSYNC_32_US         512
    #define HSYNC_64_US         1024
    #define HSYNC_DURATION      76
    #define HALF_HSYNC_DURATION 38
    #define H_OFFSET            160
  #endif
    
    #define START        40  //erste Linie an der ein Zeichen steht
    #define LINE 		304  //sichtbare Linien
    #define VORTRABANT 	309  //5 Vortrabanten
    #define HAUPTIMPULS 314  //5 Hauptimpulse
    #define NACHTRABANT 318	 //5 Nachtrabanten

    #define SYNC_OUTPUT DDRB = (1<<PB1);

    #define SYNC_LOW    PORTB &= ~(1<<PB1)    
    #define SYNC_HIGH   PORTB |= (1<<PB1)
    #define SYNC_FLASH  PORTB ^= (1<<PB1) 

    volatile unsigned char screen_buffer[CHAR_COLS * CHAR_ROWS];

    extern void video_init (void);
    extern void video_print (unsigned char,unsigned char,char*);
    extern void video_clear (void);


#endif
